#ifndef		__YBUFFER_H__
#define		__YBUFFER_H__

#define		MAX_YBUFFER_SIZE		8096

class YBuffer
{
public:
	YBuffer()
	{
		m_pBuffer			= new BYTE [ MAX_YBUFFER_SIZE ];
		m_nBufferSize		= MAX_YBUFFER_SIZE;
		m_nBufferUsedSize	= 0;
		memset( m_pBuffer, 0, sizeof ( m_pBuffer ) );
	}

	YBuffer ( BYTE* pBuffer , int nBufferSize , int nBufferUsedSize = 0 )
	{
		m_pBuffer			= pBuffer;
		m_nBufferSize		= nBufferSize;
		m_nBufferUsedSize	= nBufferUsedSize;
	}

	~YBuffer()
	{
		if ( m_pBuffer )
		{
			delete [] m_pBuffer;
			m_pBuffer = NULL;
		}
	}
	
	BYTE* GetBuffer()
	{
		return m_pBuffer;
	}

	BYTE* GetBuffer ( int nStart )
	{
		ASSERT ( nStart >= 0 );
		ASSERT ( nStart < m_nBufferSize );
		return m_pBuffer + nStart;
	}

	BYTE* GetLastBuffer()
	{
		return m_pBuffer + m_nBufferUsedSize;
	}

	void SetBufferSize ( int nLength )
	{
		if ( m_nBufferSize - m_nBufferUsedSize < nLength )
		{
			m_nBufferSize = m_nBufferSize + nLength + 8;
			BYTE* pTempBuffer = new BYTE [ m_nBufferSize ];
			ASSERT ( pTempBuffer );

			memcpy ( pTempBuffer , m_pBuffer , m_nBufferUsedSize );

			if ( m_pBuffer )
			{
				delete [] m_pBuffer;
			}

			m_pBuffer = pTempBuffer;
		}
	}
	
	void FillBuffer ( int nLength )
	{
		m_nBufferUsedSize += nLength;
	}

	BYTE GetAt ( int nIndex )
	{
		ASSERT ( nIndex >= 0 );
		ASSERT ( nIndex < m_nBufferUsedSize );
		return m_pBuffer[nIndex];
	}

	void UseBuffer ( int nLength )
	{
		if ( m_nBufferUsedSize < nLength )
		{
			ASSERT ( FALSE );
			return;
		}
			
		m_nBufferUsedSize -= nLength;
		if ( m_nBufferUsedSize > 0 )
		{	
			memmove ( m_pBuffer , m_pBuffer + nLength , m_nBufferUsedSize );
		}
	}

	void SetData ( BYTE* pBuffer , int nLength )
	{
		ASSERT ( pBuffer );
		SetBufferSize ( nLength );

		memcpy ( m_pBuffer + m_nBufferUsedSize , pBuffer , nLength );
		m_nBufferUsedSize += nLength;
	}

	int GetLength()
	{
		return m_nBufferUsedSize;
	}

	void TracePrint()
	{
		TRACE ( "YBuffer Data : " );
		for ( int i = 0 ; i < m_nBufferUsedSize ; i++ )
		{
//			TRACE ( "%02X " , *(m_pBuffer + i) );
			TRACE ( "%c " , (char)*(m_pBuffer + i) );
		}
		TRACE ( "\n" );
	}

	void Empty()
	{
		m_nBufferUsedSize = 0;
	}

public:
	BYTE*	m_pBuffer;
	int		m_nBufferSize;
	int		m_nBufferUsedSize;

};


#endif //__YBUFFER_H__