// ReportListDlg.cpp : implementation file
//

#include "stdafx.h"
#include "psat.h"
#include "ReportListDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CReportListDlg dialog


CReportListDlg::CReportListDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CReportListDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CReportListDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_nListIndex	= 0;
	m_strProgramKey	= _T("");
	m_bIsFirst		= TRUE; 
}

void CReportListDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CReportListDlg)
	DDX_Control(pDX, IDC_LIST1, m_listReport);
	DDX_Control(pDX, IDC_EDIT_READ_CONTENT, m_edtReadContent);
	DDX_Control(pDX, IDC_BUTTON_RIGHT_MOVE, m_btnRightList);
	DDX_Control(pDX, IDC_BUTTON_LEFT_MOVE, m_btnLeftList);
	DDX_Control(pDX, IDC_BUTTON_CLOSE, m_btnClose);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CReportListDlg, CDialog)
	//{{AFX_MSG_MAP(CReportListDlg)
	ON_BN_CLICKED(IDC_BUTTON_CLOSE, OnButtonClose)
	ON_BN_CLICKED(IDC_BUTTON_LEFT_MOVE, OnButtonLeftMove)
	ON_BN_CLICKED(IDC_BUTTON_RIGHT_MOVE, OnButtonRightMove)
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CReportListDlg message handlers
#define READY_BACKBUFFER(hwnd,pDC,pDrawDC,BackColor) \
	CDC _MACRO_dc;\
	CBitmap _MACRO_bitmap;\
	CBitmap	* _MACRO_pOldBitmap;\
	CRect _MACRO_client;\
	CRect _MACRO_clip;\
	pDrawDC = pDC;\
	pDC->GetClipBox(_MACRO_clip);\
	::GetClientRect(hwnd,&_MACRO_client);\
	if (!pDC->IsPrinting()) { \
		if (_MACRO_dc.CreateCompatibleDC(pDC))	{ \
			if (_MACRO_bitmap.CreateCompatibleBitmap(pDC, _MACRO_client.Width(), _MACRO_client.Height())) {\
				pDrawDC = &_MACRO_dc;\
				_MACRO_pOldBitmap = _MACRO_dc.SelectObject(&_MACRO_bitmap);\
				_MACRO_dc.FillSolidRect(_MACRO_clip,BackColor);\
  			}\
		}\
	}\

#define BLIT_OPAQUE_BACKBUFFER(pDC,pDrawDC) \
		if (pDrawDC != pDC) {\
		pDC->LPtoDP(&_MACRO_clip);\
		pDC->SetViewportOrg(0, 0);\
		pDC->SetWindowOrg(0,0);\
		pDC->SetMapMode(MM_TEXT);\
		_MACRO_dc.SetViewportOrg(0, 0);\
		_MACRO_dc.SetWindowOrg(0,0);\
		_MACRO_dc.SetMapMode(MM_TEXT);\
		pDC->BitBlt(_MACRO_clip.left, _MACRO_clip.top, _MACRO_clip.Width(), _MACRO_clip.Height(),\
			&_MACRO_dc,_MACRO_clip.left, _MACRO_clip.top, SRCCOPY);\
		_MACRO_dc.SelectObject(_MACRO_pOldBitmap);\
	}\


void CReportListDlg::SetWnd(HWND hwnd)
{
	m_pHwnd = hwnd;
}

BOOL CReportListDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

/* ColorKey  */
	ModifyStyleEx ( 0 , WS_EX_LAYERED );
//	TRACE ( "%d %d\n" , GetLastError() , GetWindowLong ( GetSafeHwnd() , GWL_EXSTYLE ) );
	HMODULE h_user32_dll = GetModuleHandle("USER32.DLL"); 
    if(h_user32_dll != NULL){ 
		BOOL (WINAPI *fp_set_layered_window_attributes)(HWND, COLORREF, BYTE, DWORD) = 
			(BOOL (WINAPI *)(HWND, COLORREF, BYTE, DWORD))GetProcAddress(h_user32_dll, 
			"SetLayeredWindowAttributes"); 
		if(fp_set_layered_window_attributes != NULL){ 
			(*fp_set_layered_window_attributes)(m_hWnd, RGB(255, 0, 0), 0, LWA_COLORKEY); 
		} 
    } 

	if ( m_bIsFirst ) 
	{
		m_bmBackground.LoadBitmap ( IDB_REPORTLIST_BACKGROUND );
		m_btnClose.LoadBitmaps ( IDB_SDLG_CLOSE_NORMAL , IDB_SDLG_CLOSE_CLICK , IDB_SDLG_CLOSE_OVER );
		m_btnRightList.LoadBitmaps ( IDB_REPLYLIST_RIGHT_CUR_NORMAL , IDB_REPLYLIST_RIGHT_CUR_CLICK , IDB_REPLYLIST_RIGHT_CUR_NORMAL );
		m_btnLeftList.LoadBitmaps ( IDB_REPLYLIST_LEFT_CUR_NORMAL , IDB_REPLYLIST_LEFT_CUR_CLICK , IDB_REPLYLIST_LEFT_CUR_NORMAL );	
		m_bIsFirst = FALSE;
	}
	m_btnClose.SetWindowPos ( NULL , 514, 5, 16, 16, NULL );
	m_btnRightList.SetWindowPos ( NULL , 287, 205, 18, 18, NULL );
	m_btnLeftList.SetWindowPos ( NULL , 218, 205, 18, 18, NULL );
	m_listReport.SetWindowPos ( NULL , 23, 57, 488, 144, NULL );
	m_edtReadContent.SetWindowPos ( NULL , 26, 256, 480, 67, NULL );
	
	SetWindowPos(&wndTop, m_ptPosition.x, m_ptPosition.y, 537, 348, NULL);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CReportListDlg::SetSocket( CClientSocket* pClientSocket ) 
{
	m_pClientSocket = pClientSocket;
}

void CReportListDlg::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	CRect rect;
	GetClientRect ( &rect );
	CDC*	pDC = &dc;
	CDC*	pDrawDC;

	READY_BACKBUFFER ( GetSafeHwnd() , pDC , pDrawDC , RGB ( 255 , 0 , 0 ) );
	{
		DrawBackground ( pDrawDC );
	}
	BLIT_OPAQUE_BACKBUFFER ( pDC , pDrawDC );
}

void CReportListDlg::DrawBackground ( CDC* pDC )
{
	CDC cdc;
	cdc.CreateCompatibleDC ( pDC );

	BITMAP bm;
	CBitmap* pOldBitmap = NULL;

	pOldBitmap = ( CBitmap *)cdc.SelectObject ( &m_bmBackground );
	m_bmBackground.GetBitmap( &bm );
	pDC->BitBlt ( 0 , 0 , bm.bmWidth , bm.bmHeight , &cdc , 0 , 0 , SRCCOPY );
	
	if ( pOldBitmap != NULL ) 
	{
		cdc.SelectObject ( pOldBitmap );
	}
}

void CReportListDlg::SetWindowPosition ( CRect rtPosition )
{
	m_ptPosition.x =  ( rtPosition.left + rtPosition.right ) / 2 - 268;
	m_ptPosition.y =  ( rtPosition.top + rtPosition.bottom ) / 2 - 174;
}

void CReportListDlg::OnButtonClose() 
{
	m_btnClose.m_bOver = 0;
	CDialog::OnCancel();	
}

void CReportListDlg::OnButtonLeftMove() 
{
	// TODO: Add your control notification handler code here
	
}

void CReportListDlg::OnButtonRightMove() 
{
	// TODO: Add your control notification handler code here
	
}


