// CheckReliability.cpp: implementation of the CCheckReliability class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "psat.h"
#include "CheckReliability.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define MEMBER_WIGHT		4
#define	GUEST_WIGHT			1
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCheckReliability::CCheckReliability()
{

}

CCheckReliability::~CCheckReliability()
{

}

int CCheckReliability::GetReliability( unsigned int nAccessCount, unsigned int nReportCount )
{
	if ( nAccessCount < nReportCount ) 
	{
		return 0;
	}
	else if ( ( !nReportCount ) || ( !nAccessCount ) ) 
	{
		return 100;
	}
	else
	{
		return ( 100 - ( nReportCount * 100 / nAccessCount ) );
	}
}

int CCheckReliability::GetTotalReliability( unsigned int nGestAccessCount, 
											unsigned int nGestReportCount, 
											unsigned int nMemberAccessCount, 
											unsigned int nMemberReportCount )
{
	return ( MEMBER_WIGHT * GetReliability( nMemberAccessCount, nMemberReportCount ) +
		   GUEST_WIGHT * GetReliability( nGestAccessCount, nGestReportCount ) ) / ( MEMBER_WIGHT + GUEST_WIGHT );	
}

int CCheckReliability::GetTotalReliability( int nMemberReliability, int nGuestReliability )
{
	return ( MEMBER_WIGHT * nMemberReliability + GUEST_WIGHT * nGuestReliability ) / ( MEMBER_WIGHT + GUEST_WIGHT );	
}


CString CCheckReliability::GetCombinedString( unsigned int nAccessCount, unsigned int nReportCount )
{
	char szTemp[13];
	memset ( szTemp, 0, sizeof ( szTemp ) );
	sprintf( szTemp, "%06d/%06d", nReportCount, nAccessCount );
	return (LPSTR)szTemp; 
}


