#include <SystemConfiguration/SystemConfiguration.h>


/*SCDynamicStoreCopyProxies

CFDictionaryRef SCDynamicStoreCopyProxies ( 
    SCDynamicStoreRef store );  
Parameters
store
An SCDynamicStoreRef representing the dynamic store session that should be used for communication with the server. If NULL, a temporary session will be used.
Return Value

Returns a dictionary containing key-value pairs that represent the current internet proxy settings; NULL if no proxy settings have been defined or if an error was encountered. You must release the returned value. 
Discussion 

Gets the current internet proxy settings. The returned proxy settings dictionary includes: 
key 	type 	description 
kSCPropNetProxiesExceptionsList	CFArray[CFString]	Host name patterns which should bypass the proxy
kSCPropNetProxiesHTTPEnable	CFNumber (0 or 1)	Enables/disables the use of an HTTP proxy
kSCPropNetProxiesHTTPProxy	CFString	The proxy host
kSCPropNetProxiesHTTPPort	CFNumber	The proxy port number
kSCPropNetProxiesHTTPSEnable	CFNumber (0 or 1)	Enables/disables the use of an HTTPS proxy
kSCPropNetProxiesHTTPSProxy	CFString	The proxy host
kSCPropNetProxiesHTTPSPort	CFNumber	The proxy port number
kSCPropNetProxiesFTPEnable	CFNumber (0 or 1)	Enables/disables the use of an FTP proxy
kSCPropNetProxiesFTPProxy	CFString	The proxy host
kSCPropNetProxiesFTPPort	CFNumber	The proxy port number
kSCPropNetProxiesFTPPassive	CFNumber (0 or 1)	Enable passive mode operation for use behind connection filter-ing firewalls.



Other key-value pairs are defined in the SCSchemaDefinitions.h header file.*/
CFDictionaryRef SCDynamicStoreCopyProxies (
    SCDynamicStoreRef store ){};

/*kSCPropNetProxiesFTPPassive


"FTPPassive" 
extern const CFStringRef kSCPropNetProxiesFTPPassive;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesFTPPassive ;



/*SCNetworkReachabilityCreateWithName

SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename );  
Parameters
nodename
The node name of the desired host. This name would be the same as that passed to the gethostbyname(3) or getaddrinfo(3) functions.
Return Value

Returns a reference to the new immutable SCNetworkReachabilityRef. 

You must release the returned value. 
Discussion 

Creates a reference to the specified network host or node name. This reference can be used later to monitor the reachability of the target host. 
Availability
Introduced in Mac OS X v10.3.*/
SCNetworkReachabilityRef SCNetworkReachabilityCreateWithName ( 
    CFAllocatorRef allocator, 
    const char *nodename ){};



/*SCError

int SCError ();  
Return Value

Returns the last error encountered. 
Discussion 

Returns the most recent status or error code generated as the result of calling a System Configuration framework API.*/
int SCError (){};

/*SCNetworkReachabilitySetCallback

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
callout
The function to be called when the reachability of the target changes. If NULL, the current client for the target is removed.
context
The SCNetworkReachabilityContext associated with the callout. The value may be NULL.
Return Value

Returns TRUE if the notification client was successfully set. 
Discussion 

Assigns a client to a target, which receives callbacks when the reachability of the target changes. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkReachabilitySetCallback ( 
    SCNetworkReachabilityRef target, 
    SCNetworkReachabilityCallBack callout, 
    SCNetworkReachabilityContext *context ){};


/*SCNetworkReachabilityUnscheduleFromRunLoop

Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop from which the target should be unscheduled. Must be non-NULL.
runLoopMode
The mode on which to unschedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is unscheduled successfully; FALSE otherwise. 
Discussion 

Unschedules the given target from the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityUnscheduleFromRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};


/*SCNetworkReachabilityScheduleWithRunLoop

Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
target
The address or name that is set up for asynchronous notifications. Must be non-NULL.
runLoop
A reference to a run loop on which the target should be scheduled. Must be non-NULL.
runLoopMode
The mode on which to schedule the target. Must be non-NULL.
Return Value

Returns TRUE if the target is scheduled successfully; FALSE otherwise. 
Discussion 

Schedules the given target with the given run loop and mode. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityScheduleWithRunLoop ( 
    SCNetworkReachabilityRef target,
    CFRunLoopRef runLoop,
    CFStringRef runLoopMode ){};


/*SCNetworkReachabilityGetFlags

Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags );  
Parameters
target
The network reference associated with the address or name to be checked for reachability.
flags
A pointer to memory that will be filled with the SCNetworkConnectionFlags detailing the reachability of the specified target.
Return Value

Returns TRUE if the network connection flags are valid; FALSE if the status could not be determined. 
Discussion 

Determines if the given target is reachable using the current network configuration. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkReachabilityGetFlags ( 
    SCNetworkReachabilityRef target, 
    SCNetworkConnectionFlags *flags ){};


/*SCDynamicStoreCreate

SCDynamicStoreRef SCDynamicStoreCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    SCDynamicStoreCallBack callout, 
    SCDynamicStoreContext *context );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for the local dynamic store object. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
name
A string that describes the name of the calling process or plug-in of the caller.
callout
The function to be called when a watched value in the dynamic store is changed. A NULL value can be specified if no callouts are desired.
context
The SCDynamicStoreContext associated with the callout.
Return Value

Returns a reference to the new SCDynamicStore session. You must release the returned value. 
Discussion 

Creates a new session used to interact with the dynamic store maintained by the System Configuration server.*/
SCDynamicStoreRef SCDynamicStoreCreate ( 
    CFAllocatorRef allocator, 
    CFStringRef name, 
    SCDynamicStoreCallBack callout, 
    SCDynamicStoreContext *context ){};  


/*SCDynamicStoreKeyCreateProxies

CFStringRef SCDynamicStoreKeyCreateProxies ( 
    CFAllocatorRef allocator );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this key. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
Return Value

Returns a notification string for the current proxy settings. 
Discussion 

Creates a key that can be used in conjunction with the SCDynamicStoreSetNotificationKeys function to receive notifications when the current network proxy settings (such as HTTP or FTP) are changed.*/

CFStringRef SCDynamicStoreKeyCreateProxies ( 
    CFAllocatorRef allocator ){};  

/*SCDynamicStoreSetNotificationKeys

Boolean SCDynamicStoreSetNotificationKeys ( 
    SCDynamicStoreRef store, 
    CFArrayRef keys, 
    CFArrayRef patterns );  
Parameters
store
The dynamic store session being watched.
keys
An array of keys to be monitored; NULL if no specific keys are to be monitored.
patterns
An array of regex(3) pattern strings used to match keys to be monitored; NULL if no key patterns are to be monitored.
Return Value

Returns TRUE if the set of notification keys and patterns was successfully updated; FALSE if an error was encountered. 
Discussion 

Specifies a set of specific keys and key patterns that should be monitored for changes.*/
Boolean SCDynamicStoreSetNotificationKeys ( 
    SCDynamicStoreRef store, 
    CFArrayRef keys, 
    CFArrayRef patterns ){};  



/*SCDynamicStoreCreateRunLoopSource

CFRunLoopSourceRef SCDynamicStoreCreateRunLoopSource ( 
    CFAllocatorRef allocator, 
    SCDynamicStoreRef store, 
    CFIndex order );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for this run loop source. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
store
A reference to the dynamic store session.
order
On platforms which support it, for source versions which support it, this parameter determines the order in which the sources which are ready to be processed are handled. A lower order number causes processing before higher order number sources. It is inadvisable to depend on the order number for any architectural or design aspect of code. In the absence of any reason to do otherwise, zero should be used.
Return Value

A reference to the new CFRunLoopSource. You must release the returned value. 

Discussion 

Creates a CFRunLoopSource object that can be added to the application's run loop. All dynamic store notifications are delivered using this run loop source.*/

CFRunLoopSourceRef SCDynamicStoreCreateRunLoopSource ( 
    CFAllocatorRef allocator, 
    SCDynamicStoreRef store, 
    CFIndex order ){};  


/*kSCPropNetProxiesHTTPProxy


"HTTPProxy" 
extern const CFStringRef kSCPropNetProxiesHTTPProxy;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesHTTPProxy;  


/*kSCPropNetProxiesHTTPSProxy


"HTTPSProxy" 
extern const CFStringRef kSCPropNetProxiesHTTPSProxy;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesHTTPSProxy;  


/*kSCPropNetProxiesHTTPPort


"HTTPPort" 
extern const CFStringRef kSCPropNetProxiesHTTPPort;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesHTTPPort;  


/*kSCPropNetProxiesHTTPSPort


"HTTPSPort" 
extern const CFStringRef kSCPropNetProxiesHTTPSPort;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesHTTPSPort;  


/*kSCPrefSets


"Sets" 
extern const CFStringRef kSCPrefSets;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPrefSets;  

/*SCPreferencesGetValue

CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key );  
Parameters
prefs
The preferences session.
key
The preference key to be returned.
Return Value

Returns the value associated with the specified preference key; NULL if no value was located. 
Discussion 

Returns the data associated with a preference key. 

This function retrieves data associated with the specified key. 

Note: To avoid inadvertantly reading stale data, first call the SCPreferencesLock function.*/
CFPropertyListRef SCPreferencesGetValue ( 
    SCPreferencesRef prefs, 
    CFStringRef key ){};  



/*kSCEntNetInterface


"Interface" 
extern const CFStringRef kSCEntNetInterface;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCEntNetInterface;  



/*kSCPropNetInterfaceSubType


"SubType" 
extern const CFStringRef kSCPropNetInterfaceSubType;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetInterfaceSubType;  



/*kSCValNetInterfaceSubTypePPPoE


"PPPoE" 
extern const CFStringRef kSCValNetInterfaceSubTypePPPoE;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetInterfaceSubTypePPPoE;  

/*kSCPropNetServiceOrder


"ServiceOrder" 
extern const CFStringRef kSCPropNetServiceOrder;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetServiceOrder;  


/*kSCPropUserDefinedName


"UserDefinedName" 
extern const CFStringRef kSCPropUserDefinedName;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropUserDefinedName;  


/*kSCPrefCurrentSet


"CurrentSet" 
extern const CFStringRef kSCPrefCurrentSet;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPrefCurrentSet; 

 
/*kSCEntNetIPv4


"IPv4" 
extern const CFStringRef kSCEntNetIPv4;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCEntNetIPv4;  

/*kSCEntNetNetInfo


"NetInfo" 
extern const CFStringRef kSCEntNetNetInfo;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCEntNetNetInfo;  


/*kSCResvLink


"__LINK__" (Reserved) 
extern const CFStringRef kSCResvLink;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCResvLink;  


/*kSCPrefNetworkServices


"NetworkServices" 
extern const CFStringRef kSCPrefNetworkServices;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPrefNetworkServices;  


/*kSCCompNetwork


"Network" 
extern const CFStringRef kSCCompNetwork;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCCompNetwork;  


/*kSCCompService


"Service" 
extern const CFStringRef kSCCompService;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCCompService;  


/*kSCCompGlobal


"Global" 
extern const CFStringRef kSCCompGlobal;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCCompGlobal;  


/*kSCEntNetPPP


"PPP" 
extern const CFStringRef kSCEntNetPPP;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCEntNetPPP;  


/*kSCResvInactive


"__INACTIVE__" (Reserved) 
extern const CFStringRef kSCResvInactive;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCResvInactive;  

/*kSCPropNetInterfaceDeviceName


"DeviceName" 
extern const CFStringRef kSCPropNetInterfaceDeviceName;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetInterfaceDeviceName;  


/*kSCPropNetInterfaceHardware


"Hardware" 
extern const CFStringRef kSCPropNetInterfaceHardware;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetInterfaceHardware;  

/*kSCPropNetInterfaceType


"Type" 
extern const CFStringRef kSCPropNetInterfaceType;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetInterfaceType;  



/*kSCValNetInterfaceSubTypePPPSerial


"PPPSerial" 
extern const CFStringRef kSCValNetInterfaceSubTypePPPSerial;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetInterfaceSubTypePPPSerial;  


/*kSCValNetIPv4ConfigMethodDHCP


"DHCP" 
extern const CFStringRef kSCValNetIPv4ConfigMethodDHCP;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetIPv4ConfigMethodDHCP;  


/*kSCPropMACAddress


"MACAddress" 
extern const CFStringRef kSCPropMACAddress;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropMACAddress;  


/*kSCEntNetEthernet


"Ethernet" 
extern const CFStringRef kSCEntNetEthernet;  
Availability
Introduced in Mac OS X 10.*/
 const CFStringRef kSCEntNetEthernet;  


/*kSCEntNetModem


"Modem" 
extern const CFStringRef kSCEntNetModem;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCEntNetModem;  

/*kSCValNetInterfaceTypeEthernet


"Ethernet" 
extern const CFStringRef kSCValNetInterfaceTypeEthernet;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetInterfaceTypeEthernet;  

/*kSCEntNetProxies


"Proxies" 
extern const CFStringRef kSCEntNetProxies;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCEntNetProxies;  

/*kSCValNetIPv4ConfigMethodPPP


"PPP" 
extern const CFStringRef kSCValNetIPv4ConfigMethodPPP;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetIPv4ConfigMethodPPP;  


/*kSCEntNetAirPort


"AirPort" 
extern const CFStringRef kSCEntNetAirPort;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCEntNetAirPort;  


/*kSCValNetInterfaceTypePPP


"PPP" 
extern const CFStringRef kSCValNetInterfaceTypePPP;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetInterfaceTypePPP;  


/*kSCValNetAppleTalkConfigMethodNode


"Node" 
extern const CFStringRef kSCValNetAppleTalkConfigMethodNode;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetAppleTalkConfigMethodNode;  




/*kSCEntNetDNS


"DNS" 
extern const CFStringRef kSCEntNetDNS;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCEntNetDNS;  

/*kSCValNetIPv4ConfigMethodManual


"Manual" 
extern const CFStringRef kSCValNetIPv4ConfigMethodManual;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetIPv4ConfigMethodManual;


/*kSCPropNetPPPOverridePrimary


"PPPOverridePrimary" 
extern const CFStringRef kSCPropNetPPPOverridePrimary;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPOverridePrimary;  

/*kSCPropNetProxiesExceptionsList


"ExceptionsList" 
extern const CFStringRef kSCPropNetProxiesExceptionsList;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesExceptionsList;  


/*kSCPropNetProxiesGopherEnable


"GopherEnable" 
extern const CFStringRef kSCPropNetProxiesGopherEnable;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesGopherEnable;  


/*kSCPropNetAppleTalkNodeID


"NodeID" 
extern const CFStringRef kSCPropNetAppleTalkNodeID;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetAppleTalkNodeID;  



/*kSCPropNetDNSServerAddresses


"ServerAddresses" 
extern const CFStringRef kSCPropNetDNSServerAddresses;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetDNSServerAddresses;  


/*kSCPropNetPPPDisconnectOnIdle


"DisconnectOnIdle" 
extern const CFStringRef kSCPropNetPPPDisconnectOnIdle;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPDisconnectOnIdle;  

/*kSCPropNetPPPIPCPCompressionVJ


"IPCPCompressionVJ" 
extern const CFStringRef kSCPropNetPPPIPCPCompressionVJ;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPIPCPCompressionVJ;  


/*kSCPropNetPPPLCPEchoEnabled


"LCPEchoEnabled" 
extern const CFStringRef kSCPropNetPPPLCPEchoEnabled;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPLCPEchoEnabled;  

/*kSCPropNetAirPortPreferredNetwork


"PreferredNetwork" 
extern const CFStringRef kSCPropNetAirPortPreferredNetwork;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetAirPortPreferredNetwork;  


/*kSCPropNetModemConnectionScript


"ConnectionScript" 
extern const CFStringRef kSCPropNetModemConnectionScript;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetModemConnectionScript;  


/*kSCPropNetModemPulseDial


"PulseDial" 
extern const CFStringRef kSCPropNetModemPulseDial;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetModemPulseDial;  


/*kSCPropNetModemSpeaker


"Speaker" 
extern const CFStringRef kSCPropNetModemSpeaker;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetModemSpeaker;  

/*kSCPropNetModemDataCompression


"DataCompression" 
extern const CFStringRef kSCPropNetModemDataCompression;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetModemDataCompression;  


/*kSCPropNetProxiesSOCKSEnable


"SOCKSEnable" 
extern const CFStringRef kSCPropNetProxiesSOCKSEnable;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesSOCKSEnable;  


/*kSCPropNetProxiesSOCKSProxy


"SOCKSProxy" 
extern const CFStringRef kSCPropNetProxiesSOCKSProxy;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesSOCKSProxy;  
/*kSCPropNetAppleTalkConfigMethod


"ConfigMethod" 
extern const CFStringRef kSCPropNetAppleTalkConfigMethod;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetAppleTalkConfigMethod;  


/*kSCValNetIPv4ConfigMethodBOOTP


"BOOTP" 
extern const CFStringRef kSCValNetIPv4ConfigMethodBOOTP;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetIPv4ConfigMethodBOOTP;  


/*kSCValNetIPv4ConfigMethodINFORM


"INFORM" 
extern const CFStringRef kSCValNetIPv4ConfigMethodINFORM;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCValNetIPv4ConfigMethodINFORM;  

/*kSCPropNetIPv4ConfigMethod


"ConfigMethod" 
extern const CFStringRef kSCPropNetIPv4ConfigMethod;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetIPv4ConfigMethod;  



/*kSCPropNetIPv4DHCPClientID


"DHCPClientID" 
extern const CFStringRef kSCPropNetIPv4DHCPClientID;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetIPv4DHCPClientID;  

/*kSCPropNetIPv4Addresses


"Addresses" 
extern const CFStringRef kSCPropNetIPv4Addresses;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetIPv4Addresses;  


/*kSCPropNetIPv4SubnetMasks


"SubnetMasks" 
extern const CFStringRef kSCPropNetIPv4SubnetMasks;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetIPv4SubnetMasks;  

/*kSCPropNetIPv4Router


"Router" 
extern const CFStringRef kSCPropNetIPv4Router;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetIPv4Router;  


/*kSCPropNetPPPCommRedialInterval


"CommRedialInterval" 
extern const CFStringRef kSCPropNetPPPCommRedialInterval;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPCommRedialInterval;  



/*kSCPropNetPPPLCPEchoInterval


"LCPEchoInterval" 
extern const CFStringRef kSCPropNetPPPLCPEchoInterval;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPLCPEchoInterval;  


/*kSCPropNetModemDialMode


"DialMode" 
extern const CFStringRef kSCPropNetModemDialMode;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetModemDialMode;  

/*kSCValNetModemDialModeIgnoreDialTone


"IgnoreDialTone" 
extern const CFStringRef kSCValNetModemDialModeIgnoreDialTone;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetModemDialModeIgnoreDialTone;  


/*kSCPropNetProxiesFTPEnable


"FTPEnable" 
extern const CFStringRef kSCPropNetProxiesFTPEnable;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesFTPEnable;  

/*kSCPropNetProxiesFTPProxy


"FTPProxy" 
extern const CFStringRef kSCPropNetProxiesFTPProxy;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesFTPProxy;  


/*kSCPropNetDNSSearchDomains


"SearchDomains" 
extern const CFStringRef kSCPropNetDNSSearchDomains;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetDNSSearchDomains;  


/*kSCPropNetPPPVerboseLogging


"VerboseLogging" 
extern const CFStringRef kSCPropNetPPPVerboseLogging;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPVerboseLogging;  

/*kSCPropNetPPPCommAlternateRemoteAddress


"CommAlternateRemoteAddress" 
extern const CFStringRef kSCPropNetPPPCommAlternateRemoteAddress;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPCommAlternateRemoteAddress;  


/*kSCPropNetPPPLCPEchoFailure


"LCPEchoFailure" 
extern const CFStringRef kSCPropNetPPPLCPEchoFailure;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPLCPEchoFailure;  

/*kSCValNetModemDialModeWaitForDialTone


"WaitForDialTone" 
extern const CFStringRef kSCValNetModemDialModeWaitForDialTone;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCValNetModemDialModeWaitForDialTone;  


/*kSCPropNetModemErrorCorrection


"ErrorCorrection" 
extern const CFStringRef kSCPropNetModemErrorCorrection;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetModemErrorCorrection;  



/*kSCPropNetProxiesFTPPort


"FTPPort" 
extern const CFStringRef kSCPropNetProxiesFTPPort;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesFTPPort;  



/*kSCPropNetProxiesSOCKSPort


"SOCKSPort" 
extern const CFStringRef kSCPropNetProxiesSOCKSPort;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesSOCKSPort;  


/*kSCPropNetProxiesGopherProxy


"GopherProxy" 
extern const CFStringRef kSCPropNetProxiesGopherProxy;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesGopherProxy;  



/*kSCPropNetAppleTalkDefaultZone


"DefaultZone" 
extern const CFStringRef kSCPropNetAppleTalkDefaultZone;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetAppleTalkDefaultZone;  

/*kSCPropNetProxiesRTSPPort


"RTSPPort" 
extern const CFStringRef kSCPropNetProxiesRTSPPort;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesRTSPPort;  



/*kSCPropNetAppleTalkNetworkID


"NetworkID" 
extern const CFStringRef kSCPropNetAppleTalkNetworkID;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetAppleTalkNetworkID;  


/*kSCPropNetProxiesRTSPProxy


"RTSPProxy" 
extern const CFStringRef kSCPropNetProxiesRTSPProxy;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesRTSPProxy;  

/*kSCPropNetProxiesRTSPEnable


"RTSPEnable" 
extern const CFStringRef kSCPropNetProxiesRTSPEnable;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetProxiesRTSPEnable;  



/*kSCPropNetProxiesGopherPort


"GopherPort" 
extern const CFStringRef kSCPropNetProxiesGopherPort;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesGopherPort;  

/*kSCPropNetProxiesHTTPEnable


"HTTPEnable" 
extern const CFStringRef kSCPropNetProxiesHTTPEnable;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesHTTPEnable;  

/*kSCPropNetProxiesHTTPSEnable


"HTTPSEnable" 
extern const CFStringRef kSCPropNetProxiesHTTPSEnable;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetProxiesHTTPSEnable;  


/*kSCPropNetPPPDialOnDemand


"DialOnDemand" 
extern const CFStringRef kSCPropNetPPPDialOnDemand;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPDialOnDemand;  

/*kSCPropNetPPPCommRedialEnabled


"CommRedialEnabled" 
extern const CFStringRef kSCPropNetPPPCommRedialEnabled;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPCommRedialEnabled;  

/*kSCPropNetPPPCommRemoteAddress


"CommRemoteAddress" 
extern const CFStringRef kSCPropNetPPPCommRemoteAddress;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPCommRemoteAddress;  


/*kSCPropNetPPPDisconnectOnIdleTimer


"DisconnectOnIdleTimer" 
extern const CFStringRef kSCPropNetPPPDisconnectOnIdleTimer;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPDisconnectOnIdleTimer; 

/*kSCPropNetPPPLogfile


"Logfile" 
extern const CFStringRef kSCPropNetPPPLogfile;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPLogfile;  


/*kSCPropNetPPPCommRedialCount


"CommRedialCount" 
extern const CFStringRef kSCPropNetPPPCommRedialCount;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPCommRedialCount; 

/*kSCPropNetPPPDisconnectOnLogout


"DisconnectOnLogout" 
extern const CFStringRef kSCPropNetPPPDisconnectOnLogout;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPDisconnectOnLogout;  


/*kSCPropNetPPPIdleReminder


"IdleReminder" 
extern const CFStringRef kSCPropNetPPPIdleReminder;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPIdleReminder;  


/*kSCPropNetPPPIdleReminder


"IdleReminder" 
extern const CFStringRef kSCPropNetPPPIdleReminder;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPIdleReminder;  


/*kSCPropNetPPPCommDisplayTerminalWindow


"CommDisplayTerminalWindow" 
extern const CFStringRef kSCPropNetPPPCommDisplayTerminalWindow;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCPropNetPPPCommDisplayTerminalWindow; 

/*kSCPropNetPPPAuthPassword


"AuthPassword" 
extern const CFStringRef kSCPropNetPPPAuthPassword;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPAuthPassword;  

/*kSCPropNetPPPAuthName


"AuthName" 
extern const CFStringRef kSCPropNetPPPAuthName;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPAuthName;  


/*kSCPropNetPPPIdleReminderTimer


"IdleReminderTimer" 
extern const CFStringRef kSCPropNetPPPIdleReminderTimer;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCPropNetPPPIdleReminderTimer;  


/*kSCDynamicStoreDomainSetup


"Setup:" 
extern const CFStringRef kSCDynamicStoreDomainSetup;  
Availability
Introduced in Mac OS X 10.1.*/
const CFStringRef kSCDynamicStoreDomainSetup;  


/*kSCCompAnyRegex


"[^/]+" 
extern const CFStringRef kSCCompAnyRegex;  
Availability
Introduced in Mac OS X 10.1.*/
 const CFStringRef kSCCompAnyRegex;  


/*SCNetworkConnectionCopyUserPreferences

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions );  
Parameters
selectionOptions
Currently unimplemented. Pass NULL for this version.
serviceID
Reference to the default serviceID for starting connections, this value will be returned by the function.
userOptions
Reference to default userOptions for starting connections, this will be returned by the function.
Return Value

Returns TRUE if there is a valid service to dial; FALSE if the function was unable to retrieve a service to dial. 
Discussion 

Provides the default service ID and a dictionary of user options for the connection. Applications can use the returned serviceID and userOptions values to open a connection on the fly. 
Availability
Introduced in Mac OS X v10.3.*/

Boolean SCNetworkConnectionCopyUserPreferences ( 
    CFDictionaryRef selectionOptions, 
    CFStringRef *serviceID, 
    CFDictionaryRef *userOptions ){};

 /*SCNetworkConnectionGetStatus

SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status value. 
Discussion 

Returns the status of the SCNetworkConnection. A status is one of the following values: 
 
	kSCNetworkConnectionInvalid
	kSCNetworkConnectionDisconnected
	kSCNetworkConnectionConnecting
	kSCNetworkConnectionDisconnecting
	kSCNetworkConnectionConnected

Availability
Introduced in Mac OS X v10.3.*/
SCNetworkConnectionStatus SCNetworkConnectionGetStatus ( 
    SCNetworkConnectionRef connection ){};  


/*SCNetworkConnectionStart

Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger );  
Parameters
connection
The SCNetworkConnection to start.
userOptions
The options dictionary to start the connection with. If userOptions is NULL, the default settings will be used. If userOptions are specified, they must be in the same format as network services stored in the system configuration preferences schema. The options will override the default settings defined for the service. 

For security reasons, not all options can be overridden; the appropriate merging of all settings will be done before the connection is established, and inappropriate options will be ignored.
linger
This parameter indicates whether or not the connection can stay around when the application no longer has interest in it. A typical application should pass FALSE, and the connection will be automatically stopped when the reference is released or if the application quits. If the application passes TRUE, the application can release the reference or exit and the connection will be maintained until a timeout event, until a specific stop request occurs, or until an error is encountered.
Return Value

Returns TRUE if the connection was correctly started (the actual connection is not established yet, and the connection status needs to be periodically checked); FALSE if the connection request was not started. The error must be retrieved from the SCError function. 
Discussion 

Starts the connection for the SCNetworkConnection. The connection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. The connection is made with the default settings from the administrator. Some of the settings can be overridden for the duration of the connection. These are specified in an options dictionary. The options dictionary uses the same format as a network service defined in the system configuration preferences schema. 

Note: Starting and stopping of connections is implicitly arbitrated. Calling SCNetworkConnectionStart on a connection already started will indicate that the application has interest in the connection and it shouldn't be stopped by anyone else. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStart ( 
    SCNetworkConnectionRef connection, 
    CFDictionaryRef userOptions, 
    Boolean linger ){};  

/*SCNetworkConnectionStop

Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect );  
Parameters
connection
The SCNetworkConnection to stop.
Return Value

Returns TRUE if the disconnection request succeeded; FALSE if the disconnection request failed. The error must be retrieved from the SCError function. 
Discussion 

Stops the connection for the SCNetworkConnection. The disconnection process is asynchronous and the function will return immediately. The connection status can be obtained by polling or by callback. This function performs an arbitrated stop of the connection. If several applications have marked their interest in the connection, by calling SCNetworkConnectionStart, the call will succeed but the actual connection will be maintained until the last interested application calls SCNetworkConnectionStop. 

In certain cases, you might want to stop the connection anyway. In these cases, you set the forceDisconnect argument to TRUE. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionStop ( 
    SCNetworkConnectionRef connection, 
    Boolean forceDisconnect ){};  

/*SCNetworkConnectionCopyExtendedStatus

CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection );  
Parameters
connection
The SCNetworkConnection to obtain status from.
Return Value

Returns the status dictionary. If NULL is returned, the error can be retrieved using the SCError function. 
Discussion 

Returns the extended status of the connection. An extended status dictionary contains specific dictionaries describing the status for each subcomponent of the service. 

For example, a status dictionary will contain the following sub-dictionaries, keys, and values: 
 
	IPv4  : Addresses      : the assigned IP address.
 
	PPP   : Status         : the PPP-specific status of type
				 SCNetworkConnectionPPPStatus.
 
		LastCause      : Available when the status is "Disconnected"
				 and contains the last error associated with
				 connecting or disconnecting.
 
		ConnectTime    : the time when the connection was
				 established.
 
	Modem : ConnectSpeed   : the speed of the modem connection
				 in bits/second.

Other dictionaries could be present for PPPoE, PPTP, and L2TP. 

The status dictionary may be extended in the future to contain additional information. 
Availability
Introduced in Mac OS X v10.3.*/
CFDictionaryRef SCNetworkConnectionCopyExtendedStatus ( 
    SCNetworkConnectionRef connection ){};  


/*kSCPropNetPPPStatus


"Status" 
extern const CFStringRef kSCPropNetPPPStatus;  
Availability
Introduced in Mac OS X 10.2.*/
const CFStringRef kSCPropNetPPPStatus ;  

/*SCNetworkConnectionCreateWithServiceID

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context );  
Parameters
allocator
The CFAllocator that should be used to allocate memory for the connection structure. This parameter may be NULL in which case the current default CFAllocator is used. If this reference is not a valid CFAllocator, the behavior is undefined.
serviceID
A string that defines the service identifier of the connection. Service identifiers uniquely identify services in the system configuration database.
callout
The function to be called when the status of the connection changes. If this parameter is NULL, the application will not receive notifications of status change and will need to poll for updates.
context
The SCNetworkConnectionContext associated with the callout.
Return Value

Returns a reference to the new SCNetworkConnection. 
Discussion 

Creates a new connection reference to use for getting the status or for connecting or disconnecting the associated service. 
Availability
Introduced in Mac OS X v10.3.*/

SCNetworkConnectionRef SCNetworkConnectionCreateWithServiceID ( 
    CFAllocatorRef allocator, 
    CFStringRef serviceID, 
    SCNetworkConnectionCallBack callout, 
    SCNetworkConnectionContext *context ){};  


/*SCNetworkConnectionScheduleWithRunLoop

Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to schedule.
runLoop
The run loop to schedule with.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is scheduled successfully; FALSE if the scheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Schedules a connection with the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionScheduleWithRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};  







/*SCNetworkConnectionUnscheduleFromRunLoop

Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode );  
Parameters
connection
The SCNetworkConnection to unschedule.
runLoop
The run loop to unschedule from.
runLoopMode
The run loop mode.
Return Value

Returns TRUE if the connection is unscheduled successfully; FALSE if the unscheduling failed. The error can be retrieved using the SCError function. 
Discussion 

Unschedules a connection from the run loop. 
Availability
Introduced in Mac OS X v10.3.*/
Boolean SCNetworkConnectionUnscheduleFromRunLoop ( 
    SCNetworkConnectionRef connection, 
    CFRunLoopRef runLoop, 
    CFStringRef runLoopMode ){};  










