#include <Metadata/Metadata.h>

/*MDItemCreate

Creates an MDItem object for a file at the specified path.

MDItemRef MDItemCreate (
CFAllocatorRef allocator,
CFStringRef path
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
path

A path to the file from which to create the MDItem. The path must exist.
Return Value

An MDItem object or NULL if there was a problem creating the object. 
Discussion

Returns a metadata item for the given path. MDItemRefs are uniqued and can be compared using == or CFEqual.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
MDItemRef MDItemCreate (
CFAllocatorRef allocator,
CFStringRef path
){};



/*MDItemCopyAttributeNames

Returns an array containing the attribute names existing in the metadata item.

CFArrayRef MDItemCopyAttributeNames (
MDItemRef item
);
Parameters
item

The item to be queried.
Return Value

A CFArray of CFString attribute names, or NULL on failure.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFArrayRef MDItemCopyAttributeNames (
MDItemRef item
){};

/*MDItemCopyAttributes

Returns the values of the specified attributes in the metadata item.

CFDictionaryRef MDItemCopyAttributes (
MDItemRef item,
CFArrayRef names
);
Parameters
item

The item to be queried.
names

A CFArray containing the names of the requested attributes.
Return Value

A CFDictionary containing keys for the requested attribute names, and the corresponding values. If an attribute does not exist, or the attribute is unreadable, there will be no key-value pair for it in the dictionary. Returns NULL on failure.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFDictionaryRef MDItemCopyAttributes (
MDItemRef item,
CFArrayRef names
){};

/*MDSchemaCopyDisplayNameForAttribute

Returns the localized display name of a metadata attribute key.

CFStringRef MDSchemaCopyDisplayNameForAttribute (
CFStringRef name
);
Parameters
name

The name of the metadata attribute key.
Return Value

The localized display name of the metadata attribute, or NULL if no localized display name is available.
Availability
Available in Mac OS X version 10.4 or later.*/
CFStringRef MDSchemaCopyDisplayNameForAttribute (
CFStringRef name
){};

/*MDQueryCreate

Creates a new query instance.

MDQueryRef MDQueryCreate (
CFAllocatorRef allocator,
CFStringRef queryString,
CFArrayRef valueListAttrs,
CFArrayRef sortingAttrs
);
Parameters
allocator

The CFAllocator object to be used to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
queryString

The query expression string for this query.
valueListAttrs

An optional array of attribute names. The query will collect the values of these attributes into uniqued lists that can be used to summarize the results of the query and allow the user to further qualify the search. This parameter may be NULL if no value lists are required. Value list collection increases CPU usage and significantly increases the memory usage of an MDQuery. The attribute names are CFStrings.
sortingAttrs

A n array of attribute names used to sort the results, or NULL if no sorting is required. The first name in the array is used as the primary sort key, the second as the secondary key, and so on. The comparison of like-typed values is a simple, literal comparison. Sorting increases memory usage and significantly increases the CPU usage of an MDQuery. It is usually more efficent to allow the MDQuery to sort the results than retrieiving the values and sorting the results yourself. The attribute names are CFStrings.
Return Value

An MDQueryRef, or NULL on failure. If the query string is empty or malformed the function returns NULL.
Availability
Available in Mac OS X v10.4 and later.*/
MDQueryRef MDQueryCreate (
CFAllocatorRef allocator,
CFStringRef queryString,
CFArrayRef valueListAttrs,
CFArrayRef sortingAttrs
){};

/*MDItemCopyAttribute

Returns the value of the specified attribute in the metadata item.

CFTypeRef MDItemCopyAttribute (
MDItemRef item,
CFStringRef name
)
Parameters
item

The item to be queried.
name

The name of the requested attribute.
Return Value

A CFTypeRef, or NULL if there was a failure reading the attribute or the attribute does not exist.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
MDItem.h*/
CFTypeRef MDItemCopyAttribute (
MDItemRef item,
CFStringRef name
){};

/*MDQueryGetResultAtIndex

Returns the current result at the given index.

const void *MDQueryGetResultAtIndex (
MDQueryRef query,
CFIndex idx
)
Parameters
query

The query.
idx

The index into the query's result list. If the index is negative, or is equal to or larger than the current number of results in the query, the behavior is undefined.
Return Value

Returns the MDItemRef currently at the given index, or if a result-creation function has been set, returns the result returned by that function.
Discussion

This function causes the result object to be created if it hasn't been created already. For performance reasons you should only request objects that you require. If possible, call this function to fetch only the results you need to display or otherwise process. 

Note that the index of a particular result can change over time if the query is configured to allow live-updates.
Availability
Available in Mac OS X v10.4 and later.*/
const void *MDQueryGetResultAtIndex (
MDQueryRef query,
CFIndex idx
){};



/*MDQueryGetResultCount

Returns the number of results currently collected by the query. 

CFIndex MDQueryGetResultCount (
MDQueryRef query
)
Parameters
query

The query.
Return Value

The number of results in the query.
Discussion

Note that the number of results in a query will change over time as the query's result list is updated.
Availability
Available in Mac OS X v10.4 and later.*/
CFIndex MDQueryGetResultCount (
MDQueryRef query
){};



/*MDQueryExecute

Run the query, and populate the query with the results. 

Boolean MDQueryExecute (
MDQueryRef query,
CFOptionFlags optionFlags
);
Parameters
query

The query to execute.
optionFlags

A bitwise OR of the MDQueryOptionFlags to be used by the query.
Return Value

Returns TRUE if the query was started, FALSE otherwise. Queries cannot be executed more than once.
Discussion

Queries only gather results or process updates while the current thread's run loop is running.

Queries have two phases: the initial gathering phase that collects all currently matching results and a second live-update phase. Updates occur during the live-update phase if a change in a file occurs such that it no longer matches the query or if it begins to match the query. Files which begin to match the query are added to the result list, and files which no longer match the query expression are removed from the result list.

Query notifications are posted within the context of the same thread which executes the query.
Availability
Available in Mac OS X v10.4 and later.*/
Boolean MDQueryExecute (
MDQueryRef query,
CFOptionFlags optionFlags
){};

/*MDQuerySetSearchScope

Sets the search scope for a query instance.

void MDQuerySetSearchScope (
MDQueryRef query,
CFArrayRef scopeDirectories,
OptionBits scopeOptions
);
Parameters
query

The query object to modify.
scopeDirectories

A CFArray of CFStringRef or CFURLRef objects which specify where to search. For convenience the kMDQueryScopeHome, kMDQueryScopeComputer and kMDQueryScopeNetwork constants may also be included in the array.
scopeOptions

Additional options for modifying the search. Currently you must pass 0.
Discussion

Availability
Available in Mac OS X v10.4 and later.*/
void MDQuerySetSearchScope (
MDQueryRef query,
CFArrayRef scopeDirectories,
OptionBits scopeOptions
){};











