#import <DiscRecordingEngine/DRCoreNotifications.h>

/*DRNotificationCenterCreate


Creates a notification center that can be used to register for and receive asyncronous notifications. 
extern DRNotificationCenterRef DRNotificationCenterCreate(
    void) ;  
Return Value

Returns reference to a new DRNotificationCenter object. 
Availability
Introduced in Mac OS X v10.2*/
DRNotificationCenterRef DRNotificationCenterCreate(
    void) {};  

/*DRNotificationCenterCreateRunLoopSource


Creates a run-loop source object for a notification center. 
extern CFRunLoopSourceRef DRNotificationCenterCreateRunLoopSource(
    DRNotificationCenterRef center) ;  
Parameters
center
The notification center that the new run-loop source object is for. 

If this parameter is not a valid DRNotificationCenter object, the behavior is undefined.
Return Value

Returns a reference to a CFRunLoopSource object. 
Availability
Introduced in Mac OS X v10.2*/
CFRunLoopSourceRef DRNotificationCenterCreateRunLoopSource(
    DRNotificationCenterRef center){} ;  


/*DRNotificationCenterAddObserver


Adds an observer callback for a notification center. 
extern void DRNotificationCenterAddObserver(
    DRNotificationCenterRef center,
    const void *observer,
    DRNotificationCallback callback,
    CFStringRef name,
    DRTypeRef object) ;  
Parameters
center
The notification center that the new observer callback is for.
observer
The observer callback to add, which gets passed to the callback.
callback
The observer callback to use for notification delivery.
name
The notification name for adding the observer.
object
The object the notification name is associated with.
Availability
Introduced in Mac OS X v10.2*/
void DRNotificationCenterAddObserver(
    DRNotificationCenterRef center,
    const void *observer,
    DRNotificationCallback callback,
    CFStringRef name,
    DRTypeRef object){} ;  


