#include <DiscRecordingEngine/DRCoreDevice.h>

/*DRDeviceCopyInfo


Returns information about the device. 
extern CFDictionaryRef DRDeviceCopyInfo(
    DRDeviceRef device) ;  
Parameters
device
The device to query.
Return Value

A CFDictionary object identifying the device and its capabilities. 
Discussion 

This function returns information that identifies the device and describes its capabilites. The information includes the vendor's name, the product identifier, whether the device can burn CDs or DVDs, and so on. 
Availability
Introduced in Mac OS X v10.2*/
CFDictionaryRef DRDeviceCopyInfo(
    DRDeviceRef device) {};  



/*kDRDeviceCanWriteDVDRAMKey

extern const CFStringRef kDRDeviceCanWriteDVDRAMKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to DVD-RAM media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceCanWriteDVDRAMKey;  

/*kDRDeviceWriteCapabilitiesKey

extern const CFStringRef kDRDeviceWriteCapabilitiesKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object describing the capabilities the drive has for writing to different media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceWriteCapabilitiesKey;  

/*kDRDeviceProductNameKey

extern const CFStringRef kDRDeviceProductNameKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the product name extracted from the device. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDeviceProductNameKey;  

/*kDRDeviceVendorNameKey

extern const CFStringRef kDRDeviceVendorNameKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the vendor name extracted from the device. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceVendorNameKey;  


/*kDRDeviceCanWriteDVDRWKey

extern const CFStringRef kDRDeviceCanWriteDVDRWKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to DVD-RW media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceCanWriteDVDRWKey;  

/*kDRDevicePhysicalInterconnectFireWire

extern const CFStringRef kDRDevicePhysicalInterconnectFireWire;  
Discussion 

One value for the kDRDevicePhysicalInterconnectKey dictionary key. This value indicates that the device is connected by a FireWire interface. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDevicePhysicalInterconnectFireWire;  


/*kDRDeviceCanWriteDVDRKey

extern const CFStringRef kDRDeviceCanWriteDVDRKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to DVD-R media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceCanWriteDVDRKey;  

/*kDRDeviceCanWriteCDRWKey

extern const CFStringRef kDRDeviceCanWriteCDRWKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to CD-RW media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceCanWriteCDRWKey;  


/*DRCopyDeviceArray


Returns an array of all writable devices connected to the system. 
extern CFArrayRef DRCopyDeviceArray() ;  
Return Value

A CFArray containing the devices attached to the system at the time the function is called. 
Discussion 

FireWire, USB, and other technologies allow users to connect and disconnect devices while a computer is on. The device array returned by this function is a snapshot that is not guaranteed to stay current for the lifetime of a process. 

Since device connections are dynamic, a better option than this function is to maintain a list of attached devices by listening for kDRDeviceAppearedNotification and kDRDeviceDisappearedNotification notifications. This function is most useful for initially populating a list of devices. 
Availability
Introduced in Mac OS X v10.2*/
CFArrayRef DRCopyDeviceArray(){} ;


/*DRDeviceEjectMedia


Commands a device to unmount and eject media. 
extern OSStatus DRDeviceEjectMedia(
    DRDeviceRef device) ;  
Parameters
device
Device to eject.
Return Value

An error code indicating whether the media could be ejected. 
Discussion 

If media is present but cannot be unmounted, this function will fail and return an error. If there is no media in the device, this function is equivalent to DRDeviceOpenTray . 
Availability
Introduced in Mac OS X v10.2*/
OSStatus DRDeviceEjectMedia(
    DRDeviceRef device){} ;  

/*DRDeviceCopyStatus


Returns the status of the device. 
extern CFDictionaryRef DRDeviceCopyStatus(
    DRDeviceRef device) ;  
Parameters
device
The device to query.
Return Value

A CFDictionary object describing the status of the device and any media it contains. 
Discussion 

This function returns information about the status of the device. This information includes whether media is present or not, and, if present, a descripton of the media including its size, kind, and so on. 
Availability
Introduced in Mac OS X v10.2*/
CFDictionaryRef DRDeviceCopyStatus(
    DRDeviceRef device){} ;  

/*kDRDeviceMediaStateKey

extern const CFStringRef kDRDeviceMediaStateKey;  
Discussion 

A key for the dictionary returned by DRDeviceCopyStatus . The value of this key is a reference to a CFString object containing information about the state of the media. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDeviceMediaStateKey;  


/*kDRDeviceCanWriteCDRKey

extern const CFStringRef kDRDeviceCanWriteCDRKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to CD-R media. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDeviceCanWriteCDRKey;  

/*kDRDeviceCanWriteCDRKey

extern const CFStringRef kDRDeviceCanWriteCDRKey;  
Discussion 

A key for the kDRDeviceWriteCapabilitiesKey dictionary in the device info dictionary. The value is a reference to a CFBoolean object indicating whether the device can write to CD-R media. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceCanWriteCDRKey;
/*kDRDeviceMediaStateMediaPresent

extern const CFStringRef kDRDeviceMediaStateMediaPresent;  
Discussion 

One value for the kDRDeviceMediaStateKey dictionary key. This value indicates that some kind of media is present in the drive. Check the value of the kDRDeviceMediaInfoKey dictionary key for specific media information. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaStateMediaPresent;  


/*kDRDeviceMediaInfoKey

extern const CFStringRef kDRDeviceMediaInfoKey;  
Discussion 

A key for the dictionary returned by DRDeviceCopyStatus . The value of this key is a reference to a CFDictionary object containing information about the media in the drive. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaInfoKey;  


/*kDRDeviceStatusChangedNotification

extern const CFStringRef kDRDeviceStatusChangedNotification;  
Discussion 

Notification sent when a device's status changes, usually because a disc has been inserted or removed. The value of the info parameter for your notification callback is equivalent to the dictionary object reference returned from a call to DRDeviceCopyStatus . 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDeviceStatusChangedNotification;  


/*kDRDeviceDisappearedNotification

extern const CFStringRef kDRDeviceDisappearedNotification;  
Discussion 

Notification sent when a device is no longer available. Because users can connect and disconnect FireWire, USB, and other devices while a computer is on, you should maintain your own list of attached devices and rely on notifications to keep the list current. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceDisappearedNotification;  

/*kDRDeviceMediaIsBlankKey

extern const CFStringRef kDRDeviceMediaIsBlankKey;  
Discussion 

A key in the kDRDeviceMediaInfoKey dictionary. The value of this key is a reference to a CFBoolean object indicating whether the media is blank and has no data on it. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaIsBlankKey;  




/*kDRDeviceMediaIsAppendableKey

extern const CFStringRef kDRDeviceMediaIsAppendableKey;  
Discussion 

A key in the kDRDeviceMediaInfoKey dictionary. The value of this key is a reference to a CFBoolean object indicating whether the disc is appendable -- in other words, whether new sessions can be written. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaIsAppendableKey;  


/*DRDeviceIsValid


Determines whether the device is still attached and turned on. 
extern Boolean DRDeviceIsValid(
    DRDeviceRef device) ;  
Parameters
device
The device reference to check.
Return Value

A boolean indicating whether the device reference is still usable (TRUE) or not (FALSE). 
Discussion 

Devices can be removed from a system while a client has a reference to them. This function allows clients to check if a device reference they are holding is still usable. 
Availability
Introduced in Mac OS X v10.2*/
 Boolean DRDeviceIsValid(
    DRDeviceRef device) {};

  
/*kDRDeviceMediaIsReservedKey

extern const CFStringRef kDRDeviceMediaIsReservedKey;  
Discussion 

A key in the kDRDeviceMediaInfoKey dictionary. The value of this key is a reference to a CFBoolean object indicating whether the disc is reserved for exclusive use by the current process. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaIsReservedKey;  



/*kDRDevicePhysicalInterconnectUSB

extern const CFStringRef kDRDevicePhysicalInterconnectUSB;  
Discussion 

One value for the kDRDevicePhysicalInterconnectKey dictionary key. This value indicates that the device is connected by a USB interface. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDevicePhysicalInterconnectUSB;  

/*kDRDeviceMediaIsErasableKey

extern const CFStringRef kDRDeviceMediaIsErasableKey;  
Discussion 

A key in the kDRDeviceMediaInfoKey dictionary. The value of this key is a reference to a CFBoolean object indicating whether the disc can be erased. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaIsErasableKey;  

/*kDRDeviceFirmwareRevisionKey

extern const CFStringRef kDRDeviceFirmwareRevisionKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the firmware revision extracted from the device. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDeviceFirmwareRevisionKey;  

/*kDRDevicePhysicalInterconnectSCSI

extern const CFStringRef kDRDevicePhysicalInterconnectSCSI;  
Discussion 

One value for the kDRDevicePhysicalInterconnectKey dictionary key. This value indicates that the device is connected by a SCSI interface. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDevicePhysicalInterconnectSCSI;  


/*kDRDevicePhysicalInterconnectATAPI

extern const CFStringRef kDRDevicePhysicalInterconnectATAPI;  
Discussion 

One value for the kDRDevicePhysicalInterconnectKey dictionary key. This value indicates that the device is connected by an ATAPI interface. 
Availability
Introduced in Mac OS X v10.2*/
 const CFStringRef kDRDevicePhysicalInterconnectATAPI;  

/*kDRDeviceMediaStateInTransition

extern const CFStringRef kDRDeviceMediaStateInTransition;  
Discussion 

One value for the kDRDeviceMediaStateKey dictionary key. This value indicates that the media is in transition, typically spinning up after being inserted or spinning down in preparation for ejecting. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDeviceMediaStateInTransition;  

/*kDRDevicePhysicalInterconnectKey

extern const CFStringRef kDRDevicePhysicalInterconnectKey;  
Discussion 

A key for the dictionary object returned by DRDeviceCopyInfo . The value of this key is a reference to a CFString object containing the type of the bus the device is on. 
Availability
Introduced in Mac OS X v10.2*/
const CFStringRef kDRDevicePhysicalInterconnectKey;  

/*DRDeviceAcquireMediaReservation


Indicates an interest in reserving blank media. 
extern void DRDeviceAcquireMediaReservation(
    DRDeviceRef device) ;  
Parameters
device
The device reference for which to indicate an interest.
Discussion 

Blank media participates in a reservation system thats allows applications to express claims on blank media to other applications. Indicating an interest to reserve blank media does not guarantee acquisition--there may be other applications that have indicated an interest in the same media. 

Your application will receive a kDRDeviceStatusChangedNotification notification with a value of true for the kDRDeviceMediaIsReservedKey when a blank media reservation has been acquired. 

This function may be called multiple times. Each time it is called, a call to DRDeviceReleaseMediaReservation must be made at a later time or the process will never fully rescind its interest in the blank media reservation. 
Availability
Introduced in Mac OS X v10.2*/
 void DRDeviceAcquireMediaReservation(
    DRDeviceRef device){} ;  


/*DRDeviceReleaseMediaReservation


Rescind an interest in the blank media reservation. 
extern void DRDeviceReleaseMediaReservation(
    DRDeviceRef device) ;  
Parameters
device
The device reference for which to rescind an interest.
Discussion 

If the process currently has a reservation, it will be released and passed on to the next interested process. 
Availability
Introduced in Mac OS X v10.2*/
void DRDeviceReleaseMediaReservation(
    DRDeviceRef device){} ;  


/*DRDeviceAcquireExclusiveAccess


Attempts to acquire an exclusive access session with the device. 
extern OSStatus DRDeviceAcquireExclusiveAccess(
    DRDeviceRef device) ;  
Parameters
device
The device reference for which to acquire exclusive access.
Return Value

An error code indicating whether exclusive access could be acquired. 
Discussion 

If this function succeeds, the device becomes unusable by any other process. All volumes mounted from media in the drive must be unmounted before exclusive access can be granted. The Disc Recording engine attempts to unmount volumes for you, but this call will fail if some volumes could not be unmounted. 

Your application may call this function multiple times. Each time, a call to DRDeviceReleaseExclusiveAccess must be made at a later time or the process will never release its exclusive access. 
Availability
Introduced in Mac OS X v10.2*/
 OSStatus DRDeviceAcquireExclusiveAccess(
    DRDeviceRef device){} ;  


/*DRDeviceReleaseExclusiveAccess


Release exclusive access to a device. 
extern void DRDeviceReleaseExclusiveAccess(
    DRDeviceRef device) ;  
Parameters
device
The device reference for which to release exclusive access.
Discussion 

This function will release one request for exclusive access made by a process that called DRDeviceAcquireExclusiveAccess. A call to this function must be made for every call to DRDeviceAcquireExclusiveAccess , otherwise the process will never release its exclusive access. 
Availability
Introduced in Mac OS X v10.2*/
void DRDeviceReleaseExclusiveAccess(
    DRDeviceRef device){} ;  




