#import <DiscRecordingContent/DRTrack_ContentSupport.h>

@implementation  DRTrack (AudioContentCreation)

/*trackForAudioFile:


Creates a DRTrack capable of burning RedBook CD audio from a QuickTime readable file. 
private

+ (DRTrack*) trackForAudioFile:(NSString*)path; 
Parameters
path
The path to the file. This file must be one that can be read by QuickTime.
Return Value

An autoreleased DRTrack 
Discussion 

This method creates a track object configured and primed to output RedBook audio CD data. It accepts any file readable by QuickTime and extracts the audio data (if any) from the file, translating that into the correct format for output to the disc.*/
+ (DRTrack*) trackForAudioFile:(NSString*)path{}

@end


@implementation  DRTrack (DataContentCreation)

/*trackForRootFolder:


Creates a DRTrack capable of burning a folder to disc. 
private

+ (DRTrack*) trackForRootFolder:(DRFolder*)rootFolder;
Parameters
rootFolder
The root of the volume to be created.
Return Value

An autoreleased DRTrack 
Discussion 

Additional track properties can be set controlling the various filesystems to be generated. See the documentation for DRTrack for more info.*/
+ (DRTrack*) trackForRootFolder:(DRFolder*)rootFolder{}


@end
