#import <AppKit/NSShadow.h>

@implementation  NSShadow

/*setShadowOffset:

Sets the offset values for the receiver.

- (void)setShadowOffset:(NSSize)offset
Parameters
offset

The horizontal and vertical offset values, specified using the width and height fields of the NSSize data type. These offsets are measured using the default user coordinate space and are not affected by custom transformations. This means that positive values always extend up and to the right from the user's perspective. 
Availability
Available in Mac OS X v10.3 and later.
See Also
– shadowOffset*/
- (void)setShadowOffset:(NSSize)offset{}


/*setShadowBlurRadius:

Sets the blur radius of the receiver. 

- (void)setShadowBlurRadius:(float)val
Parameters
val

The blur radius, as measured in the default user coordinate space. A value of 0 indicates no blur, while larger values produce correspondingly larger blurring. This value must not be negative.
Availability
Available in Mac OS X v10.3 and later.
See Also
– shadowBlurRadius*/
- (void)setShadowBlurRadius:(float)val{}

/*shadowOffset

Returns the offset values for the receiver.

- (NSSize)shadowOffset
Return Value

The horizontal and vertical offset values, specified using the width and height fields of the NSSize data type. These offsets are measured using the default user coordinate space and are not affected by custom transformations. This means that positive values always extend up and to the right from the user's perspective.
Availability
Available in Mac OS X v10.3 and later.
See Also
– setShadowOffset:*/
- (NSSize)shadowOffset{}


/*shadowBlurRadius

Returns the blur radius of the receiver.

- (float)shadowBlurRadius
Return Value

The blur radius, as measured in the default user coordinate space. A value of 0 indicates no blur, while larger values produce correspondingly larger blurring. The default value is 0.
Availability
Available in Mac OS X v10.3 and later.
See Also
– setShadowBlurRadius:*/
- (float)shadowBlurRadius{}

/*set

Sets the shadow of subsequent drawing operations to the shadow represented by the receiver.

- (void)set
Discussion

The shadow attributes of the receiver are used until another shadow is set or until the graphics state is restored.
Availability
Available in Mac OS X v10.3 and later.*/
- (void)set{}



@end

