#include <AGL/agl.h>

/*aglChoosePixelFormat

Creates a pixel format object that satisfies the constraints of the specified buffer and renderer attributes.

AGLPixelFormat aglChoosePixelFormat (
   const AGLDevice *gdevs,
   GLint ndev,
   const GLint *attribs);
Parameters
gdevs

A pointer to an AGLDevice data type that contains an array of Mac OS graphics devices. AGL chooses pixel formats and renderers that are appropriate for these devices. To create a pixel format object that supports all devices on the system, pass NULL.
ndev

The number of graphics devices that your application supplies in the gdevs parameter. Pass 0 if you also pass NULL for the gdevs parameter.
attribs

A NULL terminated array that contains a list of buffer and renderer attributes. The existence of a Boolean attribute implies a true value. If an attribute is not Boolean in nature, you must supply the desired value immediately following the attribute. For information on the attributes that you can supply, see “Buffer and Renderer Attributes”. I
Return Value

A new pixel format object that contains pixel format information and a list of virtual screens. Returns NULL if the system cannot find a pixel format and virtual screen that satisfies the constraints of the buffer and renderer attributes.
Discussion

After a pixel format object is created successfully, the integer attributes are set to values that are as close to the desired value as can be provided by the system. Attribute values can differ for each virtual screen. You can use the AGL_MINIMUM_POLICY and AGL_MAXIMUM_POLICY attributes to control how the system chooses the setting. For more information on choosing attributes, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglCreateContext
aglDescribePixelFormat
aglDestroyPixelFormat*/

AGLPixelFormat aglChoosePixelFormat (
   const AGLDevice *gdevs,
   GLint ndev,
   const GLint *attribs){};

/*aglCreateContext

Creates an AGL rendering context.

AGLContext aglCreateContext (
   AGLPixelFormat pix,
   AGLContext share);
Parameters
pix

A pixel format object creating by calling the function aglChoosePixelFormat.
share

The rendering context with which to share the OpenGL object state—including texture objects, programs and shader display lists, vertex array objects, vertex buffer objects, pixel buffer objects, and frame buffer objects—and the object state associated which each of these object types. Pass NULL to indicate that no sharing is to take place. 
Return Value

A new rendering context. The aglCreateContext function returns NULL if the function fails for any reason. You can call the function aglGetError to determine what the error is.
Discussion

If the pixel format object you supply is able to support multiple graphics devices, then the rendering context can render transparently across the supported devices. With a multiple-device rendering context, sharing is possible only when the relationship between the renderers and the graphics devices they support is the same for all rendering contexts that are shared. Normally you achieve the best results by using the same pixel format object for all shared rendering contexts. For more information, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglChoosePixelFormat
aglDestroyContext
aglSetDrawable*/

AGLContext aglCreateContext (
   AGLPixelFormat pix,
   AGLContext share){};

/*aglGetError

Returns an AGL error code.

GLenum aglGetError (void);
Return Value

The value of the global AGL error flag. See “Error Codes” for a complete description of the error codes that can be returned.
Discussion

This function is similar to the OpenGL function glGetError. You call the function aglGetError whenever an AGL function returns TRUE to retrieve the error code associated with the error condition. Each error is assigned a numeric code and a symbolic name. When an error occurs, the error flag is set to the appropriate error code value. No other errors are recorded until aglGetError is called, the error code is returned, and the flag is reset to AGL_NO_ERROR. If a call to aglGetError returns AGL_NO_ERROR, this means that there has been no detectable error since the last call to aglGetError.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglErrorString*/
GLenum aglGetError (void){};


/*aglGetCGLContext

Gets the CGL rendering context associated with an AGL rendering context.

GLboolean aglGetCGLContext (
   AGLContext ctx,
   void **cgl_ctx);
Parameters
ctx

An AGL rendering context.
cgl_ctx

On return, points to the CGL rendering context associated with the specified AGL rendering context.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You should use this function only when you absolutely need to use a non-AGL function that requires an CGL rendering context. You can cast the returned CGL rendering context to another data type as needed. Note that destroying the AGL rendering context also destroys the CGL rendering context, thus rendering the data reference returned by this function invalid.

Note: Always use the AGL version of a function when available, because there is additional work that AGL must perform to be compatible with Carbon.

Availability
Available in Mac OS X v10.4 and later.
Declared In
agl.h*/

GLboolean aglGetCGLContext (
   AGLContext ctx,
   void **cgl_ctx){};


/*aglSetDrawable

Attaches a rendering context to a Carbon window.

GLboolean aglSetDrawable (
   AGLContext ctx,
   AGLDrawable draw);
Parameters
ctx

A rendering context returned by the function aglCreateContext.
draw

The drawable object—which must be a Carbon window—to attach to the AGL rendering context. You need to supply a CGrafPtr data type obtained from a valid window. The Window Manager function GetWindowPort returns the CGrafPtr associated with a Carbon window. To disable rendering for a rendering context, pass NULL. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

After calling this function, AGL directs subsequent OpenGL rendering calls to the specified rendering context to modify the window content. In addition, the function aglSetDrawable performs all of the actions performed by aglUpdateContext.

When a rendering context is initially attached to the window, its viewport is set to the full size of the window. If the rendering context is subsequently attached to the same window, its viewport is unaltered.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetDrawable*/
GLboolean aglSetDrawable (
   AGLContext ctx,
   AGLDrawable draw){};

/*aglSetInteger

Sets the value of an option for a rendering context.

GLboolean aglSetInteger (
   AGLContext ctx,
   GLenum pname,
   const GLint *params);
Parameters
ctx

A rendering context.
pname

The rendering context option whose value you want to set. You can pass any of the constants listed in “Context Options and Parameters” that have an associated integer value.
params

A pointer to the value to set the parameter to.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

Use aglEnable to enable the option.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetInteger*/
GLboolean aglSetInteger (
   AGLContext ctx,
   GLenum pname,
   const GLint *params){};


/*aglGetCGLPixelFormat

Gets the CGL pixel format object associated with an AGL pixel format.

GLboolean aglGetCGLPixelFormat (
   AGLPixelFormat pix,
   void **cgl_pix);
Parameters
pix

An AGL pixel format object.
cgl_pix

On return, points to the CGL pixel format object associated with the specified AGL pixel format.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You should use this function only when you absolutely need to pass a CGL pixel format object to a non-AGL function. You can cast the returned CGL pixel format object to another data type as needed. Note that destroying the AGL pixel format object also destroys the CGL pixel format object, thus making the data reference returned invalid.

Note: Always use the AGL version of a function when available, because there is additional work that AGL must perform to be compatible with Carbon.

Availability
Available in Mac OS X v10.4 and later.
Declared In
agl.h*/

GLboolean aglGetCGLPixelFormat (
   AGLPixelFormat pix,
   void **cgl_pix){};


/*aglSetCurrentContext

Sets the specified rendering context as the current rendering context.

GLboolean aglSetCurrentContext (
   AGLContext ctx);
Parameters
ctx

The rendering context to set as the current rendering context. Pass NULL to release the current rendering context without assigning a new one.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

There can be only one current rendering context. Subsequent OpenGL rendering calls operate on the current rendering context to modify the drawable object associated with it. 

You can use AGL macros to bypass the current rendering context mechanism and maintain your own current rendering context.

A context is current on a per-thread basis. Multiple threads must serialize calls into the same context.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetCurrentContext*/
GLboolean aglSetCurrentContext (
   AGLContext ctx){};


/*aglErrorString

Returns a string that describes the specified AGL error code.

const GLubyte *aglErrorString (
   GLenum code);
Parameters
code

An AGL error code returned by the function aglGetError. For a description of these constants, see “Error Codes”.
Return Value

An error string that describes the error code passed in the code parameter. If the code is invalid, returns the string “No such error code.”
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetError*/
const GLubyte *aglErrorString (
   GLenum code){};


/*aglSurfaceTexture

Allows texturing from a drawable object that has an attached rendering context, using the surface contents as the source data for the texture.

void aglSurfaceTexture (
   AGLContext context,
   GLenum target,
   GLenum internalformat,
   AGLContext surfacecontext);
Parameters
context

A rendering context attached to the window that's the target of the texture operation.
target

A constant that specifies an OpenGL target texture. You can supply any of the texture targets defined by the OpenGL specification, including: 
GL_TEXTURE_2D, a texture whose dimensions are a power of two.
GL_TEXTURE_RECTANGLE_EXT, a texture whose dimensions are not a power of two.
GL_TEXTURE_CUBE_MAP, a mapped cube texture.
internalformat

A constant that specifies the internal color format of the texture— either GL_RGB or GL_RGBA.
surfacecontext

A rendering context that's attached to the window that's the source of the texture data.
Discussion

The aglSurfaceTexture function behaves similar to the function glTexImage2D. The texture target and internal format must be supported by the renderer of the target rendering context, and the geometry of the source drawable object must be compatible with the texture target. For example, if the texture target is GL_TEXTURE_2D, the window must conform to power-of-two dimensions.

Before calling this function you must use OpenGL calls to set up the OpenGL texture referred to by the target parameter. That is, enable texturing, generate a texture name, bind it to a texture target, and so forth. For more information, see OpenGL Programming Guide.

The target and source windows must use the same renderer (virtual screen) or the function fails, most typically by not texturing the target rendering context.

An error condition occurs if the surface rendering context is not attached to a windowed drawable object; the drawable object cannot be an offscreen area or pixel buffer. It’s also possible to get standard OpenGL errors similar to the errors that can occur for the function glTexImage2D. Use the function glError to query OpenGL errors.

Note: Although the function aglSurfaceTexture provides a flexible way to render to an offscreen texture and then use it as a source, you should consider using pixel buffer objects or OpenGL framebuffer objects instead. For details on using a hidden window as a texture source, see OpenGL Programming Guide for Mac OS X. This document also describes how to use pixel buffer objects and framebuffer objects as texture sources.

Availability
Available in Mac OS X v10.2 and later.
Declared In
agl.h*/

void aglSurfaceTexture (
   AGLContext context,
   GLenum target,
   GLenum internalformat,
   AGLContext surfacecontext){};

/*aglDestroyContext

Frees the resources associated with a rendering context.

GLboolean aglDestroyContext (
   AGLContext ctx);
Parameters
ctx

The rendering context whose resources you want to release. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

This function frees all the resources used by the rendering context passed to it. If the rendering context that you pass is the current rendering context, the current context is set to NULL and there is no current rendering context after the function executes.

After you call this function, you must make sure that you do not use the destroyed rendering context. This includes using AGL macros in which the rendering context is explicitly passed to OpenGL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglCreateContext
aglUpdateContext*/

GLboolean aglDestroyContext (
   AGLContext ctx){};


/*aglDestroyPixelFormat

Frees the memory associated with a pixel format object.

void aglDestroyPixelFormat (
   AGLPixelFormat pix);
Parameters
pix

The pixel format object whose resources you want to release. This must be a pixel format object returned by the functionaglChoosePixelFormat. AGL sets a AGL_BAD_PIXELFMT error if you pass the returned value from the function aglNextPixelFormat or the pix parameter is not a valid pixel format.
Discussion

A copy of the pixel format data is made by the aglCreateContext function, so your application can free a pixel format immediately after creating a rendering context with it. On the other hand, a pixel format object can be useful for enumerating virtual screens when multiple renderers are supported, so you may want to retain it.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDescribePixelFormat*/

void aglDestroyPixelFormat (
   AGLPixelFormat pix){};


/*aglSwapBuffers

Exchanges the front and back buffers of the specified rendering context.

void aglSwapBuffers (
   AGLContext ctx);
Parameters
ctx

The rendering context whose buffers you want to swap. AGL sets the AGL_BAD_CONTEXT error if the ctx parameter is not a valid AGL rendering context.
Discussion

The aglSwapBuffers function either swaps the buffers or copies the back buffer content to the front buffer. Before it returns, aglSwapBuffers invokes the OpenGL function glFlush.

To synchronize with a monitor retrace, set the current swap interval (AGL_SWAP_INTERVAL) to 1 by calling the function aglSetInteger. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h*/
void aglSwapBuffers (
   AGLContext ctx){};


/*aglUpdateContext

Notifies the rendering context that the window geometry has changed.

GLboolean aglUpdateContext (
   AGLContext ctx);
Parameters
ctx

The rendering context that needs updating. 
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You must call the aglUpdateContext function any time that the geometry of the drawable object changes. You should call this function after the completion of any move or resize action.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglSetDrawable*/
GLboolean aglUpdateContext (
   AGLContext ctx){};

/*aglCreatePBuffer

Creates a pixel buffer of the specified size, compatible with the specified texture target.

GLboolean aglCreatePBuffer (
   GLint width,
   GLint height,
   GLenum target,
   GLenum internalFormat,
   long max_level,
   AGLPbuffer *pbuffer);
Parameters
width

The width, in pixels, of the pixel buffer.
height

The height, in pixels, of the pixel buffer.
target

A constant that specifies the type of the pixel buffer target texture. You can supply any of the texture targets defined by the OpenGL specification, including: 
GL_TEXTURE_2D, a texture whose dimensions are a power of two.
GL_TEXTURE_RECTANGLE_EXT, a texture whose dimensions are not a power of two.
GL_TEXTURE_CUBE_MAP, a mapped cube texture.
internalformat

A constant that specifies the internal color format of the pixel buffer, which can be GL_RGB or GL_RGBA. The format controls whether the alpha channel of the pixel buffer is used for texturing operations. 
max_level

The maximum level of mipmap detail allowable. Pass 0 for a pixel buffer that's not using mipmaps. The value passed should never exceed the actual maximum number of mipmap levels that can be represented with the given width and height.
pbuffer

On return, points to a new pixel buffer object.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

This function does not have any knowledge of OpenGL contexts or pixel format objects and does not specifically allocate the storage needed for the actual pixel buffer. These operations occur when you call the function aglSetPBuffer.

You can determine the dimensional limits of a pixel buffer by calling the OpenGL function glGetInteger. You can find the maximum size supported by querying GL_MAX_VIEWPORT_DIMS and the minimum size by querying GL_MIN_PBUFFER_VIEWPORT_DIMS_APPLE, which returns two integer values (similar to GL_MAX_VIEWPORT_DIMS). All pixel buffer dimensions that you request with the function aglCreatePBuffer should fall within these limits (inclusively) and should comply with any limitations imposed by the texture target you select.

The maximum viewport size supported in Mac OS X is quite large. You should take into consideration the amount of video or system memory required to support the requested pixel buffer size, including additional memory needed for multiple buffers and options such as multisampling.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglDescribePBuffer
aglDestroyPBuffer*/
GLboolean aglCreatePBuffer (
   GLint width,
   GLint height,
   GLenum target,
   GLenum internalFormat,
   long max_level,
   AGLPbuffer *pbuffer){};

/*aglGetVirtualScreen

Returns the current virtual screen number associated with a rendering context.

GLint aglGetVirtualScreen (
   AGLContext ctx);
Parameters
ctx

A rendering context.
Return Value

Returns the virtual screen number of the context. The value is always 0 on a single-monitor system and –1 if the function fails for any reason. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

The current virtual screen is set automatically by the function aglUpdateContext. The current virtual screen can change when a drawable object is moved or resized across graphics device boundaries. A change in the current virtual screen can affect the return values of some OpenGL functions and in most cases also means that the renderer has changed.

For detailed information on virtual screens, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglSetVirtualScreen*/

GLint aglGetVirtualScreen (
   AGLContext ctx){};



/*aglSetPBuffer

Attaches a pixel buffer object to a rendering context.

GLboolean aglSetPBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint face,
   GLint level,
   GLint screen);
Parameters
ctx

A rendering context.
pbuffer

A pixel buffer object.
face

The cube map face to draw if the buffer texture target is type GL_TEXTURE_CUBE_MAP; otherwise pass 0.
level

The mipmap level to draw. This must not exceed the maximum mipmap level set when the pixel buffer object was created. Pass 0 for a texture target that does not support mipmaps.
screen

A virtual screen value. The virtual screen determines the renderer that OpenGL uses to draw to the pixel buffer object. For best performance, for a pixel buffer used as a texture source, you should supply the a virtual screen value that results in using the same renderer used by the context that's the texturing target.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

The first time you call this function for a specific pixel buffer object, the system creates the necessary buffers. The buffers are created to support the pixel formats used to create the rendering context. The storage requirements for pixel buffer objects, which can be quite large, are very similar to the requirements for windows or views with OpenGL contexts attached. All drawable objects compete for the same scarce resources. This function can fail is there is not enough contiguous VRAM for each buffer. It's best to code defensively with a scheme that reduces resource consumption without causing the application to resort to failure. Unless, of course, failure is the only viable alternative.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglGetPBuffer*/
GLboolean aglSetPBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint face,
   GLint level,
   GLint screen){};


/*aglTexImagePBuffer

Binds the contents of a pixel buffer to a data source for a texture object.

GLboolean aglTexImagePBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint source);
Parameters
ctx

A rendering context, which is the target context for the texture operation. This is the context that you plan to render content to. This is not the context attached to the pixel buffer.
pbuffer

A pixel buffer object.
source

The source buffer to texture from, which should be a valid OpenGL buffer such as GL_FRONT or GL_BACK and should be compatible with the buffer and renderer attributes that you used to create the rendering context attached to the pixel buffer. This means that the pixel buffer must possess the buffer in question for the texturing operation to succeed.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

You must generate and bind a texture name (using standard OpenGL texturing calls) that is compatible with the pixel buffer texture target. Don't supply a texture object that was used previously for nonpixel buffer texturing operations unless a you first call the OpenGL function glDeleteTextures and then regenerate the texture name. 

If you modify the content of a pixel buffer that uses mipmap levels, you must call this function again before drawing with the pixel buffer, to ensure that the content is synchronized with OpenGL. For pixel buffers without mipmaps, simply rebind to the texture object to synchronize content.

No OpenGL texturing calls that modify a pixel buffer texture content are permitted (such as glTexSubImage2D or glCopyTexImage2D) with the pixel buffer texture as the destination. It is permitted to use texturing commands to read data from a pixel buffer texture, such as glCopyTexImage2D, with the pixel buffer texture as the source. It is also legal to use OpenGL functions such as glReadPixels to read the contents of a pixel buffer directly through the pixel buffer context.

Note that texturing with the aglTexImagePBuffer function can fail to produce the intended results without error in the same way other OpenGL texturing commands can normally fail. The function fails if you do not enable the proper texture target, set an incompatible filter mode, or other conditions described in the OpenGL specification.

You don't need to share a context when a pixel buffer object is a texture source. You can use independent pixel formats and OpenGL contexts for both the pixel buffer and the target drawable object without sharing resources, and still texture using a pixel buffer in the target context.

For details on how to use a pixel buffer object as a texture source, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h*/

GLboolean aglTexImagePBuffer (
   AGLContext ctx,
   AGLPbuffer pbuffer,
   GLint source){};



/*aglDestroyPBuffer

Releases the resources associated with a pixel buffer object.

GLboolean aglDestroyPBuffer (
   AGLPbuffer pbuffer);
Parameters
pbuffer

The pixel buffer object whose resources you want to release.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

Call this function only after you no longer need to use the pixel buffer object. Before calling this function, you should delete all texture objects associated with the pixel buffer object. You do not need to make sure that all texturing commands have completed prior to calling this function, because the OpenGL framework manages texturing synchronization.
Availability
Available in Mac OS X v10.3 and later.
Declared In
agl.h
See Also
aglCreatePBuffer*/

GLboolean aglDestroyPBuffer (
   AGLPbuffer pbuffer){};


/*aglQueryRendererInfo

Creates and returns a renderer information object that contains properties and values for all renderers driving the specified displays.

AGLRendererInfo aglQueryRendererInfo (
   const AGLDevice *gdevs,
   GLint ndev);
Parameters
gdevs

A pointer to a list of graphics devices to which you want to restrict the query. Pass NULL to obtain information for all graphics devices on the system. 
ndev

The number of graphics devices in gdev. Pass 0 if gdevs is NULL. AGL sets the AGL_BAD_DEVICE error if the ndev parameter is nonzero and the gdevs parameter is not an array of valid devices.
Return Value

A renderer information object that describes all renderers able to drive the devices specified by the gdevs parameter. The function returns NULL if it fails for any reason. If an error occurs, call the function aglGetError to determine what the error is. 
Discussion

This function normally returns a list of more than one renderer information object—one for each renderer found on the system. To access data in the first renderer information object tin the list, call the function aglDescribeRenderer. To access data in a renderer information object that is not the first one in the list, use aglNextRendererInfo. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDestroyRendererInfo*/
AGLRendererInfo aglQueryRendererInfo (
   const AGLDevice *gdevs,
   GLint ndev){};

/*aglDescribeRenderer
Obtains the value associated with a renderer property.

GLboolean aglDescribeRenderer (
   AGLRendererInfo rend,
   GLint prop,
   GLint *value);
Parameters
rend

An opaque renderer information object that contains a description of the renderer capabilities you want to inspect. You obtain a renderer information object by calling the function aglQueryRendererInfo. 
prop

The renderer property whose value you want to obtain. See “Renderer Properties” for a list of the constants you can supply for this parameter. There are also a number of constants described in “Buffer and Renderer Attributes” that you can supply to this function.
value

On return, points to the value of the requested property.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglNextRendererInfo
aglDestroyRendererInfo*/
GLboolean aglDescribeRenderer (
   AGLRendererInfo rend,
   GLint prop,
   GLint *value){};


/*aglSetFullScreen

Attaches an rendering context to a full screen graphics device.

GLboolean aglSetFullScreen (
   AGLContext ctx,
   GLsizei width,
   GLsizei height,
   GLsizei freq,
   GLint device);
Parameters
ctx

A rendering context.
width

The width, in pixels, of the graphics device. This value must be an exact match to the graphics device.
height

The height, in pixels, of the graphics device. This value must be an exact match to the graphics device.
freq

The refresh frequency of the graphics device, in Hertz. If you specify a frequency of 0, AGL uses the highest refresh frequency available for the specified width and height. If you specify a nonzero frequency, AGL chooses the closest frequency available for the given geometry. If a display provides only a 0 refresh frequency, AGL matches it with width and height regardless of the value of frequency passed.
device

This parameter is ignored in Mac OS X, where all devices that are compatible with the pixel format of the rendering context are considered when selecting a full screen graphics device.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

After calling this function, subsequent OpenGL rendering calls directed to the full-screen graphics device. The rendering context must be created with respect to a pixel format that supports a full-screen device, which you can request by passing AGL_FULLSCREEN to the function aglChoosePixelFormat. The aglSetFullScreen function also performs all of the actions performed by aglUpdateContext. The aglSetFullScreen function uses information obtained from the pixel format object use to create the rendering context to choose the color depth for full-screen display mode.

When a rendering context is initially attached to a full screen graphics device, its viewport is set to the full size of the device. If the rendering context is subsequently attached to the same device, its viewport is unaltered. To disable a rendering context, call aglSetDrawable with the draw parameter set to NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglGetDrawable*/
GLboolean aglSetFullScreen (
   AGLContext ctx,
   GLsizei width,
   GLsizei height,
   GLsizei freq,
   GLint device){};


/*aglDestroyRendererInfo

Frees resources associated with a renderer information object.

void aglDestroyRendererInfo (
   AGLRendererInfo rend);
Parameters
rend

The renderer information object whose resources you want to release. 
Discussion

AGL sets a AGL_BAD_RENDINFO error if you pass an invalid renderer information object. You can check for this error by calling aglGetError.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglQueryRendererInfo*/
void aglDestroyRendererInfo (
   AGLRendererInfo rend){};



/*aglNextRendererInfo

Returns the next renderer information object.

AGLRendererInfo aglNextRendererInfo (
   AGLRendererInfo rend);
Parameters
rend

A renderer information object that contains one or more renderer information objects. You obtain a renderer information object by calling the function aglQueryRendererInfo.
Return Value

The next renderer information object in the list. Returns NULL if the object is the last in the list or if the function fails for any reason. In case of a failure, call the function aglGetError to determine what the error is. 
Discussion

You typically use this function to iterate through a list of renderer information objects returned by the function aglQueryRendererInfo. Most systems have more than one renderer installed because support for different buffer depths is typically provided by separate renderers.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDescribeRenderer
aglDestroyRendererInfo*/
AGLRendererInfo aglNextRendererInfo (
   AGLRendererInfo rend){};


/*aglEnable

Enables an option for a rendering context.

GLboolean aglEnable (
   AGLContext ctx,
   GLenum pname);
Parameters
ctx

A rendering context.
pname

The option you want to enable. You can pass any of the constants listed in “Context Options and Parameters” that specify they can be enabled or disabled.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Discussion

To set the value associated with a rendering context option, use the function aglSetInteger. For example, if you enable AGL_SWAP_RECT, you can specify the area of the window that is affected by the aglSwapBuffers function by setting the rectangle size with the function aglSetInteger.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglDisable
aglIsEnabled*/
GLboolean aglEnable (
   AGLContext ctx,
   GLenum pname){};

/*aglDisable

Disables an option for a rendering context.

GLboolean aglDisable (
   AGLContext ctx,
   GLenum pname);
Parameters
ctx

A rendering context.
pname

The capability that you want to disable. You can pass any of the constants listed in “Context Options and Parameters” that specify they can be enabled or disabled.
Return Value

Returns GL_FALSE if it fails for any reason, GL_TRUE otherwise. If an error occurs, call the function aglGetError to determine what the error is.
Availability
Available in Mac OS X v10.0 and later.
Declared In
agl.h
See Also
aglEnable*/
GLboolean aglDisable (
   AGLContext ctx,
   GLenum pname){};






















