
#import <Foundation/Foundation.h>

@class XGActionMonitorInternal;
@class XGResource;

/*XGActionMonitorOutcome

See Also:
XGActionMonitorOutcome
typedef enum { 
    XGActionMonitorOutcomeNone = 0, 
    XGActionMonitorOutcomeSuccess, 
    XGActionMonitorOutcomeFailure 
} XGActionMonitorOutcome; 
Constants
XGActionMonitorOutcomeNone
The action hasn't completed yet.
XGActionMonitorOutcomeSuccess
The action succeeded.
XGActionMonitorOutcomeFailure
The action failed.
Discussion

The outcome of the action.*/
typedef enum { 
    XGActionMonitorOutcomeNone = 0, 
    XGActionMonitorOutcomeSuccess, 
    XGActionMonitorOutcomeFailure 
} XGActionMonitorOutcome; 


@interface XGActionMonitor : NSObject

/*outcome


Returns the XGActionMonitorOutcome of the action being monitored. 
- (XGActionMonitorOutcome)outcome;
method result
The XGActionMonitorOutcome.*/
- (XGActionMonitorOutcome)outcome;

/*results


Returns the results of the action being monitored. 
- (NSDictionary *)results;
method result
The results dictionary.*/
- (NSDictionary *)results;

@end

/*XGActionMonitorResultsOutputStreamsKey

extern NSString * const XGActionMonitorResultsOutputStreamsKey; 
Discussion

The key used to retrieve the output streams from the results dictionary following a successful outcome to a XGResourceActionGetOutputStreams action.*/
extern NSString * const XGActionMonitorResultsOutputStreamsKey; 

/*XGActionMonitorResultsOutputFilesKey

extern NSString * const XGActionMonitorResultsOutputFilesKey; 
Discussion

The key used to retrieve the output files from the results dictionary following a successful outcome to a XGResourceActionGetOutputFiles action.*/
extern NSString * const XGActionMonitorResultsOutputFilesKey; 
