
#ifndef CSSMTYPE_H
#define CSSMTYPE_H

#include <Security/cssmconfig.h>

#include <HYS/Security/cssmtype.h>
#ifdef __cplusplus
extern "C" {
#endif

/*Keychain Item Class Constants

Specifies a keychain item’s class code.

typedef FourCharCode SecItemClass;
enum
{
   / SecKeychainItem.h *
   kSecInternetPasswordItemClass   = 'inet',
   kSecGenericPasswordItemClass    = 'genp',
   kSecAppleSharePasswordItemClass = 'ashp',
   kSecCertificateItemClass        =
   CSSM_DL_DB_RECORD_X509_CERTIFICATE,
};
enum
{
   / Record Types defined in The Open Group Application Name Space  *
   / cssmtype.h *
   CSSM_DL_DB_RECORD_PUBLIC_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 5,
   CSSM_DL_DB_RECORD_PRIVATE_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 6,
   CSSM_DL_DB_RECORD_SYMMETRIC_KEY =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 7,
   CSSM_DL_DB_RECORD_ALL_KEYS =
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 8
};
Constants
kSecInternetPasswordItemClass

Indicates that the item is an Internet password.

Available in Mac OS X v10.2 and later.
kSecGenericPasswordItemClass

Indicates that the item is a generic password.

Available in Mac OS X v10.2 and later.
kSecAppleSharePasswordItemClass

Indicates that the item is an AppleShare password.

Available in Mac OS X v10.2 and later.
kSecCertificateItemClass

Indicates that the item is an X509 certificate.

Available in Mac OS X v10.2 and later.
CSSM_DL_DB_RECORD_PUBLIC_KEY

Indicates that the item is a public key of a public-private pair.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_PRIVATE_KEY

Indicates that the item is a private key of a public-private pair.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_SYMMETRIC_KEY

Indicates that the item is a private key used for symmetric-key encryption.

Available in Mac OS X v10.0 and later.
CSSM_DL_DB_RECORD_ALL_KEYS

The item can be any type of key; used for searches only.

Available in Mac OS X v10.0 and later.
Discussion

These enumerations define constants your application can use to specify the type of the keychain item you wish to create, dispose, add, delete, update, copy, or locate. You can also use these constants with the tag constant SecItemAttr.
Declared In
SecKeychainItem.h, cssmtype.h.*/

enum
{
   /* Record Types defined in The Open Group Application Name Space  */
   /* cssmtype.h */
   CSSM_DL_DB_RECORD_PUBLIC_KEY =\
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 5,
   CSSM_DL_DB_RECORD_PRIVATE_KEY =\
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 6,
   CSSM_DL_DB_RECORD_SYMMETRIC_KEY =\
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 7,
   CSSM_DL_DB_RECORD_ALL_KEYS =\
   CSSM_DB_RECORDTYPE_OPEN_GROUP_START  + 8
};



#ifdef __cplusplus
}
#endif

#endif