
#ifndef SECBASE_H
#define SECBASE_H

#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*SecKeychainRef

Contains information about a keychain.

typedef struct OpaqueSecKeychainRef *SecKeychainRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueSecKeychainRef *SecKeychainRef;

/*SecKeychainAttrType

Represents a keychain attribute type.

typedef OSType SecKeychainAttrType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType SecKeychainAttrType;

/*SecKeychainItemRef

Contains information about a keychain item.

typedef struct OpaqueSecKeychainItemRef *SecKeychainItemRef;
Discussion

A SecKeychainItemRef object for a certificate that is stored in a keychain can be safely cast to a SecCertificateRef for use with the Certificate, Key, and Trust API.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueSecKeychainItemRef *SecKeychainItemRef;

/*SecKeychainAttribute

Contains keychain attributes. 

struct SecKeychainAttribute
   {
   SecKeychainAttrType tag;
   UInt32 length;
   void *data;
};
typedef struct SecKeychainAttribute SecKeychainAttribute;
typedef SecKeychainAttribute *SecKeychainAttributePtr;
Fields
tag

A 4-byte attribute tag. See “Keychain Item Attribute Constants” for valid attribute types.
length

The length of the buffer pointed to by data.
data

A pointer to the attribute data.
Availability
Available in Mac OS X v10.0 and later.*/
struct SecKeychainAttribute
   {
   SecKeychainAttrType tag;
   UInt32 length;
   void *data;
};
typedef struct SecKeychainAttribute SecKeychainAttribute;
typedef SecKeychainAttribute *SecKeychainAttributePtr;


/*SecKeychainAttributeList

Represents a list of keychain attributes.

struct SecKeychainAttributeList
   {
   UInt32 count;
   SecKeychainAttribute *attr;
};
typedef struct SecKeychainAttributeList SecKeychainAttributeList;
Fields
count

An unsigned 32-bit integer that represents the number of keychain attributes in the array.
attr

A pointer to the first keychain attribute in the array.
Availability
Available in Mac OS X v10.0 and later.*/
struct SecKeychainAttributeList
   {
   UInt32 count;
   SecKeychainAttribute *attr;
};
typedef struct SecKeychainAttributeList SecKeychainAttributeList;


#if defined(__cplusplus)
}
#endif

#endif 
