#ifndef SKDOCUMENT_H
#define SKDOCUMENT_H

#ifndef CFBASE_H
#include <CoreFoundation/CFBase.h>
#endif

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*SKDocumentRef

Defines an opaque data type representing a document’s URL.

typedef struct __SKDocument *SKDocumentRef;
Discussion

A document URL object is a generic location specification for a document. It is built from a document scheme, a parent document, and a document name. You can convert back and forth between document URL objects and CFURL objects using Search Kit’s SKDocumentCreateWithURL and SKDocumentCopyURL functions.

To create a Search Kit document URL object, use SKDocumentCreateWithURL when you can provide a complete URL, or use SKDocumentCreate when you want to specify document location indirectly using a parent document URL object. For other operations on documents, see "Working with Documents and Terms".

If you create document URL objects with indirect locations using the SKDocumentCreate function, you can resolve the locations by assembling them piece by piece, starting with a document URL object and going up step by step, parent to parent.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKDocument.h*/
typedef struct __SKDocument *SKDocumentRef;

/*SKDocumentID

Defines an opaque data type representing a lightweight document identifier.

typedef CFIndex SKDocumentID;
Discussion

Use document IDs rather than document URL objects (SKDocumentRefs) whenever possible. Using document IDs results in faster searching.

You can work with document IDs using a variety of Search Kit functions. See SKIndexGetMaximumDocumentID, SKIndexCopyDocumentForDocumentID, SKIndexCopyInfoForDocumentIDs, SKIndexCopyDocumentRefsForDocumentIDs, SKIndexCopyDocumentURLsForDocumentIDs, SKIndexCopyDocumentIDArrayForTermID, and SKIndexCopyTermIDArrayForDocumentID.
Availability
Available in Mac OS X v10.4 and later.
Declared In
SKIndex.h*/
typedef CFIndex SKDocumentID;

//function

/*SKDocumentCreate

Creates a document URL object based on a scheme, parent, and name.

SKDocumentRef SKDocumentCreate (
CFStringRef     inScheme,
SKDocumentRef   inParent,
CFStringRef     inName
);
Parameters
inScheme

The scheme to use—analogous to the scheme of a URL. Only documents referenced with the “file” scheme can be read by the SKIndexAddDocument function. The scheme can be anything you like if you use the SKIndexAddDocumentWithText function. The scheme can be NULL, in which case it will be set to be the same scheme as the document URL object’s (SKDocumentRef’s) parent. For more information on schemes, see http://www.iana.org/assignments/uri-schemes.html.
inParent

The document URL object one step up in the document hierarchy. Can be NULL.
inName

The name of the document that you’re creating a document URL object for. For the “file” scheme, it is the name of the file or the container, not its path. The path can be constructed by following parent links. The maximum length for a document name is 256 bytes.
Return Value

The new document URL object, or NULL on failure.
Discussion

The new document URL object’s (SKDocumentRef’s) parent can be NULL, but you must specify either a scheme or a parent. When your application no longer needs the document URL object, dispose of it by calling CFRelease.
Availability
Available in Mac OS X v10.3 and later.
Declared In
SKDocument.h*/
SKDocumentRef SKDocumentCreate (
CFStringRef     inScheme,
SKDocumentRef   inParent,
CFStringRef     inName
);

#ifdef __cplusplus
}
#endif

#endif