#ifndef QUICKTIMESTREAMING_H
#define QUICKTIMESTREAMING_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef MOVIES_H
#include <QuickTime/Movies.h>
#endif

#ifndef QUICKTIMECOMPONENTS_H
#include <QuickTime/QuickTimeComponents.h>
#endif

#include <HYS/QuickTime/QuickTimeStreaming.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*QTSStreamBuffer

Defines a stream buffer for QuickTime streaming.

struct QTSStreamBuffer {
   struct QTSStreamBuffer *   reserved1;
      struct QTSStreamBuffer *   reserved2;
         struct QTSStreamBuffer *   next;
            unsigned char *            rptr;
            unsigned char *            wptr;
            long                       reserved3;
            UInt32                     metadata[4];
            SInt32                     flags;
         };
Fields
reserved1
Discussion

Reserved; do not use.
reserved2
Discussion

Reserved; do not use.
next
Discussion

A pointer to the next message block in a message. 
rptr
Discussion

A pointer to the first byte in the data buffer that contains real data. 
wptr
Discussion

A pointer to the byte after the last byte in the data buffer that contains real data. 
reserved3
Discussion

Reserved; do not use.
metadata
Discussion

Usage defined by message sender. 
flags
Discussion

Reserved; do not use.
Related Functions
QTSCopyMessage
QTSDupMessage
QTSFlattenMessage
QTSFreeMessage
QTSMessageLength
RTPRssmGetTimeScaleFromPacket
RTPRssmHandleNewPacket 
Declared In
QuickTimeStreaming.h, QTStreamingComponents.h*/
struct QTSStreamBuffer {
   struct QTSStreamBuffer *   reserved1;
      struct QTSStreamBuffer *   reserved2;
         struct QTSStreamBuffer *   next;
            unsigned char *            rptr;
            unsigned char *            wptr;
            long                       reserved3;
            UInt32                     metadata[4];
            SInt32                     flags;
         };
typedef struct QTSStreamBuffer          QTSStreamBuffer;

#ifdef __cplusplus
}
#endif
#endif