#ifndef IOKIT_IOLIB_H
#define IOKIT_IOLIB_H

#include <sys/cdefs.h>
#include <sys/appleapiopts.h>
#include <IOKit/system.h>
#include <IOKit/IOReturn.h>
#include <IOKit/IOTypes.h>
#include <IOKit/IOLocks.h>
#include <libkern/OSAtomic.h>
#include <kern/thread_call.h>
#include <kern/clock.h>


#define min(a,b) ((a) < (b) ? (a) : (b))
#define max(a,b) ((a) > (b) ? (a) : (b))

/*Debugger


Enter the kernel debugger. 
void Debugger(
    const char *reason);  
Parameters
reason
A C-string to describe why the debugger is being entered.
Discussion 

This function freezes the kernel and enters the builtin debugger. It may not be possible to exit the debugger without a second machine.*/
void Debugger(
    const char *reason);  


#endif