#ifndef NOTIFICATION_H
#define NOTIFICATION_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <HYS/HIToolbox/Notification.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*NMRec

Defines the record format of a notification request.

struct NMRec {
   QElemPtr qLink;
   short qType;
   short nmFlags;
   long nmPrivate;
   short nmReserved;
   short nmMark;
   Handle nmIcon;
   Handle nmSound;
   StringPtr nmStr;
   NMUPP nmResp;
   long nmRefCon;
};
typedef struct NMRec NMRec;
typedef NMRec * NMRecPtr;
Fields
qLink

This field is used internally by the Notification Manager. You do not need to assign a value to this field.
qType

Indicates the type of queue. You should assign the value nmType to this field.
nmFlags

Reserved.
nmPrivate

Reserved.
nmReserved

Reserved.
nmMark

In Mac OS, the item to mark in the Application menu. If you do not want to display a mark, assign 0 to this field. 

For additional information about the use of this field in Mac OS X, see the discussion below.
nmIcon

In Mac OS, a handle to a small icon that is to blink periodically in the menu bar. If you do not want to display an icon, assign NULL to this field.
nmSound

In Mac OS, a handle to a sound resource to be played. If you do not want to play a sound, assign NULL to this field.
nmStr

A string to appear in the notification window. In Mac OS, if you do not want a notification window you should assign NULL to this field.
nmResp

A UPP to a response callback function. If no processing is necessary in response to the notification, assign the value NULL to this field.
nmRefCon

A long integer for private use by your application.
Discussion

In Mac OS X version 10.0, only the alert notification is supported.

In Mac OS X version 10.1 and later, mark and alert notifications are both supported. If you set the nmMark field to a non-zero value, your process icon will bounce in the dock.
Availability
Available in Mac OS X v10.0 and later.*/
struct NMRec {
   QElemPtr qLink;
   short qType;
   short nmFlags;
   long nmPrivate;
   short nmReserved;
   short nmMark;
   Handle nmIcon;
   Handle nmSound;
   StringPtr nmStr;
   NMUPP nmResp;
   long nmRefCon;
};
typedef struct NMRec NMRec;
typedef NMRec * NMRecPtr;

/*NMProcPtr

Defines a pointer to a response callback function. Your response callback function is executed as the final stage of a notification.

typedef void (*NMProcPtr) (
   NMRecPtr request
);

If you name your function MyNMProc, you would declare it like this:

void MyNMProc (
   NMRecPtr request
);
Parameters
request

A pointer to a notification request record.
Discussion

The nmResp field of the notification record defines a response function executed as the final stage of a notification. If no processing is necessary in response to the notification, then you can supply the value NULL in that field. If you supply a UPP to your own response function in the nmResp field, the Notification Manager passes it one parameter, a pointer to your notification request.*/
typedef void (*NMProcPtr) (
   NMRecPtr request
);


//function

/*NMInstall

Installs a notification request in the notification queue.

OSErr NMInstall (
   NMRecPtr request
);
Parameters
request

A pointer to a notification request record that the caller provides.
Return Value

A result code. If the result is non-zero, the Notification Manager cannot install the request because it contains invalid information. See “Notification Manager Result Codes”.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/

OSErr NMInstall (
   NMRecPtr request
);

/*NMRemove

Removes a notification request from the notification queue.

OSErr NMRemove (
   NMRecPtr request
);
Parameters
nmReqPtr

A pointer to a notification request record.
Return Value

A result code. If the result is non-zero, the Notification Manager cannot remove the request. See “Notification Manager Result Codes”.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/
OSErr NMRemove (
   NMRecPtr request
);

/*NewNMUPP

Creates a universal procedure pointer (UPP) to a response callback function.

NMUPP NewNMUPP (
   NMProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a response callback function. For more information about response callbacks, see NMProcPtr.
Return Value

A new UPP. When you no longer need this UPP, you should call DisposeNMUPP to release it.
Availability
CarbonLib 1.0 and later. Mac OS X version 10.0 and later.
Declared In
Notification.h*/

NMUPP NewNMUPP (
   NMProcPtr userRoutine
);


#ifdef __cplusplus
}
#endif

#endif