#ifndef DRBURNSESSION_H
#define DRBURNSESSION_H

#ifndef DISCRECORDING_H
#import <DiscRecording/DiscRecording.h>
#endif

#ifndef CARBON_H
#import <Carbon/Carbon.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Burn Session Dialog Result Codes

enum { 
    kDRBurnSessionOK = 1, 
    kDRBurnSessionCancel = 0, 
};  
Constants
kDRBurnSessionOK
Value returned by the setup dialog when the user has confirmed the burn setup.
kDRBurnSessionCancel
Value returned by the setup dialog when the user has canceled the burn setup.
Discussion 
enum { 
    kDRBurnSessionOK = 1, 
    kDRBurnSessionCancel = 0, 
};  

Return codes for the burn session setup dialog.*/
enum { 
    kDRBurnSessionOK = 1, 
    kDRBurnSessionCancel = 0, 
};  


/*DRBurnSessionProgressDialogOptions struct version

enum { 
    kBurnSessionProgressDialogOptionsCurrentVersion = 1 
};  */
enum { 
    kBurnSessionProgressDialogOptionsCurrentVersion = 1 
};  

/*Burn Setup Dialog Option Flags

enum { 
    kBurnSessionSetupDialogDefaultOptions = 0x00000000, / use defaults for all the options *
    kBurnSessionSetupDialogForceClosedDiscs = 0x00000001, /*Force discs to be closed (not appendable) *
    kBurnSessionSetupDialogDontHandleReservations = 0x00000002, /*
        Don't handle media reservations. Application handles them itself *
    kBurnSessionSetupDialogAllowTestBurns = 0x80000004 / Allow the user to perform a test burn *
};  
Constants
kBurnSessionSetupDialogDefaultOptions
Use defaults for all the options
kBurnSessionSetupDialogForceClosedDiscs
Force discs to be closed (not appendable)
kBurnSessionSetupDialogDontHandleReservations
Burn session does not handle media reservations. Application handles them itself
kBurnSessionSetupDialogAllowTestBurns
Allow the user to perform a test burn
Discussion 

Flags used to configure the burn setup dialog behavior*/

enum { 
    kBurnSessionSetupDialogDefaultOptions = 0x00000000, /* use defaults for all the options */
    kBurnSessionSetupDialogForceClosedDiscs = 0x00000001, /* Force discs to be closed (not appendable) */
    kBurnSessionSetupDialogDontHandleReservations = 0x00000002, /* 
        Don't handle media reservations. Application handles them itself */
    kBurnSessionSetupDialogAllowTestBurns = 0x80000004 /* Allow the user to perform a test burn */
};  


/*kDRBurnProgressSetupCallbacksCurrentVersion struct version

enum { 
    kDRBurnProgressSetupCallbacksCurrentVersion = 1 
};*/
enum { 
    kDRBurnProgressSetupCallbacksCurrentVersion = 1 
};

/*Burn Progress Dialog Option Flags

enum { 
    kBurnSessionProgressDialogDefaultOptions = 0x00000000, / use defaults for all the options *
    kBurnSessionProgressDialogDisplayVerboseProgress = 0x00000001 /
        Report all status changes in detail *
};  
Constants
kBurnSessionProgressDialogDefaultOptions
Use defaults for all the options
kBurnSessionProgressDialogDisplayVerboseProgress
Report all status changes in detail
Discussion 

Flags used to configure the burn progress dialog behavior*/
enum { 
    kBurnSessionProgressDialogDefaultOptions = 0x00000000, /* use defaults for all the options */
    kBurnSessionProgressDialogDisplayVerboseProgress = 0x00000001 /* 
        Report all status changes in detail */
};  


/*DRBurnSessionSetupDialogOptions struct version

enum { 
    kBurnSessionSetupDialogOptionsCurrentVersion = 1 
};  */
enum { 
    kBurnSessionSetupDialogOptionsCurrentVersion = 1 
};  

/*DRBurnSessionSetupCallbacks struct version

enum { 
    kDRBurnSessionSetupCallbacksCurrentVersion = 1 
};  */
enum { 
    kDRBurnSessionSetupCallbacksCurrentVersion = 1 
};

/*DRBurnSessionProgressDialogOptionFlags


Specifies progress dialog configuration options. 
typedef UInt32 DRBurnSessionProgressDialogOptionFlags;  */
typedef UInt32 DRBurnSessionProgressDialogOptionFlags; 

/*DRBurnSessionSetupDialogOptionFlags


Specifies setup dialog configuration options. 
typedef UInt32 DRBurnSessionSetupDialogOptionFlags;  */
typedef UInt32 DRBurnSessionSetupDialogOptionFlags; 

/*DRBurnSessionRef

typedef struct __DRBurnSession* DRBurnSessionRef;  
Discussion 

This is the type of a reference to DRBurnSession instances.*/
typedef struct __DRBurnSession* DRBurnSessionRef; 

/*DRBurnSessionSetupDialogOptions


Options passed into the setup dialog to configure it. 
struct DRBurnSessionSetupDialogOptions { 
    UInt32 version; 
    DRBurnSessionSetupDialogOptionFlags dialogOptionFlags; / option flags for affecting the dialog's behavior *
    CFStringRef defaultButtonTitle; / title of default button *
};  
Fields
version
Identifies the version of this structure.
dialogOptionFlags
One of several constants defined by the DRBurnSessionSetupDialogOptionFlags data type as described in Burn Setup Dialog Option Flags .
defaultButtonTitle
A CFStringRef that defines a custom title to be used for the dialog's default button. If you do not provide this string (passing NULL), the normal button title is used.*/
struct DRBurnSessionSetupDialogOptions { 
    UInt32 version; 
    DRBurnSessionSetupDialogOptionFlags dialogOptionFlags; /* option flags for affecting the dialog's behavior */
    CFStringRef defaultButtonTitle; /* title of default button */
};   
typedef struct DRBurnSessionSetupDialogOptions DRBurnSessionSetupDialogOptions;

/*DRBurnSessionDeviceCheckProcPtr


Callback used for checking the suitability of a device. 
typedef Boolean (*DRBurnSessionDeviceCheckProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device);  
Parameters
burnSession
The burn session object.
device
The device to examine.
Return Value

A Boolean value indicating the suitability of the device. 
Discussion 

This callback is called whenever a new device appears. It's purpose is to allow the application to filter out devices which do not support the operation to be performed. for example, a device may filter our CD-R/Ws if it is a DVD creation appliacation.*/
typedef Boolean (*DRBurnSessionDeviceCheckProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device);  

/*DRBurnSessionMediaCheckProcPtr


Callback used for checking the suitability of media in a device. 
typedef Boolean (*DRBurnSessionMediaCheckProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device,
    CFStringRef*prompt);  
Parameters
burnSession
The burn session object.
device
The device containing the media to examine.
prompt
A pointer to a CFStringRef. An application may return a custom message to display in the setup dialog.
Return Value

A Boolean value indicating the suitability of the media. 
Discussion 

This callback is called whenever the state of the media has changed. It's purpose is to allow the application to determine if the media is suitable for the operation to be performed. For example, the application an check to see if there is enough space on the media for the data to be written.*/
typedef Boolean (*DRBurnSessionMediaCheckProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device,
    CFStringRef*prompt);  

/*DRBurnSessionDeviceSelectionNotificationProcPtr


Callback used to notify the application of a new device selected. 
typedef void (*DRBurnSessionDeviceSelectionNotificationProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device);  
Parameters
burnSession
The burn session object.
device
The newly selected device.*/
typedef void (*DRBurnSessionDeviceSelectionNotificationProcPtr)(
    DRBurnSessionRef burnSession,
    DRDeviceRef device);  



/*DRBurnSessionSetupCallbacks


Callback functions passed to the setup dialog. 
struct DRBurnSessionSetupCallbacks { 
    UInt32 version; 
    DRBurnSessionDeviceCheckProcPtr deviceShouldBeTarget; 
    DRBurnSessionMediaCheckProcPtr containsSuitableMedia; 
    DRBurnSessionDeviceSelectionNotificationProcPtr deviceSelectionChanged; 
};  
Fields
version
Identifies the version of this structure.
deviceShouldBeTarget
Pointer to a DRBurnSessionDeviceCheckProcPtr. The value of this field may be NULL.
containsSuitableMedia
Pointer to a DRBurnSessionMediaCheckProcPtr. The value of this field may be NULL.
deviceSelectionChanged
Pointer to a DRBurnSessionDeviceSelectionNotificationProcPtr. The value of this field may be NULL.*/
struct DRBurnSessionSetupCallbacks { 
    UInt32 version; 
    DRBurnSessionDeviceCheckProcPtr deviceShouldBeTarget; 
    DRBurnSessionMediaCheckProcPtr containsSuitableMedia; 
    DRBurnSessionDeviceSelectionNotificationProcPtr deviceSelectionChanged; 
};  
typedef struct   DRBurnSessionSetupCallbacks  DRBurnSessionSetupCallbacks;  

/*DRBurnSessionProgressDialogOptions


Options passed into the progress dialog to configure it. 
struct DRBurnSessionProgressDialogOptions { 
    UInt32 version; 
    DRBurnSessionProgressDialogOptionFlags dialogOptionFlags; /
        option flags for affecting the dialog's behavior *
    CFStringRef description; / optional description of the burn *
};  
Fields
version
Identifies the version of this structure.
dialogOptionFlags
One of several constants defined by the DRBurnSessionProgressDialogOptionFlags data type as described in Burn Progress Dialog Option Flags .
description
A CFStringRef that defines a custom description to be used for the dialog. If you do not provide this string (passing NULL), the normal description is used.*/
struct DRBurnSessionProgressDialogOptions { 
    UInt32 version; 
    DRBurnSessionProgressDialogOptionFlags dialogOptionFlags; /* 
        option flags for affecting the dialog's behavior */
    CFStringRef description; /* optional description of the burn */
};  
typedef struct  DRBurnSessionProgressDialogOptions DRBurnSessionProgressDialogOptions;

/*DRBurnSessionProgressBeginNotificationProcPtr


Callback notifying the application the burn progress is about to begin. 
typedef void (*DRBurnSessionProgressBeginNotificationProcPtr)(
    DRBurnSessionRef burnSession);  
Parameters
burnSession
The burn session object.
Discussion 

This callback is called when the burn progress is about to be displayed. This allows the application to do things such as disable the quit menu item, or the close menu for a document window.*/
typedef void (*DRBurnSessionProgressBeginNotificationProcPtr)(
    DRBurnSessionRef burnSession);  

/*DRBurnSessionProgressFinishNotificationProcPtr


Callback notifying the application the burn progress has finished. 
typedef void (*DRBurnSessionProgressFinishNotificationProcPtr)(
    DRBurnSessionRef burnSession);  
Parameters
burnSession
The burn session object.
Discussion 

This callback is called when the burn progress has been removed from view. This allows the application to do things such as re-enable the quit menu item, or the close menu for a document window.*/
typedef void (*DRBurnSessionProgressFinishNotificationProcPtr)(
    DRBurnSessionRef burnSession); 

/*DRBurnSessionBurnCompleteProcPtr


Callback notifying the application the burn has finished. 
typedef Boolean (*DRBurnSessionBurnCompleteProcPtr)(
    DRBurnSessionRef burnSession,
    DRBurnRef burn);  
Parameters
burnSession
The burn session object.
burn
The burn instance that just finished.
Return Value

A Boolean value controlling the display of the burn session's error dialog. 
Discussion 

This callback is called when the burn operation completes, either successfully or with an error. This function can be used by the application to present it's own custom end-of-burn handling. Return a false return value to prevent the burn session from presenting it's own notification.*/
typedef Boolean (*DRBurnSessionBurnCompleteProcPtr)(
    DRBurnSessionRef burnSession,
    DRBurnRef burn);  



/*DRBurnSessionProgressCallbacks


Callback functions passed to the progress dialog. 
struct DRBurnSessionProgressCallbacks { 
    UInt32 version; 
    DRBurnSessionProgressBeginNotificationProcPtr progressWillBegin; 
    DRBurnSessionProgressFinishNotificationProcPtr progressDidFinish; 
    DRBurnSessionBurnCompleteProcPtr burnDidFinish; 
};  
Fields
version
Identifies the version of this structure.
progressWillBegin
Pointer to a DRBurnSessionProgressBeginNotificationProcPtr. The value of this field may be NULL.
progressDidFinish
Pointer to a DRBurnSessionProgressFinishNotificationProcPtr. The value of this field may be NULL.
burnDidFinish
Pointer to a DRBurnSessionBurnCompleteProcPtr. The value of this field may be NULL.*/
struct DRBurnSessionProgressCallbacks { 
    UInt32 version; 
    DRBurnSessionProgressBeginNotificationProcPtr progressWillBegin; 
    DRBurnSessionProgressFinishNotificationProcPtr progressDidFinish; 
    DRBurnSessionBurnCompleteProcPtr burnDidFinish; 
};  

typedef struct  DRBurnSessionProgressCallbacks DRBurnSessionProgressCallbacks;

//func

/*DRBurnSessionCreate


Creates a new burn session. 
extern DRBurnSessionRef DRBurnSessionCreate();  
Return Value

A reference to a new DRBurnSession. 
Availability
Introduced in Mac OS X v10.3.*/
extern DRBurnSessionRef DRBurnSessionCreate();

/*DRBurnSessionSetupDialog


Presents the setup interface as a modal dialog. 
extern SInt8 DRBurnSessionSetupDialog( 
    DRBurnSessionRef burnSession, 
    DRBurnSessionSetupDialogOptions*options, 
    DRBurnSessionSetupCallbacks*setupCallbacks);  
Parameters
burnSession
The burn session object
options
A pointer to a structure of type DRBurnSessionSetupDialogOptions . This pointer may be NULL if no custom configuration is required.
setupCallbacks
A pointer to a structure of type DRBurnSessionSetupCallbacks . This pointer may be NULL if no custom behavior is desired.
Return Value

Returns one of the constants defined by Burn Session Dialog Result Codes . 
Discussion 

This function present the user with a modal dialog that allows them to configure a burn to their custom settings. These include: the device to use, whether or not to eject the media when finished, the burn speed and others. The function does not return until the user dismissed the dialog. 
Availability
Introduced in Mac OS X v10.3.*/
extern SInt8 DRBurnSessionSetupDialog( 
    DRBurnSessionRef burnSession, 
    DRBurnSessionSetupDialogOptions *options, 
    DRBurnSessionSetupCallbacks* setupCallbacks);  

/*DRBurnSessionBeginProgressDialog


Presents the progress interface as a non-modal dialog. 
extern void DRBurnSessionBeginProgressDialog( 
    DRBurnSessionRef burnSession, 
    CFTypeRef layout, 
    DRBurnSessionProgressDialogOptions*options, 
    DRBurnSessionProgressCallbacks*progressCallbacks);  
Parameters
burnSession
The burn session object
layout
The track layout to be used for the burn.
options
A pointer to a structure of type DRBurnSessionSetupDialogOptions .
progressCallbacks
A pointer to a structure of type DRBurnSessionProgressCallbacks . This pointer may be NULL if no custom behavior is desired.
Discussion 

This function present the user with a non-modal dialog that shows the burn progress. 
Availability
Introduced in Mac OS X v10.3.*/
extern void DRBurnSessionBeginProgressDialog( 
    DRBurnSessionRef burnSession, 
    CFTypeRef layout, 
    DRBurnSessionProgressDialogOptions*options, 
    DRBurnSessionProgressCallbacks*progressCallbacks);  

#ifdef __cplusplus
}
#endif

#endif 