#ifndef  DRCORETRACK_H
#define DRCORETRACK_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef  CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef DRCOREDEVICE_H
#include <DiscRecordingEngine/DRCoreDevice.h>
#endif

#ifndef DRCOREOBJECT_H
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif


/*Session Format

enum { 
    kDRSessionFormatAudio = 0, 
    kDRSessionFormatMode1Data = 0, 
    kDRSessionFormatCDI = 0x10, 
    kDRSessionFormatCDXA = 0x20, 
    kDRSessionFormatDVDData = 0 
};  
Constants
kDRSessionFormatAudio
Audio data.
kDRSessionFormatMode1Data
Mode 1 data.
kDRSessionFormatCDI
CD-I disc.
kDRSessionFormatCDXA
CD-ROM XA disc.
kDRSessionFormatDVDData
DVD data.
Discussion 

Common session format values for types of track data.*/
enum { 
    kDRSessionFormatAudio = 0, 
    kDRSessionFormatMode1Data = 0, 
    kDRSessionFormatCDI = 0x10, 
    kDRSessionFormatCDXA = 0x20, 
    kDRSessionFormatDVDData = 0 
};  


/*Track Modes

enum { 
    kDRTrackModeAudio = 0, 
    kDRTrackMode1Data = 4, 
    kDRTrackMode2Data = 4, 
    kDRTrackMode2Form1Data = 4, 
    kDRTrackMode2Form2Data = 4, 
    kDRTrackModeDVDData = 5 
};  
Constants
kDRTrackModeAudio
Audio data.
kDRTrackMode1Data
Mode 1 data.
kDRTrackMode2Data
Mode 2 data. Photo CD and CD-i use this.
kDRTrackMode2Form1Data
Mode 2 Form 1 data.
kDRTrackMode2Form2Data
Mode 2 Form 2 data.
kDRTrackModeDVDData
DVD data.
Discussion 

Common track mode values for types of track data.*/
enum { 
    kDRTrackModeAudio = 0, 
    kDRTrackMode1Data = 4, 
    kDRTrackMode2Data = 4, 
    kDRTrackMode2Form1Data = 4, 
    kDRTrackMode2Form2Data = 4, 
    kDRTrackModeDVDData = 5 
};  


/*Data Forms

enum { 
    kDRDataFormAudio = 0, 
    kDRDataFormMode1Data = 16, 
    kDRDataFormMode2Data = 32, 
    kDRDataFormMode2Form1Data = 32, 
    kDRDataFormMode2Form2Data = 32, 
    kDRDataFormDVDData = 16 
};  
Constants
kDRDataFormAudio
Audio data.
kDRDataFormMode1Data
Mode 1 data.
kDRDataFormMode2Data
Mode 2 data. Photo CD and CD-i use this.
kDRDataFormMode2Form1Data
Mode 2 Form 1 data.
kDRDataFormMode2Form2Data
Mode 2 Form 2 data.
kDRDataFormDVDData
DVD data.
Discussion 

Common data form values for types of track data.*/
enum { 
    kDRDataFormAudio = 0, 
    kDRDataFormMode1Data = 16, 
    kDRDataFormMode2Data = 32, 
    kDRDataFormMode2Form1Data = 32, 
    kDRDataFormMode2Form2Data = 32, 
    kDRDataFormDVDData = 16 
};  


/*Block Types

enum { 
    kDRBlockTypeAudio = 0, 
    kDRBlockTypeMode1Data = 8, 
    kDRBlockTypeMode2Data = 13, 
    kDRBlockTypeMode2Form1Data = 10, 
    kDRBlockTypeMode2Form2Data = 12, 
    kDRBlockTypeDVDData = 8 
};  
Constants
kDRBlockTypeAudio
Audio data.
kDRBlockTypeMode1Data
Mode 1 data.
kDRBlockTypeMode2Data
Mode 2 data. Photo CD and CD-i use this.
kDRBlockTypeMode2Form1Data
Mode 2 Form 1 data.
kDRBlockTypeMode2Form2Data
Mode 2 Form 2 data.
kDRBlockTypeDVDData
DVD data.
Discussion 

Common block type values for types of track data.*/
enum { 
    kDRBlockTypeAudio = 0, 
    kDRBlockTypeMode1Data = 8, 
    kDRBlockTypeMode2Data = 13, 
    kDRBlockTypeMode2Form1Data = 10, 
    kDRBlockTypeMode2Form2Data = 12, 
    kDRBlockTypeDVDData = 8 
};  


/*Track Messages

enum { 
    kDRTrackMessagePreBurn = 'pre ', 
    kDRTrackMessageProduceData = 'prod', 
    kDRTrackMessageVerificationStarting = 'vstr', 
    kDRTrackMessageVerifyData = 'vrfy', 
    kDRTrackMessageVerificationDone = 'vdon', 
    kDRTrackMessagePostBurn = 'post', 
    kDRTrackMessageEstimateLength = 'esti', // added in 10.3 //
    kDRTrackMessageProducePreGap = 'prpr', // added in 10.3 //
    kDRTrackMessageVerifyPreGap = 'vrpr' // added in 10.4 //
};  
Constants
kDRTrackMessagePreBurn
Message sent to the track production callback indicating a burn is about to begin. Clients should open any files needed to produce data and get ready to start sending data. 

The ioParam parameter contains a CFDictionary object with information about the burn. It currently holds kDRBurnKey and kDRDeviceMediaInfoKey dictionary keys, but may be extended to hold other properties in the future. 

kDRTrackMessageProduceData
Message sent to the track production callback requesting that the client produce the next chunk of data for the track. 

The ioParam parameter is a pointer to a DRTrackProductionInfo structure. 

kDRTrackMessageVerificationStarting
Message sent to the callback proc indicating that verification is about to begin. 

ioParam is not used and is NULL. 

kDRTrackMessageVerifyData
Message sent to the track production callback when the client has chosen the kDRVerificationTypeReceiveData option. 

The ioParam parameter is a pointer to a DRTrackProductionInfo structure describing the data passed to the callback. 

kDRTrackMessageVerificationDone
Message sent to the track production callback when verification is complete. 

The ioParam parameter is not used and is NULL. 

kDRTrackMessagePostBurn
Message sent to the track production callback indicating a burn has completed. 

The ioParam parameter is not used and is NULL. 

kDRTrackMessageEstimateLength
Message sent to the track production callback asking it to estimate the length of the track. This message is sent outside of a burn cycle, when the DRTrackEstimateLength function is called. 

The ioParam parameter is a pointer to a UInt64 value, which the callback fills in with an estimated number of blocks for the track. The estimate should be reasonably accurate and no smaller than the actual size that will be needed. 

kDRTrackMessageProducePreGap
Message sent to the track production callback requesting that the client produce the next chunk of the pregap. 

The ioParam parameter is a pointer to a DRTrackProductionInfo structure. 

kDRTrackMessageVerifyPreGap
Message sent to the track production callback when the client has chosen the kDRVerificationTypeReceiveData option. The data produced by the client for the kDRTrackMessageProducePreGap should be verified. 

The ioParam parameter is a pointer to a DRTrackProductionInfo structure describing the data passed to the callback.
Discussion 

Messages sent to the DRTrackCallbackProc callback during a burn.*/
enum { 
    kDRTrackMessagePreBurn = 'pre ', 
    kDRTrackMessageProduceData = 'prod', 
    kDRTrackMessageVerificationStarting = 'vstr', 
    kDRTrackMessageVerifyData = 'vrfy', 
    kDRTrackMessageVerificationDone = 'vdon', 
    kDRTrackMessagePostBurn = 'post', 
    kDRTrackMessageEstimateLength = 'esti', /* added in 10.3 */
    kDRTrackMessageProducePreGap = 'prpr', /* added in 10.3 */
    kDRTrackMessageVerifyPreGap = 'vrpr' /* added in 10.4 */
};  


/*Block Sizes

enum { 
    kDRBlockSizeAudio = 2352, 
    kDRBlockSizeMode1Data = 2048, 
    kDRBlockSizeMode2Data = 2332, 
    kDRBlockSizeMode2Form1Data = 2048, 
    kDRBlockSizeMode2Form2Data = 2324, 
    kDRBlockSizeDVDData = 2048 
};  
Constants
kDRBlockSizeAudio
Audio data.
kDRBlockSizeMode1Data
Mode 1 data.
kDRBlockSizeMode2Data
Mode 2 data. Photo CD and CD-i use this.
kDRBlockSizeMode2Form1Data
Mode 2 Form 1 data.
kDRBlockSizeMode2Form2Data
Mode 2 Form 2 data.
kDRBlockSizeDVDData
DVD data.
Discussion 

Common block sizes for different types of track data.*/
enum { 
    kDRBlockSizeAudio = 2352, 
    kDRBlockSizeMode1Data = 2048, 
    kDRBlockSizeMode2Data = 2332, 
    kDRBlockSizeMode2Form1Data = 2048, 
    kDRBlockSizeMode2Form2Data = 2324, 
    kDRBlockSizeDVDData = 2048 
};  


/*DRTrackRef

typedef struct __DRTrack* DRTrackRef;  
Discussion 

A reference to a DRTrack object.*/
typedef struct __DRTrack* DRTrackRef; 

/*DRTrackMessage


Messages sent to the DRTrackCallbackProc callback. 
typedef UInt32 DRTrackMessage;  */
typedef UInt32 DRTrackMessage;  

/*DRTrackProductionInfo


Parmeter block used for data production. 
struct DRTrackProductionInfo { 
    void *buffer; 
    UInt32 reqCount; 
    UInt32 actCount; 
    UInt32 flags; 
    UInt32 blockSize; 
    UInt64 requestedAddress; 
};  
Fields
buffer
In - The buffer to produce into. This buffer is passed into the track production callback and only the contents should be modified.
reqCount
In - The number of bytes requested by the engine.
actCount
Out - The number of bytes actually produced (between 0 and reqCount).
flags
InOut - Miscellaneous flags. Flags are passed into the track production callback callback from the Disc Recording engine and the callback can set flags to be passed back to the engine.
blockSize
In - The block size the engine is expecting. For best results, return multiples of this size.
requestedAddress
In - The byte address that the burn engine is requesting from the object (0-based). This increments when you send data, as one would expect.*/
struct DRTrackProductionInfo { 
    void *buffer; 
    UInt32 reqCount; 
    UInt32 actCount; 
    UInt32 flags; 
    UInt32 blockSize; 
    UInt64 requestedAddress; 
};  

typedef  struct DRTrackProductionInfo DRTrackProductionInfo;

/*DRTrackCallbackProc


Callback defined in the client to produce track data for recording. 
typedef OSStatus (*DRTrackCallbackProc)( 
    DRTrackRef track, 
    DRTrackMessage message, 
    void*ioParam);  
Parameters
track
The track with this callback is associated.
message
Indicates the type of data requested as one of the constants in the Track Messages enumeration.
ioParam
Parameters are message-specific.
Return Value

Error code. Your client application should return a value of kDRFunctionNotSupportedErr when a message is received that you don't respond to, and a value of noErr when the message is handled successfully. Any other error will cause the burn to immediately fail with the value you return as the error code. 
Discussion 

If your callback does not support a given function, it should return a value of kDRFunctionNotSupportedErr .*/
typedef OSStatus (*DRTrackCallbackProc)( 
    DRTrackRef track, 
    DRTrackMessage message, 
    void*ioParam);  

/*kDRBlockSizeKey

extern const CFStringRef kDRBlockSizeKey;  
Discussion 

Required key. This key corresponds to a CFNumber object containing the size of each block of the track. Common values are defined in the Block Sizes enumeration. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRBlockSizeKey;  

/*kDRBlockTypeKey

extern const CFStringRef kDRBlockTypeKey;  
Discussion 

Required key. This key corresponds to a CFNumber object containing the type of each block of the track. Common values are defined in the Block Types enumeration. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRBlockTypeKey;  

/*kDRTrackLengthKey

extern const CFStringRef kDRTrackLengthKey;  
Discussion 

Required Key. This key corresponds to a CFNumber object containing the length of the track data in blocks. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRTrackLengthKey;  

/*kDRDataFormKey

extern const CFStringRef kDRDataFormKey;  
Discussion 

Required key. This key corresponds to a CFNumber object containing the data format of each block of the track. Common values are defined in the Data Forms enumeration. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRDataFormKey;  

/*kDRSessionFormatKey

extern const CFStringRef kDRSessionFormatKey;  
Discussion 

Required key. This key corresponds to a CFNumber object containing the session format of the track. Common values are defined in the Session Mode enumeration. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRSessionFormatKey;  

/*kDRTrackModeKey

extern const CFStringRef kDRTrackModeKey;  
Discussion 

Required key. This key corresponds to a CFNumber object containing the track mode of the track. Common values are defined in the Track Modes enumeration. 
Availability
Introduced in Mac OS X v10.2*/
extern const CFStringRef kDRTrackModeKey;  

//func

/*DRTrackGetProperties


Returns the properties of the track. 
extern CFDictionaryRef DRTrackGetProperties(
    DRTrackRef track) ;  
Parameters
track
The track whose properties will be retrieved. If this parameter is not a valid DRTrack object, the behavior is undefined.
Return Value

A CFMutableDictionary object containing the track properties. 
Availability
Introduced in Mac OS X v10.2*/
extern CFDictionaryRef DRTrackGetProperties(
    DRTrackRef track) ;  

/*DRTrackCreate


Creates a new track object. 
extern DRTrackRef DRTrackCreate(
    CFDictionaryRef properties,
    DRTrackCallbackProc callback) ;  
Parameters
properties
A CFDictionary object containing the track properties. If this parameter is not a valid CFDictionary object the behavior is undefined.
callback
A pointer to a DRTrackCallbackProc callback. If this callback is NULL the behavior is undefined.
Return Value

A reference to the new DRTrack object. 
Availability
Introduced in Mac OS X v10.2*/
extern DRTrackRef DRTrackCreate(
    CFDictionaryRef properties,
    DRTrackCallbackProc callback) ;  

#ifdef __cplusplus
}
#endif

#endif 
