#ifndef CGDISPLAY_CONFIGURATION_H
#define CGDISPLAY_CONFIGURATION_H

#include <IOKit/IOKitLib.h>
#include <CoreGraphics/CGDirectDisplay.h>
#include <AvailabilityMacros.h>

/*CGDisplayUsesOpenGLAcceleration

Returns a Boolean value indicating whether Quartz is using OpenGL-based window acceleration (Quartz Extreme) to render in a display.

boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

If true, Quartz Extreme is used to render in the specified display; otherwise, false.
Discussion

Quartz Extreme is an OpenGL-based, hardware-accelerated window compositor available in Mac OS X version 10.2 and later. Quartz Extreme requires a minimum hardware configuration to operate.

The information this function provides is typically used to adjust the demands of drawing operations to the capabilities of the display hardware. For example, an application running on an unaccelerated system could disable live window-resizing.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
boolean_t CGDisplayUsesOpenGLAcceleration (
   CGDirectDisplayID display
);

/*CGDisplayIOServicePort

Returns the I/O Kit service port of the specified display.

io_service_t CGDisplayIOServicePort (
   CGDirectDisplayID display
);
Parameters
display

The display to access.
Return Value

The I/O Kit service port for the specified display.
Discussion

An I/O Kit service port can be passed to I/O Kit to obtain additional information about the display. 

The port is owned by the graphics system, and should not be destroyed. 
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGDisplayConfiguration.h*/
io_service_t CGDisplayIOServicePort (
   CGDirectDisplayID display
);

#endif