#ifndef CFSTREAM_H
#define CFSTREAM_H

#include <CoreFoundation/CFString.h>
#include <CoreFoundation/CFDictionary.h>

#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#include <CoreFoundation/CFRunLoop.h>
#include <CoreFoundation/CFSocket.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFStream Error Domain Constants

Defines constants for values returned in the domain field of the CFStreamError structure. 

typedef enum {
   kCFStreamErrorDomainCustom = -1,
   kCFStreamErrorDomainPOSIX = 1,
   kCFStreamErrorDomainMacOSStatus,
} CFStreamErrorDomain;
const SInt32 kCFStreamErrorDomainNetDB;
const SInt32 kCFStreamErrorDomainNetServices;
const SInt32 kCFstreamErrorDomainMach;
const SInt32 kCFStreamErrorDomainFTP;
const SInt32 kCFStreamErrorDomainHTTP;
const int kCFStreamErrorDomainSOCKS;
const SInt32 kCFStreamErrorDomainSystemConfiguration;
const int kCFStreamErrorDomainSSL;
Constants
kCFStreamErrorDomainCustom

The error code is a custom error code.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainPOSIX

The error code is an error code defined in errno.h.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainMacOSStatus

The error is an OSStatus value defined in MacErrors.h.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainNetDB

The error code is an error code defined in netdb.h.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainNetServices

The error code is a CFNetService error code. For details, see the CFNetServicesError enumeration.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainMach

The error code is a Mach error code defined in mach/error.h.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainFTP

The error code is an FTP error code.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainHTTP

The error code is an HTTP error code.

Available in Mac OS X v10.1 and later.
kCFStreamErrorDomainSOCKS

The error code is a SOCKS proxy error.

Available in Mac OS X v10.2 and later.
kCFStreamErrorDomainSystemConfiguration

The error code is a system configuration error code as defined in System/ConfigurationSystemConfiguration.h.

Available in Mac OS X v10.3 and later.
kCFStreamErrorDomainSSL

The error code is an SSL error code as defined in Security/SecureTransport.h.

Available in Mac OS X v10.1 and later.
Discussion

These constants indicate how the error code in the error field in the CFStreamError structure should be interpreted.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CoreFoundation/CFStream.h*/
typedef enum {
   kCFStreamErrorDomainCustom = -1,
   kCFStreamErrorDomainPOSIX = 1,
   kCFStreamErrorDomainMacOSStatus,
} CFStreamErrorDomain;
const SInt32 kCFStreamErrorDomainNetDB;
const SInt32 kCFStreamErrorDomainNetServices;
const SInt32 kCFstreamErrorDomainMach;
const SInt32 kCFStreamErrorDomainFTP;
const SInt32 kCFStreamErrorDomainHTTP;
const int kCFStreamErrorDomainSOCKS;
const SInt32 kCFStreamErrorDomainSystemConfiguration;
const int kCFStreamErrorDomainSSL;


/*CFWriteStreamRef

A reference to a writable stream object.

typedef struct __CFWriteStream *CFWriteStreamRef;
Availability
Available in Mac OS X v10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
typedef struct __CFWriteStream *CFWriteStreamRef;

/*CFReadStreamRef

A reference to a readable stream object.

typedef struct __CFReadStream *CFReadStreamRef;
Availability
Available in Mac OS X v10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
typedef struct __CFReadStream *CFReadStreamRef;

/*CFStreamError

The structure returned by CFReadStreamGetError and CFWriteStreamGetError.

typedef struct {
CFStreamErrorDomain domain;
SInt32 error
} CFStreamError;
Fields
domain

The error domain that should be used to interpret the error. See CFStreamErrorDomain for possible values.
error

The error code.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CoreFoundation/CFStream.h*/
typedef struct {
CFStreamErrorDomain domain;
SInt32 error
} CFStreamError;


/*CFStreamClientContext

A structure that contains program-defined data and callbacks with which you can configure a stream’s client behavior.

struct CFStreamClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFStreamClientContext CFStreamClientContext;
Fields
version

Version number of the structure. Must be 0.
info

An arbitrary pointer to program-defined data, which can be associated with the client. This pointer is passed to the callbacks defined in the context and to the client callback function CFReadStreamClientCallBack.
retain

A retain callback for your program-defined info pointer. Can be NULL.
release

A release callback for your program-defined info pointer. Can be NULL.
copyDescription

A copy description callback for your program-defined info pointer. Can be NULL.
Availability
Available in Mac OS X v10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
struct CFStreamClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct CFStreamClientContext CFStreamClientContext;

/*CFStream Event Type Constants

Defines constants for stream-related events.

typedef enum {
kCFStreamEventNone = 0,
kCFStreamEventOpenCompleted = 1,
kCFStreamEventHasBytesAvailable = 2,
kCFStreamEventCanAcceptBytes = 4,
kCFStreamEventErrorOccurred = 8,
kCFStreamEventEndEncountered = 16
} CFStreamEventType;
Constants
kCFStreamEventNone

No event has occurred.

Available in Mac OS X v10.1 and later.
kCFStreamEventOpenCompleted

The open has completed successfully.

Available in Mac OS X v10.1 and later.
kCFStreamEventHasBytesAvailable

The stream has bytes to be read.

Available in Mac OS X v10.1 and later.
kCFStreamEventCanAcceptBytes

The stream can accept bytes for writing.

Available in Mac OS X v10.1 and later.
kCFStreamEventErrorOccurred

An error has occurred on the stream.

Available in Mac OS X v10.1 and later.
kCFStreamEventEndEncountered

The end of the stream has been reached.

Available in Mac OS X v10.1 and later.
Discussion

This enumeration defines constants for stream-related events.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CoreFoundation/CFStream.h*/
typedef enum {
kCFStreamEventNone = 0,
kCFStreamEventOpenCompleted = 1,
kCFStreamEventHasBytesAvailable = 2,
kCFStreamEventCanAcceptBytes = 4,
kCFStreamEventErrorOccurred = 8,
kCFStreamEventEndEncountered = 16
} CFStreamEventType;


/*CFReadStreamClientCallBack

Callback invoked when certain types of activity takes place on a readable stream.

typedef void (*CFReadStreamClientCallBack) (
   CFReadStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   CFReadStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);
Parameters
stream

The stream that experienced the event eventType.
eventType

The event that caused the callback to be called. The possible events are listed in CFStreamEventType.
clientCallBackInfo

The info member of the CFStreamClientContext structure that was used when setting the client for stream.
Discussion

This callback is called only for the events requested when setting the client with CFReadStreamSetClient.
Availability
Available in Mac OS X v10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
typedef void (*CFReadStreamClientCallBack) (
   CFReadStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);

/*CFWriteStreamClientCallBack

Callback invoked when certain types of activity takes place on a writable stream.

typedef void (*CFWriteStreamClientCallBack) (
   CFWriteStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);

If you name your function MyCallBack, you would declare it like this:

void MyCallBack (
   CFWriteStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);
Parameters
stream

The stream that experienced the event eventType.
eventType

The event that caused the callback to be called. The possible events are listed in “Stream Events.”.
clientCallBackInfo

The info member of the CFStreamClientContext structure that was used when setting the client for stream.
Discussion

This callback is called only for the events requested when setting the client with CFWriteStreamSetClient.
Availability
Available in Mac OS X v10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
typedef void (*CFWriteStreamClientCallBack) (
   CFWriteStreamRef stream,
   CFStreamEventType eventType,
   void *clientCallBackInfo
);

/*CFReadStreamUnscheduleFromRunLoop

Removes a read stream from a given run loop.

void CFReadStreamUnscheduleFromRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to unschedule.
runLoop

The run loop from which to remove stream.
runLoopMode

The run loop mode of runLoop from which to remove stream.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
void CFReadStreamUnscheduleFromRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);

/*CFReadStreamSetClient

Assigns a client to a stream, which receives callbacks when certain events occur.

Boolean CFReadStreamSetClient (
   CFReadStreamRef stream,
   CFOptionFlags streamEvents,
   CFReadStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);
Parameters
stream

The stream to modify.
streamEvents

The set of events for which the client should receive callbacks. The events are listed in CFStreamEventType. If you pass kCFStreamEventNone, the current client for stream is removed.
clientCB

The client callback function to be called when one of the events requested in streamEvents occurs. If NULL, the current client for stream is removed.
clientContext

A structure holding contextual information for the stream client. The function copies the information out of the structure, so the memory pointed to by clientContext does not need to persist beyond the function call. If NULL, the current client for stream is removed.
Return Value

TRUE if the stream supports asynchronous notification, otherwise FALSE.
Discussion

To avoid polling and blocking, you can register a client to hear about interesting events that occur on a stream. Only one client per stream is allowed; registering a new client replaces the previous one.

Once you have set a client, you need to schedule the stream in a run loop using CFReadStreamScheduleWithRunLoop so that the client can receive the asynchronous notifications. You can schedule each stream in multiple run loops (for example, if you are using a thread pool). It is the caller's responsibility to ensure that at least one of the scheduled run loops is being run, otherwise the callback cannot be called.

Although all Core Foundation streams currently support asynchronous notification, future stream types may not. If a stream does not support asynchronous notification, this function returns false. Typically, such streams never block for device I/O (for example, a stream reading memory) and don’t benefit from asynchronous notification.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamSetClient (
   CFReadStreamRef stream,
   CFOptionFlags streamEvents,
   CFReadStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);

/*CFReadStreamClose

Closes a readable stream.

void CFReadStreamClose (
   CFReadStreamRef stream
);
Parameters
stream

The stream to close.
Discussion

This function terminates the flow of bytes and releases any system resources required by the stream. The stream is removed from any run loops in which it was scheduled. Once closed, the stream cannot be reopened.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/

void CFReadStreamClose (
   CFReadStreamRef stream
);

/*CFWriteStreamUnscheduleFromRunLoop

Removes a stream from a particular run loop.

void CFWriteStreamUnscheduleFromRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to remove.
runLoop

The run loop from which to remove stream.
runLoopMode

The run loop mode of runLoop from which to remove stream.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamUnscheduleFromRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);

/*CFWriteStreamSetClient

Assigns a client to a stream, which receives callbacks when certain events occur.

Boolean CFWriteStreamSetClient (
   CFWriteStreamRef stream,
   CFOptionFlags streamEvents,
   CFWriteStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);
Parameters
stream

The stream to modify.
streamEvents

The set of events for which the client should receive callbacks. The events are listed in CFStreamEventType. If you pass kCFStreamEventNone, the current client for stream is removed.
clientCB

The client callback function to call when one of the events requested in streamEvents occurs. If NULL, the current client for stream is removed.
clientContext

A structure holding contextual information for the stream client. The function copies the information out of the structure, so the memory pointed to by clientContext does not need to persist beyond the function call. If NULL, the current client for stream is removed.
Return Value

true if the stream supports asynchronous notification, false otherwise.
Discussion

To avoid polling and blocking, you can register a client to hear about interesting events that occur on a stream. Only one client per stream is allowed; registering a new client replaces the previous one.

Once you have set a client, you need to schedule the stream in a run loop using CFWriteStreamScheduleWithRunLoop so that the client can receive the asynchronous notifications. You can schedule each stream in multiple run loops (for example, if you are using a thread pool). It is the caller's responsibility to ensure that at least one of the scheduled run loops is being run, otherwise the callback cannot be called.

Although all Core Foundation streams currently support asynchronous notification, future stream types may not. If a stream does not support asynchronous notification, this function returns false. Typically, such streams never block for device I/O (for example, a stream writing to memory) and don’t benefit from asynchronous notification.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamSetClient (
   CFWriteStreamRef stream,
   CFOptionFlags streamEvents,
   CFWriteStreamClientCallBack clientCB,
   CFStreamClientContext *clientContext
);


/*CFWriteStreamClose

Closes a writable stream.

void CFWriteStreamClose (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to close.
Discussion

This function terminates the flow of bytes and releases any system resources required by the stream. The stream is removed from any run loops in which it was scheduled. Once closed, the stream cannot be reopened.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamClose (
   CFWriteStreamRef stream
);


/*CFReadStreamGetTypeID

Returns the type identifier the CFReadStream opaque type.

CFTypeID CFReadStreamGetTypeID ();
Return Value

The type identifier for the CFReadStream opaque type.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFTypeID CFReadStreamGetTypeID ();

/*CFWriteStreamGetTypeID

Returns the type identifier of all CFWriteStream objects.

CFTypeID CFWriteStreamGetTypeID ();
Return Value

The type identifier for the CFWriteStream opaque type.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFTypeID CFWriteStreamGetTypeID ();

/*CFWriteStreamSetProperty

Sets the value of a property for a stream.

Boolean CFWriteStreamSetProperty (
   CFWriteStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);
Parameters
stream

The stream to modify.
propertyName

The name of the property to set. The available properties for standard Core Foundation streams are listed in “Stream Properties.”
propertyValue

The value to which to set the property propertyName for stream. The allowed data type of the value depends on the property being set.
Return Value

true if stream recognizes and accepts the given property-value pair, false otherwise.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any interesting information about a stream. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Properties that can be set configure the behavior of the stream and may be modifiable only at particular times, such as before the stream has been opened. (In fact, you should assume that you can set properties only before opening the stream, unless otherwise noted.) To read the value of a property use CFWriteStreamCopyProperty, although some properties are write-only.
Availability
Available in Mac OS X v10.2 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamSetProperty (
   CFWriteStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);

/*CFWriteStreamCreateWithFile

Creates a writable stream for a file.

CFWriteStreamRef CFWriteStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
fileURL

The URL of the file to which to write. The URL must use a file scheme.
Return Value

The new write stream, or NULL on failure. Ownership follows the Create Rule.
Discussion

The stream overwrites an existing file unless you set the kCFStreamPropertyAppendToFile to kCFBooleanTrue with CFWriteStreamSetProperty, in which case the stream appends data to the file.

You must open the stream, using CFWriteStreamOpen, before writing to it.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFWriteStreamRef CFWriteStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);

/*CFReadStreamCopyProperty

Returns the value of a property for a stream.

CFTypeRef CFReadStreamCopyProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName
);
Parameters
stream

The stream to examine.
propertyName

The name of the stream property to obtain. The available properties for standard Core Foundation streams are listed in CFStream Reference.
Return Value

The value of the property propertyName. Ownership follows the Create Rule.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any information about a stream, other than the actual data the stream handles. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Use CFReadStreamSetProperty to modify the value of a property, although some properties are read-only.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFTypeRef CFReadStreamCopyProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName
);

/*CFReadStreamSetProperty

Sets the value of a property for a stream.

Boolean CFReadStreamSetProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);
Parameters
stream

The stream to modify.
propertyName

The name of the property to set. The available properties for standard Core Foundation streams are listed in CFStream Reference.
propertyValue

The value to which to set the property propertyName for stream. The allowed data type of the value depends on the property being set.
Return Value

TRUE if stream recognizes and accepts the given property-value pair, otherwiseFALSE.
Discussion

Each type of stream can define a set of properties that either describe or configure individual streams. A property can be any interesting information about a stream. Examples include the headers from an HTTP transmission, the expected number of bytes, file permission information, and so on. Properties that can be set configure the behavior of the stream and may be modifiable only at particular times, such as before the stream has been opened. (In fact, you should assume that you can set properties only before opening the stream, unless otherwise noted.) To read the value of a property use CFReadStreamCopyProperty, although some properties are write-only.
Availability
Available in Mac OS X v10.2 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamSetProperty (
   CFReadStreamRef stream,
   CFStringRef propertyName,
   CFTypeRef propertyValue
);

/*CFReadStreamRead

Reads data from a readable stream.

CFIndex CFReadStreamRead (
   CFReadStreamRef stream,
   UInt8 *buffer,
   CFIndex bufferLength
);
Parameters
stream

The stream from which to read.
buffer

The buffer into which to place the data.
bufferLength

The size of buffer and the maximum number of bytes to read.
Return Value

The number of bytes read; 0 if the stream has reached its end; or -1 if either the stream is not open or an error occurs.
Discussion

If stream is in the process of opening, this function waits until it has completed. This function blocks until at least one byte is available; it does not block until buffer is filled. To avoid blocking, call this function only if CFReadStreamHasBytesAvailable returns TRUE or after the stream’s client (set with CFReadStreamSetClient) is notified of a kCFStreamEventHasBytesAvailable event.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFIndex CFReadStreamRead (
   CFReadStreamRef stream,
   UInt8 *buffer,
   CFIndex bufferLength
);


/*CFWriteStreamWrite

Writes data to a writable stream.

CFIndex CFWriteStreamWrite (
   CFWriteStreamRef stream,
   const UInt8 *buffer,
   CFIndex bufferLength
);
Parameters
stream

The stream to which to write.
buffer

The buffer holding the data to write.
bufferLength

The number of bytes from buffer to write.
Return Value

The number of bytes successfully written, 0 if the stream has been filled to capacity (for fixed-length streams), or -1 if either the stream is not open or an error occurs.
Discussion

If stream is in the process of opening, this function waits until it has completed. If the stream is not full, this call blocks until at least one byte is written; it does not block until all the bytes in buffer is written. To avoid blocking, call this function only if CFWriteStreamCanAcceptBytes returns true or after the stream’s client (set with CFWriteStreamSetClient) is notified of a kCFStreamEventCanAcceptBytes event.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
CFIndex CFWriteStreamWrite (
   CFWriteStreamRef stream,
   const UInt8 *buffer,
   CFIndex bufferLength
);

/*CFReadStreamGetError

Returns the error status of a stream.

CFStreamError CFReadStreamGetError (
   CFReadStreamRef stream
);
Parameters
stream

The stream to examine.
Return Value

The error status of stream returned in a CFStreamError structure.

The error field is 0 if no error has occurred. If the error field is not 0, the domain field contains a code that identifies the domain in which the value of the error field should be interpreted.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFStreamError CFReadStreamGetError (
   CFReadStreamRef stream
);

/*CFWriteStreamOpen

Opens a stream for writing.

Boolean CFWriteStreamOpen (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to open.
Return Value

true if stream was successfully opened, false otherwise. If stream is not in the kCFStreamStatusNotOpen state, this function returns false.
Discussion

Opening a stream causes it to reserve all the system resources it requires. If the stream can open in the background without blocking, this function always returns true. To learn when a background open operation completes, you can either schedule the stream into a run loop with CFWriteStreamScheduleWithRunLoop and wait for the stream’s client (set with CFWriteStreamSetClient) to be notified or you can poll the stream using CFWriteStreamGetStatus, waiting for a status of kCFStreamStatusOpen or kCFStreamStatusError. 
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
Boolean CFWriteStreamOpen (
   CFWriteStreamRef stream
);

/*CFReadStreamScheduleWithRunLoop

Schedules a stream into a run loop.

void CFReadStreamScheduleWithRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to schedule.
runLoop

The run loop with which to schedule stream.
runLoopMode

The run loop mode of runLoop in which to schedule stream.
Discussion

After scheduling stream with a run loop, its client (set with CFReadStreamSetClient) is notified when various events happen with the stream, such as when it finishes opening, when it has bytes available, and when an error occurs. A stream can be scheduled with multiple run loops and run loop modes. Use CFReadStreamUnscheduleFromRunLoop to later remove stream from the run loop.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
void CFReadStreamScheduleWithRunLoop (
   CFReadStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);

/*CFReadStreamOpen

Opens a stream for reading.

Boolean CFReadStreamOpen (
   CFReadStreamRef stream
);
Parameters
stream

The stream to open.
Return Value

TRUE if stream was successfully opened, FALSE otherwise. If stream is not in the kCFStreamStatusNotOpen state, this function returns FALSE.
Discussion

Opening a stream causes it to reserve all the system resources it requires. If the stream can open in the background without blocking, this function always returns true. To learn when a background open operation completes, you can either schedule the stream into a run loop with CFReadStreamScheduleWithRunLoop and wait for the stream’s client (set with CFReadStreamSetClient) to be notified or you can poll the stream using CFReadStreamGetStatus, waiting for a status of kCFStreamStatusOpen or kCFStreamStatusError.

You do not need to wait until a stream has finished opening in the background before calling the CFReadStreamRead function. The read operation will simply block until the open has completed.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
Boolean CFReadStreamOpen (
   CFReadStreamRef stream
);

/*CFWriteStreamGetError

Returns the error status of a stream.

CFStreamError CFWriteStreamGetError (
   CFWriteStreamRef stream
);
Parameters
stream

The stream to examine.
Return Value

The error status of stream returned in a CFStreamError structure.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/

CFStreamError CFWriteStreamGetError (
   CFWriteStreamRef stream
);


/*CFReadStreamCreateWithFile

Creates a readable stream for a file.

CFReadStreamRef CFReadStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
fileURL

The URL of the file to read. The URL must use the file scheme.
Return Value

The new readable stream object, or NULL on failure. Ownership follows the Create Rule.
Discussion

You must open the stream, using CFReadStreamOpen, before reading from it.
Availability
Available in Mac OS X v10.1 and later.
Declared In
CoreFoundation/CFStream.h*/
CFReadStreamRef CFReadStreamCreateWithFile (
   CFAllocatorRef alloc,
   CFURLRef fileURL
);


/*CFWriteStreamScheduleWithRunLoop

Schedules a stream into a run loop.

void CFWriteStreamScheduleWithRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
stream

The stream to schedule.
runLoop

The run loop in which to schedule stream.
runLoopMode

The run loop mode of runLoop in which to schedule stream.
Discussion

After scheduling stream into a run loop, its client (set with CFWriteStreamSetClient) is notified when various events happen with the stream, such as when it finishes opening, when it can accept new bytes, and when an error occurs. A stream can be scheduled into multiple run loops and run loop modes. Use CFWriteStreamUnscheduleFromRunLoop to later remove stream from the run loop.
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFWriteStreamScheduleWithRunLoop (
   CFWriteStreamRef stream,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);

/*CFStreamCreatePairWithSocket

Creates readable and writable streams connected to a socket.

void CFStreamCreatePairWithSocket (
   CFAllocatorRef alloc,
   CFSocketNativeHandle sock,
   CFReadStreamRef *readStream,
   CFWriteStreamRef *writeStream
);
Parameters
alloc

The allocator to use to allocate memory for the new objects. Pass NULL or kCFAllocatorDefault to use the current default allocator.
sock

The pre-existing (and already connected) socket which the socket streams should use.
readStream

Upon return, a readable stream connected to the socket address in signature. If you pass NULL, this function will not create a readable stream. Ownership follows the Create Rule.
writeStream

Upon return, a writable stream connected to the socket address in signature. If you pass NULL, this function will not create a writable stream. Ownership follows the Create Rule.
Discussion

Most properties are shared by both streams. Setting the property for one stream automatically sets the property for the other.
Availability
Available in Mac OS X v10.1 and later. 
Declared In
CoreFoundation/CFStream.h*/
void CFStreamCreatePairWithSocket (
   CFAllocatorRef alloc,
   CFSocketNativeHandle sock,
   CFReadStreamRef *readStream,
   CFWriteStreamRef *writeStream
);

#ifdef __cplusplus
}
#endif

#endif