
#import <Foundation/NSObject.h>
#import <Foundation/NSKeyValueObserving.h>

@class NSDictionary;
@class NSEntityDescription;
@class NSError;
@class NSManagedObjectContext;
@class NSManagedObjectID;
@class NSString;

@interface NSManagedObject : NSObject 

/*valueForKey:

Returns the value for the property specified by key.

- (id)valueForKey:(NSString *)key
Parameters
key

The name of one of the receiver's properties.
Return Value

The value of the property specified by key.
Discussion

If key is not a property defined by the model, the method raises an exception. This method is overridden by NSManagedObject to access the managed object’s generic dictionary storage unless the receiver’s class explicitly provides key-value coding compliant accessor methods for key.

Important:  Subclasses should not override this method.

Availability
Available in Mac OS X v10.4 and later.
See Also
– primitiveValueForKey:
– setObservationInfo:
– setObservationInfo:*/
- (id)valueForKey:(NSString *)key;

/*objectID

Returns the object ID of the receiver.

- (NSManagedObjectID *)objectID
Return Value

The object ID of the receiver.
Discussion

If the receiver is a fault, calling this method does not cause it to fire.

Important:  If the receiver has not yet been saved, the object ID is a temporary value that will change when the object is saved.

Availability
Available in Mac OS X v10.4 and later.
See Also
URIRepresentation (NSManagedObjectID)*/
- (NSManagedObjectID *)objectID;

/*isInserted

Returns a Boolean indicating whether the receiver has been inserted in a managed object context.

- (BOOL)isInserted
Return Value

YES if the receiver has been inserted in a managed object context, otherwise NO.
Discussion

If the receiver is a fault, calling this method does not cause it to fire.
Availability
Available in Mac OS X v10.4 and later.
See Also
– isDeleted
– isFault
– isUpdated*/
- (BOOL)isInserted;


/*primitiveValueForKey:

Returns from the receiver’s private internal storage the value for the specified property.

- (id)primitiveValueForKey:(NSString *)key
Parameters
key

The name of one of the receiver's properties.
Return Value

The value of the property specified by key. Returns nil if no value has been set.
Discussion

This method does not invoke the access notification methods (willAccessValueForKey: and didAccessValueForKey:). This method is used primarily by subclasses that implement custom accessor methods that need direct access to the receiver’s private storage.

Important:  Subclasses should not override this method.

Availability
Available in Mac OS X v10.4 and later.
See Also
– setObservationInfo:
– valueForKey:
– setValue:forKey:*/
- (id)primitiveValueForKey:(NSString *)key;

/*managedObjectContext

Returns the managed object context with which the receiver is registered.

- (NSManagedObjectContext *)managedObjectContext
Return Value

The managed object context with which the receiver is registered.
Discussion

If the receiver is a fault, calling this method does not cause it to fire.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSManagedObjectContext *)managedObjectContext;

/*entity

Returns the entity description of the receiver.

- (NSEntityDescription*)entity
Return Value

The entity description of the receiver.
Discussion

If the receiver is a fault, calling this method does not cause it to fire.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSEntityDescription*)entity;

/*setPrimitiveValue:forKey:

Sets in the receiver's private internal storage the value of a given property.

- (void)setPrimitiveValue:(id)value forKey:(NSString *)key
Parameters
value

The new value for the property specified by key.
key

The name of one of the receiver's properties.
Discussion

Sets in the receiver’s private internal storage the value of the property specified by key to value. If key identifies a to-one relationship, relates the object specified by value to the receiver, unrelating the previously related object if there was one. Given a collection object and a key that identifies a to-many relationship, relates the objects contained in the collection to the receiver, unrelating previously related objects if there were any.

This method does not invoke the change notification methods (willChangeValueForKey: and didChangeValueForKey:). It is typically used by subclasses that implement custom accessor methods that need direct access to the receiver’s private internal storage. It is also used by the Core Data framework to initialize the receiver with values from a persistent store or to restore a value from a snapshot.

This method is typically used only for modifying attributes (usually transient), not relationships. If you try to set a to-many relationship to a new NSMutableSet object, it will (eventually) fail. In the unusual event that you need to modify a relationship using this method, you first get the existing set using primitiveValueForKey: (ensure the method does not return nil), create a mutable copy, and then modify the copy—as illustrated in the following example:NSMutableSet *recentHires = [[dept primitiveValueForKey:@"recentHires"] mutableCopy];
if (recentHires != nil) {
    [recentHires removeAllObjects];
    [dept setPrimitiveValue:recentHires forKey:@"recentHires"];
}


Note that if the relationship is bi-directional (that is, if an inverse relationship is specified) then you are also responsible for maintaining the inverse relationship (regardless of cardinality)—in contrast with Core Data's normal behavior described in Using Managed Objects.

Important:  Subclasses should not override this method.

Availability
Available in Mac OS X v10.4 and later.
See Also
– primitiveValueForKey:
– valueForKey:
– setValue:forKey:
– awakeFromFetch*/
- (void)setPrimitiveValue:(id)value forKey:(NSString *)key;


/*willAccessValueForKey:

Provides support for key-value observing access notification.

- (void)willAccessValueForKey:(NSString *)key
Parameters
key

The name of one of the receiver's properties.
Discussion

See didAccessValueForKey: for more details. You can invoke this method with the key value of nil to ensure that a fault has been fired, as illustrated by the following example.[aManagedObject willAccessValueForKey:nil];

Availability
Available in Mac OS X v10.4 and later.
See Also
– didAccessValueForKey:
– willChangeValueForKey:
– didChangeValueForKey:*/
- (void)willAccessValueForKey:(NSString *)key;

/*didAccessValueForKey:

Provides support for key-value observing access notification.

- (void)didAccessValueForKey:(NSString *)key
Parameters
key

The name of one of the receiver's properties.
Discussion

Together with willAccessValueForKey:, this method is used to fire faults, to maintain inverse relationships, and so on. Each read access must be wrapped in this method pair (in the same way that each write access must be wrapped in the willChangeValueForKey:/didChangeValueForKey: method pair). In the default implementation of NSManagedObject these methods are invoked for you automatically. If, say, you create a custom subclass that uses explicit instance variables, you must invoke them yourself, as in the following example.- (NSString *)firstName
{
    [self willAccessValueForKey:@"firstName"];
    NSString *rtn = firstName;
    [self didAccessValueForKey:@"firstName"];
    return rtn;
}

Availability
Available in Mac OS X v10.4 and later.
See Also
– willAccessValueForKey:
– didChangeValueForKey:
– willChangeValueForKey:
– willChangeValueForKey:withSetMutation:usingObjects:
– willChangeValueForKey:withSetMutation:usingObjects:*/
- (void)didAccessValueForKey:(NSString *)key;

/*awakeFromInsert

Invoked automatically by the Core Data framework when the receiver is first inserted into a managed object context.

- (void)awakeFromInsert
Discussion

You typically use this method to initialize special default property values. This method is invoked only once in the object's lifetime.

Important:  Subclasses must invoke super’s implementation before performing their own initialization.

Special Considerations

If you create a managed object then perform undo operations to bring the managed object context to a state prior to the object’s creation, then perform redo operations to bring the managed object context back to a state after the object’s creation, awakeFromInsert is not invoked a second time.
Availability
Available in Mac OS X v10.4 and later.
See Also
– awakeFromFetch*/
- (void)awakeFromInsert;

/*awakeFromFetch

Invoked automatically by the Core Data framework after the receiver has been fetched.

- (void)awakeFromFetch
Discussion

This method is commonly used to compute derived values or to recreate transient relationships from the receiver’s persistent properties.

The change processing is explicitly disabled around this method so that you can conveniently use public setters to establish transient values and other caches without dirtying the object or its context. Because of this, however, you should not modify relationships in this method as the inverse will not be set. 

Important:  Subclasses must invoke super’s implementation before performing their own initialization.

Availability
Available in Mac OS X v10.4 and later.
See Also
– awakeFromInsert
– primitiveValueForKey:
– setPrimitiveValue:forKey:*/
- (void)awakeFromFetch;


/*didTurnIntoFault

Invoked automatically by the Core Data framework when the receiver is turned into a fault.

- (void)didTurnIntoFault
Discussion

This method may be used to clear out custom data caches—transient values declared as entity properties are typically already cleared out by the time this method is invoked (see, for example, refreshObject:mergeChanges:). 
Availability
Available in Mac OS X v10.4 and later.*/
- (void)didTurnIntoFault;



@end


