
#ifndef FILES_H
#define FILES_H


#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif

#ifndef MIXEDMODE_H
#include <CarbonCore/MixedMode.h>
#endif

#ifndef OSUTILS_H
#include <CarbonCore/OSUtils.h>
#endif

#ifndef TEXTCOMMON_H
#include <CarbonCore/TextCommon.h>
#endif

#ifndef UTCUTILS_H
#include <CarbonCore/UTCUtils.h>
#endif



#ifndef FINDER_H
#include <CarbonCore/Finder.h>
#endif


#ifndef CFURL_H
#include <CoreFoundation/CFURL.h>
#endif

#ifndef CFRUNLOOP_H
#include <CoreFoundation/CFRunLoop.h>
#endif


#ifndef  CFUUID_H
#include <CoreFoundation/CFUUID.h>
#endif

#include <sys/types.h>
#include <sys/fcntl.h>


#include <sys/acl.h>


#include <DiskArbitration/DADisk.h>


#include <AvailabilityMacros.h>

#include <HYS/CarbonCore/Files.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*btaining Queue Headers
#define GetFSQHdr()		(QHdrPtr);
#define GetVCBQHdr()		(QHdrPtr);
#define GetDrvQHdr()		(QHdrPtr);*/
//#define GetVCBQHdr()		(QHdrPtr);
#define GetDrvQHdr()		(QHdrPtr);



/*FNMessage


typedef UInt32 FNMessage;
enum {
   kFNDirectoryModifiedMessage = 1
};
Constants
kFNDirectoryModifiedMessage

Available in Mac OS X v10.0 and later.*/

typedef UInt32 FNMessage;
enum {
   kFNDirectoryModifiedMessage = 1
};

/*Icon Type Constants

Specify the icon types for the desktop database. 

enum {
   kLargeIcon = 1,
   kLarge4BitIcon = 2,
   kLarge8BitIcon = 3,
   kSmallIcon = 4,
   kSmall4BitIcon = 5,
   kSmall8BitIcon = 6,
   kicnsIconFamily = 239
};
Constants
kLargeIcon

Large black-and-white icon with mask. Corresponding resource type: 'ICN#'.

Available in Mac OS X v10.0 and later.
kLarge4BitIcon

Large 4-bit color icon. Corresponding resource type: 'icl4’.

Available in Mac OS X v10.0 and later.
kLarge8BitIcon

Large 8-bit color icon. Corresponding resource type: 'icl8'.

Available in Mac OS X v10.0 and later.
kSmallIcon

Small black-and-white icon with mask. Corresponding resource type: 'ics#'.

Available in Mac OS X v10.0 and later.
kSmall4BitIcon

Small 4-bit color icon. Corresponding resource type: 'ics4'.

Available in Mac OS X v10.0 and later.
kSmall8BitIcon

Small 8-bit color icon. Corresponding resource type: 'ics8'.

Available in Mac OS X v10.0 and later.
kicnsIconFamily

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioIconType field of the DTPBRec parameter block.*/
enum {
   kLargeIcon = 1,
   kLarge4BitIcon = 2,
   kLarge8BitIcon = 3,
   kSmallIcon = 4,
   kSmall4BitIcon = 5,
   kSmall8BitIcon = 6,
   kicnsIconFamily = 239
};

/*Icon Size Constants

Specify the sizes of the desktop database icon types.

enum {
   kLargeIconSize = 256,
   kLarge4BitIconSize = 512,
   kLarge8BitIconSize = 1024,
   kSmallIconSize = 64,
   kSmall4BitIconSize = 128,
   kSmall8BitIconSize = 256
};
Constants
kLargeIconSize

Large black-and-white icon with mask. Corresponding resource type: 'ICN#'.

Available in Mac OS X v10.0 and later.
kLarge4BitIconSize

Large 4-bit color icon. Corresponding resource type: 'icl4’.

Available in Mac OS X v10.0 and later.
kLarge8BitIconSize

Large 8-bit color icon. Corresponding resource type: 'icl8'.

Available in Mac OS X v10.0 and later.
kSmallIconSize

Small black-and-white icon with mask. Corresponding resource type: 'ics#'.

Available in Mac OS X v10.0 and later.
kSmall4BitIconSize

Small 4-bit color icon. Corresponding resource type: 'ics4'.

Available in Mac OS X v10.0 and later.
kSmall8BitIconSize

Small 8-bit color icon. Corresponding resource type: 'ics8'.

Available in Mac OS X v10.0 and later.
Discussion

These constants indicate the amount of storage you should allocate for the icon data for each of the icon types specified by the Icon Type Constants. The desktop database functions which set or retrieve icon data–namely, PBDTAddIconSync , PBDTAddIconAsync , PBDTGetIconSync , PBDTGetIconAsync , PBDTGetIconInfoSync , and PBDTGetIconInfoAsync –expect a pointer to the the storage in the ioDTBuffer field of the DTPBRec*/
enum {
   kLargeIconSize = 256,
   kLarge4BitIconSize = 512,
   kLarge8BitIconSize = 1024,
   kSmallIconSize = 64,
   kSmall4BitIconSize = 128,
   kSmall8BitIconSize = 256
};


/*User Privileges Constants

Specify the user privileges for a directory on a remote volume.

enum {
   kioACUserNoSeeFolderBit = 0,
   kioACUserNoSeeFolderMask = 0x01,
   kioACUserNoSeeFilesBit = 1,
   kioACUserNoSeeFilesMask = 0x02,
   kioACUserNoMakeChangesBit = 2,
   kioACUserNoMakeChangesMask = 0x04,
   kioACUserNotOwnerBit = 7,
   kioACUserNotOwnerMask = 0x80
};
Constants
kioACUserNoSeeFolderBit

Set if the user does not have “See Folders” privileges. Without “See Folders” privileges, the user cannot see other directories in the specified directory.

Available in Mac OS X v10.0 and later.
kioACUserNoSeeFolderMask

Tests if the user has “See Folders” privileges.

Available in Mac OS X v10.0 and later.
kioACUserNoSeeFilesBit

Set if the user does not have “See Files” privileges. Without “See Files” privileges, the user cannot open documents or applications in the specified directory.

Available in Mac OS X v10.0 and later.
kioACUserNoSeeFilesMask

Tests if the user has “See Files” privileges.

Available in Mac OS X v10.0 and later.
kioACUserNoMakeChangesBit

Set if the user does not have “Make Changes” privileges. Without “Make Changes” privileges, the user cannot create, modify, rename, or delete any file or directory within the specified directory.

Available in Mac OS X v10.0 and later.
kioACUserNoMakeChangesMask

Tests if the user has “Make Changes” privileges.

Available in Mac OS X v10.0 and later.
kioACUserNotOwnerBit

Set if the user is not the owner of the directory.

Available in Mac OS X v10.0 and later.
kioACUserNotOwnerMask

Tests whether the user is the owner of the directory.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioACUser field of the HFileInfo and DirInfo structures returned by the PBGetCatInfoSync and PBGetCatInfoAsync functions.*/
enum {
   kioACUserNoSeeFolderBit = 0,
   kioACUserNoSeeFolderMask = 0x01,
   kioACUserNoSeeFilesBit = 1,
   kioACUserNoSeeFilesMask = 0x02,
   kioACUserNoMakeChangesBit = 2,
   kioACUserNoMakeChangesMask = 0x04,
   kioACUserNotOwnerBit = 7,
   kioACUserNotOwnerMask = 0x80
};


/*Catalog Search Masks

Specify the criteria for a catalog search.

enum {
   fsSBPartialName = 1,
   fsSBFullName = 2,
   fsSBFlAttrib = 4,
   fsSBFlFndrInfo = 8,
   fsSBFlLgLen = 32,
   fsSBFlPyLen = 64,
   fsSBFlRLgLen = 128,
   fsSBFlRPyLen = 256,
   fsSBFlCrDat = 512,
   fsSBFlMdDat = 1024,
   fsSBFlBkDat = 2048,
   fsSBFlXFndrInfo = 4096,
   fsSBFlParID = 8192,
   fsSBNegate = 16384,
   fsSBDrUsrWds = 8,
   fsSBDrNmFls = 16,
   fsSBDrCrDat = 512,
   fsSBDrMdDat = 1024,
   fsSBDrBkDat = 2048,
   fsSBDrFndrInfo = 4096,
   fsSBDrParID = 8192
};
Constants
fsSBPartialName

Search by a substring of the name.

Available in Mac OS X v10.0 and later.
fsSBFullName

Search by the full name.

Available in Mac OS X v10.0 and later.
fsSBFlAttrib

Search by the file or directory attributes. You can use the attributes to specify that you are searching for a directory, or for a file or directory that is locked by software. 

Available in Mac OS X v10.0 and later.
fsSBFlFndrInfo

For files only search by the file’s Finder info.

Available in Mac OS X v10.0 and later.
fsSBFlLgLen

For files only; search by the logical length of the data fork.

Available in Mac OS X v10.0 and later.
fsSBFlPyLen

For files only; search by the physical length of the data fork.

Available in Mac OS X v10.0 and later.
fsSBFlRLgLen

For files only; search for the logical length of the resource fork.

Available in Mac OS X v10.0 and later.
fsSBFlRPyLen

For files only; search by the physical length of the resource fork.

Available in Mac OS X v10.0 and later.
fsSBFlCrDat

For files only search by the file’s creation date.

Available in Mac OS X v10.0 and later.
fsSBFlMdDat

For files only search by the date of the file’s last modification.

Available in Mac OS X v10.0 and later.
fsSBFlBkDat

For files only search by the date of the file’s last backup.

Available in Mac OS X v10.0 and later.
fsSBFlXFndrInfo

For files only search by the file’s extended Finder info.

Available in Mac OS X v10.0 and later.
fsSBFlParID

For files only search by the file’s parent ID.

Available in Mac OS X v10.0 and later.
fsSBNegate

Search for all non-matches. That is, if a file or directory matches one of the other specified criteria, it is not returned; if it does not match any of the specified ctiteria, it is returned.

Available in Mac OS X v10.0 and later.
fsSBDrUsrWds

For directories only search by the directory’s Finder info.

Available in Mac OS X v10.0 and later.
fsSBDrNmFls

For directories only; search by the number of files in the directory.

Available in Mac OS X v10.0 and later.
fsSBDrCrDat

For directories only search by the directory’s creation date.

Available in Mac OS X v10.0 and later.
fsSBDrMdDat

For directories only search by the date of the directory’s last modification.

Available in Mac OS X v10.0 and later.
fsSBDrBkDat

For directories only search by the date of the directory’s last backup.

Available in Mac OS X v10.0 and later.
fsSBDrFndrInfo

For directories only search by the directory’s additional Finder info.

Available in Mac OS X v10.0 and later.
fsSBDrParID

For directories only search by the directory’s parent ID.

Available in Mac OS X v10.0 and later.
Discussion

Use these constants in the ioSearchBits field of the PBCatSearchSync and PBCatSearchAsync functions to specify the criteria for your search.*/
enum {
   fsSBPartialName = 1,
   fsSBFullName = 2,
   fsSBFlAttrib = 4,
   fsSBFlFndrInfo = 8,
   fsSBFlLgLen = 32,
   fsSBFlPyLen = 64,
   fsSBFlRLgLen = 128,
   fsSBFlRPyLen = 256,
   fsSBFlCrDat = 512,
   fsSBFlMdDat = 1024,
   fsSBFlBkDat = 2048,
   fsSBFlXFndrInfo = 4096,
   fsSBFlParID = 8192,
   fsSBNegate = 16384,
   fsSBDrUsrWds = 8,
   fsSBDrNmFls = 16,
   fsSBDrCrDat = 512,
   fsSBDrMdDat = 1024,
   fsSBDrBkDat = 2048,
   fsSBDrFndrInfo = 4096,
   fsSBDrParID = 8192
};


/*File Operation Options

Flags you can use to specify how to perform a file operation.

enum {
   kFSFileOperationDefaultOptions = 0,
   kFSFileOperationOverwrite = 0x01,
   kFSFileOperationSkipSourcePermissionErrors = 0x02,
   kFSFileOperationDoNotMoveAcrossVolumes = 0x04,
   kFSFileOperationSkipPreflight = 0x08
};
Constants
kFSFileOperationDefaultOptions

Use the following default options:
If the destination directory contains an object with the same name as a source object, abort the operation.
If a source object cannot be read, abort the operation.
If asked to move an object across volume boundaries, perform the operation.

Available in Mac OS X v10.4 and later.
kFSFileOperationOverwrite

If the destination directory contains an object with the same name as a source object, overwrite the destination object.

Available in Mac OS X v10.4 and later.
kFSFileOperationSkipSourcePermissionErrors

If a source object cannot be read, skip the object and continue the operation.

Available in Mac OS X v10.4 and later.
kFSFileOperationDoNotMoveAcrossVolumes

If asked to move an object across volume boundaries, abort the operation.

Available in Mac OS X v10.4 and later.
kFSFileOperationSkipPreflight

Skip the preflight stage for a directory move or copy operation. This option limits the status information that can be returned during the operation.

Available in Mac OS X v10.4 and later.
Discussion

These flags may be passed to any of the functions that initiate a file operation. For more information, see “High-Level File Operations”.*/
enum {
   kFSFileOperationDefaultOptions = 0,
   kFSFileOperationOverwrite = 0x01,
   kFSFileOperationSkipSourcePermissionErrors = 0x02,
   kFSFileOperationDoNotMoveAcrossVolumes = 0x04,
   kFSFileOperationSkipPreflight = 0x08
};



/*File Operation Status Dictionary Keys

Keys used to determine the status of a file operation as reported in a status dictionary.

const CFStringRef kFSOperationTotalBytesKey;
const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
const CFStringRef kFSOperationObjectsCompleteKey;
const CFStringRef kFSOperationObjectsRemainingKey;
const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
const CFStringRef kFSOperationThroughputKey;
Constants
kFSOperationTotalBytesKey

The value for this key is a CFNumber that represents the total number of bytes that will be moved or copied by this file operation. This value is not available for a directory operation if the kFSFileOperationSkipPreflight option flag is specified.

Available in Mac OS X v10.4 and later.
kFSOperationBytesCompleteKey

The value for this key is a CFNumber that represents the total number of bytes that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationBytesRemainingKey

The value for this key is a CFNumber that represents the total number of bytes that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalObjectsKey

The value for this key is a CFNumber that represents the total number of objects that will be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationTotalUserVisibleObjectsKey

The value for this key is a CFNumber that represents the total number of user-visible objects that will be moved or copied by this file operation. In general, an object is user-visible if it is displayed in a Finder window. For example, a package is counted as a single user-visible object even though it typically contains many other objects.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsCompleteKey

The value for this key is a CFNumber that represents the total number of user-visible objects that have already been moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationUserVisibleObjectsRemainingKey

The value for this key is a CFNumber that represents the total number of user-visible objects that remain to be moved or copied by this file operation.

Available in Mac OS X v10.4 and later.
kFSOperationThroughputKey

The value for this key is a CFNumber that represents the current throughput of this file operation in bytes per second.

Available in Mac OS X v10.4 and later.
Discussion

The status dictionary for a file operation is passed back to your status callback function. For more information, see “File Operation Callbacks”. You can also get the status dictionary for a file operation by calling a status accessor function such as FSFileOperationCopyStatus.*/
const CFStringRef kFSOperationTotalBytesKey;
const CFStringRef kFSOperationBytesCompleteKey;
const CFStringRef kFSOperationBytesRemainingKey;
const CFStringRef kFSOperationTotalObjectsKey;
const CFStringRef kFSOperationObjectsCompleteKey;
const CFStringRef kFSOperationObjectsRemainingKey;
const CFStringRef kFSOperationTotalUserVisibleObjectsKey;
const CFStringRef kFSOperationUserVisibleObjectsCompleteKey;
const CFStringRef kFSOperationUserVisibleObjectsRemainingKey;
const CFStringRef kFSOperationThroughputKey;



/*FSFileOperationClientContext

Specifies user-defined data and callbacks associated with an asynchronous file operation.

struct FSFileOperationClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct FSFileOperationClientContext FSFileOperationClientContext;
Fields
version

The version number of the structure; this field should always contain 0.
info

A generic pointer to your user-defined data. This pointer is passed back to your application when you check the status of the file operation. There are two ways you can ask the File Manager for status information about a file operation: by supplying a status callback function when you start the operation, or by calling a file operation status function directly.
retain

An optional callback function that the File Manager can use to retain the user-defined data specified in the info parameter. If your data is a Core Foundation object, you can simply specify the function CFRetain. If no callback is needed, set this field to NULL.
release

An optional callback function that the File Manager can use to release the user-defined data specified in the info parameter. If your data is a Core Foundation object, you can simply specify the function CFRelease. If no callback is needed, set this field to NULL.
copyDescription

An optional callback function that the File Manager can use to create a descriptive string representation of your user-defined data for debugging purposes. If no callback is needed, set this field to NULL.
Discussion

You supply a client context when calling functions such as FSCopyObjectAsync or FSMoveObjectAsync that start an asynchronous copy or move operation.
Availability
Available in Mac OS X v10.4 and later.*/
struct FSFileOperationClientContext {
   CFIndex version;
   void *info;
   CFAllocatorRetainCallBack retain;
   CFAllocatorReleaseCallBack release;
   CFAllocatorCopyDescriptionCallBack copyDescription;
};
typedef struct FSFileOperationClientContext FSFileOperationClientContext;

/*File Operation Stages

Constants used by the File Manager to indicate the current stage of an asynchronous file operation.

typedef UInt32 FSFileOperationStage;
enum {
   kFSOperationStageUndefined = 0,
   kFSOperationStagePreflighting = 1,
   kFSOperationStageRunning = 2,
   kFSOperationStageComplete = 3
};
Constants
kFSOperationStageUndefined

The File Manager has not started the file operation.

Available in Mac OS X v10.4 and later.
kFSOperationStagePreflighting

The File Manager is performing tasks such as calculating the sizes and number of objects in the operation, and checking to make sure there is enough space on the destination volume to complete the operation.

Available in Mac OS X v10.4 and later.
kFSOperationStageRunning

The File Manager is copying or moving the file or directory.

Available in Mac OS X v10.4 and later.
kFSOperationStageComplete

The file operation is complete.

Available in Mac OS X v10.4 and later.
Discussion

These constants are passed back to your file operation status callback function. For more information, see “File Operation Callbacks”. You can also get the current stage of a file operation by calling a status accessor function such as FSFileOperationCopyStatus.*/

typedef UInt32 FSFileOperationStage;
enum {
   kFSOperationStageUndefined = 0,
   kFSOperationStagePreflighting = 1,
   kFSOperationStageRunning = 2,
   kFSOperationStageComplete = 3
};


/*FSPermissionInfo


struct FSPermissionInfo {
   UInt32 userID;
   UInt32 groupID;
   UInt8 reserved1;
   UInt8 userAccess;
   UInt16 mode;
   UInt32 reserved2;
};
typedef struct FSPermissionInfo FSPermissionInfo;
Availability
Available in Mac OS X v10.0 and later.*/

struct FSPermissionInfo {
   UInt32 userID;
   UInt32 groupID;
   UInt8 reserved1;
   UInt8 userAccess;
   UInt16 mode;
   UInt32 reserved2;
   int fileSec;//hys
};
typedef struct FSPermissionInfo FSPermissionInfo;

/*FSFileOperationRef

Defines an opaque type that represents an asynchronous file operation.

typedef struct __FSFileOperation * FSFileOperationRef;
Discussion

You supply a file operation object when calling functions such as FSCopyObjectAsync or FSMoveObjectAsync to start an asynchronous copy or move operation. You can also use a file operation object to check the status of a file operation or to cancel the operation.

To perform an asynchronous file operation:
Create a file operation object using the function FSFileOperationCreate.
Pass the object to the function FSFileOperationScheduleWithRunLoop to schedule the operation.
Pass the object to one of the asychronous file operation functions to start the operation.

The FSFileOperationRef opaque type is a standard Core Foundation data type. It is derived from CFType and inherits the properties that all Core Foundation types have in common. For more information, see CFType Reference.
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct __FSFileOperation * FSFileOperationRef;

/*Catalog Information Node Flags

Define the values used in the nodeFlags field of the FSCatalogInfo structure.

enum {
   kFSNodeLockedBit = 0,
   kFSNodeLockedMask = 0x0001,
   kFSNodeResOpenBit = 2,
   kFSNodeResOpenMask = 0x0004,
   kFSNodeDataOpenBit = 3,
   kFSNodeDataOpenMask = 0x0008,
   kFSNodeIsDirectoryBit = 4,
   kFSNodeIsDirectoryMask = 0x0010,
   kFSNodeCopyProtectBit = 6,
   kFSNodeCopyProtectMask = 0x0040,
   kFSNodeForkOpenBit = 7,
   kFSNodeForkOpenMask = 0x0080,
   kFSNodeHardLinkBit = 8,
   kFSNodeHardLinkMask = 0x00000100
};
Constants
kFSNodeLockedBit

Set if the file or directory is locked.

Available in Mac OS X v10.0 and later.
kFSNodeLockedMask

Indicates that the file or directory is locked.

Available in Mac OS X v10.0 and later.
kFSNodeResOpenBit

Set if the resource fork is open.

Available in Mac OS X v10.0 and later.
kFSNodeResOpenMask

Indicates that the resource fork is open.

Available in Mac OS X v10.0 and later.
kFSNodeDataOpenBit

Set if the data fork is open.

Available in Mac OS X v10.0 and later.
kFSNodeDataOpenMask

Indicates that the data fork is open.

Available in Mac OS X v10.0 and later.
kFSNodeIsDirectoryBit

Set if the object is a directory.

Available in Mac OS X v10.0 and later.
kFSNodeIsDirectoryMask

Indicates that the object is a directory.

Available in Mac OS X v10.0 and later.
kFSNodeCopyProtectBit

Set of the file or directory is copy protected.

Available in Mac OS X v10.0 and later.
kFSNodeCopyProtectMask

Indicates that the file or directory is copy protected.

Available in Mac OS X v10.0 and later.
kFSNodeForkOpenBit

Set if the file or directory has any open fork.

Available in Mac OS X v10.0 and later.
kFSNodeForkOpenMask

Indicates that the file or directory has an open fork of any type.

Available in Mac OS X v10.0 and later.
kFSNodeHardLinkBit

Available in Mac OS X v10.2 and later.
kFSNodeHardLinkMask

Available in Mac OS X v10.2 and later.*/

enum {
   kFSNodeLockedBit = 0,
   kFSNodeLockedMask = 0x0001,
   kFSNodeResOpenBit = 2,
   kFSNodeResOpenMask = 0x0004,
   kFSNodeDataOpenBit = 3,
   kFSNodeDataOpenMask = 0x0008,
   kFSNodeIsDirectoryBit = 4,
   kFSNodeIsDirectoryMask = 0x0010,
   kFSNodeCopyProtectBit = 6,
   kFSNodeCopyProtectMask = 0x0040,
   kFSNodeForkOpenBit = 7,
   kFSNodeForkOpenMask = 0x0080,
   kFSNodeHardLinkBit = 8,
   kFSNodeHardLinkMask = 0x00000100
};



/*File and Folder Access Privilege Constants

Specify access privileges for files and directories in the ioACAccess field of the AccessParam data type.

enum {
   kioACAccessOwnerBit = 31,
   kioACAccessOwnerMask = 0x80000000,
   kioACAccessBlankAccessBit = 28,
   kioACAccessBlankAccessMask = 0x10000000,
   kioACAccessUserWriteBit = 26,
   kioACAccessUserWriteMask = 0x04000000,
   kioACAccessUserReadBit = 25,
   kioACAccessUserReadMask = 0x02000000,
   kioACAccessUserSearchBit = 24,
   kioACAccessUserSearchMask = 0x01000000,
   kioACAccessEveryoneWriteBit = 18,
   kioACAccessEveryoneWriteMask = 0x00040000,
   kioACAccessEveryoneReadBit = 17,
   kioACAccessEveryoneReadMask = 0x00020000,
   kioACAccessEveryoneSearchBit = 16,
   kioACAccessEveryoneSearchMask = 0x00010000,
   kioACAccessGroupWriteBit = 10,
   kioACAccessGroupWriteMask = 0x00000400,
   kioACAccessGroupReadBit = 9,
   kioACAccessGroupReadMask = 0x00000200,
   kioACAccessGroupSearchBit = 8,
   kioACAccessGroupSearchMask = 0x00000100,
   kioACAccessOwnerWriteBit = 2,
   kioACAccessOwnerWriteMask = 0x00000004,
   kioACAccessOwnerReadBit = 1,
   kioACAccessOwnerReadMask = 0x00000002,
   kioACAccessOwnerSearchBit = 0,
   kioACAccessOwnerSearchMask = 0x00000001,
   kfullPrivileges = 0x00070007,
   kownerPrivileges = 0x00000007
};
Constants
kioACAccessOwnerBit

Indicates that the user is the owner of the directory.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerMask

The user is the owner of the directory.

Available in Mac OS X v10.0 and later.
kioACAccessBlankAccessBit

Indicates that the directory has blank access privileges. 

Available in Mac OS X v10.0 and later.
kioACAccessBlankAccessMask

The directory has blank access privileges. A directory with blank access privileges set ignores the other access privilege bits and uses the access privilege bits of its parent directory.

Available in Mac OS X v10.0 and later.
kioACAccessUserWriteBit

Indicates that the user has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessUserWriteMask

The user has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessUserReadBit

Indicates that the user has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessUserReadMask

The user has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessUserSearchBit

Indicates that the user has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessUserSearchMask

The user has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneWriteBit

Indicates that everyone has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneWriteMask

Everyone has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneReadBit

Indicates that everyone has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneReadMask

Everyone has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneSearchBit

Indicates that everyone has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessEveryoneSearchMask

Everyone has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupWriteBit

Indicates that the group has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupWriteMask

The group has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupReadBit

Indicates that the group has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupReadMask

The group has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupSearchBit

Indicates that the group has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessGroupSearchMask

The group has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerWriteBit

Indicates that the owner has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerWriteMask

The owner has write privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerReadBit

Indicates that the owner has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerReadMask

The owner has read privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerSearchBit

Indicates that the owner has search privileges.

Available in Mac OS X v10.0 and later.
kioACAccessOwnerSearchMask

The owner has search privileges.

Available in Mac OS X v10.0 and later.
kfullPrivileges

Indicates that everyone, including the owner, have all privileges.

Available in Mac OS X v10.0 and later.
kownerPrivileges

Indicates that only the owner has all privileges.

Available in Mac OS X v10.0 and later.
Discussion

See AccessParam.*/
enum {
   kioACAccessOwnerBit = 31,
   kioACAccessOwnerMask = 0x80000000,
   kioACAccessBlankAccessBit = 28,
   kioACAccessBlankAccessMask = 0x10000000,
   kioACAccessUserWriteBit = 26,
   kioACAccessUserWriteMask = 0x04000000,
   kioACAccessUserReadBit = 25,
   kioACAccessUserReadMask = 0x02000000,
   kioACAccessUserSearchBit = 24,
   kioACAccessUserSearchMask = 0x01000000,
   kioACAccessEveryoneWriteBit = 18,
   kioACAccessEveryoneWriteMask = 0x00040000,
   kioACAccessEveryoneReadBit = 17,
   kioACAccessEveryoneReadMask = 0x00020000,
   kioACAccessEveryoneSearchBit = 16,
   kioACAccessEveryoneSearchMask = 0x00010000,
   kioACAccessGroupWriteBit = 10,
   kioACAccessGroupWriteMask = 0x00000400,
   kioACAccessGroupReadBit = 9,
   kioACAccessGroupReadMask = 0x00000200,
   kioACAccessGroupSearchBit = 8,
   kioACAccessGroupSearchMask = 0x00000100,
   kioACAccessOwnerWriteBit = 2,
   kioACAccessOwnerWriteMask = 0x00000004,
   kioACAccessOwnerReadBit = 1,
   kioACAccessOwnerReadMask = 0x00000002,
   kioACAccessOwnerSearchBit = 0,
   kioACAccessOwnerSearchMask = 0x00000001,
   kfullPrivileges = 0x00070007,
   kownerPrivileges = 0x00000007
};


/*Foreign Privilege Model Constant

Identifies the A/UX privilege model.

enum {
   fsUnixPriv = 1
};
Constants
fsUnixPriv

Represents a volume that supports the A/UX privilege model.

Available in Mac OS X v10.0 and later.
Discussion

Used in the vMForeignPrivID field of the GetVolParmsInfoBuffer*/

enum {
   fsUnixPriv = 1
};

/*Volume Mount Flags

Define flags used by the volume mounting information structures.

enum {
   volMountNoLoginMsgFlagBit = 0,
   volMountNoLoginMsgFlagMask = 0x0001,
   volMountExtendedFlagsBit = 7,
   volMountExtendedFlagsMask = 0x0080,
   volMountInteractBit = 15,
   volMountInteractMask = 0x8000,
   volMountChangedBit = 14,
   volMountChangedMask = 0x4000,
   volMountFSReservedMask = 0x00FF,
   volMountSysReservedMask = 0xFF00
};
Constants
volMountNoLoginMsgFlagBit

Indicates that any log-in message or greeting dialog will be suppressed.

Available in Mac OS X v10.0 and later.
volMountNoLoginMsgFlagMask

Tells the file system to suppress any log-in message or greeting dialog.

Available in Mac OS X v10.0 and later.
volMountExtendedFlagsBit

Indicates that the mounting information is a AFPXVolMountInfo record for AppleShare Client version 3.7 and later.

Available in Mac OS X v10.0 and later.
volMountExtendedFlagsMask

Tells the file system that the mounting information is an AFPXVolMountInfo record for AppleShare Client version 3.7 and later.

Available in Mac OS X v10.0 and later.
volMountInteractBit

Indicates that it's safe for the file system to perform user interaction to mount the volume.

Available in Mac OS X v10.0 and later.
volMountInteractMask

Tells the file system that it’s safe to perform user interaction to mount the volume.

Available in Mac OS X v10.0 and later.
volMountChangedBit

Indicates that the volume was mounted, but the volume mounting information record needs to be updated.

Available in Mac OS X v10.0 and later.
volMountChangedMask

Tests if the volume mounting information record needs to be updated. 

Available in Mac OS X v10.0 and later.
volMountFSReservedMask

Reserved.

Available in Mac OS X v10.0 and later.
volMountSysReservedMask

Reserved.

Available in Mac OS X v10.0 and later.
Discussion

Bits 0-7 are defined by each file system for its own use; bits 8-15 are reserved for Apple system use. These constants are used in the flags fields of the AFPVolMountInfo, AFPXVolMountInfo , and VolumeMountInfoHeader structures.*/
enum {
   volMountNoLoginMsgFlagBit = 0,
   volMountNoLoginMsgFlagMask = 0x0001,
   volMountExtendedFlagsBit = 7,
   volMountExtendedFlagsMask = 0x0080,
   volMountInteractBit = 15,
   volMountInteractMask = 0x8000,
   volMountChangedBit = 14,
   volMountChangedMask = 0x4000,
   volMountFSReservedMask = 0x00FF,
   volMountSysReservedMask = 0xFF00
};


/*AppleShare Volume Signature

Defines the volume signature for AppleShare volumes.

enum {
   AppleShareMediaType = 'afpm'
};*/

enum {
   AppleShareMediaType = 'afpm'
};

/*Extended AFP Volume Mounting Information Flag

Specifies a flag used in the extendedFlags field of the AFPXVolMountInfo structure.

enum {
   kAFPExtendedFlagsAlternateAddressMask = 1
};
Constants
kAFPExtendedFlagsAlternateAddressMask

Indicates that the alternateAddressOffset field in the AFPXVolMountInfo record is used.

Available in Mac OS X v10.0 and later.
Discussion

See the AFPXVolMountInfo structure for more information.*/
enum {
   kAFPExtendedFlagsAlternateAddressMask = 1
};


/*AFPTagData

Defines a structure which contains tagged address information for AppleShare clients.

struct AFPTagData {
   UInt8 fLength;
   UInt8 fType;
   UInt8 fData[1];
};
typedef struct AFPTagData AFPTagData;
Fields
fLength

The length, in bytes, of this data tag, including the fLength field itself. See AFP Tag Length Constants.
fType

The type of the data tag. See AFP Tag Type Constants for the constants which you can use here.
fData

Variable length data, containing the address.
Discussion

The new tagged data format for addressing allows for changes in addressing formats, allowing AppleShare clients to support new addressing standards without changing the interface. The AFPAlternateAddress data structure uses the AFPTagData structure to specify a tagged address. 
Availability
Available in Mac OS X v10.0 and later.*/
struct AFPTagData {
   UInt8 fLength;
   UInt8 fType;
   UInt8 fData[1];
};
typedef struct AFPTagData AFPTagData;


/*AFP Tag Length Constants

Specify the length of tagged address information for AppleShare volumes.

enum {
   kAFPTagLengthIP = 0x06,
   kAFPTagLengthIPPort = 0x08,
   kAFPTagLengthDDP = 0x06
};
Constants
kAFPTagLengthIP

The length of a 4 byte IP address.

Available in Mac OS X v10.0 and later.
kAFPTagLengthIPPort

The length of a 4 byte IP address and a 2 byte port.

Available in Mac OS X v10.0 and later.
kAFPTagLengthDDP

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the fLength field of the AFPTagData structure to indicate the length, in bytes, of the tagged address information. This length includes the fLength field itself.*/
enum {
   kAFPTagLengthIP = 0x06,
   kAFPTagLengthIPPort = 0x08,
   kAFPTagLengthDDP = 0x06
};


/*Volume Attribute Constants

Describe the volume attributes as returned by the GetVolParmsSync and GetVolParmsAsync functions.

enum {
   bLimitFCBs = 31,
   bLocalWList = 30,
   bNoMiniFndr = 29,
   bNoVNEdit = 28,
   bNoLclSync = 27,
   bTrshOffLine = 26,
   bNoSwitchTo = 25,
   bNoDeskItems = 20,
   bNoBootBlks = 19,
   bAccessCntl = 18,
   bNoSysDir = 17,
   bHasExtFSVol = 16,
   bHasOpenDeny = 15,
   bHasCopyFile = 14,
   bHasMoveRename = 13,
   bHasDesktopMgr = 12,
   bHasShortName = 11,
   bHasFolderLock = 10,
   bHasPersonalAccessPrivileges = 9,
   bHasUserGroupList = 8,
   bHasCatSearch = 7,
   bHasFileIDs = 6,
   bHasBTreeMgr = 5,
   bHasBlankAccessPrivileges = 4,
   bSupportsAsyncRequests = 3,
   bSupportsTrashVolumeCache = 2
};
enum {
   bHasDirectIO = 1
};
Constants
bLimitFCBs

The Finder limits the number of file control blocks used during copying to 8 instead of 16.

Available in Mac OS X v10.0 and later.
bLocalWList

The Finder uses the returned shared volume handle for its local window list.

Available in Mac OS X v10.0 and later.
bNoMiniFndr

Reserved; always set to 1.

Available in Mac OS X v10.0 and later.
bNoVNEdit

This volume’s name cannot be edited.

Available in Mac OS X v10.0 and later.
bNoLclSync

Don’t let the Finder change the modification date.

Available in Mac OS X v10.0 and later.
bTrshOffLine

Any time this volume goes offline, it is zoomed to the Trash and unmounted.

Available in Mac OS X v10.0 and later.
bNoSwitchTo

The Finder will not switch launch to any application on this volume.

Available in Mac OS X v10.0 and later.
bNoDeskItems

Don’t place objects in this volume on the Finder desktop.

Available in Mac OS X v10.0 and later.
bNoBootBlks

This volume is not a startup volume. The Startup menu item is disabled. Boot blocks are not copied during copy operations.

Available in Mac OS X v10.0 and later.
bAccessCntl

This volume supports AppleTalk AFP access-control interfaces. The following functions are supported:
PBHGetLoginInfoSync
PBHGetLoginInfoAsync
PBHGetDirAccessSync
PBHGetDirAccessAsync
PBHSetDirAccessSync
PBHSetDirAccessAsync
PBHMapIDSync
PBHMapIDAsync
PBHMapNameSync
PBHMapNameAsync

Special folder icons are used. The Access Privileges menu command is enabled for disk and folder items. The ioFlAttrib field of the parameter block passed to the PBGetCatInfoSync and PBGetCatInfoSync functions is assumed to be valid.

Available in Mac OS X v10.0 and later.
bNoSysDir

This volume doesn’t support a system directory. Do not switch launch to this volume.

Available in Mac OS X v10.0 and later.
bHasExtFSVol

This volume is an external file system volume.

Available in Mac OS X v10.0 and later.
bHasOpenDeny

This volume supports the PBHOpenDenySync , PBHOpenDenyAsync, PBHOpenRFDenySync and PBHOpenRFDenyAsync functions.

Available in Mac OS X v10.0 and later.
bHasCopyFile

This volume supports the PBHCopyFileSync and PBHCopyFileAsync functions, which is used in copy and duplicate operations if both source and destination volumes have the same server address.

Available in Mac OS X v10.0 and later.
bHasMoveRename

This volume supports the PBHMoveRenameSync and PBHMoveRenameAsync functions.

Available in Mac OS X v10.0 and later.
bHasDesktopMgr

This volume supports all of the desktop functions.

Available in Mac OS X v10.0 and later.
bHasShortName

This volume supports AFP short names.

Available in Mac OS X v10.0 and later.
bHasFolderLock

Folders on the volume can be locked, and so they cannot be deleted or renamed.

Available in Mac OS X v10.0 and later.
bHasPersonalAccessPrivileges

This volume has local file sharing enabled.

Available in Mac OS X v10.0 and later.
bHasUserGroupList

This volume supports the Users and Groups file and thus the AFP privilege functions.

Available in Mac OS X v10.0 and later.
bHasCatSearch

This volume supports the PBCatSearchSync and PBCatSearchAsync functions.

Available in Mac OS X v10.0 and later.
bHasFileIDs

This volume supports the file ID functions, including the PBExchangeFilesSync and PBExchangeFilesAsync functions.

Available in Mac OS X v10.0 and later.
bHasBTreeMgr

Reserved for internal use.

Available in Mac OS X v10.0 and later.
bHasBlankAccessPrivileges

This volume supports inherited access privileges for folders (blank access privileges).

Available in Mac OS X v10.0 and later.
bSupportsAsyncRequests

This volume correctly handles asynchronous requests at any time.

Available in Mac OS X v10.0 and later.
bSupportsTrashVolumeCache

This volume supports the function PBHTrashVolumeCachesSync.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the vMAttrib field of the PBHGetVolParmsSync GetVolParmsInfoBuffer structure returned by the PBHGetVolParmsSync and PBHGetVolParmsAsync functions.*/

enum {
   bHasDirectIO = 1
};


/*AFPAlternateAddress

Defines a block of tagged addresses for AppleShare clients.

struct AFPAlternateAddress {
   UInt8 fVersion;
   UInt8 fAddressCount;
   UInt8 fAddressList[1];
};
typedef struct AFPAlternateAddress AFPAlternateAddress;
Availability
Available in Mac OS X v10.0 and later.*/
struct AFPAlternateAddress {
   UInt8 fVersion;
   UInt8 fAddressCount;
   UInt8 fAddressList[1];
};
typedef struct AFPAlternateAddress AFPAlternateAddress;


/*Extended Volume Attributes

Describe a volume’s extended attributes.

enum {
   bIsEjectable = 0,
   bSupportsHFSPlusAPIs = 1,
   bSupportsFSCatalogSearch = 2,
   bSupportsFSExchangeObjects = 3,
   bSupports2TBFiles = 4,
   bSupportsLongNames = 5,
   bSupportsMultiScriptNames = 6,
   bSupportsNamedForks = 7,
   bSupportsSubtreeIterators = 8,
   bL2PCanMapFileBlocks = 9
   bParentModDateChanges = 10,
   bAncestorModDateChanges = 11
   bSupportsSymbolicLinks = 13,
   bIsAutoMounted = 14,
   bAllowCDiDataHandler = 17,
   bSupportsExclusiveLocks = 18
   bSupportsJournaling = 19,
   bNoVolumeSizes = 20,
   bIsCaseSensitive = 22,
   bIsCasePreserving = 23,
   bDoNotDisplay = 24
};
Constants
bIsEjectable

The volume is in an ejectable disk drive .

Available in Mac OS X v10.0 and later.
bSupportsHFSPlusAPIs

The volume supports the HFS Plus APIs directly, i.e., the File Manager does not emulate them.

Available in Mac OS X v10.0 and later.
bSupportsFSCatalogSearch

The volume supports the FSCatalogSearch operation.

Available in Mac OS X v10.0 and later.
bSupportsFSExchangeObjects

The volume supports the FSExchangeObjects function.

Available in Mac OS X v10.0 and later.
bSupports2TBFiles

The volume supports 2 terabyte files.

Available in Mac OS X v10.0 and later.
bSupportsLongNames

The volume supports file, directory, and volume names longer than 31 characters.

Available in Mac OS X v10.0 and later.
bSupportsMultiScriptNames

The volume supports file, directory, and volume names with characters from multiple script systems.

Available in Mac OS X v10.0 and later.
bSupportsNamedForks

The volume supports named forks other than the data and resource forks.

Available in Mac OS X v10.0 and later.
bSupportsSubtreeIterators

The volume supports recursive iterators, not at the volume root. 

Available in Mac OS X v10.0 and later.
bL2PCanMapFileBlocks

The volume supports the Lg2Phys SPI correctly.

Available in Mac OS X v10.0 and later.
bParentModDateChanges

On this volume, changing a file or folder causes its parent's modification date to change.

Available in Mac OS X v10.0 and later.
bAncestorModDateChanges

On this volume, changing a file or folder causes all ancestor modification dates to change.

Available in Mac OS X v10.0 and later.
bSupportsSymbolicLinks

The volume supports the creation and use of symbolic links (Mac OS X only).

Available in Mac OS X v10.0 and later.
bIsAutoMounted

The volume was mounted automatically (Mac OS X only).

Available in Mac OS X v10.0 and later.
bAllowCDiDataHandler

QuickTime's CDi data handler is allowed to examine the volume.

Available in Mac OS X v10.1 and later.
bSupportsExclusiveLocks

The volume supports exclusive access to files opened for writing.

Available in Mac OS X v10.2 and later.
bSupportsJournaling

The volume supports journaling. This does not indicate whether journaling is currently enabled on the volume.

Available in Mac OS X v10.3 and later.
bNoVolumeSizes

The volume is unable to report volume size or free space.

Available in Mac OS X v10.3 and later.
bIsCaseSensitive

The volume is case-sensitive.

Available in Mac OS X v10.3 and later.
bIsCasePreserving

The volume is preserves case.

Available in Mac OS X v10.3 and later.
bDoNotDisplay

The volume should not be displayed in the user interface. 

Available in Mac OS X v10.3 and later.
Discussion

The GetVolParmsInfoBuffer structure uses these constants in its vMExtendedAttributes field.*/
enum {
   bIsEjectable = 0,
   bSupportsHFSPlusAPIs = 1,
   bSupportsFSCatalogSearch = 2,
   bSupportsFSExchangeObjects = 3,
   bSupports2TBFiles = 4,
   bSupportsLongNames = 5,
   bSupportsMultiScriptNames = 6,
   bSupportsNamedForks = 7,
   bSupportsSubtreeIterators = 8,
   bL2PCanMapFileBlocks = 9,
   bParentModDateChanges = 10,
   bAncestorModDateChanges = 11,
   bSupportsSymbolicLinks = 13,
   bIsAutoMounted = 14,
   bAllowCDiDataHandler = 17,
   bSupportsExclusiveLocks = 18,
   bSupportsJournaling = 19,
   bNoVolumeSizes = 20,
   bIsCaseSensitive = 22,
   bIsCasePreserving = 23,
   bDoNotDisplay = 24
};



/*Volume Attribute Constants

Describe the volume attributes as returned by the GetVolParmsSync and GetVolParmsAsync functions.

enum {
   bLimitFCBs = 31,
   bLocalWList = 30,
   bNoMiniFndr = 29,
   bNoVNEdit = 28,
   bNoLclSync = 27,
   bTrshOffLine = 26,
   bNoSwitchTo = 25,
   bNoDeskItems = 20,
   bNoBootBlks = 19,
   bAccessCntl = 18,
   bNoSysDir = 17,
   bHasExtFSVol = 16,
   bHasOpenDeny = 15,
   bHasCopyFile = 14,
   bHasMoveRename = 13,
   bHasDesktopMgr = 12,
   bHasShortName = 11,
   bHasFolderLock = 10,
   bHasPersonalAccessPrivileges = 9,
   bHasUserGroupList = 8,
   bHasCatSearch = 7,
   bHasFileIDs = 6,
   bHasBTreeMgr = 5,
   bHasBlankAccessPrivileges = 4,
   bSupportsAsyncRequests = 3,
   bSupportsTrashVolumeCache = 2
};
enum {
   bHasDirectIO = 1
};
Constants
bLimitFCBs

The Finder limits the number of file control blocks used during copying to 8 instead of 16.

Available in Mac OS X v10.0 and later.
bLocalWList

The Finder uses the returned shared volume handle for its local window list.

Available in Mac OS X v10.0 and later.
bNoMiniFndr

Reserved; always set to 1.

Available in Mac OS X v10.0 and later.
bNoVNEdit

This volume’s name cannot be edited.

Available in Mac OS X v10.0 and later.
bNoLclSync

Don’t let the Finder change the modification date.

Available in Mac OS X v10.0 and later.
bTrshOffLine

Any time this volume goes offline, it is zoomed to the Trash and unmounted.

Available in Mac OS X v10.0 and later.
bNoSwitchTo

The Finder will not switch launch to any application on this volume.

Available in Mac OS X v10.0 and later.
bNoDeskItems

Don’t place objects in this volume on the Finder desktop.

Available in Mac OS X v10.0 and later.
bNoBootBlks

This volume is not a startup volume. The Startup menu item is disabled. Boot blocks are not copied during copy operations.

Available in Mac OS X v10.0 and later.
bAccessCntl

This volume supports AppleTalk AFP access-control interfaces. The following functions are supported:
PBHGetLoginInfoSync
PBHGetLoginInfoAsync
PBHGetDirAccessSync
PBHGetDirAccessAsync
PBHSetDirAccessSync
PBHSetDirAccessAsync
PBHMapIDSync
PBHMapIDAsync
PBHMapNameSync
PBHMapNameAsync

Special folder icons are used. The Access Privileges menu command is enabled for disk and folder items. The ioFlAttrib field of the parameter block passed to the PBGetCatInfoSync and PBGetCatInfoSync functions is assumed to be valid.

Available in Mac OS X v10.0 and later.
bNoSysDir

This volume doesn’t support a system directory. Do not switch launch to this volume.

Available in Mac OS X v10.0 and later.
bHasExtFSVol

This volume is an external file system volume.

Available in Mac OS X v10.0 and later.
bHasOpenDeny

This volume supports the PBHOpenDenySync , PBHOpenDenyAsync, PBHOpenRFDenySync and PBHOpenRFDenyAsync functions.

Available in Mac OS X v10.0 and later.
bHasCopyFile

This volume supports the PBHCopyFileSync and PBHCopyFileAsync functions, which is used in copy and duplicate operations if both source and destination volumes have the same server address.

Available in Mac OS X v10.0 and later.
bHasMoveRename

This volume supports the PBHMoveRenameSync and PBHMoveRenameAsync functions.

Available in Mac OS X v10.0 and later.
bHasDesktopMgr

This volume supports all of the desktop functions.

Available in Mac OS X v10.0 and later.
bHasShortName

This volume supports AFP short names.

Available in Mac OS X v10.0 and later.
bHasFolderLock

Folders on the volume can be locked, and so they cannot be deleted or renamed.

Available in Mac OS X v10.0 and later.
bHasPersonalAccessPrivileges

This volume has local file sharing enabled.

Available in Mac OS X v10.0 and later.
bHasUserGroupList

This volume supports the Users and Groups file and thus the AFP privilege functions.

Available in Mac OS X v10.0 and later.
bHasCatSearch

This volume supports the PBCatSearchSync and PBCatSearchAsync functions.

Available in Mac OS X v10.0 and later.
bHasFileIDs

This volume supports the file ID functions, including the PBExchangeFilesSync and PBExchangeFilesAsync functions.

Available in Mac OS X v10.0 and later.
bHasBTreeMgr

Reserved for internal use.

Available in Mac OS X v10.0 and later.
bHasBlankAccessPrivileges

This volume supports inherited access privileges for folders (blank access privileges).

Available in Mac OS X v10.0 and later.
bSupportsAsyncRequests

This volume correctly handles asynchronous requests at any time.

Available in Mac OS X v10.0 and later.
bSupportsTrashVolumeCache

This volume supports the function PBHTrashVolumeCachesSync.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the vMAttrib field of the PBHGetVolParmsSync GetVolParmsInfoBuffer structure returned by the PBHGetVolParmsSync and PBHGetVolParmsAsync functions.*/
enum {
   bLimitFCBs = 31,
   bLocalWList = 30,
   bNoMiniFndr = 29,
   bNoVNEdit = 28,
   bNoLclSync = 27,
   bTrshOffLine = 26,
   bNoSwitchTo = 25,
   bNoDeskItems = 20,
   bNoBootBlks = 19,
   bAccessCntl = 18,
   bNoSysDir = 17,
   bHasExtFSVol = 16,
   bHasOpenDeny = 15,
   bHasCopyFile = 14,
   bHasMoveRename = 13,
   bHasDesktopMgr = 12,
   bHasShortName = 11,
   bHasFolderLock = 10,
   bHasPersonalAccessPrivileges = 9,
   bHasUserGroupList = 8,
   bHasCatSearch = 7,
   bHasFileIDs = 6,
   bHasBTreeMgr = 5,
   bHasBlankAccessPrivileges = 4,
   bSupportsAsyncRequests = 3,
   bSupportsTrashVolumeCache = 2
};


/*Volume Information Flags

Used by the FSVolumeInfo structure to specify characteristics of a volume.

enum {
   kFSVolFlagDefaultVolumeBit = 5,
   kFSVolFlagDefaultVolumeMask = 0x0020,
   kFSVolFlagFilesOpenBit = 6,
   kFSVolFlagFilesOpenMask = 0x0040,
   kFSVolFlagHardwareLockedBit = 7,
   kFSVolFlagHardwareLockedMask = 0x0080,
   kFSVolFlagSoftwareLockedBit = 15,
   kFSVolFlagSoftwareLockedMask = 0x8000
};
Constants
kFSVolFlagDefaultVolumeBit

Set if the volume is the default volume.

Available in Mac OS X v10.0 and later.
kFSVolFlagDefaultVolumeMask

Indicates that the volume is the default volume.

Available in Mac OS X v10.0 and later.
kFSVolFlagFilesOpenBit

Set if there are open files or iterators.

Available in Mac OS X v10.0 and later.
kFSVolFlagFilesOpenMask

Indicates that there are open files or iterators.

Available in Mac OS X v10.0 and later.
kFSVolFlagHardwareLockedBit

Set if the volume is locked by a hardware setting. On Mac OS X, the File Manager only sets the software locked bit for CDs and other read-only media; it does not set the hardware locked bit.

Available in Mac OS X v10.0 and later.
kFSVolFlagHardwareLockedMask

Indicates that the volume is locked by a hardware setting.

Available in Mac OS X v10.0 and later.
kFSVolFlagSoftwareLockedBit

Set if the volume is locked by software.

Available in Mac OS X v10.0 and later.
kFSVolFlagSoftwareLockedMask

Indicates that the volume is locked by software.

Available in Mac OS X v10.0 and later.
Discussion

See the flags field of the FSVolumeInfo structure.*/
enum {
   kFSVolFlagDefaultVolumeBit = 5,
   kFSVolFlagDefaultVolumeMask = 0x0020,
   kFSVolFlagFilesOpenBit = 6,
   kFSVolFlagFilesOpenMask = 0x0040,
   kFSVolFlagHardwareLockedBit = 7,
   kFSVolFlagHardwareLockedMask = 0x0080,
   kFSVolFlagSoftwareLockedBit = 15,
   kFSVolFlagSoftwareLockedMask = 0x8000
};


/*Allocation Flags

Indicate how new space is to be allocated.

typedef UInt16 FSAllocationFlags;
enum {
   kFSAllocDefaultFlags = 0x0000,
   kFSAllocAllOrNothingMask = 0x0001,
   kFSAllocContiguousMask = 0x0002,
   kFSAllocNoRoundUpMask = 0x0004,
   kFSAllocReservedMask = 0xFFF8
};
Constants
kFSAllocDefaultFlags

Allocate as much as possible, not necessarily contiguous.

Available in Mac OS X v10.0 and later.
kFSAllocAllOrNothingMask

This bit is set when an allocation must allocate the total requested amount, or else fail with nothing allocated; when this bit is not set, the allocation may complete successfully but allocate less than requested.

Available in Mac OS X v10.0 and later.
kFSAllocContiguousMask

This bit is set when an allocation should allocate one contiguous range of space on the volume. If this bit is clear, multiple discontiguous extents may be allocated to fulfill the request.

Available in Mac OS X v10.0 and later.
kFSAllocNoRoundUpMask

This bit is set when an allocation should no round up to the clump size. If ths bit is clear, then additional space beyond the amount requested may be allocated; this is done by some volume formats (including HFS and HFS Plus) to avoid many small allocation requests. If the bit is set, no additional allocation is done (except where required by the volume format, such as rounding up to a multiple of the allocation block size).

Available in Mac OS X v10.0 and later.
kFSAllocReservedMask

Reserved; set to zero.

Available in Mac OS X v10.0 and later.
Discussion

If the kAllocContiguousMask bit is set, then then any newly allocated space must be in one contiguous extent (preferably contiguous with any space already allocated). If kAllocAllOrNothingMask is set, then the entire requestCount bytes must be allocated for the call to succeed; if not set, as many bytes as possible will be allocated (without error). If kFSAllocNoRoundUpMask is set, then no additional space is allocated (such as rounding up to a multiple of a clump size); if clear, the volume format may allocate more space than requested as an attempt to reduce fragmentation.*/

typedef UInt16 FSAllocationFlags;
enum {
   kFSAllocDefaultFlags = 0x0000,
   kFSAllocAllOrNothingMask = 0x0001,
   kFSAllocContiguousMask = 0x0002,
   kFSAllocNoRoundUpMask = 0x0004,
   kFSAllocReservedMask = 0xFFF8
};

/*VolumeType

Defines the “signature” of the file system.

typedef OSType VolumeType;
Availability
Available in Mac OS X v10.0 and later.*/
typedef OSType VolumeType;

/*Cache Constants

Indicate whether or not data should be cached.

enum {
   pleaseCacheBit = 4,
   pleaseCacheMask = 0x0010,
   noCacheBit = 5,
   noCacheMask = 0x0020,
   rdVerifyBit = 6,
   rdVerifyMask = 0x0040,
   rdVerify = 64,
   forceReadBit = 6,
   forceReadMask = 0x0040,
   newLineBit = 7,
   newLineMask = 0x0080,
   newLineCharMask = 0xFF00
};
Constants
pleaseCacheBit

Indicates that the data should be cached.

Available in Mac OS X v10.0 and later.
pleaseCacheMask

Requests that the data be cached, if possible. You should cache reads and writes if you read or write the same portion of a file multiple times.

Available in Mac OS X v10.0 and later.
noCacheBit

Indicates that data should not be cached.

Available in Mac OS X v10.0 and later.
noCacheMask

Requests that the data not be cached, if possible. You should not cache reads and writes if you read or write data from a file only once.

Available in Mac OS X v10.0 and later.
rdVerifyBit

Indicates that all reads should come from the source and be verified against the data in memory.

Available in Mac OS X v10.0 and later.
rdVerifyMask

Requests that all reads (not writes) come directly from the source and be verified against the data in memory. This flushes the cache and sends all read requests to the data source.

Available in Mac OS X v10.0 and later.
rdVerify

This is the old name of rdVerifyMask. Both request that all reads come directly from the source of the data and be compared against the data in memory.

Available in Mac OS X v10.0 and later.
forceReadBit

Indicates that reads should come from the disk.

Available in Mac OS X v10.0 and later.
forceReadMask

Forces reads from disk, bypassing all caches. Clients can use this to verify that data is stored correctly on the media (eg., to verify after writing) by reading the data into a different buffer while setting the bit, and then comparing the newly read data with the previously written data.

The forceReadMask is the same as the rdVerifyMask used in the older APIs. The actual implementation of the rdVerifyMask in the older APIs actually caused the “force read” behavior, and only compared the data in partial sectors. FSReadFork cleans up this behavior by always letting the client do all of the compares.

Available in Mac OS X v10.0 and later.
newLineBit

Indicates that newline mode should be used for reads.

Available in Mac OS X v10.0 and later.
newLineMask

Requests that newline mode be used for reads. In newline mode, the read stops when one of the following conditions is met:
The requested number of bytes have been read.
The end-of-file is reached.
The newline character has been read. If the newline character is found, it will be the last character put into the buffer and the number of bytes read will include it.

Available in Mac OS X v10.0 and later.
newLineCharMask

Available in Mac OS X v10.0 and later.
Discussion

For the FSReadFork and FSWriteFork functions, and their parameter block equivalents, you may add either of the pleaseCacheMask or noCacheMask constants to one of the Position Mode Constants to hint whether the data should be cached or not. 

The pleaseCacheBit and the noCacheBit are mutually exclusive and only one should be set at a time. If neither bit is set, the program has indicated that it doesn’t care if the data is cached or not.*/
enum {
   pleaseCacheBit = 4,
   pleaseCacheMask = 0x0010,
   noCacheBit = 5,
   noCacheMask = 0x0020,
   rdVerifyBit = 6,
   rdVerifyMask = 0x0040,
   rdVerify = 64,
   forceReadBit = 6,
   forceReadMask = 0x0040,
   newLineBit = 7,
   newLineMask = 0x0080,
   newLineCharMask = 0xFF00
};


/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*IOParam

Defines a parameter block used by low-level I/O functions.

struct IOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct IOParam IOParam;
typedef IOParam * IOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
ioVersNum

A version number. This field is no longer used and you should always set it to 0.
ioPermssn

The access mode. See File Access Permission Constants.
ioMisc

Depending on the function called, this field contains either a new logical end-of-file (for the PBGetEOFSync/ PBGetEOFAsync and PBSetEOFSync/ PBSetEOFAsync functions), a new version number, or a pointer to a new pathname (for the PBHRenameSync/ PBHRenameAsync functions). Because ioMisc is of type Ptr, you’ll need to perform type coercion to interpret the value of ioMisc correctly when it contains an end-of-file (a LongInt value) or version number (a SignedByte value).
ioBuffer

A pointer to a data buffer into which data is written by PBReadSync and PBReadAsync calls; and from which data is read by PBWriteSync and PBWriteAsync calls.
ioReqCount

The requested number of bytes to be read, written, or allocated.
ioActCount

The number of bytes actually read, written, or allocated.
ioPosMode

The positioning mode (base location) for positioning the file mark. Bits 0 and 1 of this field indicate how to position the mark; you can use the constants described in Position Mode Constants to set or test their value.

You can also use the constants described in Cache Constants to indicate whether the data should be cached.
ioPosOffset

The offset to be used in conjunction with the base location specified in the ioPosMode field.
Availability
Available in Mac OS X v10.0 and later.*/
struct IOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct IOParam IOParam;
typedef IOParam * IOParamPtr;


/*FileParam

Defines a parameter block used by low-level functions for getting and setting file information.

struct FileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   unsigned long ioFlNum;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct FileParam FileParam;
typedef FileParam * FileParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A directory index for use with the PBHGetFInfoSync and PBHGetFInfoAsync functions.
ioFlAttrib

File attributes. See File Attribute Constants for the meaning of the bits in this field.
ioFlVersNum

A file version number. This feature is no longer supported, and you must always set this field to 0.
ioFlFndrInfo

Information used by the Finder. 
ioFlNum

A file ID.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork. This field contains 0 if the file’s resource fork is empty.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, specified in seconds since midnight, January 1, 1904.
ioFlMdDat

The date and time of the last modification to the file, specified in seconds since midnight, January 1, 1904.
Availability
Available in Mac OS X v10.0 and later.*/
struct FileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   unsigned long ioFlNum;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct FileParam FileParam;
typedef FileParam * FileParamPtr;

/*VolumeParam

Defines a parameter block used by low-level volume manipulation functions.

struct VolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsBkUp;
   unsigned short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVDirSt;
   short ioVBlLn;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtFNum;
   unsigned short ioVFrBlk;
};
typedef struct VolumeParam VolumeParam;
typedef VolumeParam * VolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler2

Reserved.
ioVolIndex

The volume index.
ioVCrDate

The date and time of the volume’s initialization.
ioVLsBkUp

The date and time the volume information was last modified. (This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory.
ioVDirSt

The first block of the volume directory.
ioVBlLn

Length of directory in blocks.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of allocation blocks.
ioVClpSiz

The volume clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtFNum

The next unused file number.
ioVFrBlk

The number of unused allocation blocks.
Availability
Available in Mac OS X v10.0 and later.*/
struct VolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsBkUp;
   unsigned short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVDirSt;
   short ioVBlLn;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtFNum;
   unsigned short ioVFrBlk;
};
typedef struct VolumeParam VolumeParam;
typedef VolumeParam * VolumeParamPtr;

/*CntrlParam

Defines a parameter block used by Device Manager control and status functions.

struct CntrlParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioCRefNum;
   short csCode;
   short csParam[11];
};
typedef struct CntrlParam CntrlParam;
typedef CntrlParam * CntrlParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioCRefNum

The driver reference number for the I/O operation.
csCode

A value identifying the type of control or status request. Each driver may interpret this number differently.
csParam

The control or status information passed to or from the driver. This field is declared generically as an array of eleven integers. Each driver may interpret the contents of this field differently. Refer to the driver's documentation for specific information.
Availability
Available in Mac OS X v10.0 and later.*/

struct CntrlParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioCRefNum;
   short csCode;
   short csParam[11];
};
typedef struct CntrlParam CntrlParam;
typedef CntrlParam * CntrlParamPtr;

/*SlotDevParam

Defines a parameter block used by low-level Device Manager functions which access a single slot device.

struct SlotDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioSRefNum;
   SInt8 ioSVersNum;
   SInt8 ioSPermssn;
   Ptr ioSMix;
   short ioSFlags;
   SInt8 ioSlot;
   SInt8 ioID;
};
typedef struct SlotDevParam SlotDevParam;
typedef SlotDevParam * SlotDevParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioSRefNum

The driver reference number.
ioSVersNum

The slot version number.
ioSPermssn

Permissions.
ioSMix

Reserved.
ioSFlags

Flags determining the number of additional fields. You should clear all of the bits in this field.
ioSlot

The slot number.
ioID

The slot resource ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct SlotDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioSRefNum;
   SInt8 ioSVersNum;
   SInt8 ioSPermssn;
   Ptr ioSMix;
   short ioSFlags;
   SInt8 ioSlot;
   SInt8 ioID;
};
typedef struct SlotDevParam SlotDevParam;
typedef SlotDevParam * SlotDevParamPtr;

/*MultiDevParam

Defines a parameter block used by low-level Device manager functions which access multiple devices.

struct MultiDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioMRefNum;
   SInt8 ioMVersNum;
   SInt8 ioMPermssn;
   Ptr ioMMix;
   short ioMFlags;
   Ptr ioSEBlkPtr;
};
typedef struct MultiDevParam MultiDevParam;
typedef MultiDevParam * MultiDevParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMRefNum

The driver reference number.
ioMVersNum

The slot version number.
ioMPermssn

Permissions.
ioMMix

Reserved.
ioMFlags

Flags specifying the number of additional fields. You should set the fMulti bit (bit 0) of this field and clear all of the other bits.
ioSEBlkPtr

A pointer to an external parameter block that is customized for the devices installed in the slot.
Availability
Available in Mac OS X v10.0 and later.*/
struct MultiDevParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioMRefNum;
   SInt8 ioMVersNum;
   SInt8 ioMPermssn;
   Ptr ioMMix;
   short ioMFlags;
   Ptr ioSEBlkPtr;
};
typedef struct MultiDevParam MultiDevParam;
typedef MultiDevParam * MultiDevParamPtr;

/*ParamBlockRec

Describes the basic File Manager parameter block.

union ParamBlockRec {
   IOParam ioParam;
   FileParam fileParam;
   VolumeParam volumeParam;
   CntrlParam cntrlParam;
   SlotDevParam slotDevParam;
   MultiDevParam multiDevParam;
};
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;
Fields
ioParam
fileParam
volumeParam
cntrlParam
slotDevParam
multiDevParam
Availability
Available in Mac OS X v10.0 and later.*/
union ParamBlockRec {
   IOParam ioParam;
   FileParam fileParam;
   VolumeParam volumeParam;
   CntrlParam cntrlParam;
   SlotDevParam slotDevParam;
   MultiDevParam multiDevParam;
};
typedef union ParamBlockRec ParamBlockRec;
typedef ParamBlockRec * ParmBlkPtr;


/*FSVolumeOperation


typedef struct OpaqueFSVolumeOperation * FSVolumeOperation;
Availability
Available in Mac OS X v10.2 and later.*/
typedef struct OpaqueFSVolumeOperation * FSVolumeOperation;

/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;

/*HFSUniStr255

Used by the File Manager to return Unicode strings.

struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;
Fields
length

The number of unicode characters in the string.
unicode

The string, in unicode characters.
Discussion

This data type is a string of up to 255 16-bit Unicode characters, with a preceding 16-bit length (number of characters). Note that only the first length characters have meaningful values; the remaining characters may be set to arbitrary values. A caller should always assume that the entire structure will be modified, even if the actual string length is less than 255. 
Availability
Available in Mac OS X v10.0 and later.*/
struct HFSUniStr255 {
   UInt16 length;
   UniChar unicode[255];
};
typedef struct HFSUniStr255 HFSUniStr255;

/*FSSpec

Specifies the name and location of a file or directory.

struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;
Fields
vRefNum

The volume reference number of the volume containing the specified file or directory.
parID

The parent directory ID of the specified file or directory (the directory ID of the directory containing the given file or directory).
name

The name of the specified file or directory. In Carbon, this name must be a leaf name; the name cannot contain a semicolon.
Discussion

The FSSpec structure can describe only a file or a directory, not a volume. A volume can be identified by its root directory, although the system software never uses an FSSpec structure to describe a volume. The directory ID of the root’s parent directory is fsRtParID. The name of the root directory is the same as the name of the volume.

If you need to convert a file specification into an FSSpec structure, call the function FSMakeFSSpec . Do not fill in the fields of an FSSpec structure yourself. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSSpec {
   short vRefNum;
   long parID;
   StrFileName name;
};
typedef struct FSSpec FSSpec;
typedef FSSpec * FSSpecPtr;

/*File System Specification Record
struct FSSpec  {                    //file system specification//
      short       vRefNum;          //volume reference number//
      long        parID;            //directory ID of parent directory//
      Str63       name;             //filename or directory name//
};

typedef struct FSSpec FSSpec;
typedef FSSpec *FSSpecPtr;
typedef FSSpecPtr *FSSpecHandle;*/
typedef FSSpecPtr *FSSpecHandle;

/*FSCatalogInfo

Holds basic information about a file or directory.

struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;
Fields
nodeFlags

Node flags. This field has two defined bits that indicate whether an object is a file or folder, and whether a file is locked (constants kFSNodeIsDirectoryMask and kFSNodeLockedMask). See Catalog Information Node Flags for the values you can use here.
volume

The object's volume reference. 
parentDirID

The ID of the directory that contains the given object. The root directory of a volume always has ID fsRtDirID (2); the parent of the root directory is ID fsRtParID (1). Note that there is no object with ID fsRtParID; this is merely used when the File Manager is asked for the parent of the root directory.
nodeID

The file or directory ID.
sharingFlags

The object’s sharing flags. See Catalog Information Sharing Flags for the meaning of the bits defined for this field.
userPrivileges

The user's effective AFP privileges (same as ioACUser in the old HFileInfo and DirInfo structures). See User Privileges Constants.
reserved1

Reserved.
reserved2

Reserved.
createDate

The date and time of the creation of the object. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field. 
contentModDate

The date and time that the data or resource fork was last modified.
attributeModDate

The date and time that an attribute of the object (such as a fork other than the data or resource fork) was last modified.
accessDate

The date and time that the object was last accessed. The Mac OS 9 File Manager does not automatically update the accessDate field; it exists primarily for use by other operating systems (notably Mac OS X).
backupDate

The date and time of the object’s last backup. This field is not updated by the File Manager a backup utility may use this field if it wishes. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, FSGetCatalogInfo, PBGetCatalogInfoSync, and PBGetCatalogInfoAsync return 0 in this field.
permissions

User and group permission information. The Mac OS 8 and 9 File Manager does not use or enforce this permission information. It could be used by a file server program or other operating system (primarily Mac OS X). In Mac OS X, this array contains the file system permissions of the returned item. To use this information, coerce the parameter to a FSPermissionInfo structure.
finderInfo

Basic Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to a FileInfo or FolderInfo structure.
extFinderInfo

Extended Finder information for the object. This information is available in the catalog information, instead of in a named fork, for historical reasons. The File Manager does not interpret the contents of these fields. To use this information, coerce the parameter to an ExtendedFileInfo or ExtendedFolderInfo structure.
dataLogicalSize

The size of the data fork in bytes (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
dataPhysicalSize

The amount of disk space, in bytes, occupied by the data fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcLogicalSize

The size of the resource fork (the fork’s logical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
rsrcPhysicalSize

The amount of disk space occupied by the resource fork (the fork’s physical size). The information in this field is only valid for files do not rely upon the value returned in this field for folders.
valence

For folders only, the number of items (files plus directories) contained within the directory. For files, it is set to zero. Many volume formats do not store a field containing a directory’s valence. For those volume formats, this field is very expensive to compute. Think carefully before you ask the File Manager to return this field.
textEncodingHint

The textEncodingHint field is used in conjunction with the Unicode filename of the object. It is an optional hint that can be used by the volume format when converting the Unicode to some other encoding. For example, HFS Plus stores this value and uses it when converting the name to a Mac OS encoding, such as when the name is returned by PBGetCatInfoSync or PBGetCatInfoAsync. As another example, HFS volumes use this value to convert the Unicode name to a Mac OS encoded name stored on disk. If the entire Unicode name can be converted to a single Mac OS encoding, then that encoding should be used as the textEncodingHint; otherwise, a text encoding corresponding to the first characters of the name will probably provide the best user experience. 

If a textEncodingHint is not supplied when a file or directory is created or renamed, the volume format will use a default value. This default value may not be the best possible choice for the given filename. Whenever possible, a client should supply a textEncodingHint.

Discussion

The FSCatalogInfoBitmap type is used to indicate which fields of the FSCatalogInfo should be set or retrieved. If the bit corresponding to a particular field is not set, then that field is not changed if the FSCatalogInfo is an output parameter, and that field is ignored if the FSCatalogInfo is an input parameter. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSCatalogInfo {
   UInt16 nodeFlags;
   FSVolumeRefNum volume;
   UInt32 parentDirID;
   UInt32 nodeID;
   UInt8 sharingFlags;
   UInt8 userPrivileges;
   UInt8 reserved1;
   UInt8 reserved2;
   UTCDateTime createDate;
   UTCDateTime contentModDate;
   UTCDateTime attributeModDate;
   UTCDateTime accessDate;
   UTCDateTime backupDate;
   UInt32 permissions[4];
   UInt8 finderInfo[16];
   UInt8 extFinderInfo[16];
   UInt64 dataLogicalSize;
   UInt64 dataPhysicalSize;
   UInt64 rsrcLogicalSize;
   UInt64 rsrcPhysicalSize;
   UInt32 valence;
   TextEncoding textEncodingHint;
};
typedef struct FSCatalogInfo FSCatalogInfo;
typedef FSCatalogInfo * FSCatalogInfoPtr;


/*FSRef

Identifies a directory or file, including a volume’s root directory.

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;
Discussion

This data type’s purpose is similar to an FSSpec except that an FSRef is completely opaque. An FSRef contains whatever information is needed to find the given object; the internal structure of an FSRef is likely to vary based on the volume format, and may vary based on the particular object being identified.

The client of the File Manager cannot examine the contents of an FSRef to extract information about the parent directory or the object’s name. Similarly, an FSRef cannot be constructed directly by the client; the FSRef must be constructed and returned via the File Manager. There is no need to call the File Manager to dispose an FSRef.

To determine the volume, parent directory and name associated with an FSRef, or to get an equivalent FSSpec, use the FSGetCatalogInfo call. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSRef {
   UInt8 hidden[80];
};
typedef struct FSRef FSRef;
typedef FSRef * FSRefPtr;


/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);


/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*FSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog inforFSRefParam

Defines a parameter block used by low-level HFS Plus functions.

struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—you should set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, or 0 for the default volume.
reserved1

Reserved.
reserved2

Reserved.
reserved3

Reserved.
ref

The FSRef describing the file or directory which is the target of the call. 
whichInfo

An FSCatalogInfoBitmap which describes the fields of the catalog information structure passed in the catInfo field which are to be retrieved or set.
catInfo

A catalog information structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.mation structure containing information about the specified file or directory. 
nameLength

The length of the file or directory’s name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
name

A pointer to the file or directory’s Unicode name, for the PBCreateSync, PBCreateAsync, PBRenameSync, and PBRenameAsync functions.
ioDirID

The directory ID of the specified file or directory’s parent directory.
spec

The target or source FSRef. 
parentRef

The secondary or destination FSRef. (Or the ref of the directory to move another file or directory to). 
newRef

The output FSRef (ie, a new FSRef ).
textEncodingHint

A text encoding hint for the file or directory’s Unicode name, used by the PBMakeFSRefSync, PBMakeFSRefAsync, PBRenameSync, and PBRenameAsync functions. 
outName

On output, a pointer to the Unicode name of the file or directory, used by the PBGetCatalogInfoSync and PBGetCatalogInfoAsync functions.
Availability
Available in Mac OS X v10.0 and later.*/
struct FSRefParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   ConstStringPtr ioNamePtr;
   short ioVRefNum;
   SInt16 reserved1;
   UInt8 reserved2;
   UInt8 reserved3;
   const FSRef * ref;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catInfo;
   UniCharCount nameLength;
   const UniChar * name;
   long ioDirID;
   FSSpec * spec;
   FSRef * parentRef;
   FSRef * newRef;
   TextEncoding textEncodingHint;
   HFSUniStr255 * outName;
};
typedef struct FSRefParam FSRefParam;
typedef FSRefParam * FSRefParamPtr;


/*Root Directory Constants

Specify the directory IDs of the root directory of a volume and its parent.

enum {
   fsRtParID = 1,
   fsRtDirID = 2
};
Constants
fsRtParID

Represents the directory ID of the root directory’s parent directory. The root directory has no parent this constant is used when specifying the root directory to functions which require the parent directory ID to identify directories. 

Available in Mac OS X v10.0 and later.
fsRtDirID

Represents the directory ID of the volume’s root directory.

Available in Mac OS X v10.0 and later.*/
enum {
   fsRtParID = 1,
   fsRtDirID = 2
};

/*File Attribute Constants

Define file and directory attributes returned by the PBGetCatInfoSync and PBGetCatInfoAsync functions.

enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};
Constants
kioFlAttribLockedBit

Indicates that the file or directory is locked. Use the functions PBHSetFLockSync and PBHSetFLockAsync to lock a file or directory. Use the functions PBHRstFLockSync and PBHRstFLockAsync to unlock a file or directory.

Available in Mac OS X v10.0 and later.
kioFlAttribLockedMask

Tests if the file or directory is locked.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenBit

Indicates that the resource fork is open. On Mac OS X, this bit is not set if the resource fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribResOpenMask

Tests if the resource fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenBit

Indicates that the data fork is open. On Mac OS X, this bit is not set if the data fork of the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribDataOpenMask

Tests if the data fork is open.

Available in Mac OS X v10.0 and later.
kioFlAttribDirBit

Indicates that this is a directory, not a file. This bit is always clear for files, and is always set for directories.

Available in Mac OS X v10.0 and later.
kioFlAttribDirMask

Tests if this is a directory.

Available in Mac OS X v10.0 and later.
ioDirFlg

Indicates that this is a directory; this is the old name of the kioFlAttribDirBit.

Available in Mac OS X v10.0 and later.
ioDirMask

Tests if this is a directory; this is the old name of the kioFlAttribDirMask.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtBit

Indicates that the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribCopyProtMask

Tests if the file is “copy-protected” by the AppleShare server.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenBit

Indicates that the file is open. This bit is set if either the data or the resource fork are open. On Mac OS X, this bit is not set if the file has been opened by a process other than the process making the call to PBHGetCatInfo or PBHGetFInfo.

Available in Mac OS X v10.0 and later.
kioFlAttribFileOpenMask

Tests if the file is open. The file is open if either the data or the resource fork are open. 

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedBit

Indicates that the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribInSharedMask

Tests if the directory is within a shared area of the directory hierarchy.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedBit

Indicates that the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribMountedMask

Tests if the directory is a share point that is mounted by a user.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointBit

Indicates that the directory is a share point.

Available in Mac OS X v10.0 and later.
kioFlAttribSharePointMask

Tests if the directory is a share point.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioFlAttrib fields of the HFileInfo and DirInfo structures returned by the functions PBGetCatInfoSync and PBGetCatInfoAsync .*/
enum {
   kioFlAttribLockedBit = 0,
   kioFlAttribLockedMask = 0x01,
   kioFlAttribResOpenBit = 2,
   kioFlAttribResOpenMask = 0x04,
   kioFlAttribDataOpenBit = 3,
   kioFlAttribDataOpenMask = 0x08,
   kioFlAttribDirBit = 4,
   kioFlAttribDirMask = 0x10,
   ioDirFlg = 4,
   ioDirMask = 0x10,
   kioFlAttribCopyProtBit = 6,
   kioFlAttribCopyProtMask = 0x40,
   kioFlAttribFileOpenBit = 7,
   kioFlAttribFileOpenMask = 0x80,
   kioFlAttribInSharedBit = 2,
   kioFlAttribInSharedMask = 0x04,
   kioFlAttribMountedBit = 3,
   kioFlAttribMountedMask = 0x08,
   kioFlAttribSharePointBit = 5,
   kioFlAttribSharePointMask = 0x20
};



/*IOCompletionProcPtr

Defines a pointer to a completion function. Your completion function is executed by the File Manager after the completion of an asynchronous File Manager function call.

typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

If you name your function MyIOCompletionProc, you would declare it like this:

void MyIOCompletionProc (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the parameter block that was passed to the asynchronous File Manager function.
Return Value
Discussion

When you execute an asynchronous File Manager function (an Async function), you can specify a completion routine by passing the routine’s address in the ioCompletion field of the parameter block passed to the function. Because you requested asynchronous execution, the File Manager places an I/O request in the file I/O queue and returns control to your application—possibly even before the actual I/O operation is completed. The File Manager takes requests from the queue one at a time and processes them meanwhile, your application is free to do other processing.

A function executed asynchronously returns control to your application with the result code noErr as soon as the call is placed in the file I/O queue. This result code does not indicate that the call has successfully completed, but simply indicates that the call was successfully placed in the queue. To determine when the call is actually completed, you can inspect the ioResult field of the parameter block. This field is set to a positive number when the call is made and set to the actual result code when the call is completed. If you specify a completion routine, it is executed after the result code is placed in ioResult.

The File Manager, when the File Sharing or AppleShare file server is active, will execute requests in arbitrary order. That means that if there is a request that depends on the completion of a previous request, it is an error for your program to issue the second request until the completion of the first request. For example, issuing a write request and then issuing a read request for the same data isn't guaranteed to read back what was written unless the read request isn't made until after the write request completes.

Request order can also change if a call results in a disk switch dialog to bring an offline volume back online. 
Special Considerations

Because a completion routine is executed at interrupt time, it should not allocate, move, or purge memory (either directly or indirectly) and should not depend on the validity of handles to unlocked blocks.

If your completion routine uses application global variables, it must also ensure that register A5 contains the address of the boundary between your application global variables and your application parameters.*/
typedef void (*IOCompletionProcPtr) (
   ParmBlkPtr paramBlock
);

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;

/*IOCompletionUPP

A universal procedure pointer to an application-defined completion function.

typedef IOCompletionProcPtr IOCompletionUPP;
Discussion

See IOCompletionProcPtr.*/
typedef IOCompletionProcPtr IOCompletionUPP;


/*ObjParam

Defines a parameter block used by low-level HFS user and group information functions.

struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler7

Reserved.
ioObjType

A function code. The values passed in this field are determined by the function to which you pass this parameter block.
ioObjNamePtr

A pointer to the returned creator/group name.
ioObjID

The creator/group ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct ObjParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler7;
   short ioObjType;
   StringPtr ioObjNamePtr;
   long ioObjID;
};
typedef struct ObjParam ObjParam;
typedef ObjParam * ObjParamPtr;


/*AccessParam

Defines a parameter block used by low-level HFS file and directory access rights manipulation functions.

struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler3

Reserved.
ioDenyModes

Access mode information.
filler4

Reserved.
filler5

Reserved.
ioACUser

The user’s access rights for the specified directory.
filler6

Reserved.
ioACOwnerID

The owner ID.
ioACGroupID

The group ID.
ioACAccess

The directory access privileges.
ioDirID
Availability
Available in Mac OS X v10.0 and later.*/
struct AccessParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler3;
   short ioDenyModes;
   short filler4;
   SInt8 filler5;
   SInt8 ioACUser;
   long filler6;
   long ioACOwnerID;
   long ioACGroupID;
   long ioACAccess;
   long ioDirID;
};
typedef struct AccessParam AccessParam;
typedef AccessParam * AccessParamPtr;

/*HFileParam

Defines a parameter block used by low-level HFS functions for file creation, deletion, and information retrieval.

struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A directory index for use with the PBHGetFInfoSync and PBHGetFInfoAsync functions.
ioFlAttrib

File attributes. See File Attribute Constants for the meaning of the bits in this field.
ioFlVersNum

A file version number. This feature is no longer supported, and you must always set this field to 0.
ioFlFndrInfo

Information used by the Finder. 
ioDirID

A directory ID.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork. This field contains 0 if the file’s resource fork is empty.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, specified in seconds since midnight, January 1, 1904.
ioFlMdDat

The date and time of the last modification to the file, specified in seconds since midnight, January 1, 1904.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioFlVersNum;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
};
typedef struct HFileParam HFileParam;
typedef HFileParam * HFileParamPtr;

/*HVolumeParam

Defines a parameter block used by low-level HFS volume manipulation functions.

struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;
typedef HVolumeParam * HVolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler2

Reserved.
ioVolIndex

A volume index for use with the PBHGetVInfoSync and PBHGetVInfoAsync functions.
ioVCrDate

The date and time of the volume’s initialization.
ioVLsMod

The date and time the volume information was last modified. (This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.

To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoAsync or PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field.
ioVBitMap

The first block of the volume bitmap.
ioAllocPtr

The block at which the next new file starts. Used internally.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of allocation blocks.
ioVClpSiz

The clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtCNID

The next unused catalog node ID.
ioVFrBlk

The number of unused allocation blocks.
ioVSigWord

A signature word identifying the type of volume it’s $D2D7 for MFS volumes and $4244 for volumes that support HFS calls.
ioVDrvInfo

The drive number of the drive containing the volume.
ioVDRefNum

For online volumes, the reference number of the I/O driver for the drive identified by the ioVDrvInfo field.
ioVFSID

The file-system identifier. It indicates which file system is servicing the volume it’s zero for File Manager volumes and nonzero for volumes handled by an external file system.
ioVBkUp

The date and time the volume was last backed up; this is 0 if the volume has never been backed up.
ioVSeqNum

Used internally.
ioVWrCnt

The volume write count.
ioVFilCnt

The total number of files on the volume.
ioVDirCnt

The total number of directories (not including the root directory) on the volume.
ioVFndrInfo

Information used by the Finder.
Availability
Available in Mac OS X v10.0 and later.*/
struct HVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler2;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
};
typedef struct HVolumeParam HVolumeParam;

/*FIDParam

Defines a parameter block used by low-level HFS file ID functions.

struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler14

Reserved.
ioDestNamePtr

A pointer to the name of the destination file.
filler15

Reserved.
ioDestDirID

The parent directory ID of the destination file.
filler16

Reserved.
filler17

Reserved.
ioSrcDirID

The parent directory ID of the source file.
filler18

Reserved.
ioFileID

The file ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct FIDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler14;
   StringPtr ioDestNamePtr;
   long filler15;
   long ioDestDirID;
   long filler16;
   long filler17;
   long ioSrcDirID;
   short filler18;
   long ioFileID;
};
typedef struct FIDParam FIDParam;
typedef FIDParam * FIDParamPtr;

/*DirInfo

Defines a structure which holds catalog information about a directory.

struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync and PBGetCatInfoAsync ignore the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync and PBGetCatInfoAsync return information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioDrUsrWds

Information used by the Finder. 
ioDrDirID

A directory ID. On input to PBGetCatInfoSync and PBGetCatInfoAsync , this field contains a directory ID, which is used only if the value of the ioFDirIndex field is negative. On output, this field contains the directory ID of the specified directory.
ioDrNmFls

The number of files in the directory.
filler3

Reserved.
ioDrCrDat

The date and time of the directory’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioDrMdDat

The date and time of the last modification to the directory, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioDrBkDat

The date and time that the directory was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioDrFndrInfo

Additional information used by the Finder. 
ioDrParID

The directory ID of the specified directory’s parent directory.
refCon
Availability
Available in Mac OS X v10.0 and later.*/
struct DirInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   DInfo ioDrUsrWds;
   long ioDrDirID;
   unsigned short ioDrNmFls;
   short filler3[9];
   unsigned long ioDrCrDat;
   unsigned long ioDrMdDat;
   unsigned long ioDrBkDat;
   DXInfo ioDrFndrInfo;
   long ioDrParID;
};
typedef struct DirInfo DirInfo;

/*CatPositionRec

Defines a catalog position structure, which maintains the current position of a catalog search between calls to PBCatSearchSync or PBCatSearchAsync.

struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;
Fields
initialize

The starting point of the catalog search. To start searching at the beginning of a catalog, specify 0 in this field. To resume a previous search, pass the value returned by the previous call to PBCatSearchSync or PBCatSearchAsync.
priv

An array of integers that is used internally by PBCatSearchSync and PBCatSearchAsync.
Discussion

When you call the PBCatSearchSync or PBCatSearchAsync function to search a volume’s catalog file, you can specify, in the ioCatPosition field of the parameter block passed to PBCatSearchSync and PBCatSearchAsync, a catalog position structure. If a catalog search consumes more time than is allowed by the ioSearchTime field, PBCatSearchSync and PBCatSearchAsync store a directory-location index in that structure; when you call PBCatSearchSync or PBCatSearchAsync again, it uses that structure to resume searching where it left off. 
Availability
Available in Mac OS X v10.0 and later.*/
struct CatPositionRec {
   long initialize;
   short priv[6];
};
typedef struct CatPositionRec CatPositionRec;

/*HFileInfo

Defines a structure which holds catalog information about a file.

struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFRefNum

The file reference number of an open file.
ioFVersNum

A file version number. This field is no longer used. File version numbers are an artifact of the obsolete MFS, and are not supported on HFS volumes. You should always set this field to 0.
filler1

Reserved.
ioFDirIndex

A file and directory index. If this field contains a positive number, PBGetCatInfoSync and PBGetCatInfoAsync return information about the file or directory having that directory index in the directory specified by the ioVRefNum field. (If ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.) 

If this field contains 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the file or directory whose name is specified in the ioNamePtr field and that is located in the directory specified by the ioVRefNum field. (Once again, if ioVRefNum contains a volume reference number, the specified directory is that volume’s root directory.)

If this field contains a negative number, PBGetCatInfoSync or PBGetCatInfoAsync ignores the ioNamePtr field and returns information about the directory specified in the ioDirID field. If both ioDirID and ioVRefNum are set to 0, PBGetCatInfoSync or PBGetCatInfoAsync returns information about the current default directory.
ioFlAttrib

File or directory attributes. See File Attribute Constants for the meaning of the bits in this field.
ioACUser

The user’s access rights for the specified directory. See User Privileges Constants for the meaning of the bits in this field.
ioFlFndrInfo

Finder information. 
ioDirID

A directory ID or file ID. On input to PBGetCatInfoSync or PBGetCatInfoAsync , this field contains a directory ID (which is used only if the ioFDirIndex field is negative). On output, this field contains the file ID of the specified file.
ioFlStBlk

The first allocation block of the data fork. This field contains 0 if the file’s data fork is empty.
ioFlLgLen

The logical length (logical end-of-file) of the data fork.
ioFlPyLen

The physical length (physical end-of-file) of the data fork.
ioFlRStBlk

The first allocation block of the resource fork.
ioFlRLgLen

The logical length (logical end-of-file) of the resource fork.
ioFlRPyLen

The physical length (physical end-of-file) of the resource fork.
ioFlCrDat

The date and time of the file’s creation, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the creation date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970, and that is the value which will be returned if you later try to retrieve the creation date. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates.
ioFlMdDat

The date and time of the last modification to the file, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the modification date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970.
ioFlBkDat

The date and time that the file was last backed up, in seconds since midnight, January 1, 1904. However, on Mac OS X, if you set the backup date to a date between January 1, 1904 and January 1, 1970, it will be clipped to January 1, 1970. 

Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates.
ioFlXFndrInfo

Additional Finder information. 
ioFlParID

The directory ID of the file’s parent directory.
ioFlClpSiz

The clump size to be used when writing the file if it’s 0, the volume’s clump size is used when the file is opened.
Availability
Available in Mac OS X v10.0 and later.*/
struct HFileInfo {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioFRefNum;
   SInt8 ioFVersNum;
   SInt8 filler1;
   short ioFDirIndex;
   SInt8 ioFlAttrib;
   SInt8 ioACUser;
   FInfo ioFlFndrInfo;
   long ioDirID;
   unsigned short ioFlStBlk;
   long ioFlLgLen;
   long ioFlPyLen;
   unsigned short ioFlRStBlk;
   long ioFlRLgLen;
   long ioFlRPyLen;
   unsigned long ioFlCrDat;
   unsigned long ioFlMdDat;
   unsigned long ioFlBkDat;
   FXInfo ioFlXFndrInfo;
   long ioFlParID;
   long ioFlClpSiz;
};
typedef struct HFileInfo HFileInfo;

/*ForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchrForeignPrivParam

Defines a parameter block used by low-level HFS foreign privileges functions.

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.onous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioFiller21

Reserved.
ioFiller22

Reserved.
ioForeignPrivBuffer

A pointer to a buffer containing access-control information about the foreign file system.
ioForeignPrivActCount

The size of the buffer pointed to by the ioForeignPrivBuffer field.
ioForeignPrivReqCount

The amount of the buffer pointed to by the ioForeignPrivBuffer field that was actually used to hold data.
ioFiller23

Reserved.
ioForeignPrivDirID

The parent directory ID of the foreign file or directory.
ioForeignPrivInfo1

A long word that may contain privileges data.
ioForeignPrivInfo2

A long word that may contain privileges data.
ioForeignPrivInfo3

A long word that may contain privileges data.
ioForeignPrivInfo4

A long word that may contain privileges data.
Availability
Available in Mac OS X v10.0 and later.*/

struct ForeignPrivParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long ioFiller21;
   long ioFiller22;
   Ptr ioForeignPrivBuffer;
   long ioForeignPrivActCount;
   long ioForeignPrivReqCount;
   long ioFiller23;
   long ioForeignPrivDirID;
   long ioForeignPrivInfo1;
   long ioForeignPrivInfo2;
   long ioForeignPrivInfo3;
   long ioForeignPrivInfo4;
};
typedef struct ForeignPrivParam ForeignPrivParam;
typedef ForeignPrivParam * ForeignPrivParamPtr;

/*CInfoPBRec

Defines a catalog information parameter block for file and directory information.

union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;
Fields
hFileInfo
dirInfo
Availability
Available in Mac OS X v10.0 and later.*/
union CInfoPBRec {
   HFileInfo hFileInfo;
   DirInfo dirInfo;
};
typedef union CInfoPBRec CInfoPBRec;
typedef CInfoPBRec * CInfoPBPtr;


/*CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CSParam

Defines a parameter block used by low-level HFS catalog search functions.

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioMatchPtr

A pointer to an array of FSSpec structures in which the file and directory names that match the selection criteria are returned. The array must be large enough to hold the largest possible number of FSSpec structures, as determined by the ioReqMatchCount field.
ioReqMatchCount

The maximum number of matches to return. This number should be the number of FSSpec structures that will fit in the memory pointed to by the ioMatchPtr field. You can use this field to avoid a possible excess of matches for criteria that prove to be too general (or to limit the length of a search if the ioSearchTime field isn’t used).
ioActMatchCount

The number of actual matches found.
ioSearchBits

The fields of the parameter blocks in the ioSearchInfo1 and ioSearchInfo2 fields that are relevant to the search. See Catalog Search Bits for more information.
ioSearchInfo1

A pointer to a CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in the ioSearchInfo2 field, and set the matching values in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this struture.
ioSearchInfo2

A pointer to a second CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.CInfoPBRec parameter block that contains the search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching values in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this struture.
ioSearchTime

A time limit on a search, in Time Manager format. Use this field to limit the run time of a single call to PBCatSearchSync or PBCatSearchAsync. A value of 0 imposes no time limit. If the value of this field is positive, it is interpreted as milliseconds. If the value of this field is negative, it is interpreted as negated microseconds.
ioCatPosition

A position in the catalog where searching should begin. Use this field to keep an index into the catalog when breaking down the PBCatSearchSync or PBCatSearchAsync search into a number of smaller searches. This field is valid whenever PBCatSearchSync or PBCatSearchAsync exits because it either spends the maximum time allowed by ioSearchTime or finds the maximum number of matches allowed by ioReqMatchCount.

To start at the beginning of the catalog, set the initialize field of ioCatPosition to 0. Before exiting after an interrupted search, PBCatSearchSync or PBCatSearchAsync sets that field to the next catalog entry to be searched.

To resume where the previous call stopped, pass the entire CatPositionRec structure returned by the previous call as input to the next.
ioOptBuffer

A pointer to an optional read buffer. The ioOptBuffer and ioOptBufSize fields let you specify a part of memory as a read buffer, increasing search speed.
ioOptBufSize

The size of the buffer pointed to by ioOptBuffer. Buffer size effectiveness varies with models and configurations, but a 16 KB buffer is likely to be optimal. The size should be at least 1024 bytes and should be an integral multiple of 512 bytes.
Availability
Available in Mac OS X v10.0 and later.*/

struct CSParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   FSSpecPtr ioMatchPtr;
   long ioReqMatchCount;
   long ioActMatchCount;
   long ioSearchBits;
   CInfoPBPtr ioSearchInfo1;
   CInfoPBPtr ioSearchInfo2;
   long ioSearchTime;
   CatPositionRec ioCatPosition;
   Ptr ioOptBuffer;
   long ioOptBufSize;
};
typedef struct CSParam CSParam;
typedef CSParam * CSParamPtr;

/*WDParam

Defines a parameter block used by low-level HFS working directory functions.

struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler9

An index to working directories.
ioWDIndex

The working directory user identifier.
ioWDProcID

The volume reference number for the working directory.
ioWDVRefNum

Reserved.
filler10

Reserved.
filler11

Reserved.
filler12

Reserved.
filler13

The working directory’s directory ID.
ioWDDirID

The working directory’s directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct WDParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioWDCreated;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler10;
   long filler11;
   long filler12;
   long filler13;
   long ioWDDirID;
};
typedef struct WDParam WDParam;
typedef WDParam * WDParamPtr;


/*HIOParam

Defines a parameter block used by low-level HFS I/O functions.

struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
ioVersNum

A version number. This field is no longer used and you should always set it to 0.
ioPermssn

The access mode. See File Access Permission Constants.
ioMisc

Depending on the function called, this field contains either a logical end-of-file, a new version number, a pointer to an access path buffer, or a pointer to a new pathname. Because ioMisc is of type Ptr, you’ll need to perform type coercion to interpret the value of ioMisc correctly when it contains an end-of-file (a LongInt value) or version number (a SignedByte value).
ioBuffer

A pointer to a data buffer into which data is written by PBReadSync and PBReadAsync calls, and from which data is read by PBWriteSync and PBWriteAsync calls.
ioReqCount

The requested number of bytes to be read, written, or allocated.
ioActCount

The number of bytes actually read, written, or allocated.
ioPosMode

The positioning mode (base location) for setting the mark. Bits 0 and 1 of this field indicate how to position the mark; you can use the constants described in Position Mode Constants to set or test their value.

You can also use the constants described in Cache Constants to indicate whether or not to cache the data.
ioPosOffset

The offset to be used in conjunction with the base location specified in the ioPosMode field.
Availability
Available in Mac OS X v10.0 and later.*/
struct HIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   SInt8 ioVersNum;
   SInt8 ioPermssn;
   Ptr ioMisc;
   Ptr ioBuffer;
   long ioReqCount;
   long ioActCount;
   short ioPosMode;
   long ioPosOffset;
};
typedef struct HIOParam HIOParam;
typedef HIOParam * HIOParamPtr;

/*CopyParam

Defines a parameter block used by low-level HFS file copying functions.

struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioDstVRefNum

A volume reference number for the destination volume.
filler8

Reserved.
ioNewName

A pointer to the destination pathname.
ioCopyName

A pointer to an optional name.
ioNewDirID

A destination directory ID.
filler14

Reserved.
filler15

Reserved.
ioDirID

A directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct CopyParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDstVRefNum;
   short filler8;
   StringPtr ioNewName;
   StringPtr ioCopyName;
   long ioNewDirID;
   long filler14;
   long filler15;
   long ioDirID;
};
typedef struct CopyParam CopyParam;
typedef CopyParam * CopyParamPtr;


/*HParamBlockRec

Describes the HFS parameter block.

union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;
Fields
ioParam

A parameter block used by low-level HFS I/O functions. See HIOParam. 
fileParam

A parameter block used by low-level HFS functions for file creation, deletion, and information retrieval. See HFileParam. 
volumeParam

A parameter block used by low-level HFS volume manipulation functions. See HVolumeParam. 
accessParam

A parameter block used by low-level HFS file and directory access rights manipulation functions. See AccessParam. 
objParam

A parameter block used by low-level HFS user and group information functions. See ObjParam. 
copyParam

A parameter block used by low-level HFS file copying functions. See CopyParam. 
wdParam

A parameter block used by low-level HFS working directory functions. See WDParam. 
fidParam

A parameter block used by low-level HFS file ID functions. See FIDParam. 
csParam

A parameter block used by low-level HFS catalog search functions. See CSParam. 
foreignPrivParam

A parameter block used by low-level HFS foreign privileges functions. See ForeignPrivParam. 
Availability
Available in Mac OS X v10.0 and later.*/
union HParamBlockRec {
   HIOParam ioParam;
   HFileParam fileParam;
   HVolumeParam volumeParam;
   AccessParam accessParam;
   ObjParam objParam;
   CopyParam copyParam;
   WDParam wdParam;
   FIDParam fidParam;
   CSParam csParam;
   ForeignPrivParam foreignPrivParam;
};
typedef union HParamBlockRec HParamBlockRec;
typedef HParamBlockRec * HParmBlkPtr;

/*GetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect thiGetVolParmsInfoBuffer

Defines a volume attributes buffer, used by the PBHGetVolParmsSync and PBHGetVolParmAsync functions to return volume information.

struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;
Fields
vMVersion

The version number of the attributes buffer structure. Currently this field returns 1, 2, 3 or 4. Version 3 is introduced to support the HFS Plus APIs.
vMAttrib

A 32-bit quantity that encodes information about the volume attributes. See Volume Attribute Constants for the meaning of the bits in this field.
vMLocalHand

A handle to private data for shared volumes. On creation of the VCB (right after mounting), this field is a handle to a 2-byte block of memory. The Finder uses this for its local window list storage, allocating and deallocating memory as needed. It is disposed of when the volume is unmounted. Your application should treat this field as reserved.
vMServerAdr

For AppleTalk server volumes, this field contains the internet address of an AppleTalk server volume. Your application can inspect this field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.s field to tell which volumes belong to which server; the value of this field is 0 if the volume does not have a server.
vMVolumeGrade

The relative speed rating of the volume. The scale used to determine these values is currently uncalibrated. In general, lower values indicate faster speeds. A value of 0 indicates that the volume’s speed is unrated. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMForeignPrivID

An integer representing the privilege model supported by the volume. Currently two values are defined for this field: 0 represents a standard HFS or HFS Plus volume that might or might not support the AFP privilege model; fsUnixPriv represents a volume that supports the A/UX privilege model. The buffer version returned in the vMVersion field must be greater than 1 for this field to be meaningful.
vMExtendedAttributes

Contains bits that describe a volume’s extended attributes. For this field to be meaningful, the vMVersion must be greater than 2. See Extended Volume Attributes for the meaning of the bits in this field.
vMDeviceID

A device name identifying the device in /dev that corresponds to the volume. You can use this string to build a POSIX path to the device for use with IOKit APIs.
vMMaxNameLength
Discussion

Volumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer. Volumes that don’t implement the HFS Plus APIs may still implement version 3 of the GetVolParmsInfoBuffer. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear (zero), then the volume does not implement the HFS Plus APIs, and they are being emulated for that volume by the File Manager itself.

If a volume does not implement the HFS Plus APIs, and supports version 2 or earlier of the GetVolParmsInfoBuffer, it cannot itself describe whether it supports the FSCatalogSearch or FSExchangeObjects calls. The compatibility layer will implement the FSCatalogSearch call if the volume supports the PBCatSearch call (i.e. the bHasCatSearch bit of vMAttrib is set). The compatibility layer will implement the FSExchangeObjects call if the volume supports PBExchangeFiles (i.e. the bHasFileIDs bit of vMAttrib is set). 
Availability
Available in Mac OS X v10.0 and later.*/
struct GetVolParmsInfoBuffer {
   short vMVersion;
   long vMAttrib;
   Handle vMLocalHand;
   long vMServerAdr;
   long vMVolumeGrade;
   short vMForeignPrivID;
   long vMExtendedAttributes;
   void * vMDeviceID;
   UniCharCount vMMaxNameLength;
};
typedef struct GetVolParmsInfoBuffer GetVolParmsInfoBuffer;

/*Volume Information Bitmap Constants

Indicate what volume information to set or retrieve.

enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};
Constants
kFSVolInfoNone

No volume information.

Available in Mac OS X v10.0 and later.
kFSVolInfoCreateDate

Retrieve the creation date of the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoModDate

Retrieve the date of the volume’s last modification.

Available in Mac OS X v10.0 and later.
kFSVolInfoBackupDate

Retrieve or set the date of the volume’s last backup.

Available in Mac OS X v10.0 and later.
kFSVolInfoCheckedDate

Retrieve the date that the volume was last checked for consistency.

Available in Mac OS X v10.0 and later.
kFSVolInfoFileCount

Retrieve the number of files on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoDirCount

Retrieve the number of directories on the volume.

Available in Mac OS X v10.0 and later.
kFSVolInfoSizes

Retrieve the total number of bytes on the volume and the number of unused bytes on the volume (in the totalBytes and freeBytes fields).

Available in Mac OS X v10.0 and later.
kFSVolInfoBlocks

Retrieve the block information: the block size, the number of total blocks on the volume, and the number of free blocks on the volume. 

Available in Mac OS X v10.0 and later.
kFSVolInfoNextAlloc

Retrieve the address at which to start the next allocation.

Available in Mac OS X v10.0 and later.
kFSVolInfoRsrcClump

Retrieve the resource fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoDataClump

Retrieve the data fork clump size.

Available in Mac OS X v10.0 and later.
kFSVolInfoNextID

Retrieve the next available catalog node ID.

Available in Mac OS X v10.0 and later.
kFSVolInfoFinderInfo

Retrieve or set the volume’s Finder information.

Available in Mac OS X v10.0 and later.
kFSVolInfoFlags

Retrieve or set the volume’s flags. See Volume Information Flags for more information on the volume’s flags.

Available in Mac OS X v10.0 and later.
kFSVolInfoFSInfo

Retrieve the filesystem ID and signature.

Available in Mac OS X v10.0 and later.
kFSVolInfoDriveInfo

Retrieve the drive information: the drive number and driver reference number.

Available in Mac OS X v10.0 and later.
kFSVolInfoGettableInfo

Retrieve all of the gettable information.

Available in Mac OS X v10.0 and later.
kFSVolInfoSettableInfo

Set all of the settable information. Currently, this is the backup date, Finder information, and flags.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used with the FSVolumeInfoBitmap data type to indicate what volume information to set or retrieve with the functions FSSetVolumeInfo and FSGetVolumeInfo , and their corresponding parameter block calls*/
enum {
   kFSVolInfoNone = 0x0000,
   kFSVolInfoCreateDate = 0x0001,
   kFSVolInfoModDate = 0x0002,
   kFSVolInfoBackupDate = 0x0004,
   kFSVolInfoCheckedDate = 0x0008,
   kFSVolInfoFileCount = 0x0010,
   kFSVolInfoDirCount = 0x0020,
   kFSVolInfoSizes = 0x0040,
   kFSVolInfoBlocks = 0x0080,
   kFSVolInfoNextAlloc = 0x0100,
   kFSVolInfoRsrcClump = 0x0200,
   kFSVolInfoDataClump = 0x0400,
   kFSVolInfoNextID = 0x0800,
   kFSVolInfoFinderInfo = 0x1000,
   kFSVolInfoFlags = 0x2000,
   kFSVolInfoFSInfo = 0x4000,
   kFSVolInfoDriveInfo = 0x8000,
   kFSVolInfoGettableInfo = 0xFFFF,
   kFSVolInfoSettableInfo = 0x3004
};


/*FSVolumeInfoBitmap

Describes which fields of the FSVolumeInfo structure you wish to retrieve or set.

typedef UInt32 FSVolumeInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSVolumeInfo structure if it is an output parameter, and that field is ignored if the FSVolumeInfo structure is an input parameter. See Volume Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSVolumeInfoBitmap;

/*FSVolumeInfo

Used when getting or setting information about a volume.

struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;
typedef FSVolumeInfo * FSVolumeInfoPtr;
Fields
createDate

The date and time the volume was created. A value of 0 means that the volume creation date is unknown. 
modifyDate

The last time when the volume was modified in any way. A value of 0 means “never” or “unknown.
backupDate

Indicates when the volume was last backed up. This field is for use by backup utilities. A value of 0 means “never” or “unknown.
checkedDate

The last date and time that the volume was checked for consistency. A value of 0 means “never” or “unknown.
fileCount

The total number of files on the volume, or 0 if unknown.
folderCount

The total number of folders on the volume, or 0 if unknown. Note that no root directory counts.
totalBytes

The size of the volume in bytes.
freeBytes

The number of bytes of free space on the volume.
blockSize

The size of an allocation block, in bytes. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
totalBlocks

The total number of allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
freeBlocks

The number of unused allocation blocks on the volume. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
nextAllocation

A hint for where to start searching for free space during an allocation. This field is only appropriate for volume formats (such as HFS and HFS Plus) that allocate space in fixed-size pieces; other volume formats may not have a similar concept, and may set this field to zero.
rsrcClumpSize

Default resource fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
dataClumpSize

Default data fork clump size. When a fork is automatically grown as it is written, the File Manager attempts to allocate space that is a multiple of the clump size. This field is zero for volume formats that don’t support the notion of a clump size.
nextCatalogID

The next unused catalog node ID. Some volume formats (such as HFS and HFS Plus) use a monotonically increasing number for the catalog node ID (i.e. File ID or Directory ID) of newly created files and directories. For those volume formats, the nextCatalogID is the next file/directory ID that will be assigned. For other volume formats, this field will be zero.
finderInfo

Information used by Finder, such as the Directory ID of the System Folder. Some volume formats do not support Finder information for a volume and will set this field to all zeroes.
flags

This field contains bit flags holding informaiton about the volume. See Volume Information Flags for the attribute constants you can use here.
filesystemID

Identifies the filesystem implementation that is handling the volume; this is zero for HFS and HFS Plus volumes.
signature

This field is used to distinguish between volume formats supported by a single filesystem implementation.
driveNumber

The drive number for the drive (drive queue element) associated with the volume. Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
driverRefNum

The driver reference number for the drive (drive queue element) associated with the volume.
Discussion

This structure contains information about a volume as a whole information about a volume’s root directory would use the FSCatalogInfo structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSVolumeInfo {
   UTCDateTime createDate;
   UTCDateTime modifyDate;
   UTCDateTime backupDate;
   UTCDateTime checkedDate;
   UInt32 fileCount;
   UInt32 folderCount;
   UInt64 totalBytes;
   UInt64 freeBytes;
   UInt32 blockSize;
   UInt32 totalBlocks;
   UInt32 freeBlocks;
   UInt32 nextAllocation;
   UInt32 rsrcClumpSize;
   UInt32 dataClumpSize;
   UInt32 nextCatalogID;
   UInt8 finderInfo[32];
   UInt16 flags;
   UInt16 filesystemID;
   UInt16 signature;
   UInt16 driveNumber;
   short driverRefNum;
};
typedef struct FSVolumeInfo FSVolumeInfo;

/*File Access Permission Constants

Specify the type of read and write access to a file or fork.

enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};
Constants
fsCurPerm

Requests whatever permissions are currently allowed. If write access in unavailable (because the file is locked or the file is already open with write permission), then read permission is granted. Otherwise read/write permission is granted.

Available in Mac OS X v10.0 and later.
fsRdPerm

Requests permission to read the file.

Available in Mac OS X v10.0 and later.
fsWrPerm

Requests permission to write to the file. If write permission is granted, no other access paths are granted write permission. Note, however, that the File Manager does not support write-only access to a file. Thus, fsWrPerm is synonymous with fsRdWrPerm.

Available in Mac OS X v10.0 and later.
fsRdWrPerm

Requests exclusive read and write permission. If exclusive read/ write permission is granted, no other users are granted permission to write to the file. Other users may, however, be granted permission to read the file.

Available in Mac OS X v10.0 and later.
fsRdWrShPerm

Requests shared read and write permission. Shared read and write permission allows mutiple access paths for reading and writing. This is safe only if there is some way of locking portions of the file before writing to them. On volumes that support range locking, you can use the functions PBLockRangeSync and PBUnlockRangeSync to lock and unlock ranges of bytes within a file. Applications running in Mac OS X version 10.4 or later should use the functions FSLockRange and FSUnlockRange for this purpose. 

Available in Mac OS X v10.0 and later.
fsRdDenyPerm

Requests that any other paths be prevented from having read access. A path cannot be opened if you request read permission (with the fsRdPerm constant) but some other path has requested deny-read access. Similarly, the path cannot be opened if you request deny-read permission, but some other path already has read access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions. 

Available in Mac OS X v10.0 and later.
fsWrDenyPerm

Requests that any other paths be prevented from having write access. A path cannot be opened if you request write permission (with the fsWrPerm constant) but some other path has requested deny-write access. Similarly, the path cannot be opened if you request deny-write permission, but some other path already has write access. This constant is used with the PBHOpenDenySync and PBHOpenRFDenySync functions.

Available in Mac OS X v10.0 and later.
Discussion

Use these constants to request a type of access to a file or fork, or to deny a type of access to a file or fork to other paths that may request access.

Note that it is possible, in Mac OS 8 and 9, to open a file residing on read-only media with write access. In Mac OS X, however, you cannot open a file with write access on read-only media; the attempt to open the file fails with a wrPermErr error.*/
enum {
   fsCurPerm = 0x00,
   fsRdPerm = 0x01,
   fsWrPerm = 0x02,
   fsRdWrPerm = 0x03,
   fsRdWrShPerm = 0x04,
   fsRdDenyPerm = 0x10,
   fsWrDenyPerm = 0x20
};

/*Position Mode Constants

Together with an offset, specify a position within a fork.

enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};
Constants
fsAtMark

The starting point is the access path’s current position. The offset is ignored.

Available in Mac OS X v10.0 and later.
fsFromStart

The starting point is offset bytes from the start of the fork. The offset must be non-negative.

Available in Mac OS X v10.0 and later.
fsFromLEOF

The starting point is offset bytes from the logical end of the fork. The offset must not be positive.

Available in Mac OS X v10.0 and later.
fsFromMark

The starting point is offset bytes from the access path’s current position. The offset may be positive or negative.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the ioPosMode and positionMode fields and parameters of the HFS and HFS Plus file access functions. These functions include those for reading from and writing to files or forks, changing the current position within a file or fork, changing the size of a file or fork, and allocating space to a file or fork.

For the FSReadFork and FSWriteFork calls, you may also add either of the pleaseCacheMask or noCacheMask constants to hint whether the data should be cached or not. See Cache Constants.*/
enum {
   fsAtMark = 0,
   fsFromStart = 1,
   fsFromLEOF = 2,
   fsFromMark = 3
};

/*Catalog Information Bitmap Constants

Specify what file or fork information to get or set.

enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};
Constants
kFSCatInfoNone

No catalog information.

Available in Mac OS X v10.0 and later.
kFSCatInfoTextEncoding

Retrieve or set the text encoding hint, in the textEncodingHint field.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeFlags

Retrieve or set the catalog node flags. Currently, you can only set bits 0 and 4. See Catalog Information Node Flags for more information on these flags.

Available in Mac OS X v10.0 and later.
kFSCatInfoVolume

Retrieve the volume reference number of the volume on which the file or directory resides.

Available in Mac OS X v10.0 and later.
kFSCatInfoParentDirID

Retrieve the parent directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoNodeID

Retrieve the file or directory ID.

Available in Mac OS X v10.0 and later.
kFSCatInfoCreateDate

Retrieve or set the creation date.

Available in Mac OS X v10.0 and later.
kFSCatInfoContentMod

Retrieve or set the date that the resource or data fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAttrMod

Retrieve or set the date that an attribute or named fork was last modified.

Available in Mac OS X v10.0 and later.
kFSCatInfoAccessDate

Retrieve or set the date that the fork or file was last accessed.

Available in Mac OS X v10.0 and later.
kFSCatInfoBackupDate

Retrieve or set the date that the fork or file was last backed up.

Available in Mac OS X v10.0 and later.
kFSCatInfoPermissions

Retrieve or set the file or fork’s permissions.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderInfo

Retrieve or set the file or fork’s Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoFinderXInfo

Retrieve or set the file or fork’s extended Finder information.

Available in Mac OS X v10.0 and later.
kFSCatInfoValence

For folders only, retrieve the valence of the folder. For files, this is zero.

Available in Mac OS X v10.0 and later.
kFSCatInfoDataSizes

Retrieve the logical and physical size of the data fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoRsrcSizes

Retrieve the logical and physical size of the resource fork.

Available in Mac OS X v10.0 and later.
kFSCatInfoSharingFlags

Retrieve the fork or file’s sharing flags: kioFlAttribMountedBit, kioFlAttribSharePointBit. See File Attribute Constants for more information on these bits.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserPrivs

Retrieve the file’s user privileges.

Available in Mac OS X v10.0 and later.
kFSCatInfoUserAccess

Available in Mac OS X v10.1 and later.
kFSCatInfoSetOwnership

Attempt to set the file’s user and group (UID and GID). If the File Manager cannot set the the user or group ID, the call fails. (Mac OS X only).

Available in Mac OS X v10.3 and later.
kFSCatInfoAllDates

Retrieve or set all of the date information for the fork or file: creation date, modification dates, access date, backup date, etc.

Available in Mac OS X v10.0 and later.
kFSCatInfoGettableInfo

Retrieve all gettable data.

Available in Mac OS X v10.0 and later.
kFSCatInfoSettableInfo

Set all settable data. This includes the flags, dates, permissions, Finder info, and text encoding hint.

Available in Mac OS X v10.0 and later.
kFSCatInfoReserved

Represents bits that are currently reserved.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the FSCatalogInfoBitmap type to specify what file or fork information to get or set. If used with the FSGetCatalogInfo or FSGetCatalogInfoBulk functions, these constants tell the File Manager which fields to return information in. If used with the FSSetCatalogInfo function, these constants tell the File Manager which fields you’ve filled out with values that it should use to change the fork or file’s catalog information.*/
enum {
   kFSCatInfoNone = 0x00000000,
   kFSCatInfoTextEncoding = 0x00000001,
   kFSCatInfoNodeFlags = 0x00000002,
   kFSCatInfoVolume = 0x00000004,
   kFSCatInfoParentDirID = 0x00000008,
   kFSCatInfoNodeID = 0x00000010,
   kFSCatInfoCreateDate = 0x00000020,
   kFSCatInfoContentMod = 0x00000040,
   kFSCatInfoAttrMod = 0x00000080,
   kFSCatInfoAccessDate = 0x00000100,
   kFSCatInfoBackupDate = 0x00000200,
   kFSCatInfoPermissions = 0x00000400,
   kFSCatInfoFinderInfo = 0x00000800,
   kFSCatInfoFinderXInfo = 0x00001000,
   kFSCatInfoValence = 0x00002000,
   kFSCatInfoDataSizes = 0x00004000,
   kFSCatInfoRsrcSizes = 0x00008000,
   kFSCatInfoSharingFlags = 0x00010000,
   kFSCatInfoUserPrivs = 0x00020000,
   kFSCatInfoUserAccess = 0x00080000,
   kFSCatInfoSetOwnership = 0x00100000,
   kFSCatInfoAllDates = 0x000003E0,
   kFSCatInfoGettableInfo = 0x0003FFFF,
   kFSCatInfoSettableInfo = 0x00001FE3,
   kFSCatInfoReserved = 0xFFFC0000
};


/*FSCatalogInfoBitmap

Describes which fields of the FSCatalogInfo structure you wish to retrieve or set.

typedef UInt32 FSCatalogInfoBitmap;
Discussion

If the bit corresponding to a particular field is not set in the bitmap, then that field is not changed in the FSCatalogInfo structure if it is an output parameter, and that field is ignored if the FSCatalogInfo structure is an input parameter. See Catalog Information Bitmap Constants for a description of the constants you should use with this data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 FSCatalogInfoBitmap;

/*FSVolumeRefNum

Identifies a particular mounted volume.

typedef SInt16 FSVolumeRefNum;
Discussion

This data type is the same as the 16-bit volume refnum previously passed in the ioVRefNum fields of a parameter block; this is simply a new type name for the old data type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 FSVolumeRefNum;


/*FSIterator

Refers to a position within the catalog, used when iterating over files and folders in a directory.

typedef struct OpaqueFSIterator * FSIterator;
Discussion

This data type is like a file reference number because it maintains state internally to the File Manager and must be explicitly opened and closed.

An FSIterator is returned by FSOpenIterator and is passed as input to FSGetCatalogInfoBulk , FSCatalogSearch and FSCloseIterator. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueFSIterator * FSIterator;

/*Iterator Flags

Indicate whether an iterator iterates over subtrees or just the immediate children of the container.

enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;
Constants
kFSIterateFlat

Iterate over the immediate children of the container only. 

Available in Mac OS X v10.0 and later.
kFSIterateSubtree

Iterate over the entire subtree rooted at the container.

Available in Mac OS X v10.0 and later.
kFSIterateDelete

Available in Mac OS X v10.0 and later.
kFSIterateReserved

Available in Mac OS X v10.0 and later.*/
enum {
   kFSIterateFlat = 0,
   kFSIterateSubtree = 1,
   kFSIterateDelete = 2,
   kFSIterateReserved = 0xFFFFFFFC
};
typedef OptionBits FSIteratorFlags;

/*FSVolumeMountProcPtr


typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);

If you name your function MyFSVolumeMountProc, you would declare it like this:

void MyFSVolumeMountProc (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);
Parameters
volumeOp
clientData
err
mountedVolumeRefNum*/

typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);


/*FSVolumeMountUPP


typedef void (*FSVolumeMountProcPtr) (
   FSVolumeOperation volumeOp,
   void * clientData,
   OSStatus err,
   FSVolumeRefNum mountedVolumeRefNum
);

typedef FSVolumeMountProcPtr FSVolumeMountUPP;
Discussion

For more information, see the description of the FSVolumeMountProcPtr callback function.*/
typedef FSVolumeMountProcPtr FSVolumeMountUPP;


/*FSForkIOParam

Defines a parameter block used by low-level HFS Plus fork I/O functions.

struct FSForkIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   void * reserved1;
   SInt16 reserved2;
   SInt16 forkRefNum;
   UInt8 reserved3;
   SInt8 permissions;
   const FSRef * ref;
   Ptr buffer;
   UInt32 requestCount;
   UInt32 actualCount;
   UInt16 positionMode;
   SInt64 positionOffset;
   FSAllocationFlags allocationFlags;
   UInt64 allocationAmount;
   UniCharCount forkNameLength;
   const UniChar * forkName;
   CatPositionRec forkIterator;
   HFSUniStr255 * outForkName;
};
typedef struct FSForkIOParam FSForkIOParam;
typedef FSForkIOParam * FSForkIOParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
reserved1

Reserved.
reserved2

Reserved.
forkRefNum

A reference number for a fork.
reserved3

Reserved.
permissions

The desired type of access to the specified fork.
ref

An FSRef for the file or directory to open. 
buffer

A pointer to a data buffer.
requestCount

The number of bytes requested for the given operation.
actualCount

The actual number of bytes completed by the call.
positionMode

A constant indicating the base location within the file for the start of the operation. See Position Mode Constants for the meaning of the constants you can use in this field.
positionOffset

The offset from the base location specified in the positionMode offset for the start of the operation.
allocationFlags

A set of bit flags used by the FSAllocateFork function to control how space is allocated. See Allocation Flags for a descsription of the defined flags.
allocationAmount

For the FSAllocateFork function, the amount of space, in bytes, to allocate.
forkNameLength

The length of the file or directory name passed in the forkName field, in Unicode characters.
forkName

A pointer to the file or directory’s Unicode name. This field is an input parameter functions which return the file or directory name in the parameter block use the outForkName field.
forkIterator

A fork iterator. 
outForkName

A pointer to the file or directory’s Unicode name this is an output parameter. For functions which require the file or directory name as an input argument, you should pass a pointer to that name in the forkName field and pass the length of the name in the forkNameLength field. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSForkIOParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   void * reserved1;
   SInt16 reserved2;
   SInt16 forkRefNum;
   UInt8 reserved3;
   SInt8 permissions;
   const FSRef * ref;
   Ptr buffer;
   UInt32 requestCount;
   UInt32 actualCount;
   UInt16 positionMode;
   SInt64 positionOffset;
   FSAllocationFlags allocationFlags;
   UInt64 allocationAmount;
   UniCharCount forkNameLength;
   const UniChar * forkName;
   CatPositionRec forkIterator;
   HFSUniStr255 * outForkName;
};
typedef struct FSForkIOParam FSForkIOParam;
typedef FSForkIOParam * FSForkIOParamPtr;


/*DrvQEl

Defines a drive queue element.

struct DrvQEl {
   QElemPtr qLink;
   short qType;
   short dQDrive;
   short dQRefNum;
   short dQFSID;
   unsigned short dQDrvSz;
   unsigned short dQDrvSz2;
};
typedef struct DrvQEl DrvQEl;
typedef DrvQEl * DrvQElPtr;
Fields
qLink

A pointer to the next entry in the drive queue. 
qType

Used to specify the size of the drive. If the value of this field is 0, the number of logical blocks on the drive is contained in the dQDrvSz field alone. If the value of this field is 1, both the dQDrvSz field and the dQDrvSz2 field are used to store the number of blocks; in that case, the dQDrvSz2 field contains the high-order word of this number and dQDrvSz contains the low-order word.
dQDrive

The drive number of the drive.
dQRefNum

The driver reference number of the driver controlling the device on which the volume is mounted.
dQFSID

An identifier for the file system handling the volume in the drive it’s zero for volumes handled by the File Manager and nonzero for volumes handled by other file systems.
dQDrvSz

The number of logical blocks on the drive.
dQDrvSz2

An additional field to handle large drives. This field is only used if the qType field is 1.
Discussion

The File Manager maintains a list of all disk drives connected to the computer. It maintains this list in the drive queue, which is a standard operating system queue. The drive queue is initially created at system startup time. Elements are added to the queue at system startup time or when you call the AddDrive function. The drive queue can support any number of drives, limited only by memory space. Each element in the drive queue contains information about the corresponding drive. 
Availability
Available in Mac OS X v10.0 and later.*/
struct DrvQEl {
   QElemPtr qLink;
   short qType;
   short dQDrive;
   short dQRefNum;
   short dQFSID;
   unsigned short dQDrvSz;
   unsigned short dQDrvSz2;
};
typedef struct DrvQEl DrvQEl;
typedef DrvQEl * DrvQElPtr;

/*VolumeMountInfoHeader

Defines an extended volume mounting information header structure for remote volumes.

struct VolumeMountInfoHeader {
   short length;
   VolumeType media;
   short flags;
};
typedef struct VolumeMountInfoHeader VolumeMountInfoHeader;
typedef VolumeMountInfoHeader * VolumeMountInfoHeaderPtr;
Fields
length

The length of the VolumeMountInfoHeader structure, which is the total length of the structure header described here, plus the variable-length location data which follows the header.
media

The volume type of the remote volume. The AppleShareMediaType represents an AppleShare volume.

If you are adding support for the programmatic m ounting functions to a non-Macintosh file system, you should register a four-character identifier for your volumes with DTS.

flags

The volume mount flags. See Volume Mount Flags.
Discussion

This volume mount info record supercedes the VolMountInfoHeader structure; VolMountInfoHeader is included for compatibility. The VolumeMountInfoHeader record allows access to the volume mount flags by foreign filesystem writers. 

To mount a remote server, fill out an VolumeMountInfoHeader structure using the PBGetVolMountInfo function and then pass this structure to the PBVolumeMount function to mount the volume. 
Availability
Available in Mac OS X v10.0 and later.*/

struct VolumeMountInfoHeader {
   short length;
   VolumeType media;
   short flags;
};
typedef struct VolumeMountInfoHeader VolumeMountInfoHeader;
typedef VolumeMountInfoHeader * VolumeMountInfoHeaderPtr;

/*AFPXVolMountInfo

Defines a volume mounting structure for an AppleShare server, for AppleShare 3.7 and later.

struct AFPXVolMountInfo {
   short length;
   VolumeType media;
   short flags;
   SInt8 nbpInterval;
   SInt8 nbpCount;
   short uamType;
   short zoneNameOffset;
   short serverNameOffset;
   short volNameOffset;
   short userNameOffset;
   short userPasswordOffset;
   short volPasswordOffset;
   short extendedFlags;
   short uamNameOffset;
   short alternateAddressOffset;
   char AFPData[176];
};
typedef struct AFPXVolMountInfo AFPXVolMountInfo;
typedef AFPXVolMountInfo * AFPXVolMountInfoPtr;
Fields
length

The length of the AFPXVolMountInfo structure (that is, the total length of the structure header described here plus the variable-length location data).
media

The volume type of the remote volume. The value AppleShareMediaType (a constant that translates to 'afpm') represents an AppleShare volume. 
flags

Volume mount flags. See Volume Mount Flags for a description of the bits in this field. In order to use the new features of the extended AFP volume mount structure, you must set the volMountExtendedFlagsBit bit.
nbpInterval

The NBP retransmit interval, in units of 8 ticks.
nbpCount

The NBP retransmit count. This field specifies the total number of times a packet should be transmitted, including the first transmission.
uamType

The user authentication method used by the remote volume. AppleShare uses four methods, defined by the constants described in Authentication Method Constants.
zoneNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the AppleShare zone.
serverNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the AppleShare server.
volNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the volume.
userNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the user.
userPasswordOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the user’s password (as a pascal string).
volPasswordOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the volume’s password (as a pascal string). Some versions of the AppleShare software do not pass the information in this field to the server.
extendedFlags

Extended flags. See Extended AFP Volume Mounting Information Flag.
uamNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the user authentication module name (as a pascal string).
alternateAddressOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing IP addresses, specified as a block of tagged data. This block of tagged data begins with a version byte and a count byte, followed by up to 255 tagged addresses. See AFPAlternateAddress.
AFPData

The actual volume mounting information, offsets to which are contained in the preceding fields. To mount an AFP volume, you must fill in the structure with at least the zone name, server name, user name, user password, and volume password. You can lay out the data in any order within this data field, as long as you specify the correct offsets in the offset fields.
Discussion

To mount an AppleShare server, fill out an AFPXVolMountInfo structure using the PBGetVolMountInfo function and then pass this structure to the PBVolumeMount function to mount the volume. 

The extended AFP volume mount information structure requires AppleShare client 3.7 and later. The new fields and flag bits allow you to specify the information needed to support TCP/IP and User Authentication Modules.

Note that, for all fields specifying an offset, if you wish to leave the string field in the AFPData field empty, you must specify an empty string and have the offset in the corresponding offset field point to that empty string. You cannot simply pass 0 as the offset. 
Availability
Available in Mac OS X v10.0 and later.*/

struct AFPXVolMountInfo {
   short length;
   VolumeType media;
   short flags;
   SInt8 nbpInterval;
   SInt8 nbpCount;
   short uamType;
   short zoneNameOffset;
   short serverNameOffset;
   short volNameOffset;
   short userNameOffset;
   short userPasswordOffset;
   short volPasswordOffset;
   short extendedFlags;
   short uamNameOffset;
   short alternateAddressOffset;
   char AFPData[176];
};
typedef struct AFPXVolMountInfo AFPXVolMountInfo;
typedef AFPXVolMountInfo * AFPXVolMountInfoPtr;

/*AFP Tag Type Constants

Specify the type of tagged address information for AppleShare clients.

enum {
   kAFPTagTypeIP = 0x01,
   kAFPTagTypeIPPort = 0x02,
   kAFPTagTypeDDP = 0x03,
   kAFPTagTypeDNS = 0x04
};
Constants
kAFPTagTypeIP

A basic 4 byte IP address, most significant byte first.

Available in Mac OS X v10.0 and later.
kAFPTagTypeIPPort

A 4 byte IP address and a 2 byte port number, most significant byte first.

Available in Mac OS X v10.0 and later.
kAFPTagTypeDDP

Available in Mac OS X v10.0 and later.
kAFPTagTypeDNS

The address is a DNS name in address:port format. The total length of the DNS name is variable up to 254 characters.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used in the fType field of the tagged address structure, AFPTagData, to specify the type of address represented by the structure.*/
enum {
   kAFPTagTypeIP = 0x01,
   kAFPTagTypeIPPort = 0x02,
   kAFPTagTypeDDP = 0x03,
   kAFPTagTypeDNS = 0x04
};

/*AFPVolMountInfo

Defines a volume mounting structure for an AppleShare server.

struct AFPVolMountInfo {
   short length;
   VolumeType media;
   short flags;
   SInt8 nbpInterval;
   SInt8 nbpCount;
   short uamType;
   short zoneNameOffset;
   short serverNameOffset;
   short volNameOffset;
   short userNameOffset;
   short userPasswordOffset;
   short volPasswordOffset;
   char AFPData[144];
};
typedef struct AFPVolMountInfo AFPVolMountInfo;
typedef AFPVolMountInfo * AFPVolMountInfoPtr;
Fields
length

The length of the AFPVolMountInfo structure (that is, the total length of the structure header described here plus the variable-length location data).
media

The volume type of the remote volume. The value AppleShareMediaType (a constant that translates to 'afpm') represents an AppleShare volume. 
flags

If bit 0 is set, no greeting message from the server is displayed.
nbpInterval

The NBP retransmit interval, in units of 8 ticks.
nbpCount

The NBP retransmit count. This field specifies the total number of times a packet should be transmitted, including the first transmission.
uamType

The user authentication method used by the remote volume. AppleShare uses four methods, defined by the constants described in Authentication Method Constants.
zoneNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the AppleShare zone.
serverNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the AppleShare server.
volNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the volume.
userNameOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the name (as a pascal string) of the user.
userPasswordOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the user’s password (as a pascal string).
volPasswordOffset

The offset in bytes from the beginning of the structure to the entry in the AFPData field containing the volume’s password (as a pascal string). Some versions of the AppleShare software do not pass the information in this field to the server.
AFPData

The actual volume mounting information, offsets to which are contained in the preceding six fields. To mount an AFP volume, you must fill in the structure with at least the zone name, server name, user name, user password, and volume password. You can lay out the data in any order within this data field, as long as you specify the correct offsets in the offset fields.
Discussion

The only volumes that currently support the programmatic mounting functions are AppleShare servers, which use a volume mounting structure of type AFPVolMountInfo.

To mount an AppleShare server, fill out an AFPVolMountInfo structure using the PBGetVolMountInfo function and then pass this structure to the PBVolumeMount function to mount the volume. 
Version Notes

AppleShare clients prior to version 3.7 mount volumes over AppleTalk only. For maximum compatibility set the uamType field to 1 for guest login or 3 for login using a password.

To mount volumes using IP addresses and other address formats, use the AFPXVolMountInfo structure.
Availability
Available in Mac OS X v10.0 and later.*/

struct AFPVolMountInfo {
   short length;
   VolumeType media;
   short flags;
   SInt8 nbpInterval;
   SInt8 nbpCount;
   short uamType;
   short zoneNameOffset;
   short serverNameOffset;
   short volNameOffset;
   short userNameOffset;
   short userPasswordOffset;
   short volPasswordOffset;
   char AFPData[144];
};
typedef struct AFPVolMountInfo AFPVolMountInfo;
typedef AFPVolMountInfo * AFPVolMountInfoPtr;

/*FSFileOperationStatusProcPtr

Defines a status callback function for an asynchronous file operation on an FSRef object.

typedef void (*FSFileOperationStatusProcPtr) (
   FSFileOperationRef fileOp,
   const FSRef *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);

If you name your function MyFSFileOperationStatusProc, you would declare it like this:

void MyFSFileOperationStatusProc (
   FSFileOperationRef fileOp,
   const FSRef *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);
Parameters
fileOp

The file operation.
currentItem

A pointer to an FSRef variable. On output, the variable contains the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory).
stage

The current stage of the operation.
error

The current error status of the operation.
statusDictionary

A dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You are not responsible for releasing the dictionary.
info

A pointer to user-defined data associated with this operation.
Discussion

When you call the functions FSCopyObjectAsync or FSMoveObjectAsync, you can specify a status callback function of this type. The function you provide is called by the File Manager whenever the file operation changes stages (including failing due to an error), or as updated information is available limited by the status change interval of the operation. If you need to save any of the status information beyond the scope of the callback, you should make a copy of the information.*/
typedef void (*FSFileOperationStatusProcPtr) (
   FSFileOperationRef fileOp,
   const FSRef *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);

/*FSPathFileOperationStatusProcPtr

Defines a status callback function for an asynchronous file operation on an object specified with a path.

typedef void (*FSPathFileOperationStatusProcPtr) (
   FSFileOperationRef fileOp,
   const char *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);

If you name your function MyFSPathFileOperationStatusProc, you would declare it like this:

void MyFSPathFileOperationStatusProc (
   FSFileOperationRef fileOp,
   const char *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);
Parameters
fileOp

The file operation.
currentItem

The UTF-8 path to the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory).
stage

The current stage of the operation.
error

The current error status of the operation.
statusDictionary

A dictionary with more detailed status information. For infomation about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You are not responsible for releasing the dictionary.
info

A pointer to user-defined data associated with this operation.
Discussion

When you call the functions FSPathCopyObjectAsync or FSPathMoveObjectAsync, you can specify a status callback function of this type. The function you provide is called by the File Manager whenever the file operation changes stages (including failing due to an error), or as updated information is available limited by the status change interval of the operation. If you need to save any of the status information beyond the scope of the callback, you should make a copy of the information.*/

typedef void (*FSPathFileOperationStatusProcPtr) (
   FSFileOperationRef fileOp,
   const char *currentItem,
   FSFileOperationStage stage,
   OSStatus error,
   CFDictionaryRef statusDictionary,
   void *info
);

/*ConstFSSpecPtr

Defines a pointer to an FSSpec structure.

typedef const FSSpec*  ConstFSSpecPtr;
Discussion

The only difference between “const FSSpec*” and the ConstFSSpecPtr data type is that, as a parameter, a ConstFSSpecPtr data type is allowed to be NULL. See FSSpec.
Availability
Available in Mac OS X v10.0 and later.*/
typedef const FSSpec*  ConstFSSpecPtr;

/*FSSpecArrayPtr

Defines a pointer to an array of FSSpec structures.

typedef FSSpecPtr FSSpecArrayPtr;
Discussion

See FSSpec. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef FSSpecPtr FSSpecArrayPtr;

/*FSSearchParams

Describes the search criteria for a catalog information search.

struct FSSearchParams {
   Duration searchTime;
   OptionBits searchBits;
   UniCharCount searchNameLength;
   const UniChar * searchName;
   FSCatalogInfo * searchInfo1;
   FSCatalogInfo * searchInfo2;
};
typedef struct FSSearchParams FSSearchParams;
typedef FSSearchParams * FSSearchParamsPtr;
Fields
searchTime

A Time Manager duration for the duration of the search. If you specify a non-zero value in this field, the search may terminate after the specified time, even if the maximum number of requested objects has not been returned and the entire catalog has not been scanned. 

If this value is negative, the time is interpreted in microseconds; if positive, it is interpreted as milliseconds. If searchTime is zero, there is no time limit on the search.
searchBits

A set of bits specifying which catalog information fields to search on. See Catalog Search Constants for the constants which you can use here.
searchNameLength

The length of the Unicode name to search by.
searchName

A pointer to the Unicode name to search by.
searchInfo1

An FSCatalogInfo structure which specifies the values and lower bounds of a search.
searchInfo2

A FSCatalogInfo structure which specifies the masks and upper bounds of a search.
Discussion

Used by FSCatalogSearch , PBCatalogSearchSync , and PBCatalogSearchAsync to specify the criteria for a catalog search. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FSSearchParams {
   Duration searchTime;
   OptionBits searchBits;
   UniCharCount searchNameLength;
   const UniChar * searchName;
   FSCatalogInfo * searchInfo1;
   FSCatalogInfo * searchInfo2;
};
typedef struct FSSearchParams FSSearchParams;
typedef FSSearchParams * FSSearchParamsPtr;


/*FSCatalogBulkParam

Defines a parameter block used to retrieve catalog information in bulk on HFS Plus volumes.

struct FSCatalogBulkParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   Boolean containerChanged;
   UInt8 reserved;
   FSIteratorFlags iteratorFlags;
   FSIterator iterator;
   const FSRef * container;
   ItemCount maximumItems;
   ItemCount actualItems;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catalogInfo;
   FSRef * refs;
   FSSpec * specs;
   HFSUniStr255 * names;
   const FSSearchParams * searchParams;
};
typedef struct FSCatalogBulkParam FSCatalogBulkParam;
typedef FSCatalogBulkParam * FSCatalogBulkParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
containerChanged

A Boolean value indicating whether or not the container has changed since the last call to PBGetCatalogInfoBulkSync or PBGetCatalogInfoBulkAsync.
reserved

Reserved.
iteratorFlags

A set of flags which specifies how the iterator should iterate over the container. See Iterator Flags for the meaning of the constants used here.
iterator

A catalog iterator. 
container

An FSRef for the directory or volume to iterate over. 
maximumItems

The maximum number of items to return information about.
actualItems

The actual number of items returned.
whichInfo

A bitmap indicating which fields of the catalog information structure to return. See Catalog Information Bitmap Constants for the bits defined for this field.
catalogInfo

A pointer to an array of catalog information structures. On input, you should pass a pointer to an array of maximumItemsFSCatalogInfo structures. On return, actualItems structures will be filled out with the information requested in the whichInfo field. If you do not wish any catalog information to be returned, pass a NULL pointer in this field and pass the constant kFSCatInfoNone in the whichInfo field.
refs

A pointer to an array of FSRef structures. On input, you should pass a pointer to maximumItemsFSRef structures. On return, actualItems structures will be filled out. If you do not wish any FSRef structures to be returned, pass a NULL pointer in this field.
specs

A pointer to an array of FSSpec structures. On input, you should pass a pointer to maximumItems file system specifications. On return, actualItemsFSSpec structures will be filled in. If you do not wish any FSSpec information to be returned, pass a NULL pointer in this field.
names

A pointer to an array of Unicode names. On input, you should pass a pointer to an array of maximumItemsHFSUniStr255 structures. On return, actualItems structures will contain Unicode names. If you do not wish any file or directory names to be returned, pass a NULL pointer in this field. 
searchParams

A pointer to an FSSearchParams structure, specifying the values to match against.
Availability
Available in Mac OS X v10.0 and later.*/
struct FSCatalogBulkParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   Boolean containerChanged;
   UInt8 reserved;
   FSIteratorFlags iteratorFlags;
   FSIterator iterator;
   const FSRef * container;
   ItemCount maximumItems;
   ItemCount actualItems;
   FSCatalogInfoBitmap whichInfo;
   FSCatalogInfo * catalogInfo;
   FSRef * refs;
   FSSpec * specs;
   HFSUniStr255 * names;
   const FSSearchParams * searchParams;
};
typedef struct FSCatalogBulkParam FSCatalogBulkParam;
typedef FSCatalogBulkParam * FSCatalogBulkParamPtr;

/*FCBPBRec

Defines a file control block (FCB) parameter block used by the functions PBGetFCBInfoSync and PBGetFCBInfoAsync.

struct FCBPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   short filler;
   short ioFCBIndx;
   short filler1;
   long ioFCBFlNm;
   short ioFCBFlags;
   unsigned short ioFCBStBlk;
   long ioFCBEOF;
   long ioFCBPLen;
   long ioFCBCrPs;
   short ioFCBVRefNum;
   long ioFCBClpSiz;
   long ioFCBParID;
};
typedef struct FCBPBRec FCBPBRec;
typedef FCBPBRec * FCBPBPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioRefNum

The file reference number of an open file.
filler

Reserved.
ioFCBIndx

An index for use with the PBGetFCBInfoSync and PBGetFCBInfoAsync functions.
filler1

Reserved.
ioFCBFlNm

The file ID.
ioFCBFlags

Flags describing the status of the file. See FCB Flags for the meanings of the bits in this field.
ioFCBStBlk

The number of the first allocation block of the file.
ioFCBEOF

The logical length (logical end-of-file) of the file.
ioFCBPLen

The physical length (physical end-of-file) of the file.
ioFCBCrPs

The current position of the file mark.
ioFCBVRefNum

The volume reference number.
ioFCBClpSiz

The file clump size.
ioFCBParID

The file’s parent directory ID.
Discussion

The low-level HFS function PBGetFCBInfo uses the file control block parameter block defined by the FCBPBRec data type. 
Availability
Available in Mac OS X v10.0 and later.*/

struct FCBPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioRefNum;
   short filler;
   short ioFCBIndx;
   short filler1;
   long ioFCBFlNm;
   short ioFCBFlags;
   unsigned short ioFCBStBlk;
   long ioFCBEOF;
   long ioFCBPLen;
   long ioFCBCrPs;
   short ioFCBVRefNum;
   long ioFCBClpSiz;
   long ioFCBParID;
};
typedef struct FCBPBRec FCBPBRec;
typedef FCBPBRec * FCBPBPtr;

/*VCB

Defines a volume control block.

struct VCB {
   QElemPtr qLink;
   short qType;
   short vcbFlags;
   unsigned short vcbSigWord;
   unsigned long vcbCrDate;
   unsigned long vcbLsMod;
   short vcbAtrb;
   unsigned short vcbNmFls;
   short vcbVBMSt;
   short vcbAllocPtr;
   unsigned short vcbNmAlBlks;
   long vcbAlBlkSiz;
   long vcbClpSiz;
   short vcbAlBlSt;
   long vcbNxtCNID;
   unsigned short vcbFreeBks;
   Str27 vcbVN;
   short vcbDrvNum;
   short vcbDRefNum;
   short vcbFSID;
   short vcbVRefNum;
   Ptr vcbMAdr;
   Ptr vcbBufAdr;
   short vcbMLen;
   short vcbDirIndex;
   short vcbDirBlk;
   unsigned long vcbVolBkUp;
   unsigned short vcbVSeqNum;
   long vcbWrCnt;
   long vcbXTClpSiz;
   long vcbCTClpSiz;
   unsigned short vcbNmRtDirs;
   long vcbFilCnt;
   long vcbDirCnt;
   long vcbFndrInfo[8];
   unsigned short vcbVCSize;
   unsigned short vcbVBMCSiz;
   unsigned short vcbCtlCSiz;
   unsigned short vcbXTAlBlks;
   unsigned short vcbCTAlBlks;
   short vcbXTRef;
   short vcbCTRef;
   Ptr vcbCtlBuf;
   long vcbDirIDM;
   short vcbOffsM;
};
typedef struct VCB VCB;
typedef VCB * VCBPtr;
Fields
qLink

A pointer to the next entry in the VCB queue. 
qType

The queue type. When the volume is mounted and the VCB is created, this field is cleared. Thereafter, bit 7 of this field is set whenever a file on that volume is opened.
vcbFlags

Volume flags. Bit 15 is set if the volume information has been changed by a File Manager call since the volume was last flushed by a FlushVol call. See Volume Control Block Flags.
vcbSigWord

The volume signature.
vcbCrDate

The date and time of the volume’s creation (initialization).
vcbLsMod

The date and time of the volume’s last modification. This is not necessarily when the volume was last flushed.
vcbAtrb

The volume attributes.
vcbNmFls

The number of files in the root directory of the volume.
vcbVBMSt

The first block of the volume bitmap.
vcbAllocPtr

The start block of the next allocation search. This field is used internally.
vcbNmAlBlks

The number of allocation blocks in the volume.
vcbAlBlkSiz

The allocation block size, in bytes. This value must always be a multiple of 512 bytes.
vcbClpSiz

The default clump size.
vcbAlBlSt

The first allocation block in the volume.
vcbNxtCNID

The next unused catalog node ID (directory or file ID).
vcbFreeBks

The number of unused allocation blocks on the volume.
vcbVN

The volume name. Note that a volume name can occupy at most 27 characters; this is an exception to the normal file and directory name limit of 31 characters.
vcbDrvNum

The drive number of the drive on which the volume is located. When a mounted drive is placed offline or ejected, this field is set to 0.
vcbDRefNum

The driver reference number of the driver used to access the volume When a volume is ejected, this field is set to the previous value of the vcbDrvNum field (and hence is a positive number). When a volume is placed offline, this field is set to the negative of the previous value of the vcDrvNum field (and hence is a negative number).
vcbFSID

An identifier for the file system handling the volume it’s zero for volumes handled by the File Manager and nonzero for volumes handled by other file systems.
vcbVRefNum

The volume reference number of the volume.
vcbMAdr

Used internally.
vcbBufAdr

Used internally.
vcbMLen

Used internally.
vcbDirIndex

Used internally.
vcbDirBlk

Used internally.
vcbVolBkUp

The date and time that the volume was last backed up.
vcbVSeqNum

Used internally.
vcbWrCnt

The volume write count.
vcbXTClpSiz

The clump size of the extents overflow file.
vcbCTClpSiz

The clump size of the catalog file.
vcbNmRtDirs

The number of directories in the root directory.
vcbFilCnt

The total number of files on the volume.
vcbDirCnt

The total number of directories on the volume.
vcbFndrInfo

Finder information.
vcbVCSize

Used internally.
vcbVBMCSiz

Used internally.
vcbCtlCSiz

Used internally.
vcbXTAlBlks

The size, in allocation blocks, of the extents overflow file.
vcbCTAlBlks

The size, in allocation blocks, of the catalog file.
vcbXTRef

The path reference number for the extents overflow file.
vcbCTRef

The path reference number for the catalog file.
vcbCtlBuf

A pointer to the extents and catalog caches.
vcbDirIDM

The directory last searched.
vcbOffsM

The offspring index at the last search.
Discussion

The volume control block queue is a standard operating system queue that’s maintained in the system heap. It contains a volume control block for each mounted volume. A volume control block is a nonrelocatable block that contains volume-specific information.

Each time a volume is mounted, the File Manager reads its volume information from the master directory block and uses the information to build a new volume control block (VCB) in the volume control block queue (unless an ejected or offline volume is being remounted). The File Manager also creates a volume buffer in the system heap. When a volume is placed offline, its buffer is released. When a volume is unmounted, its VCB is removed from the VCB queue as well. 
Availability
Available in Mac OS X v10.0 and later.*/
struct VCB {
   QElemPtr qLink;
   short qType;
   short vcbFlags;
   unsigned short vcbSigWord;
   unsigned long vcbCrDate;
   unsigned long vcbLsMod;
   short vcbAtrb;
   unsigned short vcbNmFls;
   short vcbVBMSt;
   short vcbAllocPtr;
   unsigned short vcbNmAlBlks;
   long vcbAlBlkSiz;
   long vcbClpSiz;
   short vcbAlBlSt;
   long vcbNxtCNID;
   unsigned short vcbFreeBks;
   Str27 vcbVN;
   short vcbDrvNum;
   short vcbDRefNum;
   short vcbFSID;
   short vcbVRefNum;
   Ptr vcbMAdr;
   Ptr vcbBufAdr;
   short vcbMLen;
   short vcbDirIndex;
   short vcbDirBlk;
   unsigned long vcbVolBkUp;
   unsigned short vcbVSeqNum;
   long vcbWrCnt;
   long vcbXTClpSiz;
   long vcbCTClpSiz;
   unsigned short vcbNmRtDirs;
   long vcbFilCnt;
   long vcbDirCnt;
   long vcbFndrInfo[8];
   unsigned short vcbVCSize;
   unsigned short vcbVBMCSiz;
   unsigned short vcbCtlCSiz;
   unsigned short vcbXTAlBlks;
   unsigned short vcbCTAlBlks;
   short vcbXTRef;
   short vcbCTRef;
   Ptr vcbCtlBuf;
   long vcbDirIDM;
   short vcbOffsM;
};
typedef struct VCB VCB;
typedef VCB * VCBPtr;

/*ConstHFSUniStr255Param

Defines a pointer to an HFSUniStr255 structure.

typedef const HFSUniStr255*  ConstHFSUniStr255Param;
Discussion

See HFSUniStr255. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef const HFSUniStr255*  ConstHFSUniStr255Param;

/*DTPBRec

Defines the desktop database parameter block used by the desktop database functions.

struct DTPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDTRefNum;
   short ioIndex;
   long ioTagInfo;
   Ptr ioDTBuffer;
   long ioDTReqCount;
   long ioDTActCount;
   SInt8 ioFiller1;
   UInt8 ioIconType;
   short ioFiller2;
   long ioDirID;
   OSType ioFileCreator;
   OSType ioFileType;
   long ioFiller3;
   long ioDTLgLen;
   long ioDTPyLen;
   short ioFiller4[14];
   long ioAPPLParID;
};
typedef struct DTPBRec DTPBRec;
typedef DTPBRec * DTPBPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a file, directory, or volume name. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

The volume reference number.
ioDTRefNum

The desktop database reference number.
ioIndex

The index into icon list.
ioTagInfo

The tag information.
ioDTBuffer

The data buffer.
ioDTReqCount

The requested length of data.
ioDTActCount

The actual length of data.
ioFiller1

Unused.
ioIconType

The icon type.
ioFiller2

Unused.
ioDirID

The parent directory ID.
ioFileCreator

The file creator.
ioFileType

The file type.
ioFiller3

Unused.
ioDTLgLen

The logical length of the desktop database.
ioDTPyLen

The physical length of the desktop database.
ioFiller4

Unused.
ioAPPLParID

The parent directory ID of an application.
Availability
Available in Mac OS X v10.0 and later.*/
struct DTPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short ioDTRefNum;
   short ioIndex;
   long ioTagInfo;
   Ptr ioDTBuffer;
   long ioDTReqCount;
   long ioDTActCount;
   SInt8 ioFiller1;
   UInt8 ioIconType;
   short ioFiller2;
   long ioDirID;
   OSType ioFileCreator;
   OSType ioFileType;
   long ioFiller3;
   long ioDTLgLen;
   long ioDTPyLen;
   short ioFiller4[14];
   long ioAPPLParID;
};
typedef struct DTPBRec DTPBRec;
typedef DTPBRec * DTPBPtr;

/*CMovePBRec

Defines a parameter block, used with the functions PBCatMoveSync and PBCatMoveAsync.

struct CMovePBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler1;
   StringPtr ioNewName;
   long filler2;
   long ioNewDirID;
   long filler3[2];
   long ioDirID;
};
typedef struct CMovePBRec CMovePBRec;
typedef CMovePBRec * CMovePBPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type (This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler1

Reserved.
ioNewName

The name of the directory into which the specified file or directory is to be moved.
filler2

Reserved.
ioNewDirID

The directory ID of the directory into which the specified file or directory is to be moved.
filler3

Reserved.
ioDirID

The current directory ID of the file or directory to be moved (used in conjunction with the ioVRefNum and ioNamePtr fields).
Discussion

The low-level HFS function PBCatMove uses the catalog move parameter block defined by the CMovePBRec data type. 
Availability
Available in Mac OS X v10.0 and later.*/

struct CMovePBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   long filler1;
   StringPtr ioNewName;
   long filler2;
   long ioNewDirID;
   long filler3[2];
   long ioDirID;
};
typedef struct CMovePBRec CMovePBRec;
typedef CMovePBRec * CMovePBPtr;

/*WDPBRec

Defines a working directory parameter block.

struct WDPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler1;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler2[7];
   long ioWDDirID;
};
typedef struct WDPBRec WDPBRec;
typedef WDPBRec * WDPBPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
filler1

Reserved.
ioWDIndex

An index.
ioWDProcID

An identifier that’s used to distinguish between working directories set up by different users you should set ioWDProcID to your application’s signature.
ioWDVRefNum

The working directory’s volume reference number.
filler2

Reserved.
ioWDDirID

The working directory’s directory ID.
Availability
Available in Mac OS X v10.0 and later.*/
struct WDPBRec {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   short filler1;
   short ioWDIndex;
   long ioWDProcID;
   short ioWDVRefNum;
   short filler2[7];
   long ioWDDirID;
};
typedef struct WDPBRec WDPBRec;
typedef WDPBRec * WDPBPtr;

/*XVolumeParam

Defines an extended volume information parameter block.

struct XVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   unsigned long ioXVersion;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
   UInt64 ioVTotalBytes;
   UInt64 ioVFreeBytes;
};
typedef struct XVolumeParam XVolumeParam;
typedef XVolumeParam * XVolumeParamPtr;
Fields
qLink

A pointer to the next entry in the file I/O queue. (This field is used internally by the File Manager to keep track of asynchronous calls awaiting execution. 
qType

The queue type. This field is used internally by the File Manager.
ioTrap

The trap number of the function that was called. This field is used internally by the File Manager.
ioCmdAddr

The address of the function that was called. This field is used internally by the File Manager.
ioCompletion

A universal procedure pointer to a completion routine to be executed at the end of an asynchronous call. It should be 0 for asynchronous calls with no completion routine and is automatically set to 0 for all synchronous calls. See IOCompletionProcPtr for information about completion routines.
ioResult

The result code of the function. For synchronous calls, this field is the same as the result code of the function call itself. To determine when an asynchronous call has actually been completed, your application can poll this field it’s set to a positive number when the call is made and receives the actual result code when the call is completed.
ioNamePtr

A pointer to a pathname. Whenever a function description specifies that ioNamePtr is used—whether for input, output, or both—it’s very important that you set this field to point to storage for a Str255 value (if you’re using a pathname) or to NULL (if you’re not).
ioVRefNum

A volume reference number, 0 for the default volume, or a drive number.
ioXVersion

The version of the XVolumeParam parameter block; currently, this is 0.
ioVolIndex

A volume index for use with the PBXGetVolInfoSync and PBXGetVolInfoAsync functions.
ioVCrDate

The date and time that the volume was created (initialized).
ioVLsMod

The date and time that the volume information was last modified. This field is not changed when information is written to a file and does not necessarily indicate when the volume was flushed.
ioVAtrb

The volume attributes. See Volume Information Attribute Constants for the meanings of the bits in this field.
ioVNmFls

The number of files in the root directory.
ioVBitMap

The first block of the volume bitmap.
ioAllocPtr

The block at which the next new file starts. Used internally.
ioVNmAlBlks

The number of allocation blocks.
ioVAlBlkSiz

The size of the allocation blocks.
ioVClpSiz

The clump size.
ioAlBlSt

The first block in the volume map.
ioVNxtCNID

The next unused catalog node ID.
ioVFrBlk

The number of unused allocation blocks.
ioVSigWord

A signature word identifying the type of volume it’s $D2D7 for MFS volumes and $4244 for volumes that support HFS calls.
ioVDrvInfo

The drive number of the drive containing the volume.
ioVDRefNum

For online volumes, the reference number of the I/O driver for the drive identified by the ioVDrvInfo field.
ioVFSID

The file-system identifier. It indicates which file system is servicing the volume it’s zero for File Manager volumes and nonzero for volumes handled by an external file system.
ioVBkUp

The date and time that the volume was last backed up; this is 0 if the volume has never been backed up.
ioVSeqNum

Used internally.
ioVWrCnt

The volume write count.
ioVFilCnt

The total number of files on the volume.
ioVDirCnt

The total number of directories (not including the root directory) on the volume.
ioVFndrInfo

Information used by the Finder.
ioVTotalBytes

The total number of bytes on the volume.
ioVFreeBytes

The number of free bytes on the volume.
Discussion

The functions PBXGetVolInfoSync and PBXGetVolInfoAsync use this parameter block structure to pass arguments and return values. 
Availability
Available in Mac OS X v10.0 and later.*/
struct XVolumeParam {
   QElemPtr qLink;
   short qType;
   short ioTrap;
   Ptr ioCmdAddr;
   IOCompletionUPP ioCompletion;
   volatile OSErr ioResult;
   StringPtr ioNamePtr;
   short ioVRefNum;
   unsigned long ioXVersion;
   short ioVolIndex;
   unsigned long ioVCrDate;
   unsigned long ioVLsMod;
   short ioVAtrb;
   unsigned short ioVNmFls;
   unsigned short ioVBitMap;
   unsigned short ioAllocPtr;
   unsigned short ioVNmAlBlks;
   unsigned long ioVAlBlkSiz;
   unsigned long ioVClpSiz;
   unsigned short ioAlBlSt;
   unsigned long ioVNxtCNID;
   unsigned short ioVFrBlk;
   unsigned short ioVSigWord;
   short ioVDrvInfo;
   short ioVDRefNum;
   short ioVFSID;
   unsigned long ioVBkUp;
   short ioVSeqNum;
   unsigned long ioVWrCnt;
   unsigned long ioVFilCnt;
   unsigned long ioVDirCnt;
   long ioVFndrInfo[8];
   UInt64 ioVTotalBytes;
   UInt64 ioVFreeBytes;
};
typedef struct XVolumeParam XVolumeParam;
typedef XVolumeParam * XVolumeParamPtr;

/*FSForkInfo

Contains information about an open fork.

struct FSForkInfo {
   SInt8 flags;
   SInt8 permissions;
   FSVolumeRefNum volume;
   UInt32 reserved2;
   UInt32 nodeID;
   UInt32 forkID;
   UInt64 currentPosition;
   UInt64 logicalEOF;
   UInt64 physicalEOF;
   UInt64 process;
};
typedef struct FSForkInfo FSForkInfo;
typedef FSForkInfo * FSForkInfoPtr;
Fields
flags

Flags describing the status of the fork. See FCB Flags for a description of the bits in this field.
permissions

User and group permission information.
volume

A volume specification. This can be a volume reference number, drive number, or 0 for the default volume. 
reserved2

Reserved.
nodeID

The file or directory ID of the file or directory with which the fork is associated.
forkID

The fork ID.
currentPosition

The current position within the fork.
logicalEOF

The logical size of the fork.
physicalEOF

The physical size of the fork.
process

The process which opened the fork.
Discussion

This data type is used in the forkInfo parameter of the FSGetForkCBInfo function, and in the forkInfo field of the FSForkCBInfoParam parameter block passed to the PBGetForkCBInfoSync and PBGetForkCBInfoAsync functions. When these functions return, the FSForkInfo structure contains information about the specified open fork. 
Availability
Available in Mac OS X v10.0 and later.*/
struct FSForkInfo {
   SInt8 flags;
   SInt8 permissions;
   FSVolumeRefNum volume;
   UInt32 reserved2;
   UInt32 nodeID;
   UInt32 forkID;
   UInt64 currentPosition;
   UInt64 logicalEOF;
   UInt64 physicalEOF;
   UInt64 process;
};
typedef struct FSForkInfo FSForkInfo;
typedef FSForkInfo * FSForkInfoPtr;


//function


/*FSOpenIterator

Creates a catalog iterator that can be used to iterate over the contents of a directory or volume.

OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);
Parameters
container

A pointer to an FSRef for the directory to iterate. The set of items to iterate over can either be the objects directly contained in the directory, or all items directly or indirectly contained in the directory (in which case, the specified directory is the root of the subtree to iterate). See FSRef for a description of the FSRef data type.
iteratorFlags

A set of flags which controls whether the iterator iterates over subtrees or just the immediate children of the container. See Iterator Flags for a description of the flags defined for this parameter.

Iteration over subtrees which do not originate at the root directory of a volume are not currently supported, and passing the kFSIterateSubtree flag in this parameter returns errFSBadIteratorFlags. To determine whether subtree iterators are supported, check that the bSupportsSubtreeIterators bit returned by PBHGetVolParmsSync or PBHGetVolParmsAsync is set.
iterator

On return, a pointer to the new FSIterator. You can pass this iterator to the FSGetCatalogInfoBulk or FSCatalogSearch functions and their parameter block-based counterparts.

The iterator is automatically initialized so that the next use of the iterator returns the first item. The order that items are returned in is volume format dependent and may be different for two different iterators created with the same container and flags.

See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Catalog iterators must be closed when you are done using them, whether or not you have iterated over all the items. Iterators are automatically closed upon process termination, just like open files. However, you should use the FSCloseIterator function, or one of the related parameter block functions, PBCloseIteratorSync and PBCloseIteratorAsync , to close an iterator to free up any system resources allocated to the iterator.

Before calling this function, you should check that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenIterator (
   const FSRef * container,
   FSIteratorFlags iteratorFlags,
   FSIterator * iterator
);

/*FSGetCatalogInfoBulk

Returns information about one or more objects from a catalog iterator. This function can return information about multiple objects in a single call.

OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);
Parameters
iterator

The iterator to use. You can obtain a catalog iterator with the function FSOpenIterator, or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, the iterator must be created with the kFSIterateFlat option. See FSIterator for a description of the FSIterator data type.
maximumObjects

The maximum number of items to return for this call. 
actualObjects

On return, a pointer to the actual number of items found for this call.
containerChanged

On return, a pointer to a value indicating whether or not the container’s contents have changed since the previous FSGetCatalogInfoBulk call. If true, the contents have changed. Objects may still be returned, even though the container has changed. If so, note that if the container has changed, then the total set of items returned may be incorrect: some items may be returned multiple times, and some items may not be returned at all.

This parameter is optional if you don’t want this information returned, pass a NULL pointer. 

On versions of Mac OS X prior to 10.2, this parameter is unset. On Mac OS X version 10.2, this parameter is always set to false. To find out whether the container has changed since the last call to FSGetCatalogInfoBulk, check the modification date of the container.
whichInfo

A bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this parameter. For a description of the bits in this parameter, see Catalog Information Bitmap Constants.
catalogInfos

A pointer to an array of catalog information structures; one for each returned item. On input, the catalogInfos parameter should point to an array of maximumObjects catalog information structures.

This parameter is optional; if you do not wish any catalog information returned, pass NULL here.

refs

A pointer to an array of FSRef structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSRef structures. 

This parameter is optional; if you do not wish any FSRef structures returned, pass NULL here.
specs

A pointer to an array of FSSpec structures; one for each returned item. On input, this parameter should to point to an array of maximumObjectsFSSpec structures. 

This parameter is optional; if you do not wish any FSSpec structures returned, pass NULL here.
names

A pointer to an array of names; one for each returned item. If you want the Unicode name for each item found, set this parameter to point to an array of maximumObjectsHFSUniStr255 structures. Otherwise, set it to NULL. 
Return Value

A result code. See “File Manager Result Codes”. When all of the iterator’s objects have been returned, the call will return errFSNoMoreItems.
Discussion

The FSGetCatalogInfoBulk call may complete and return noErr with fewer than maximumObjects items returned. This may be due to various reasons related to the internal implementation. In this case, you may continue to make FSGetCatalogInfoBulk calls using the same iterator.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfoBulk (
   FSIterator iterator,
   ItemCount maximumObjects,
   ItemCount * actualObjects,
   Boolean * containerChanged,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfos,
   FSRef * refs,
   FSSpec * specs,
   HFSUniStr255 * names
);

/*FSMakeFSRefUnicode

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
parentRef

A pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type.
nameLength

The length of the file or directory name. 
name

A pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to FSMakeFSRefUnicode. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, if the function returns a result of noErr, a pointer to the new FSRef.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMakeFSRefUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);

/*FSCloseIterator

Closes a catalog iterator. 

OSErr FSCloseIterator (
   FSIterator iterator
);
Parameters
iterator

The catalog iterator to be closed. FSCloseIterator releases memory and other system resources used by the iterator, making the iterator invalid. See FSIterator for a description of the FSIterator data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function releases memory and other system resources used by the iterator. The iterator becomes invalid. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseIterator (
   FSIterator iterator
);

/*FSCloseFork

Closes an open fork.

OSErr FSCloseFork (
   SInt16 forkRefNum
);
Parameters
forkRefNum

The reference number of the fork to close. After the call to this function, the reference number in this parameter is invalid. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSCloseFork function causes all data written to the fork to be written to disk, in the same manner as the FSFlushFork function, before it closes the fork. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCloseFork (
   SInt16 forkRefNum
);

/*FSReadFork

Reads data from an open fork.

OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. 

If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.

See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read.

positionOffset

The offset from the base location for the start of the read. 
requestCount

The number of bytes to read. 
buffer

A pointer to the buffer where the data will be returned. 
actualCount

On return, a pointer to the number of bytes actually read. The value pointed to by the actualCount parameter should be equal to the value in the requestCount parameter unless there was an error during the read operation.

This parameter is optional; if you don’t want this information returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned.
Discussion

FSReadFork reads data starting at the position specified by the positionMode and positionOffset parameters. The function reads up to requestCount bytes into the buffer pointed to by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode parameter and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSReadFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   void * buffer,
   ByteCount * actualCount
);

/*FSOpenFork

Opens any fork of a file or directory for streaming access.

OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);
Parameters
ref

A pointer to an FSRef specifying the file or directory owning the fork to open. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the fork name in Unicode characters. 
forkName

A pointer to the Unicode name of the fork to open. You can obtain the string constants for the data fork and resource fork names using the FSGetDataForkName and FSGetResourceForkName functions. All volume formats should support data and resource forks; other named forks may be supported by some volume formats. 
permissions

A constant indicating the type of access which you wish to have to the fork via the returned fork reference. This parameter is the same as the permission parameter passed to the FSpOpenDF and FSpOpenRF functions. For a description of the types of access which you can request, see File Access Permission Constants. 
forkRefNum

On return, a pointer to the fork reference number for accessing the open fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSOpenFork will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

When you use this function to open a file on a local volume and pass in a permissions value of fsCurPerm, fsWrPerm, or fsRdWrPerm , Mac OS X does not guarantee exclusive file access. Before making any assumptions about the underlying file access, you should always check to see whether the Supports Exclusive Locks feature is available. If this feature is not available, your application cannot know whether another application has access to the same file. For more information, see ADC Technical Note TN2037. 

To access named forks or forks larger than 2GB, you must use the FSOpenFork function or one of the corresponding parameter block calls: PBOpenForkSync and PBOpenForkAsync. To determine if the FSOpenFork function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSOpenFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName,
   SInt8 permissions,
   SInt16 * forkRefNum
);

/*FSGetCatalogInfo

Returns catalog information about a file or directory. You can use this function to map an FSRef to an FSSpec.

OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory for which to retrieve information. See FSRef for a description of the FSRef data type. 
whichInfo

A bitmap specifying the catalog information fields to return. If you don’t want any catalog information, set whichInfo to the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits in this parameter.
catalogInfo

On return, a pointer to a catalog information structure containing the information about the file or directory. Only the information specified in the whichInfo parameter is returned. If you don’t want any catalog information, pass NULL here. See FSCatalogInfo for a description of the FSCatalogInfo data type.
outName

On return, a pointer to the Unicode name of the file or directory is returned here. This parameter is optional; if you do not wish the name returned, pass NULL here. See HFSUniStr255 for a description of the HFSUniStr255 data type.
fsSpec

On return, a pointer to the FSSpec for the file or directory. This parameter is optional; if you do not wish the FSSpec returned, pass NULL here. See FSSpec for a description of the FSSpec data type.
parentRef

On return, a pointer to the FSRef for the object's parent directory. This parameter is optional; if you do not wish the parent directory returned, pass NULL here.

If the object specified in the ref parameter is a volume’s root directory, then the FSRef returned here will not be a valid FSRef, since the root directory has no parent object.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   FSCatalogInfo * catalogInfo,
   HFSUniStr255 * outName,
   FSSpec * fsSpec,
   FSRef * parentRef
);

/*FSPathMakeRef

Converts a path into an FSRef structure.

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);
Parameters
path

The path for which to return an FSRef. This path can be used by POSIX-style calls. 
ref

On return, a pointer to the FSRef. 
isDirectory

A Boolean value indicating whether the object at specified by the given path is a directory. This parameter is optional and can be NULL. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSStatus FSPathMakeRef (
   const UInt8 * path,
   FSRef * ref,
   Boolean * isDirectory
);

/*FSGetVolumeInfo

Returns information about a volume.

OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);
Parameters
volume

If you wish to obtain information on a particular volume, pass that volume’s reference number here. If you wish to index through the list of mounted volumes, pass the constant kFSInvalidVolumeRefNum in this parameter. See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
volumeIndex

The index of the desired volume, or 0 to use the volume reference number in the volume parameter. 
actualVolume

On return, a pointer to the volume reference number of the volume. This is useful when indexing over all mounted volumes. If you don’t want this information (if, for instance, you supplied a particular volume reference number in the volume) parameter, set actualVolume to NULL.
whichInfo

A bitmap specifying which volume information fields to get and return in the info parameter. If you don’t want information about the volume returned in the info parameter, set whichInfo to kFSVolInfoNone. See Volume Information Bitmap Constants for a description of the bits in this parameter.
info

On return, a pointer to the volume information. If you don’t want this output, set this parameter to NULL. See FSVolumeInfo for a description of the FSVolumeInfo data type.
volumeName

On return, a pointer to the Unicode name of the volume. If you do not wish the name returned, pass NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
rootDirectory

On return, a pointer to the FSRef for the volume’s root directory. If you do not wish the root directory returned, pass NULL. See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You can specify a particular volume or index through the list of mounted volumes. To get information on a particular volume, pass the volume reference number of the desired volume in the volume parameter and set the volumeIndex parameter to zero. To index through the list of mounted volumes, pass kFSInvalidVolumeRefNum in the volume parameter and set volumeIndex to the index, starting at 1 with the first call to FSGetVolumeInfo.

When indexing through the list of mounted volumes, you may encounter an error with a particular volume. The terminating error code for full traversal of this list is nsvErr. In order to completely traverse the entire list, you may have to bump the index count when encountering other errors (for example, ioErr).

To get information about the root directory of a volume, use the FSGetCatalogInfo function, or one of the corresponding parameter block calls, PBGetCatalogInfoSync and PBGetCatalogInfoAsync. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to FSGetVolumeInfo returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.*/
OSErr FSGetVolumeInfo (
   FSVolumeRefNum volume,
   ItemCount volumeIndex,
   FSVolumeRefNum * actualVolume,
   FSVolumeInfoBitmap whichInfo,
   FSVolumeInfo * info,
   HFSUniStr255 * volumeName,
   FSRef * rootDirectory
);

/*PBHGetVolParmsSync

Returns information about the characteristics of a volume.

OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the volume’s name. You can use a either a name or a volume specification to specify the volume. If you use a volume specification to specify the volume, you should set the ioNamePtr field to NULL. 
ioVRefNum 

On input, a volume specification. You can use a either a name or a volume specification to specify the volume. A volume specification can be a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a GetVolParmsInfoBuffer record; you must allocate this memory to hold the returned attributes. On return, the PBHGetVolParmsSync function places the attributes information in the bufferVolumes that implement the HFS Plus APIs must use version 3 (or newer) of the GetVolParmsInfoBuffer structure. If the version of the GetVolParmsInfoBuffer is 2 or less, or the bSupportsHFSPlusAPIs bit is clear, then the volume does not implement the HFS Plus APIs and they are being emulated for that volume by the File Manager. 
ioReqCount 

On input, the size, in bytes, of the buffer area pointed to in the ioBuffer field. 
ioActCount 

On output, the size of the data actually returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHGetVolParmsSync (
   HParmBlkPtr paramBlock
);

/*FSMakeFSSpec

Creates an FSSpec structure describing a file or directory. (Deprecated in Mac OS X v10.4. Use FSMakeFSRefUnicode instead.)

OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);
Parameters
vRefNum

A volume specification for the volume containing the file or directory. This parameter can contain a volume reference number, a drive number, or 0 to specify the default volume. 
dirID

The parent directory ID of the target object. If the directory is sufficiently specified in the fileName parameter, the dirID parameter can be set to 0. If the fileName parameter contains an empty string, FSMakeFSSpec creates an FSSpec structure for the directory specified by the dirID parameter. 
fileName

A full or partial pathname. If the fileName parameter specifies a full pathname, FSMakeFSSpec ignores both the vRefNum and dirID parameters. A partial pathname might identify only the final target, or it might include one or more parent directory names. If fileName specifies a partial pathname, then vRefNum, dirID, or both must be valid. 
spec

A pointer to a file system specification to be filled in by FSMakeFSSpec. The FSMakeFSSpec function fills in the fields of the file system specification using the information contained in the other three parameters. If your application receives any result code other than noErr or fnfErr, all fields of the resulting FSSpec structure are set to 0. 

The file system specification structure that you pass in this parameter should not share storage space with the input pathname; the name field may be initialized to the empty string before the pathname has been processed. For example, fileName should not refer to the name field of the output file system specification.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

You should call FSMakeFSSpec, or one of the corresponding parameter block functions, PBMakeFSSpecSync and PBMakeFSSpecAsync , whenever you want to create an FSSpec structure. You should not create an FSSpec by filling in the fields of the structure yourself.

If the specified volume is mounted and the specified parent directory exists, but the target file or directory doesn’t exist in that location, FSMakeFSSpec fills in the structure and then returns fnfErr instead of noErr. The structure is valid, but it describes a target that doesn’t exist. You can use the structure for other operations, such as creating a file with the FSpCreate function. 
Carbon Porting Notes

Non-Carbon applications can also specify a working directory reference number in the vRefNum parameter. However, because working directories are not supported in Carbon, you cannot specify a working directory reference number if you wish your application to be Carbon-compatible.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSMakeFSSpec (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName,
   FSSpec * spec
);

/*PBGetCatInfoSync

Returns catalog information about a file or directory. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBGetCatInfoSync function returns information about a file or directory, depending on the values you specify in the ioFDirIndex, ioNamePtr, ioVRefNum, and ioDirID or ioDrDirID fields. If you need to determine whether the information returned is for a file or a directory, you can test bit 4 of the ioFlAttrib field; if that bit is set, the information returned describes a directory.

The PBGetCatInfoSync function selects a file or directory according to these rules:
If the value of ioFDirIndex is positive, ioNamePtr is not used as an input parameter and PBGetCatInfoSync returns information about the file or directory whose directory index is ioFDirIndex in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). If ioNamePtr is not NULL, then it must point to a Str31 buffer where the file or directory name will be returned. 
If the value of ioFDirIndex is 0, PBGetCatInfoSync returns information about the file or directory specified by ioNamePtr in the directory specified by ioDirID (or ioDrDirID) on the volume specified by ioVRefNum (again, this will be the root directory if ioVRefNum is a volume reference number or a drive number and ioDirID is 0). 
If the value of ioFDirIndex is negative, PBGetCatInfoSync ignores the ioNamePtr field and returns information about the directory specified in the ioDrDirID field. If ioNamePtr is not NULL, then it must point to a Str31 buffer where the directory name will be returned. 

With files, PBGetCatInfoSync is similar to PBHGetFInfoSync but returns some additional information. If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, the name of the file is returned in this field, if the file is open. If you do not want the name of the file returned, pass NULL in this field. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFRefNum 

On output, a file reference number. If the file is open, the reference number of the first access path found is returned here. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for the meaning of the file attributes. 
ioFlFndrInfo 

On output, information used by the Finder. 
ioDirID 

On input, a directory ID. On output, the file ID. You might need to save the value of ioDirID before calling PBGetCatInfoSync if you make subsequent calls with the same parameter block. 
ioFlStBlk 

On output, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioFlCrDat field to 0. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 
ioFlBkDat 

On output, the date and time of the file’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioFlBkDat field to 0. 
ioFlXFndrInfo 

On output, additional information used by the Finder. 
ioFlParID 

On output, the directory ID of the file’s parent directory. 
ioFlClpSiz 

On output, the file’s clump size. 

You can also use PBGetCatInfoSync to determine whether a file has a file ID reference. The value of the file ID is returned in the ioDirID field. Because that parameter could also represent a directory ID, call PBResolveFileIDRefSync to see if the value is a real file ID. If you want to determine whether a file ID reference exists for a file and create one if it doesn’t, use PBCreateFileIDRefSync , which will either create a file ID or return fidExists.

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. On output, a pointer to the directory’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFDirIndex 

On input, a directory index. 
ioFlAttrib 

On output, the directory attributes. See File Attribute Constants for the meaning of the bits in this field.The bits in this field for directories are read-only. You cannot alter directory attributes by setting these bits using the functions PBSetCatInfoSync or PBSetCatInfoAsync. Instead, you can call the PBHSetFLockSync and PBHRstFLockSync functions to lock and unlock a directory, and the PBShareSync and PBUnshareSync functions to enable and disable file sharing on local directories. 
ioACUser 

On output, the directory access rights. The PBGetCatInfoSync function returns the information in this field only for shared volumes. As a result, you should set this field to 0 before calling PBGetCatInfoSync. PBGetCatInfoSync does not return the blank access privileges bit in this field; to determine whether a directory has blank access privileges, use the PBHGetDirAccessSync function. See User Privileges Constants for a description of the constants that may be returned here. 
ioDrUsrWds 

On output, information used by the Finder. 
ioDrDirID 

On input, if you wish to obtain information about a specific directory, that directory’s ID. Otherwise, if the object returned is a directory, this field contains the directory ID on output. 
ioDrNmFls 

On output, the number of files in the directory. 
ioDrCrDat 

On output, the date and time of the directory’s creation. Note that file systems other than AFP, HFS and HFS Plus do not generally support creation dates. For file systems which do not support creation dates, the File Manager sets the ioDrCrDat field to 0.
ioDrMdDat 

On output, the date and time of the directory’s last modification. 
ioDrBkDat 

On output, the date and time of the directory’s last backup. Note that file systems other than AFP, HFS and HFS Plus do not generally support backup dates. For file systems which do not support backup dates, the File Manager sets the ioDrBkDat field to 0.
ioDrFndrInfo 

On output, additional information used by the Finder. 
ioDrParID 

On output, the directory ID of the directory’s parent directory. 

To get information on a file or directory with named forks, or on a file larger than 2GB, use one of the FSGetCatalogInfo , PBGetCatalogInfoSync , or PBGetCatalogInfoAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetCatInfoSync (
   CInfoPBPtr paramBlock
);

/*FSpOpenDF

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose data fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s data fork. In most cases, you can simply set the permission parameter to fsCurPerm. Some applications request fsRdWrPerm, to ensure that they can both read from and write to a file. For a description of the types of access that you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open data fork. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenDF is not available, you can use the function HOpenDF instead.

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenDF function, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenDF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);

/*GetEOF

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSGetForkSize instead.)

OSErr GetEOF (
   short refNum,
   long * logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

On return, a pointer to the logical size (the logical end-of-file) of the given file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetEOF (
   short refNum,
   long * logEOF
);

/*FSRead

Reads any number of bytes from an open file. (Deprecated in Mac OS X v10.4. Use FSReadFork instead.)

OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);
Parameters
refNum

The file reference number of the open file from which to read. 
count

On input, a pointer to the number of bytes to read; on output, a pointer to the number of bytes actually read. 
buffPtr

A pointer to the data buffer into which the data will be read. This buffer is allocated by your application and must be at least as large as the count parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read operation begins at the current mark, you might want to set the mark first by calling the SetFPos function. If you try to read past the logical end-of-file, FSRead reads in all the data up to the end-of-file, moves the mark to the end-of-file, and returns eofErr as its function result. Otherwise, FSRead moves the file mark to the byte following the last byte read and returns noErr.

The low-level functions PBReadSync and PBReadAsync let you set the mark without having to call SetFPos. Furthermore, if you want to read data in newline mode, you must use PBReadSync or PBReadAsync instead of FSRead. For a description of the PBReadSync and PBReadAsync functions, see the Device Manager Reference .

If you wish to read from named forks other than the data or resource forks, or from files larger than 2GB, you must use the FSReadFork function, or one of its corresponding parameter block calls, PBReadForkSync and PBReadForkAsync. If you attempt to use FSRead to read from a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSRead (
   short refNum,
   long * count,
   void * buffPtr
);

/*FSClose

Closes an open file. (Deprecated in Mac OS X v10.4. Use FSCloseFork instead.)

OSErr FSClose (
   short refNum
);
Parameters
refNum

The file reference number of the open file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSClose function removes the access path for the specified file and writes the contents of the volume buffer to the volume.

The FSClose function calls the PBFlushFileSync function internally to write the file’s bytes onto the volume. To ensure that the file’s catalog entry is updated, you should call FlushVol after you call FSClose. 
Special Considerations

Make sure that you do not call FSClose with a file reference number of a file that has already been closed. Attempting to close the same file twice may result in loss of data on a volume.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSClose (
   short refNum
);

/*FSRefMakePath

Converts an FSRef into a path.

OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);
Parameters
ref

The FSRef to convert into a path. 
path

On return, a pointer to the path. This path can be used by POSIX-style calls. 
pathSize

The size of the path. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

This function, though available through Carbon on Mac OS 8 and 9, is only implemented on Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FSRefMakePath (
   const FSRef * ref,
   UInt8 * path,
   UInt32 maxPathSize
);

/*FSGetDataForkName

Returns a Unicode string constant for the name of the data fork.

OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);
Parameters
dataForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the data fork. Currently, this is the empty string. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetDataForkName (
   HFSUniStr255 * dataForkName
);

/*FSGetForkSize

Returns the size of an open fork. 

OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
forkSize

On return, a pointer to the logical size (the logical end-of-file) of the fork, in bytes. The size returned is the total number of bytes that can be read from the fork; the amount of space actually allocated on the volume (the physical size) will probably be larger. 
Return Value

A result code. See “File Manager Result Codes”.
Special Considerations

To determine whether the FSGetForkSize function is present, call the Gestalt function. If FSGetForkSize is present, but is not directly supported by a volume, the File Manager will call PBGetEOFSync; however, you will not be able to determine the size of a fork other than the data or resource fork, or of a fork larger than 2 GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkSize (
   SInt16 forkRefNum,
   SInt64 * forkSize
);

/*FSEjectVolumeSync

Ejects a volume.

OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);
Parameters
vRefNum

The volume reference number of the volume to eject. 
flags

Options for future use.
dissenter

On return, a pointer to the pid of the process which denied the unmount if the eject is denied.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function ejects the volume specified by the vRefNum parameter. If the volume cannot be ejected the pid of the process which denied the unmount will be returned in the dissenter parameter. This function returns after the eject is complete. Ejecting a volume will result in the unmounting of other volumes on the same device.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSEjectVolumeSync (
   FSVolumeRefNum vRefNum,
   OptionBits flags,
   pid_t * dissenter
);

/*PBMakeFSRefSync

Creates an FSRef for a file or directory, given an FSSpec.

OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the parameter block based calls, the fields of the source FSSpec are passed as separate parameters (in the ioNamePtr, ioVRefNum, and ioDirID fields). This allows the call to be dispatched to external file systems the same way as other FSp calls are. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you wish to create an FSRef. 
ioVRefNum 

On input, a volume specification for the volume containing the file or directory. This can be a volume reference number, a drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the file or directory’s parent directory. 
newRef 

On input, a pointer to an FSRef structure. On output, this FSRef refers to the specified file or directory. 

To obtain an FSSpec from an FSRef, use the PBGetCatalogInfoSync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBMakeFSRefSync (
   FSRefParam * paramBlock
);
/*FSCreateFileUnicode

Creates a new file with a Unicode name.

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);
Parameters
parentRef

A pointer to an FSRef for the directory where the file is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the file's name. 
name

A pointer to the Unicode name for the new file. 
whichInfo

A bitmap specifying which catalog information fields to set for the new file. You specify the values for these fields in the catalogInfo parameter. If you do not wish to set catalog information for the new file, pass the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values of the new file’s catalog information. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new file.

newRef

On return, a pointer to the FSRef for the new file. If you do not want the FSRef returned, specify NULL.
newSpec

On return, a pointer to the FSSpec for the new file. If you do not want the FSSpec returned, specify NULL. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new file using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the file. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateFileUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBHCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode filenames, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCreateFileUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec
);


/*FSSetCatalogInfo

Sets catalog information about a file or directory.

OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);
Parameters
ref

A pointer to an FSRef specifying the file or directory whose information is to be changed. See FSRef for a description of the FSRef data type.
whichInfo

A bitmap specifying which catalog information fields to set. Only some of the catalog information fields may be set. These fields are given by the constant kFSCatInfoSettableInfo; no other bits may be set in the whichInfo parameter. See Catalog Information Bitmap Constants for a description of the bits in this parameter.

To set the user ID (UID) and group ID (GID) on Mac OS X, specify the kFSCatInfoSetOwnership flag in this parameter. The File Manager attempts to set the user and group ID to the values specified in the permissions field of the catalog information structure. If FSSetCatalogInfo cannot set the user and group IDs, it returns an error.
catalogInfo

A pointer to the structure containing the new catalog information. Only some of the catalog information fields may be set. The fields which may be set are:
createDate
contentModDate
attributeModDate
accessDate
backupDate
permissions
finderInfo
extFinderInfo
textEncodingHint

On Mac OS 9, you may also set the kFSNodeLockedBit bit in the nodeFlags field if you are changing catalog information for a file.

Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetCatalogInfo (
   const FSRef * ref,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo
);

/*FSDeleteObject

Deletes a file or an empty directory. 

OSErr FSDeleteObject (
   const FSRef * ref
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to be deleted. If the object to be deleted is a directory, it must be empty (it must contain no files or folders). See FSRef for a description of the FSRef data type.
Return Value

A result code. See “File Manager Result Codes”. On Mac OS 8 and 9, if you attempt to delete a folder for which there is an open catalog iterator, FSDeleteObject returns the error fBsyErr. On Mac OS X, a similar attempt to delete a folder while another process has an open iterator will succeed and FSDeleteObject returns noErr. Iteration, however, will continue to work until the iterator is closed.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSDeleteObject (
   const FSRef * ref
);

/*FSDisposeVolumeOperation

Releases the memory associated with a volume operation. 

OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);
Parameters
volumeOp

The FSVolumeOperation to release. 
Return Value

A result code. See “File Manager Result Codes”. This function will return paramErr if the FSVolumeOperation is in use.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSDisposeVolumeOperation (
   FSVolumeOperation volumeOp
);

/*FSMountServerVolumeAsync

Mounts a server volume asynchronously.

OSStatus FSMountServerVolumeAsync (
   CFURLRef url,
   CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);
Parameters
url

The server to mount. 
mountDir

The directory to mount the server to. If this parameter is NULL, the default location is used. 
user

A string to pass as the user for authentication. This parameter can be NULL. 
password

A string to pass as the password for authenticated log in. This parameter can be NULL. 
volumeOp

An FSVolumeOperation returned by the FSCreateVolumeOperation function. 
clientData

A pointer to client data associated with the operation. This parameter can be NULL.
flags

Options for future use.
callback

A function to call when the mount is complete. This parameter can be NULL. 
runloop

The runloop to run on. 
runloopMode

The mode for the runloop. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function will start the process to mount the server specified by the url parameter at the location specified by the mountDir parameter. If mountDir is NULL, the default location is used. An optional user and password can be passed in for authentication. If no user or password is provided then the underlying file system will handle authentication if required. If a callback function is provided, that function will be called when the mount operation is complete. Once this function returns noErr the status of the operation can be found using the FSGetAsyncMountStatus function.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/


OSStatus FSMountServerVolumeAsync (
    CFURLRef url,
  CFURLRef mountDir,
   CFStringRef user,
   CFStringRef password,
   FSVolumeOperation volumeOp,
   void * clientData,
   OptionBits flags,
   FSVolumeMountUPP callback,
   CFRunLoopRef runloop,
   CFStringRef runloopMode
);

/*NewFSVolumeMountUPP


FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the FSVolumeMountUPP data type.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
FSVolumeMountUPP NewFSVolumeMountUPP (
   FSVolumeMountProcPtr userRoutine
);

/*FSCreateVolumeOperation

Returns an FSVolumeOperation which can be used for an asynchronous volume operation. 

OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);
Parameters
volumeOp

The new FSVolumeOperation. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

When the operation is completed the FSVolumeOperation should be disposed of to free the memory associated with the operation using FSDisposeVolumeOperation.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCreateVolumeOperation (
   FSVolumeOperation * volumeOp
);

/*FSpMakeFSRef

Creates an FSRef for a file or directory, given an FSSpec.

OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);
Parameters
source

A pointer to the FSSpec for the file or directory. This parameter must point to a valid FSSpec for an existing file or directory; if it does not, the call will return fnfErr. See FSSpec for a description of the FSSpec data type.
newRef

On input, a pointer to an FSRef structure. On return, a pointer to the FSRef for the file or directory specified in the FSSpec pointed to in the source parameter. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To obtain an FSSpec from an FSRef, use the FSGetCatalogInfo function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSpMakeFSRef (
   const FSSpec * source,
   FSRef * newRef
);

/*FSCompareFSRefs

Determines whether two FSRef structures refer to the same file or directory.

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);
Parameters
ref1

A pointer to the first FSRef to compare. For a description of the FSRef data type, see FSRef.
ref2

A pointer to the second FSRef to compare.
Return Value

A result code. See “File Manager Result Codes”. If the two FSRef structures refer to the same file or directory, then noErr is returned. If they refer to objects on different volumes, then diffVolErr is returned. If they refer to different files or directories on the same volume, then errFSRefsDifferent is returned. This function may return other errors, including nsvErr, fnfErr, dirNFErr, and volOffLinErr.
Discussion

You must use FSCompareFSRefs, or one of the corresponding parameter block functions, PBCompareFSRefsSync and PBCompareFSRefsAsync , to compare FSRef structures. It is not possible to compare the FSRef structures directly since some bytes may be uninitialized, case-insensitive text, or contain hint information.

Some volume formats may be able to tell that two FSRef structures would refer to two different files or directories, without having to actually find those objects. In this case, the volume format may return errFSRefsDifferent even if one or both objects no longer exist. Similarly, if the FSRef structures are for objects on different volumes, the File Manager will return diffVolErr even if one or both volumes are no longer mounted. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSCompareFSRefs (
   const FSRef * ref1,
   const FSRef * ref2
);

/*FSCreateDirectoryUnicode

Creates a new directory (folder) with a Unicode name. 

OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);
Parameters
parentRef

A pointer to an FSRef specifying the parent directory where the new directory is to be created. See FSRef for a description of the FSRef data type.
nameLength

The length of the new directory's Unicode name. 
name

A pointer to the Unicode name of the new directory. 
whichInfo

A bitmap specifying which catalog information fields to set for the new directory. Specify the values for these fields in the catalogInfo parameter. 

If you do not wish to set catalog information for the new directory, specify the constant kFSCatInfoNone. See Catalog Information Bitmap Constants for a description of the bits defined for this parameter.
catalogInfo

A pointer to the FSCatalogInfo structure which specifies the values for the catalog information fields for the new directory. Specify which fields to set in the whichInfo parameter.

This parameter is optional; specify NULL if you do not wish to set catalog information for the new directory.

See FSCatalogInfo for a description of the FSCatalogInfo data type.
newRef

On return, a pointer to the FSRef for the new directory. This parameter is optional; specify NULL if you do not want the FSRef returned.
newSpec

On return, a pointer to the FSSpec for the new directory. This parameter is optional; specify NULL if you do not want the FSSpec returned. See FSSpec for a description of the FSSpec data type.
newDirID

On return, a pointer to the directory ID of the directory. This parameter is optional; specify NULL if you do not want the directory ID returned. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

You may optionally set catalog information for the new directory using the whichInfo and catalogInfo parameters; this is equivalent to calling FSSetCatalogInfo , or one of the corresponding parameter block functions, PBSetCatalogInfoSync and PBSetCatalogInfoAsync , after creating the directory. 

If possible, you should set the textEncodingHint field of the catalog information structure specified in the catalogInfo parameter. This will be used by the volume format when converting the Unicode filename to other encodings. 
Special Considerations

If the FSCreateDirectoryUnicode function is present, but is not implemented by a particular volume, the File Manager will emulate this function by making the appropriate call to PBDirCreateSync. However, if the function is not directly supported by the volume, you will not be able to use the long Unicode directory names, or other features added with HFS Plus. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateDirectoryUnicode (
   const FSRef * parentRef,
   UniCharCount nameLength,
   const UniChar * name,
   FSCatalogInfoBitmap whichInfo,
   const FSCatalogInfo * catalogInfo,
   FSRef * newRef,
   FSSpec * newSpec,
   UInt32 * newDirID
);

/*FSWrite

Writes any number of bytes to an open file. (Deprecated in Mac OS X v10.4. Use FSWriteFork instead.)

OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);
Parameters
refNum

The file reference number of the open file to which to write. 
count

On input, a pointer to the number of bytes to write to the file. In Carbon on Mac OS 9 and X, passing 0 in this parameter will return a paramErr error.

On output, a pointer to the number of bytes actually written.

buffPtr

A pointer to the data buffer containing the data to write. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSWrite function takes the specified number of bytes from the data buffer and attempts to write them to the file. Because the write operation begins at the current mark, you might want to set the mark first by calling the SetFPos function.

If the write operation completes successfully, FSWrite moves the file mark to the byte following the last byte written and returns noErr. If you try to write past the logical end-of-file, FSWrite moves the logical end-of-file. If you try to write past the physical end-of-file, FSWrite adds one or more clumps to the file and moves the physical end-of-file accordingly.

The low-level functions PBWriteSync and PBWriteAsync let you set the mark without having to call SetFPos. For a description of the PBWriteSync and PBWriteAsync functions, see the Device Manager Reference .

If you wish to write to named forks other than the data or resource forks, or grow files larger than 2GB, you must use the FSWriteFork function, or one of its corresponding parameter block calls, PBWriteForkSync and PBWriteForkAsync. If you attempt to use FSWrite to write to a file larger than 2GB, you will receive an error message. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/


OSErr FSWrite (
   short refNum,
   long * count,
   const void * buffPtr
);

/*FSpCreate

Creates a new file. (Deprecated in Mac OS X v10.4. Use FSCreateFileUnicode instead.)

OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to be created. See FSSpec for a description of the FSSpec data type.
creator

The creator of the new file. See the documentation for the Finder Interface for more information on file creators. 
fileType

The file type of the new file. See the documentation for the Finder Interface for more information on file types.
scriptTag

The code of the script system in which the filename is to be displayed. If you have established the name and location of the new file using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information about the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. See the Script Manager Reference for a description of the smSystemScript constant.

Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCreate function creates a new file (both data and resource forks) with the specified type, creator, and script code. The new file is unlocked and empty. The date and time of creation and last modification are set to the current date and time.

Files created using FSpCreate are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager functions HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpCreate is not available, you can use the function HCreate instead. To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpCreate (
   const FSSpec * spec,
   OSType creator,
   OSType fileType,
   ScriptCode scriptTag
);

/*FSpDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr FSpDelete (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to delete. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, FSpDelete returns the result code fBsyErr. FSpDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both forks of the file are deleted. The file ID reference, if any, is removed. A file must be closed before you can delete it. Similarly, a directory must be empty before you can delete it. 

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDelete is not available, you can use the function HDelete instead. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpDelete (
   const FSSpec * spec
);

/*PBSetCatInfoSync

Modifies catalog information for a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);
Parameters
paramBlock

A pointer to an HFS catalog information parameter block. See CInfoPBRec for a description of the CInfoPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBSetCatInfoSync function sets information about a file or directory. When used to set information about a file, it works much as PBHSetFInfoSync does, but lets you set some additional information.

If the object is a file, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioFlFndrInfo 

On input, Finder information for the file. 
ioDirID 

On input, the parent directory ID of the file. 
ioFlCrDat 

On input, the date and time of the file’s creation. 
ioFlMdDat 

On input, the date and time of the file’s last modification. 
ioFlBkDat 

On input, the date and time of the file’s last backup. 
ioFlXFndrInfo 

On input, extended Finder information. 

If the object is a directory, the relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDrUsrWds 

On input, information used by the Finder. 
ioDrDirID 

On input, the directory ID. 
ioDrCrDat 

On input, the date and time of the directory’s creation. 
ioDrMdDat 

On input, the date and time of the directory’s last modification. 
ioDrBkDat 

On input, the date and time of the directory’s last backup. 
ioDrFndrInfo 

On input, additional information used by the Finder. 

To modify the catalog information for a named fork other than the data and resource fork, or to modify other catalog information maintained on HFS Plus volumes that is not modifiable through PBSetCatInfoSync, use one of the functions, FSSetCatalogInfo , PBSetCatalogInfoSync , or PBSetCatalogInfoAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetCatInfoSync (
   CInfoPBPtr paramBlock
);

/*SetFPos

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use FSSetForkPosition instead.)

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);
Parameters
refNum

The file reference number of an open file. 
posMode

A constant specifying how to position the file mark; this parameter must contain one of the values described in Position Mode Constants.
posOff

The offset from the base location specified by the posMode parameter for the new file mark position. If you specify fsFromLEOF in the posMode parameter, the value in the posOff parameter must be less than or equal to 0. If you specify fsAtMark, the value in the posOff parameter is ignored. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you may want to call SetFPos to reposition the file mark before reading from or writing to the file.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr SetFPos (
   short refNum,
   short posMode,
   long posOff
);

/*SetEOF

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use FSSetForkSize instead.)

OSErr SetEOF (
   short refNum,
   long logEOF
);
Parameters
refNum

The file reference number of an open file. 
logEOF

The new logical size (the logical end-of-file) of the given file. If you set the logEOF parameter to 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you attempt to set the logical end-of-file beyond the physical end-of-file, the physical end-of-file is set 1 byte beyond the end of the next free allocation block if there isn’t enough space on the volume, no change is made, and SetEOF returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr SetEOF (
   short refNum,
   long logEOF
);

/*GetFPos

Returns the current position of the file mark. (Deprecated in Mac OS X v10.4. Use FSGetForkPosition instead.)

OSErr GetFPos (
   short refNum,
   long * filePos
);
Parameters
refNum

The file reference number of an open file. 
filePos

On return, a pointer to the current position of the mark. The position value is zero-based; that is, the value of filePos is 0 if the file mark is positioned at the beginning of the file. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because the read and write operations performed by the functions FSRead and FSWrite begin at the current mark, you should call GetFPos, or one of the parameter block functions, PBGetFPosSync and PBGetFPosAsync , to determine the current position of the file mark before reading from or writing to the file.

To determine the current position of a named fork, or of a fork larger than 2GB, use the FSGetForkPosition function, or one of the corresponding parameter block calls, PBGetForkPositionSync and PBGetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr GetFPos (
   short refNum,
   long * filePos
);

/*FSpSetFInfo

Sets the Finder information about a file. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file for which to set the Finder information. See FSSpec for a description of the FSSpec data type.
fndrInfo

A pointer to the new Finder information. For a description of the FInfo data type, see the Finder Interface Reference.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpSetFInfo function changes the Finder information in the volume catalog entry for the specified file. FSpSetFInfo allows you to set only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFInfo (
   const FSSpec * spec,
   const FInfo * fndrInfo
);

/*PBSetFPosAsync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionAsync instead.)

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. 
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosAsync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosAsync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosAsync (
   ParmBlkPtr paramBlock
);

/*PBWriteForkAsync

Writes data to an open fork.

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned. 
forkRefNum 

On input, the reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching. 
positionOffset 

On input, the offset from the base location for the start of the write. 
requestCount 

On input, the number of bytes to write. 
buffer 

A pointer to a buffer containing the data to write. 
actualCount 

On output, the number of bytes actually written. The value in the actualCount field will be equal to the value in the requestCount field unless there was an error during the write operation. 

PBWriteForkAsync writes data starting at the position specified by the positionMode and positionOffset fields. The function attempts to write requestCount bytes from the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBWriteForkAsync (
   FSForkIOParam * paramBlock
);

/*PBReadForkAsync

Reads data from an open fork.

void PBReadForkAsync (
   FSForkIOParam * paramBlock
);
Parameters
paramBlock

A pointer to a fork I/O parameter block. See FSForkIOParam for a description of the FSForkIOParam data type.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. If there are fewer than requestCount bytes from the specified position to the logical end-of-file, then all of those bytes are read, and eofErr is returned. 
forkRefNum 

On input, the reference number of the fork to read from. You should have previously opened this fork using the FSOpenFork call, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode 

On input, a constant specifying the base location within the fork for the start of the read. See Position Mode Constants for a description of the constants which you can use to specify the base location.The caller can also use this parameter to hint to the File Manager whether the data being read should or should not be cached. Caching reads appropriately can be important in ensuring that your program access files efficiently. If you add the forceReadMask constant to the value you pass in this parameter, this tells the File Manager to force the data to be read directly from the disk. This is different from adding the noCacheMask constant since forceReadMask tells the File Manager to flush the appropriate part of the cache first, then ignore any data already in the cache. However, data that is read may be placed in the cache for future reads. The forceReadMask constant is also passed to the device driver, indicating that the driver should avoid reading from any device caches.See Cache Constants for further description of the constants that you can use to indicate your preference for caching the read. 
positionOffset 

On input, the offset from the base location for the start of the read. 
requestCount 

On input, the number of bytes to read. The value that you pass in this field should be greater than zero. 
buffer 

A pointer to the buffer where the data will be returned. 
actualCount 

On output, the number of bytes actually read. The value in this field should be equal to the value in the requestCount field unless there was an error during the read operation. 

PBReadForkAsync reads data starting at the position specified by the positionMode and positionOffset fields. The function reads up to requestCount bytes into the buffer pointed to by the buffer field and sets the fork’s current position to the byte immediately after the last byte read (that is, the initial position plus actualCount).

To verify that data previously written has been correctly transferred to disk, read it back in using the forceReadMask constant in the positionMode field and compare it with the data you previously wrote.

When reading data from a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your read requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Version Notes

Note that on Mac OS 8 and 9, it is possible to call PBReadForkAsync with a value of 0 in the requestCount field; however, this behavior is not supported on Mac OS X. On OS X, PBReadForkAsync returns a paramErr error if the value in the requestCount field is 0.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void PBReadForkAsync (
   FSForkIOParam * paramBlock);

/*NewIOCompletionUPP

Creates a new universal procedure pointer (UPP) to your completion function.

IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);
Parameters
userRoutine

A pointer to a completion callback function. See IOCompletionProcPtr for a description of the IOCompletionProcPtr data type.
Return Value

A universal procedure pointer to your completion function. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
IOCompletionUPP NewIOCompletionUPP (
   IOCompletionProcPtr userRoutine
);

/*FSpGetFInfo

Obtains the Finder information for a file. (Deprecated in Mac OS X v10.4. Use FSGetCatalogInfo instead.)

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);
Parameters
spec

A pointer to an FSSpec structure specifying the file. See FSSpec for a description of the FSSpec data type.
fndrInfo

On return, a pointer to information used by the Finder. The FSpGetFInfo function returns the Finder information from the volume catalog entry for the specified file. The function provides only the original Finder information—the information in the FInfo or DInfo structures, not the information in the FXInfo or DXInfo structures. For a description of the FInfo structure, see the Finder Interface Reference.
Return Value

A result code. If the specified object is a folder, this function returns fnfErr. For other possible return values, see “File Manager Result Codes”. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpGetFInfo (
   const FSSpec * spec,
   FInfo * fndrInfo
);

/*PBHGetFInfoSync

Obtains information about a file. (Deprecated in Mac OS X v10.4. Use PBGetCatalogInfoSync instead.)

OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a pathname. If the value of the ioFDirIndex field is negative or 0, PBHGetFInfoSync returns information about the file in the volume specified by the reference number in the ioVRefNum field and having the name given here.On output, a pointer to the name of the file, if the file is open. If you do not wish the name returned, pass NULL here. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file, or 0 for the default volume. 
ioFRefNum 

On output, the reference number of the first access path found, if the file is open and if the ioFDirIndex field is negative or 0; if the ioFDirIndex field is positive... 
ioFDirIndex 

On input, a directory index. If this value is positive, the function returns information about the file having the directory index specified here, on the volume specified in the ioVRefNum field and in the directory specified in the ioDirID field.If this value is negative or 0, the function returns information about the file on the specified volume, having the name pointed to in the ioNamePtr field. 
ioFlAttrib 

On output, the file attributes. See File Attribute Constants for a description of the file attributes. 
ioFlFndrInfo 

On output, Finder information about the file. For a description of the FInfo data type, see the Finder Interface Reference . 
ioDirID 

On input, the parent directory ID of the file. On output, the file’s file ID. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 
ioFlStBlk 

On ouput, the first allocation block of the data fork. 
ioFlLgLen 

On output, the logical size (the logical end-of-file) of the file’s data fork, in bytes. 
ioFlPyLen 

On output, the physical size (the physical end-of-file) of the file’s data fork, in bytes. 
ioFlRStBlk 

On output, the first allocation block of the resource fork. 
ioFlRLgLen 

On output, the logical size of the resource fork, in bytes. 
ioFlRPyLen 

On output, the physical size of the resource fork, in bytes. 
ioFlCrDat 

On output, the date and time of the file’s creation. 
ioFlMdDat 

On output, the date and time of the file’s last modification. 

You should call PBHGetFInfoSync just before PBHSetFInfoSync , so that the current information is present in the parameter block. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHGetFInfoSync (
   HParmBlkPtr paramBlock
);

/*PBCreateFileIDRefSync

Establishes a file ID reference for a file.

OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.PBCreateFileIDRefSync returns the result code fidExists if a file ID reference already exists for the file.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

Given a volume reference number, filename, and parent directory ID, the PBCreateFileIDRefSync function creates a structure to hold the name and parent directory ID of the specified file. The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the file’s name. 
ioVRefNum 

On input, a volume reference number for the volume containing the file. 
ioSrcDirID 

On input, the file’s parent directory ID. 
ioFileID 

On output, a file ID. If a file ID reference already exists for the file, PBCreateFileIDRefSync supplies the file ID but returns the result code fidExists. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBCreateFileIDRefSync (
   HParmBlkPtr paramBlock
);

/*FSpRename

Renames a file or directory. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to rename. See FSSpec for a description of the FSSpec data type.
newName

The new name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If a file ID reference for the specified file exists, it remains with the renamed file.

If you want to change the name of a new copy of an existing file, you should use the FSpExchangeFiles function instead. To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRename (
   const FSSpec * spec,
   ConstStr255Param newName
);

/*HGetVol

Determines the current default volume and default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);
Parameters
volName

On return, a pointer to the name of the default volume. If you do not want the name of the default volume returned, set this parameter to NULL. 
vRefNum

On return, a pointer to the volume reference number of the default volume. 
dirID

On return, a pointer to the directory ID of the default directory. 
Return Value

A result code. See “File Manager Result Codes”.
Version Notes

When CarbonLib is not present, the HGetVol function returns a working directory reference number in the vRefNum parameter if the previous call to HSetVol (or one of the corresponding parameter block calls) passed in a working directory reference number.
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HGetVol (
   StringPtr volName,
   short * vRefNum,
   long * dirID
);

/*FSpOpenRF

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use FSOpenFork instead.)

OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);
Parameters
spec

A pointer to an FSSpec structure specifying the file whose resource fork is to be opened. See FSSpec for a description of the FSSpec data type.
permission

A constant indicating the type of access with which to open the file’s resource fork. For a description of the types of access you can request, see File Access Permission Constants. 
refNum

On return, a pointer to the file reference number for accessing the open resource fork. 
Return Value

A result code. See “File Manager Result Codes”. On some file systems, FSpOpenRF will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpOpenRF is not available, you can use the function HOpenRF instead. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the FSpOpenRF function, you will receive an error message. 
Special Considerations

Generally, your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The FSpOpenRF function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork. 

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpOpenRF (
   const FSSpec * spec,
   SInt8 permission,
   short * refNum
);

/*FlushVol

Writes the contents of the volume buffer and update information about the volume.

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
);
Parameters
volName

The name of the mounted volume to flush. 
vRefNum

The volume reference number, drive number, or 0 for the default volume. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

For the specified volume, the FlushVol function writes the contents of the associated volume buffer and descriptive information about the volume. Information which has changed since the last time FlushVol was called is written to the volume. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FlushVol (
   ConstStr63Param volName,
   short vRefNum
);

/*PBGetVolMountInfoSize

Determines how much space to allocate for a volume mounting information structure.

OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to storage for the size information, which is of type Integer (2 bytes). If PBGetVolMountInfoSize returns noErr, that integer contains the size of the volume mounting information structure on output. 

You should call this function before you call PBGetVolMountInfo , to obtain the size of the volume mounting information for which you must allocate storage. Then call PBGetVolMountInfo to retrieve the actual volume mounting information. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBGetVolMountInfoSize (
   ParmBlkPtr paramBlock
);

/*PBGetVolMountInfo

Retrieves a record containing all the information needed to mount a volume, except for passwords.

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname 
ioVRefNum 

On input, a volume specification. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioBuffer 

On input, a pointer to a buffer to hold the mounting information. The length of the buffer is specified by the value pointed to by the ioBuffer field in a previous call to PBGetVolMountInfoSize. On output, the mounting information for the specified volume. You can later pass this structure to the PBVolumeMount function to mount the volume.The mounting information for an AppleShare volume is stored as an AFP mounting record. The PBGetVolMountInfo function does not return the user password or volume password in the AFPVolMountInfo structure. Your application should solicit these passwords from the user and fill in the structure before attempting to mount the remote volume. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. This programmatic mounting function stores the mounting information in a structure called the AFPVolMountInfo structure. 
Special Considerations

This function executes synchronously. You should not call it at interrupt time.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBGetVolMountInfo (
   ParmBlkPtr paramBlock
);

/*FSCopyDiskIDForVolume

Returns a copy of the disk ID for a volume.

OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
);
Parameters
vRefNum

The volume reference number of the target volume. 
diskID

On return, a pointer to the disk ID string associated with the target volume. 
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.2 and later.
Declared In
Files.h*/
OSStatus FSCopyDiskIDForVolume (
   FSVolumeRefNum vRefNum,
   CFStringRef * diskID
);

/*FSRenameUnicode

Renames a file or folder.

OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef for the file or directory to rename. See FSRef for a description of the FSRef data type.
nameLength

The length of the new name in Unicode characters. 
name

A pointer to the new Unicode name of the file or directory. 
textEncodingHint

The suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef

On return, a pointer to the new FSRef for the file or directory. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Because renaming an object may change its FSRef, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to access the object after the renaming, if you wish to continue to refer to the object. The FSRef passed in the ref parameter may or may not be usable after the object is renamed. The FSRef returned in the newRef parameter may point to the same storage as the FSRef passed in ref. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSRenameUnicode (
   const FSRef * ref,
   UniCharCount nameLength,
   const UniChar * name,
   TextEncoding textEncodingHint,
   FSRef * newRef
);

/*FSIterateForks

Determines the name and size of every named fork belonging to a file or directory.

OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to iterate. See FSRef for a description of the FSRef data type.
forkIterator

A pointer to a structure which maintains state between calls to FSIterateForks. Before the first call, set the initialize field of the structure to 0. The fork iterator will be updated after the call completes; the updated iterator should be passed into the next call. See CatPositionRec for a description of the CatPositionRec data type.
forkName

On return, a pointer to the Unicode name of the fork. This parameter is optional; if you do not wish the name returned, pass a NULL pointer. See HFSUniStr255 for a description of the HFSUniStr255 data type.
forkSize

On return, a pointer to the logical size of the fork, in bytes. This parameter is optional; if you do not wish to retrieve the logical fork size, pass a NULL pointer. 
forkPhysicalSize

On return, a pointer to the physical size of the fork (that is, to the amount of space allocated on disk), in bytes. This parameter is optional; if you do not wish to retrieve the physical fork size, pass a NULL pointer. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Since information is returned about one fork at a time, several calls may be required to iterate through all the forks. There is no guarantee about the order in which forks are returned; the order may vary between iterations. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSIterateForks (
   const FSRef * ref,
   CatPositionRec * forkIterator,
   HFSUniStr255 * forkName,
   SInt64 * forkSize,
   UInt64 * forkPhysicalSize
);

/*PBHCopyFileSync

Duplicates a file and optionally renames it.

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the source file. 
ioVRefNum 

On input, the volume reference number or drive number for the volume containing the source file. Pass 0 for the default volume. 
ioDstVRefNum 

On input, the reference number or drive number of the destination volume. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the partial pathname for the destination directory. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 

This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it. 
Special Considerations

This is an optional call for AppleShare file servers. Your application should examine the information returned by the PBHGetVolParmsSync function to see if the volume supports PBHCopyFileSync. If the bHasCopyFile bit is set in the vMAttrib field of the GetVolParmsInfoBuffer structure, then the volume supports PBHCopyFileSync.

For AppleShare file servers, the source and destination pathnames must indicate the same file server; however, the parameter block may specify different source and destination volumes on that file server. A useful way to tell if two file server volumes are on the same file server is to call the PBHGetVolParmsSync function for each volume and compare the server addresses returned. The server opens source files with read/deny write enabled and destination files with write/deny read and write enabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHCopyFileSync (
   HParmBlkPtr paramBlock
);

/*PBHGetDirAccessSync

Returns the access control information for a directory or file.

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the directory or file. 
ioVRefNum 

On input, a volume specification for the volume containing the directory or file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On output, the user ID for the owner of the directory or file. 
ioACGroupID 

On output, the primary group ID of the directory or file. 
ioACAccess 

On output, the access rights for the directory or file. See File and Folder Access Privilege Constants for more information on these access rights.
ioDirID 

On input, the directory ID. 
Version Notes

On Mac OS 8 and 9, PBHGetDirAccessSync only returns access information for directories; you cannot use it to return information for files.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHGetDirAccessSync (
   HParmBlkPtr paramBlock
);

/*FSAllocateFork

Allocates space on a volume to an open fork.

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain a fork reference number with the FSOpenFork function, or with one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
flags

A constant indicating how the new space should be allocated. See Allocation Flags for a description of the constants which you can use in this parameter.
positionMode

A constant specifying the base location for the start of the allocation. See Position Mode Constants for more information on the constants which you can use to specify the base location. 
positionOffset

The offset from the base location of the start of the allocation. 
requestCount

The number of bytes to allocate. 
actualCount

On return, a pointer to the number of bytes actually allocated to the file. The value returned in here may be smaller than the number specified in the requestCount parameter if some of the space was already allocated. The value pointed to by the actualCount parameter does not reflect any additional bytes that may have been allocated because space is allocated in terms of fixed units such as allocation blocks, or the use of a clump size to reduce fragmentation. 

The actualCount output is optional if you don’t want the number of allocated bytes returned, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSAllocateFork function attempts to allocate requestCount bytes of physical storage starting at the offset specified by the positionMode and positionOffset parameters. For volume formats that support preallocated space, you can later write to this range of bytes (including extending the size of the fork) without requiring an implicit allocation.

Any extra space allocated but not used will be deallocated when the fork is closed, using FSCloseFork , PBCloseForkSync , or PBCloseForkAsync ; or when the fork is flushed, using FSFlushFork , PBFlushForkSync , or PBFlushForkAsync. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr FSAllocateFork (
   SInt16 forkRefNum,
   FSAllocationFlags flags,
   UInt16 positionMode,
   SInt64 positionOffset,
   UInt64 requestCount,
   UInt64 * actualCount
);

/*FSWriteFork

Writes data to an open fork.

OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
);
Parameters
forkRefNum

The reference number of the fork to which to write. You should have previously opened the fork using the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant specifying the base location within the fork for the start of the write. See Position Mode Constants for a description of the constants which you can use to specify the base location.

The caller can also use this parameter to hint to the File Manager whether the data being written should or should not be cached. See Cache Constants for further description of the constants that you can use to indicate your preference for caching.
positionOffset

The offset from the base location for the start of the write. 
requestCount

The number of bytes to write. 
buffer

A pointer to a buffer containing the data to write. 
actualCount

On return, a pointer to the number of bytes actually written. The value pointed to by the actualCount parameter will be equal to the value in the requestCount parameter unless there was an error during the write operation.

This parameter is optional; if you don’t want this information, set actualCount to NULL.
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to write requestCount bytes, then dskFulErr is returned.
Discussion

FSWriteFork writes data starting at the position specified by the positionMode and positionOffset parameters. The function attempts to write requestCount bytes from the buffer pointed at by the buffer parameter and sets the fork’s current position to the byte immediately after the last byte written (that is, the initial position plus actualCount).

When writing data to a fork, it is important to pay attention to that way that your program accesses the fork, because this can have a significant performance impact. For best results, you should use an I/O size of at least 4KB and block align your write requests. On Mac OS X, you should align your requests to 4KB boundaries; on the traditional Mac OS, byte-alignments beyond 512-bytes are irrelevant, but 4KB aligned requests will perform well on current and future versions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSWriteFork (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset,
   ByteCount requestCount,
   const void * buffer,
   ByteCount * actualCount
);

/*FSCreateFork

Creates a named fork for a file or directory.

OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
);
Parameters
ref

A pointer to an FSRef specifying the file or directory. See FSRef for a description of the FSRef data type.
forkNameLength

The length of the name of the new fork. 
forkName

A pointer to the Unicode name of the fork. 
Return Value

A result code. See “File Manager Result Codes”. If the named fork already exists, the function returns errFSForkExists. If the fork name is syntactically invalid or otherwise unsupported for the given volume, FSCreateFork returns errFSBadForkName or errFSNameTooLong.
Discussion

A newly created fork has zero length (that is, its logical end-of-file is zero). The data and resource forks of a file are automatically created and deleted as needed. This is done for compatibility with older APIs, and because data and resource forks are often handled specially. If a given fork always exists for a given volume format (such as data and resource forks for HFS and HFS Plus, or data forks for most other volume formats), an attempt to create that fork when a zero-length fork already exists should return noErr; if a non-empty fork already exists then errFSForkExists should be returned. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSCreateFork (
   const FSRef * ref,
   UniCharCount forkNameLength,
   const UniChar * forkName
);

/*FSSetForkSize

Changes the size of an open fork.

OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of the open fork. You can obtain this fork reference number with the FSOpenFork function, or one of the corresponding parameter block calls, PBOpenForkSync and PBOpenForkAsync. 
positionMode

A constant indicating the base location within the fork for the new size. See Position Mode Constants for more information about the constants you can use to specify the base location. 
positionOffset

The offset of the new size from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. If there is not enough space on the volume to extend the fork, then dskFulErr is returned and the fork’s size is unchanged.
Discussion

The FSSetForkSize function sets the logical end-of-file to the position indicated by the positionMode and positionOffset parameters. The fork’s new size may be less than, equal to, or greater than the fork’s current size. If the fork’s new size is greater than the fork’s current size, then the additional bytes, between the old and new size, will have an undetermined value.

If the fork’s current position is larger than the fork’s new size, then the current position will be set to the new fork size the current position will be equal to the logical end-of-file. 
Special Considerations

You do not need to check that the volume supports the FSSetForkSize function. If a volume does not support the FSSetForkSize function, but the FSSetForkSize function is present, the File Manager automatically calls the PBSetEOFSync function and translates between the calls appropriately. 

Note, however, that if the volume does not support the FSSetForkSize function, you can only access the data and resource forks, and you cannot grow the fork beyond 2GB. To check that the FSSetForkSize function is present, call the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkSize (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);

/*FSCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory.

OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);

/*FSMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory.

OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
source

A pointer to the source object to move. The object can be a file or a directory.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectAsync (
   FSFileOperationRef fileOp,
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   OptionBits flags,
   FSFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);

/*FSFileOperationCreate

Creates an object that represents an asynchronous file operation.

FSFileOperationRef FSFileOperationGetTypeID (
   CFAllocatorRef alloc
);
Parameters
alloc

The allocator to use. Pass NULL for the default allocator.
Return Value

A new FSFileOperation object, or NULL if the object could not be created. When you no longer need the object, you should release it by calling CFRelease.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
FSFileOperationRef FSFileOperationCreate (
   CFAllocatorRef alloc
);

/*FSFileOperationScheduleWithRunLoop

Schedules an asynchronous file operation with the specified run loop and mode.

OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);
Parameters
fileOp

The file operation to schedule.
runLoop

The run loop in which to schedule the operation. For information about Core Foundation run loops, see Run Loops.
runLoopMode

The run loop mode in which to schedule the operation. In most cases, you may specify kCFRunLoopCommonModes.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

To run, a file operation must be scheduled with at least one run loop. A file operation can be scheduled with multiple run loop and mode combinations.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSFileOperationScheduleWithRunLoop (
   FSFileOperationRef fileOp,
   CFRunLoopRef runLoop,
   CFStringRef runLoopMode
);

/*FSPathMoveObjectSync

Moves a source object into a destination directory using paths.

OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should call it in a thread other than the main thread or use FSPathMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathMoveObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);

/*FSPathCopyObjectSync

Copies a source object into a destination directory using paths.

OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);
Parameters
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
targetPath

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the new object in the destination directory. If the operation fails, the path is set to NULL. When you no longer need the path, you should free it. This parameter is optional; pass NULL if you don’t need the path to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSPathCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectSync (
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   char **targetPath,
   OptionBits options
);

/*FSPathFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation that uses paths.

OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to a char* variable. On output, the variable refers to the UTF-8 path to the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory). You should free the path when you are finished using it.
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   char **currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
);

/*FSPathMoveObjectAsync

Starts an asynchronous file operation to move a source object into a destination directory using paths.

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this move operation.
sourcePath

The UTF-8 path to the source object to move. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSPathMoveObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);

/*FSPathCopyObjectAsync

Starts an asynchronous file operation to copy a source object into a destination directory using paths.

OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);
Parameters
fileOp

The file operation object you created for this copy operation.
sourcePath

The UTF-8 path to the source object to copy. The object can be a file or a directory.
destDirPath

The UTF-8 path to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
flags

One or more file operation option flags. See File Operation Options.
callback

A callback function to receive status updates as the file operation proceeds. For more information, see “File Operation Callbacks”. This parameter is optional; pass NULL if you don’t need to supply a status callback.
statusChangeInterval

The minimum time in seconds between callbacks within a single stage of an operation.
clientContext

User-defined data to associate with this operation. For more information, see FSFileOperationClientContext. This parameter is optional; pass NULL if you don’t need to supply a client context.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If you specify a status callback function, status callbacks will occur in one of the run loop and mode combinations with which you scheduled the file operation.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSPathCopyObjectAsync (
   FSFileOperationRef fileOp,
   const char *sourcePath,
   const char *destDirPath,
   CFStringRef destName,
   OptionBits flags,
   FSPathFileOperationStatusProcPtr callback,
   CFTimeInterval statusChangeInterval,
   FSFileOperationClientContext *clientContext
);

/*FSMoveObjectSync

Moves a source object into a destination directory.

OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to move. The object can be a file or a directory. On output, the source object is no longer valid; if you want to refer to the moved object, you should use the FSRef variable passed back in the target parameter.
destDir

A pointer to the destination directory. If the destination directory is not on the same volume as the source object, the source object is copied and then deleted.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options. If you specify the kFSFileOperationDoNotMoveAcrossVolumes flag and the destination directory is not on the same volume as the source object, this function does nothing and returns an error.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the destination directory is on the same volume as the source object, this is a fast operation. If the move is across volumes, this function could take a significant amount of time to execute; you should either call it in a thread other than the main thread or use FSMoveObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSMoveObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);

/*FSCopyObjectSync

Copies a source object into a destination directory.

OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);
Parameters
source

A pointer to the source object to copy. The object can be a file or a directory.
destDir

A pointer to the destination directory.
destName

The name for the new object in the destination directory. Pass NULL to use the name of the source object.
target

A pointer to an FSRef variable. On output, the variable refers to the new object in the destination directory. This parameter is optional; pass NULL if you don’t need to refer to the new object.
options

One or more file operation option flags. See File Operation Options.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

This function could take a significant amount of time to execute. To avoid blocking your user interface, you should either call this function in a thread other than the main thread or use FSCopyObjectAsync instead.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/
OSStatus FSCopyObjectSync (
   const FSRef *source,
   const FSRef *destDir,
   CFStringRef destName,
   FSRef *target,
   OptionBits options
);

/*FSFileOperationCopyStatus

Gets a copy of the current status information for an asynchronous file operation.

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error
   CFDictionaryRef *statusDictionary,
   void **info
);
Parameters
fileOp

The file operation to access.
currentItem

A pointer to an FSRef variable. On output, the variable contains the object currently being moved or copied. If the operation is complete, this parameter refers to the target (the new object corresponding to the source object in the destination directory).
stage

A pointer to a file operation stage variable. On output, the variable contains the current stage of the file operation.
error

A pointer to an error status variable. On output, the variable contains the current error status of the file operation.
statusDictionary

A pointer to a dictionary variable. On output, the variable contains a dictionary with more detailed status information. For information about the contents of the dictionary, see “File Operation Status Dictionary Keys”. You should release the dictionary when you are finished using it.
info

A pointer to a generic pointer. On output, the generic pointer refers to user-defined data associated with this file operation.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
Files.h*/

OSStatus FSFileOperationCopyStatus (
   FSFileOperationRef fileOp,
   FSRef *currentItem,
   FSFileOperationStage *stage,
   OSStatus *error,
   CFDictionaryRef *statusDictionary,
   void **info
);

/*Accessing Information About Files and Directories
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoSync
   				(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBGetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfo	(CInfoPBPtr paramBlock, Boolean async);
pascal OSErr PBSetCatInfoSync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBSetCatInfoAsync
   				(CInfoPBPtr paramBlock);
pascal OSErr PBHGetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHSetFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHSetFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLock	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRstFLockSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRstFLockAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHRename		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHRenameSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHRenameAsync	(HParmBlkPtr paramBlock);*/
pascal OSErr PBGetCatInfo	(CInfoPBPtr paramBlock, Boolean async);

/*Obtaining Volume Information
pascal OSErr PBHGetVInfo	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVInfoAsync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfo		(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBSetVInfoSync	(HParmBlkPtr paramBlock);
pascal OSErr PBSetVInfoAsync	(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBHGetVolParmsSync
   				(HParmBlkPtr paramBlock);
pascal OSErr PBHGetVolParmsAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBHGetVolParms	(HParmBlkPtr paramBlock, Boolean async);

/*Searching a Catalog
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async);
pascal OSErr PBCatSearchSync	(HParmBlkPtr paramBlock);
pascal OSErr PBCatSearchAsync
   				(HParmBlkPtr paramBlock);*/
pascal OSErr PBCatSearch	(HParmBlkPtr paramBlock, Boolean async);

/*FSpExchangeFiles

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use FSExchangeObjects instead.)

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec for the first file to swap. The contents of this file and its file information are placed in the file specified in the dest parameter. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec for the second file to swap. The contents of this file and its file information are placed in the file specified in the source parameter.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpExchangeFiles function swaps the data in two files by changing the information in the volume’s catalog and, if either of the files are open, in the file control blocks. The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use FSpExchangeFiles when updating an existing file, so that the file ID remains valid in case the file is being tracked through its file ID. The FSpExchangeFiles function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The FSpExchangeFiles function works on both open and closed files. If either file is open, FSpExchangeFiles updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access permissions as opening both files for writing.

The files whose data is to be exchanged must both reside on the same volume. If they do not, FSpExchangeFiles returns the result code diffVolErr.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

The “compatibility code,” by which FSpExchangeFiles attempted to perform the file exchange itself if it suspected that the underlying filesystem did not have Exchange capability, has been removed in Carbon on Mac OS 9 and X. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling FSpExchangeFiles. Exclusive read/write access to both files will ensure that FSpExchangeFiles doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

FSpExchangeFiles does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling FSpExchangeFiles ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpExchangeFiles (
   const FSSpec * source,
   const FSSpec * dest
);

/*PBCatalogSearchAsync

Searches for objects traversed by a catalog iterator that match a given set of criteria.

void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
);
Parameters
paramBlock

A pointer to a catalog information parameter block. See FSCatalogBulkParam for a description of the FSCatalogBulkParam data type.
Discussion

The relevant fields of this parameter are:
ioCompletion 

On input, a pointer to a completion routine. For more information on completion routines, see IOCompletionProcPtr. 
ioResult 

On output, the result code of the function. When the entire volume has been searched, errFSNoMoreItems is returned. 
iterator 

On input, the iterator to use. Objects traversed by this iterator are matched against the criteria specified by the searchParams field. You can obtain a catalog iterator with the function FSOpenIterator , or with one of the related parameter block calls, PBOpenIteratorSync and PBOpenIteratorAsync. Currently, this iterator must be created with the kFSIterateSubtree option and the container must be the root directory of a volume. See FSIterator for more information on the FSIterator data type. 
searchParams 

On input, a pointer to an FSSearchParams structure containing the search criteria. You can match against the object’s name in Unicode and by the fields in an FSCatalogInfo structure. You may use the same search bits as passed in the ioSearchBits field to the PBCatSearchSync and PBCatSearchAsync functions; they control the corresponding FSCatalogInfo fields. See Catalog Search Masks for a description of the search bits.There are a few new search criteria supported by PBCatalogSearchAsync but not by PBCatSearchSync and PBCatSearchAsync. These new search criteria are indicated by the constants described in Catalog Search Constants.If the searchTime field of this structure is non-zero, it is interpreted as a Time Manager duration; the search may terminate after this duration even if maximumItems objects have not been returned and the entire catalog has not been scanned. If searchTime is zero, there is no time limit for the search.If you are searching by any criteria other than name, you must set the searchInfo1 and searchInfo2 fields of the structure in this field to point to FSCatalogInfo structures containing the values to match against. 
maximumItems 

On input, the maximum number of items to return for this call. 
actualItems 

On output, the actual number of items returned for this call. 
containerChanged 

On output, a Boolean value indicating whether the container’s contents have changed. If true, the container’s contents changed since the previous PBCatalogSearchAsync call. Objects may still be returned even though the container changed. Note that if the container has changed, then the total set of items returned may be incorrect; some items may be returned multiple times, and some items may not be returned at all. 
whichInfo 

On input, a bitmap specifying the catalog information fields to return for each item. If you don’t wish any catalog information returned, pass the constant kFSCatInfoNone in this field. See Catalog Information Bitmap Constants for a description of the bits in this field. 
catalogInfo 

On output, a pointer to an array of FSCatalogInfo structures; one for each found item. On input, the catalogInfo field should point to an array of maximumItems catalog information structures.This field is optional; if you do not wish any catalog information returned, pass NULL here. 
refs 

On output, a pointer to an array of FSRef structures; one for each returned item. On input, if you want an FSRef for each item found, pass a pointer to an array of maximumItems FSRef structures. Otherwise, pass NULL. 
names 

On output, a pointer to an array of filenames; one for each returned item. On input, if you want the Unicode filename for each item found, pass a pointer to an array of maximumItems HFSUniStr255 structures. Otherwise, pass NULL. 

A single search may span more than one call to PBCatalogSearchAsync. The call may complete with no error before scanning the entire volume. This typically happens because the time limit ( searchTime) has been reached or maximumItems items have been returned. If the search is not completed, you can continue the search by making another call to PBCatalogSearchAsync and passing the updated iterator returned by the previous call in the iterator field.

Before calling this function, you should determine that it is present, by calling the Gestalt function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
void PBCatalogSearchAsync (
   FSCatalogBulkParam * paramBlock
);

/*DisposeIOCompletionUPP

Disposes of a universal procedure pointer (UPP) to your completion callback function.

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
);
Parameters
userUPP

The universal procedure pointer to dispose. See IOCompletionUPP for a description of the IOCompletionUPP data type.
Discussion

See IOCompletionProcPtr for more information about completion functions. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

void DisposeIOCompletionUPP (
   IOCompletionUPP userUPP
);

/*PBGetFCBInfoSync

Gets information about an open file from the file control block. (Deprecated in Mac OS X v10.4. Use PBGetForkCBInfoSync instead.)

OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a file control block parameter block. See FCBPBRec for a description of the FCBPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. You should pass a pointer to a Str31 value if you want the name of the file returned. If you pass NULL, no filename is returned. On output, if PBGetFCBInfoSync executes successfully, a pointer to the name of the specified open file. 
ioVRefNum 

On input, a volume specification. If you specify a valid index number in the ioFCBIndx field, the File Manager returns information on the file having that index in the FCB buffer on the volume specified in this field. This field may contain a drive number or volume reference number. If the value of ioVRefNum is 0, all open files are indexed; otherwise, only open files on the specified volume are indexed. 
ioRefNum 

On input, if the ioFCBIndx field is 0, the file reference number of the file to get information about. If the value of ioFCBIndx is positive, the ioRefNum field is ignored on input and contains the file reference number on output. 
ioFCBIndx 

On input, an index. If the value of ioFCBIndx is positive, the File Manager returns information about the file whose index in the FCB buffer is ioFCBIndx and that is located on the volume specified in the ioVRefNum field.If the value of ioFCBIndx is 0, the File Manager returns information about the file whose file reference number is specified by the ioRefNum field. 
ioFCBFlNm 

On output, the file ID. 
ioFCBFlags 

On output, file status flags. See FCB Flags for a description of the bits in this field. 
ioFCBStBlk 

On output, the first allocation block of the file. 
ioFCBEOF 

On output, the logical size (the logical end-of-file) of the file. 
ioFCBPLen 

On output, the physical size (the physical end-of-file) of the file. 
ioFCBCrPs 

On output, the current position of the file mark. 
ioFCBVRefNum 

On output, the volume reference number. 
ioFCBClpSiz 

On output, the file clump size. 
ioFCBParID 

On output, the directory ID of the file’s parent directory. 

To get information about a fork control block, use one of the functions, FSGetForkCBInfo , PBGetForkCBInfoSync , or PBGetForkCBInfoAsync. 
Special Considerations

On OS X, the value returned by PBGetFCBInfoSync in the ioFCBPLen field may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by PBGetFCBInfoSync changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetFCBInfoSync (
   FCBPBPtr paramBlock
);

/*PBHGetVInfoSync

Gets detailed information about a volume. (Deprecated in Mac OS X v10.4. Use PBGetVolumeInfoSync instead.)

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HVolumeParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.On output, a pointer to the volume’s name. You should pass a pointer to a Str31 value if you want the name returned. If you pass NULL, no volume name is returned. 
ioVRefNum 

On input, a volume reference number or drive number for the volume for which to return information; or 0 for the default volume. If the ioVolIndex field is negative, the File Manager uses the value in the ioNamePtr field, along with the value specified in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field. On output, the volume reference number. 
ioVolIndex 

On input, an index used for indexing through all mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s initialization. 
ioVLsMod 

On output, the date and time of the volume’s last modification. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of the volume attributes returned by this function. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block at which the search for the next new file allocation should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the size of the allocation blocks. 
ioVClpSiz 

On output, the default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of unused allocation blocks. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 

Mac OS X does not support drive numbers; in Mac OS X, the File Manager always returns a value of 1 in this field.
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system handling this volume. 
ioVBkUp 

On output, the date and time of the volume’s last backup. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 

You can get information about all the online volumes by making repeated calls to PBHGetVInfoSync, starting with the value of the ioVolIndex field set to 1 and incrementing that value until PBHGetVInfoSync returns nsvErr.

If you need to obtain information about HFS Plus volumes, you should use the FSGetVolumeInfo function, or one of the corresponding parameter block calls, PBGetVolumeInfoSync and PBGetVolumeInfoAsync. The PBHGetVInfoSync function is still supported for HFS Plus volumes, but there is additional information returned by the FSGetVolumeInfo function (such as the date and time that the volume was last checked for consistency). 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBHGetVInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.

If the value of ioVolIndex is negative, the File Manager uses ioNamePtr and ioVRefNum in the standard way to determine the volume. However, because PBHGetVInfoSync returns the volume name in the buffer whose address you passed in ioNamePtr, your input pathname will be modified. If you don't want your input pathname modified, make a copy of it and pass the copy to PBHGetVInfoSync.

The volume name returned by PBHGetVInfoSync is not a full pathname to the volume because it does not contain a colon.

For compatibility with older programs, some values returned by PBHGetVInfoSync are not what is stored in the volume's Volume Control Block (VCB). Specifically:
ioVNmAlBlks and ioVFrBlk are pinned to values which, when multiplied by ioVAlBlkSiz, are always less than 2 Gigabytes.
ioVNmAlBlks may not include the allocation blocks used by the catalog and extents overflow files. 
$4244 is returned in ioVSigWord for both HFS and HFS Plus volumes. 

For unpinned total and free byte counts, and for the real ioVSigWord, use PBXGetVolInfoSync instead of PBHGetVInfoSync.
Version Notes

In non-Carbon applications, you may pass a working directory reference in the ioVRefNum field; if you pass a working directory reference in that field, the number of files and directories in the specified directory is returned in the ioVNmFls field.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetVInfoSync (
   HParmBlkPtr paramBlock
);

/*FSGetResourceForkName

Returns a Unicode string constant for the name of the resource fork. 

OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
);
Parameters
resourceForkName

On input, a pointer to an HFSUniStr255 structure. On return, this structure contains the Unicode name of the resource fork. Currently, this is “RESOURCE_FORK”. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

There is no parameter block-based form of this call since it is not dispatched to individual volume formats, and does not require any I/O. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetResourceForkName (
   HFSUniStr255 * resourceForkName
);

/*HRename

Renames a file, directory, or volume. (Deprecated in Mac OS X v10.4. Use FSRenameUnicode instead.)

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
oldName

An existing filename, directory name, or volume name. 
newName

The new filename, directory name, or volume name.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Given the name of a file or directory in the oldName parameter, HRename changes it to the name in the newName parameter. Given a volume name in the oldName parameter or a volume reference number in the vRefNum parameter, HRename changes the name of the volume to the name in newName. Access paths currently in use aren’t affected by this function.

If a file ID reference exists for a file you are renaming, the file ID remains with the renamed file.

To rename a file or directory using a long Unicode name, use the FSRenameUnicode function or one of the corresponding parameter block calls, PBRenameUnicodeSync and PBRenameUnicodeAsync. 
Special Considerations

You cannot use HRename to change the directory in which a file resides. To move a file or directory, use the FSpCatMove, PBCatMoveSync, or PBCatMoveAsync functions. 

If you’re renaming a volume, make sure that both names end with a colon.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HRename (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   ConstStr255Param newName
);

/*DirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
parentDirID

The directory ID of the parent directory. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the volume specified in the vRefNum parameter is a volume other than the default volume, the new directory is placed in the root directory of the volume.To create a directory at the root of a volume, regardless of whether that volume is the current default volume, pass the constant fsRtDirID(2) in this parameter. 
directoryName

The name of the new directory. 
createdDirID

On return, a pointer to the directory ID of the new directory. Note that a directory ID, unlike a volume reference number, is a long integer.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The date and time of the new directory’s creation and last modification are set to the current date and time.

To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr DirCreate (
   short vRefNum,
   long parentDirID,
   ConstStr255Param directoryName,
   long * createdDirID
);

/*PBGetEOFSync

Determines the current logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBGetForkSizeSync instead.)

OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On output, a pointer to the logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you’ll need to coerce the value to a long integer to interpret the value correctly. 

To determine the size of a named fork other than the data or resource forks, or of a fork larger than 2 GB, use the FSGetForkSize function, or one of the corresponding parameter block functions, PBGetForkSizeSync and PBGetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetEOFSync (
   ParmBlkPtr paramBlock
);

/*PBXGetVolInfoSync

Returns information about a volume, including size information for volumes up to 2 terabytes. (Deprecated in Mac OS X v10.4. Use FSGetVolumeInfo instead.)

OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
);
Parameters
paramBlock

A pointer to an extended volume parameter block. See XVolumeParam for a description of the XVolumeParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a buffer. You should pass a pointer to a Str31 value if you want the volume name returned; otherwise, pass NULL. If you specify a negative number in the ioVolIndex field, this buffer should hold the name of the volume for which to return information.the volume’s name. On output, a pointer to the volume’s name. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. If the value in the ioVolIndex field is negative, the File Manager uses the name in the ioNamePtr field, along with the value in the ioVRefNum field, to determine the volume. If the value in ioVolIndex is 0, the File Manager attempts to access the volume using only the value in this field.On output, the volume reference number. 
ioXVersion 

On input, the version of the extended volume parameter block. Currently, this value is 0. 
ioVolIndex 

On input, an index used for indexing through all the mounted volumes. If this value is positive, the File Manager uses it to find the volume for which to return information. For instance, if the value of ioVolIndex is 2, the File Manager attempts to access the second mounted volume in the VCB queue.If ioVolIndex is negative, the File Manager uses the values in the ioNamePtr and ioVRefNum fields to access the requested volume. If ioVolIndex is 0, the File Manager uses only the value in the ioVRefNum field. 
ioVCrDate 

On output, the date and time of the volume’s creation (initialization). 
ioVLsMod 

On output, the date and time that the volume was last modified. 
ioVAtrb 

On output, the volume attributes. See Volume Information Attribute Constants for a description of these attributes. 
ioVNmFls 

On output, the number of files in the root directory of the volume. For performance reasons, the Carbon File Manager does not return the number of files in this field; instead, it sets ioVNmFls to 0.To determine the number of files in the root directory of a volume in Carbon, call PBGetCatInfoSync for the root directory. The number of files in the root directory is returned in the ioDrNmFls field. 
ioVBitMap 

On output, the first block of the volume bitmap. 
ioVAllocPtr 

On output, the block where the next new file allocation search should start. 
ioVNmAlBlks 

On output, the number of allocation blocks on the volume. 
ioVAlBlkSiz 

On output, the allocation block size for the volume. 
ioVClpSiz 

On output, the volume’s default clump size. 
ioAlBlSt 

On output, the first block in the volume block map. 
ioVNxtCNID 

On output, the next unused catalog node ID. 
ioVFrBlk 

On output, the number of free (unused) allocation blocks on the volume. 
ioVSigWord 

On output, the volume signature. For HFS volumes, this is ‘BD’ for HFS Plus volumes, this is ‘H+’. 
ioVDrvInfo 

On output, the drive number. You can determine whether the given volume is online by inspecting the value of this field. For online volumes, the ioVDrvInfo field contains the drive number of the drive containing the specified volume and hence is always greater than 0. If the value returned in ioVDrvInfo is 0, the volume is either offline or ejected. 
ioVDRefNum 

On output, the driver reference number. You can determine whether the volume is offline or ejected by inspecting the value of this field. If the volume is offline, the value of ioVDRefNum is the negative of the drive number (which is cleared when the volume is placed offline; hence the ioVDrvInfo field for an offline volume is zero), and is a negative number. If the volume is ejected, the value of ioVDRefNum is the drive number itself, and thus is a positive number. For online volumes, ioVDRefNum contains a driver reference number; these numbers are always less than 0. 
ioVFSID 

On output, the file system ID for the file system handling this volume. 
ioVBkUp 

On output, the date and time that the volume was last backed up. 
ioVSeqNum 

Used internally. 
ioVWrCnt 

On output, the volume write count. 
ioVFilCnt 

On output, the number of files on the volume. 
ioVDirCnt 

On output, the number of directories on the volume. 
ioVFndrInfo 

On output, Finder information for the volume. 
ioVTotalBytes 

On output, the total number of bytes on the volume. 
ioVFreeBytes 

On output, the number of free bytes on the volume. 

The PBXGetVolInfoSync function is similar to the PBHGetVInfoSync function except that it returns additional volume space information in 64-bit integers and does not modify the information copied from the volume’s volume control block (VCB). Systems that support PBXGetVolInfoSync will have the gestaltFSSupports2TBVols bit set in the response returned by the gestaltFSAttr Gestalt selector. See Inside Mac OS X: Gestalt Manager Reference for a description of the gestaltFSAttr selector and of the bits that may be returned in the response. 
Special Considerations

After an operation that changes the amount of free space on the volume—such as deleting a file—there may be a delay before a call to PBXGetVolInfoSync returns the updated amount. This is because the File Manager caches and periodically updates file system information, to reduce the number of calls made to retrieve the information from the file system. Currently, the File Manager updates its information every 15 seconds. This primarily affects NFS volumes. DOS, SMB, UFS and WebDAV volumes were also affected by this in previous versions of Mac OS X, but behave correctly in Mac OS X version 10.3 and later.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBXGetVolInfoSync (
   XVolumeParamPtr paramBlock
);

/*Mounting and Unmounting Volumes
pascal OSErr PBMountVol		(ParmBlkPtr paramBlock);
pascal OSErr PBUnmountVol	(ParmBlkPtr paramBlock);
pascal OSErr PBEject		(ParmBlkPtr paramBlock);
pascal OSErr PBOffLine		(ParmBlkPtr paramBlock);*/
pascal OSErr PBEject		(ParmBlkPtr paramBlock);

/*PBHOpenDenySync

Opens a file’s data fork using the access deny modes.

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenDenySync and PBHOpenRFDenySync functions (or their asynchronous counterparts, PBHOpenDenyAsync and PBHOpenRFDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s resource fork with access deny permissions, use the PBHOpenRFDenySync or PBHOpenRFDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenDenySync (
   HParmBlkPtr paramBlock
);

/*PBGetUGEntrySync

Gets a user or group entry from the list of User and Group names and IDs on a local file server. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetUGEntrySync (
   HParmBlkPtr paramBlock
);

/*PBUnmountVol

Unmounts a volume. (Deprecated in Mac OS X v10.4. Use FSEjectVolumeSync instead.)

OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the VolumeParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to the name of the volume. 
ioVRefNum 

On input, the volume reference number of the volume to unmount, or 0 for the default volume. 

The PBUnmountVol function unmounts the specified volume. All user files on the volume must be closed. Then, PBUnmountVol calls PBFlushVolSync to flush the volume and releases the memory used for the volume.

The PBUnmountVol function always executes synchronously. 
Special Considerations

Don’t unmount the startup volume. Doing so will cause a system crash.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnmountVol (
   ParmBlkPtr paramBlock
);

/*CatMove

Moves files or directories from one directory to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to move. 
oldName

The existing name of the file or directory to move. 
newDirID

If the newName parameter is empty, the directory ID of the destination directory; otherwise, the parent directory ID of the destination directory.
newName

The name of the destination directory. If a valid directory name is provided in this parameter, the destination directory’s parent directory is specified in the newDirID parameter. However, you can specify an empty name for newName, in which case newDirID should be set to the directory ID of the destination directory.

It is usually simplest to specify the destination directory by passing its directory ID in the newDirID parameter and by setting newName to an empty name. To specify an empty name, set newName to ':'.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

CatMove is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk.

The CatMove function cannot move a file or directory to another volume (that is, the vRefNum parameter is used in specifying both the source and the destination). Also, you cannot use it to rename files or directories; to rename a file or directory, use HRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Version Notes

On Mac OS 9, CatMove can change the location of locked files (files whose kHFSFileLockedBit bit is set). On Mac OS X, locked files cannot be moved, and CatMove returns permErr if called on a locked file.

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr CatMove (
   short vRefNum,
   long dirID,
   ConstStr255Param oldName,
   long newDirID,
   ConstStr255Param newName
);

/*PBHSetFLockSync

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to a name for the file or directory to lock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to lock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHSetFLockSync to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. Access paths currently in use aren’t affected. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHSetFLockSync (
   HParmBlkPtr paramBlock
);

/*HSetVol

Sets the default volume and the default directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
);
Parameters
volName

The name of a mounted volume or the partial pathname of a directory. This parameter can be NULL. 
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

A directory ID. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The HSetVol function lets you specify the default directory by volume reference number or by directory ID.

Both the default volume and the default directory are used in calls made with no volume name, a volume reference number of 0, and a directory ID of 0. 
Special Considerations

Use of the HSetVol function is discouraged if your application may execute in system software versions prior to version 7.0. Because the specified directory might not itself be a working directory, HSetVol records the default volume and directory separately, using the volume reference number of the volume and the actual directory ID of the specified directory. Subsequent calls to GetVol (or PBGetVolSync or PBGetVolAsync) return only the volume reference number, which will cause that volume’s root directory (rather than the default directory, as expected) to be accessed. 
Carbon Porting Notes

Carbon applications should use HGetVol and HSetVol to get and set the default directory. the functions GetVol and SetVol, as well as working directories, are no longer supported. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HSetVol (
   ConstStr63Param volName,
   short vRefNum,
   long dirID
);

/*PBSetFPosSync

Sets the position of the file mark. (Deprecated in Mac OS X v10.4. Use PBSetForkPositionSync instead.)

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number for an open file. 
ioPosMode 

On input, a constant indicating how to position the file mark; this field must contain one of the values described in Position Mode Constants. 
ioPosOffset 

On input, the offset from the base location specified by the ioPosMode field for the file mark. If you specify fsAtMark in the ioPosMode field, the mark is left wherever it’s currently positioned and the value in the ioPosOffset field is ignored. If you specify fsFromLEOF, the value in ioPosOffset must be less than or equal to 0. On output, the position at which the mark was actually set. 

The PBSetFPosSync function sets the mark of the specified file to the position specified by the ioPosMode and ioPosOffset fields. If you try to set the mark past the logical end-of-file, PBSetFPosSync moves the mark to the end-of-file and returns eofErr as its function result.

To set the file mark position for a named fork other than the data and resource forks, or to position the file mark at a point more than 2GB into the file, use the FSSetForkPosition function, or one of the corresponding parameter block calls, PBSetForkPositionSync and PBSetForkPositionAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBSetFPosSync (
   ParmBlkPtr paramBlock
);

/*PBHOpenRFDenySync

Opens a file’s resource fork using the access deny modes.

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the AccessParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. The function returns the result code opWrErr if you’ve requested write permission and you have already opened the file for writing in that case, the existing file reference number is returned in ioRefNum. You should not use this reference number unless your application originally opened the file.
Discussion

The relevant fields of the parameter block are:
ioCompletion 

On input, a pointer to a completion function. 
ioResult 

On output, the result code of the function. 
ioNamePtr 

On input, a pointer to a pathname for the file. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the file. Pass 0 to indicate the default volume. 
ioRefNum 

On output, the file reference number for the file. 
ioDenyModes 

On input, the type of access you are requesting to the fork. See File Access Permission Constants for a description of the types of access that you can request. 
ioDirID 

On input, the parent directory ID of the file. 

You should use the PBHOpenRFDenySync and PBHOpenDenySync functions (or their asynchronous counterparts, PBHOpenRFDenyAsync and PBHOpenDenyAsync ) if you want to ensure that you get the access permissions and deny-mode permissions that you request. PBHOpenRFDenySync is not retried in any way. If the file cannot be opened because of a deny conflict, the error afpDenyConflict is returned and the ioRefNum field is set to 0. 

You can check that the volume supports AFP deny-mode permissions by checking that the bHasOpenDeny bit is set in the vMAttrib field returned by the PBHGetVolParmsSync or PBHGetVolParmsAsync function. If you don’t want to special case volumes that support AFP deny mode permissions, you can use the File Manager permissions. See File Access Permission Constants for a description of how File Manager permissions are translated to AFP deny-mode permissions.

To open a file’s data fork with access deny permissions, use the PBHOpenDenySync or PBHOpenDenyAsync function. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHOpenRFDenySync (
   HParmBlkPtr paramBlock
);

/*PBHDeleteSync

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use PBDeleteObjectSync instead.)

OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block.See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, PBHDeleteSync returns the result code fBsyErr. PBHDeleteSync also returns fBsyErr if you attempt to delete a directory that has an open working directory associated with it.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file or directory to delete. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the file or directory to delete. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that file ID reference is also removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHDeleteSync (
   HParmBlkPtr paramBlock
);

/*PBSetEOFSync

Sets the logical size of an open file. (Deprecated in Mac OS X v10.4. Use PBSetForkSizeSync instead.)

OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, a file reference number for the open file. 
ioMisc 

On input, the new logical size (the logical end-of-file) of the given file. Because the ioMisc field is of type Ptr, you must coerce the desired value from a long integer to type Ptr. If the value of the ioMisc field is 0, all space occupied by the file on the volume is released. The file still exists, but it contains 0 bytes. Setting a file fork’s end-of-file to 0 is therefore not the same as deleting the file, which removes both file forks at once. 

If you attempt to set the logical end-of-file beyond the current physical end-of-file, another allocation block is added to the file if there isn’t enough space on the volume, no change is made and PBSetEOFSync returns dskFulErr as its function result.

To ensure that your changes to the file are written to disk, call one of the functions, FlushVol , PBFlushVolSync , or PBFlushVolAsync. To set the size of a named fork other than the data and resource forks, or to grow the size of a file beyond 2GB, you must use the FSSetForkSize function, or one of the corresponding parameter block calls, PBSetForkSizeSync and PBSetForkSizeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetEOFSync (
   ParmBlkPtr paramBlock
);

/*HRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The parent directory ID of the file or directory to unlock. 
fileName

The name of the file or directory. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use HRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file.

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr HRstFLock (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);

/*PBHRstFLockSync

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use PBSetCatalogInfoSync instead.)

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are: 
ioNamePtr 

On input, a pointer to the name for the file or directory to unlock. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the parent directory ID of the file or directory to unlock. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use PBHRstFLockSync to unlock a directory. Otherwise, you can only use this function to unlock a file.

Access paths currently in use aren’t affected by this function. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHRstFLockSync (
   HParmBlkPtr paramBlock
);

/*PBHOpenRFSync

Opens the resource fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. On some file systems, PBHOpenRFSync will return the error eofErr if you try to open the resource fork of a file for which no resource fork exists with read-only access.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open resource fork. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBOpenRFSync function, you will receive an error message. 
Special Considerations

Generally your application should use Resource Manager functions rather than File Manager functions to access a file’s resource fork. The PBHOpenRFSync function does not read the resource map into memory and is generally useful only for applications (such as utilities that copy files) that need block-level access to a resource fork.

You should not use the resource fork of a file to hold non-resource data. Many parts of the system software assume that a resource fork always contains resource data.

Because there is no support for locking and unlocking file ranges on local disks with Carbon on Mac OS X, regardless of whether File Sharing is enabled, you cannot open more than one path to a resource fork with read/ write permission. If you try to open a more than one path to a file's resource fork with fsRdWrShPerm permission, only the first attempt will succeed. Subsequent attempts will return an invalid reference number and the ResError function will return the error opWrErr.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenRFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenRFSync (
   HParmBlkPtr paramBlock
);

/*PBHOpenDFSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. . If you attempt to open a locked file for writing, PBHOpenDFSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

You should use PBHOpenDFSync instead of the PBHOpenSync function; PBHOpenDFSync allows you to safely open a file whose name begins with a period (.).

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, the file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenDFSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

Note that if you wish to access named forks other than the data and resource forks, or forks larger than 2GB, you will need to use the FSOpenFork function, or one of its corresponding parameter block calls, PBOpenForkSync or PBOpenForkAsync. If you try to open a fork larger than 2GB with the PBHOpenDFSync function, you will receive an error message. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenDFSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHOpenDFSync (
   HParmBlkPtr paramBlock
);

/*HDelete

Deletes a file or directory. (Deprecated in Mac OS X v10.4. Use FSDeleteObject instead.)

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);
Parameters
vRefNum

A volume reference number, drive number, or 0 for the default volume. 
dirID

The directory ID of the parent directory of the file or directory to delete. 
fileName

The name of the file or directory to delete. This can be a full or partial pathname. 
Return Value

A result code. See “File Manager Result Codes”. If you attempt to delete an open file or a non-empty directory, HDelete returns the result code fBsyErr. HDelete also returns the result code fBsyErr if the directory has an open working directory associated with it.
Discussion

If the specified target is a file, both the data and the resource fork of the file are deleted. In addition, if a file ID reference for the specified file exists, that reference is removed. A file must be closed before you can delete it. Similarly, you cannot delete a directory unless it’s empty. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr HDelete (
   short vRefNum,
   long dirID,
   ConstStr255Param fileName
);

/*PBHOpenSync

Opens the data fork of a file. (Deprecated in Mac OS X v10.4. Use PBOpenForkSync instead.)

OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HIOParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you attempt to open a locked file for writing, PBHOpenSync returns the result code permErr. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path in ioRefNum and opWrErr as its function result.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioRefNum 

On output, a file reference number for accessing the open data fork. If you request exclusive read/write permission but another access path is already open, PBHOpenSync returns the reference number of the existing access path. You should not use this reference number unless your application originally opened the file. 
ioPermssn 

On input, a constant specifying the type of access with which to open the fork. For a description of the types of access you can request, see File Access Permission Constants.You can open a path for writing even if it accesses a file on a locked volume, and no error is returned until a PBWriteSync, PBSetEOFSync , or PBAllocateSync call is made. 
ioDirID 

On input, the directory ID of the file’s parent directory. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

If you use PBHOpenSync to try to open a file whose name begins with a period, you might mistakenly open a driver instead; subsequent attempts to write data might corrupt data on the target device. To avoid these problems, you should always use PBHOpenDFSync instead of PBHOpenSync. 
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible for more than one process to have the same file open with write permission simultaneously. If your application requests write permission for a file to which another process already has write access, the PBHOpenSync function opens the file and returns noErr. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHOpenSync (
   HParmBlkPtr paramBlock
);

/*PBDTOpenInform

Gets the reference number of the specified desktop database, reporting whether the desktop database was empty when it was opened. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTOpenInform (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTOpenInform fails, it sets this field to 0. 
ioTagInfo 

On output, the return flag (in the low bit of this field). If the desktop database was just created in response to PBDTOpenInform (and is therefore empty), PBDTOpenInform sets the low bit in this field to 0. If the desktop database had been created before you called PBDTOpenInform, PBDTOpenInform sets the low bit in this field to 1. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTOpenInform (
   DTPBPtr paramBlock
);

/*PBGetForeignPrivsSync

Determines the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBGetForeignPrivsSync (
   HParmBlkPtr paramBlock
);

/*PBDTGetAPPLSync

Identifies the application that can open a file with a given creator. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On output, a pointer to the application’s name. 
ioDTRefNum 

On input, the desktop database reference number of the desktop database containing the specified application. 
ioIndex 

On input, an index into the application list. 
ioTagInfo 

On output, the application’s creation date. 
ioFileCreator 

On input, the signature of the application. 
ioAPPLParID 

On output, the application’s parent directory. 

A single call, with the ioIndex field set to 0, finds the application file with the most recent creation date. If you want to retrieve information about all copies of the application with the given signature, start with ioIndex set to 1 and increment this value by 1 with each call to PBDTGetAPPLSync until the result code afpItemNotFound is returned in the ioResult field; when called multiple times in this fashion, PBDTGetAPPLSync returns information about all the application’s copies, including the file with the most recent creation date, in arbitrary order. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBDTGetAPPLSync (
   DTPBPtr paramBlock
);

/*FSpDirCreate

Creates a new directory. (Deprecated in Mac OS X v10.4. Use FSCreateDirectoryUnicode instead.)

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
);
Parameters
spec

A pointer to an FSSpec structure specifying the directory to be created. 

Note that if the parent directory ID for the directory described by this FSSpec is 0 and the volume specified in this FSSpec is the default volume, the new directory is placed in the default directory of the volume. If the parent directory ID is 0 and the specified volume is a volume other than the default volume, the new directory is placed in the root directory of the volume. To create a directory at the root of a volume, regardless of whether that volume is the current default volume, set the parent directory ID to the constant fsRtDirID(2).

scriptTag

The code of the script system in which the directory name is to be displayed. If you have established the name and location of the new directory using either the NavAskSaveChanges or NavCustomAskSaveChanges function, specify the script code returned in the reply structure. Otherwise, specify the system script by setting the scriptTag parameter to the value smSystemScript.

For more information on the functions NavAskSaveChanges and NavCustomAskSaveChanges, see Programming With Navigation Services. For a description of the smSystemScript constant, see the Script Manager Reference.

createdDirID

On return, a pointer to the directory ID of the directory that was created. 
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpDirCreate function sets the date and time of creation and last modification to the current date and time.

Before calling this function, you should call the Gestalt function to check that the function is available. If FSpDirCreate is not available, you can use the function DirCreate instead. To create a directory with a Unicode name, use the function FSCreateDirectoryUnicode , or one of the corresponding parameter block calls, PBCreateDirectoryUnicodeSync and PBCreateDirectoryUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpDirCreate (
   const FSSpec * spec,
   ScriptCode scriptTag,
   long * createdDirID
);

/*PBHSetDirAccessSync

Changes the access control information for a directory.

OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an AccessParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the directory. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioACOwnerID 

On input, the owner ID. 
ioACGroupID 

On input, the group ID. 
ioACAccess 

On input, the directory’s access rights. You cannot set the owner or user rights bits of the ioACAccess field directly; if you try to do this, PBHSetDirAccessSync returns the result code paramErr. Only the blank access privileges can be set for a directory using this function. See File and Folder Access Privilege Constants for more information on directory access privileges. 
ioDirID 

On input, the directory ID. 

To change the owner or group, you should set the ioACOwnerID or ioACGroupID field to the appropriate ID. You must be the owner of the directory to change the owner or group ID. A guest on a server can manipulate the privileges of any directory owned by the guest. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBHSetDirAccessSync (
   HParmBlkPtr paramBlock
);

/*FSpSetFLock

Locks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpSetFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file or directory to lock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync functions indicate that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpSetFLock to lock a directory. Otherwise, you can only use this function to lock a file.

After you lock a file, all new access paths to that file are read-only. This function has no effect on existing access paths. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpSetFLock (
   const FSSpec * spec
);

/*PBHCreateSync

Creates a new file. (Deprecated in Mac OS X v10.4. Use PBCreateFileUnicodeSync instead.)

OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the HFileParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name for the new file. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDirID 

On input, the directory ID of the parent directory of the new file. 
ioFVersNum 

On input, this field should be initialized to zero; if this field is not zero, the call will fall through to the now-obsolete Macintosh File System (MFS) code if the volume accessed is an MFS volume. 

The PBHCreateSync function creates both the data and resource fork of the file the new file is unlocked and empty. The date and time of its creation and last modification are set to the current date and time. If the file created isn’t temporary (that is, if it will exist after the user quits the application), the application should call PBHSetFInfoSync after the call to PBHCreateSync to fill in the information needed by the Finder.

Files created using PBHCreateSync are not automatically opened. If you want to write data to the new file, you must first open the file using one of the file access functions, FSpOpenDF , HOpenDF , PBHOpenDFSync or PBHOpenDFAsync.

The resource fork of the new file exists but is empty. You’ll need to call one of the Resource Manager procedures HCreateResFile or FSpCreateResFile to create a resource map in the file before you can open it (by calling one of the Resource Manager functions HOpenResFile or FSpOpenResFile).

To create a file with a Unicode filename, use the function FSCreateFileUnicode , or one of the corresponding parameter block calls, PBCreateFileUnicodeSync and PBCreateFileUnicodeAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHCreateSync (
   HParmBlkPtr paramBlock
);

/*PBDTGetCommentSync

Retrieves the user comments for a file or directory. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory for which you want to retrieve comments. 
ioDTRefNum 

On input, the desktop database reference number of the database in which the specified file or directory is found. 
ioDTBuffer 

On input, a pointer to a buffer allocated to hold the comment text. On output, a pointer to the comment text. Allocate a buffer at least 255 bytes in size. The PBDTGetCommentSync function places up to ioDTReqCount bytes of the comment into the buffer as a plain text string and places the actual length of the comment in the ioDTActCount field. 
ioDTReqCount 

On input, the size of the buffer allocated to hold the comment. 
ioDTActCount 

On output, the comment size. 
ioDirID 

On input, the parent directory of the file or directory. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetCommentSync (
   DTPBPtr paramBlock
);

/*PBDTGetPath

Gets the reference number of the specified desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetPath (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the volume associated with the desktop database or the full pathname of the desktop database. 
ioVRefName 

On input, the volume reference number of the volume associated with the desktop database. 
ioDTRefNum 

On output, the desktop database reference number, which represents the access path to the database. You cannot use the desktop reference number as a file reference number in any File Manager functions other than the desktop database functions. If PBDTGetPath fails, it sets this field to 0. 

If the desktop database is not already open, PBDTGetPath opens it and then returns the reference number. If the desktop database doesn’t exist, PBDTGetPath creates it . 
Special Considerations

PBDTGetPath allocates memory in the system heap; do not call it at interrupt time.

This function executes synchronously only.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetPath (
   DTPBPtr paramBlock
);

/*FSpRstFLock

Unlocks a file or directory. (Deprecated in Mac OS X v10.4. Use FSSetCatalogInfo instead.)

OSErr FSpRstFLock (
   const FSSpec * spec
);
Parameters
spec

A pointer to an FSSpec structure specifying the file to unlock. See FSSpec for a description of the FSSpec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

If the PBHGetVolParmsSync or PBHGetVolParmsAsync function indicates that the volume supports folder locking (that is, the bHasFolderLock bit of the vMAttrib field is set), you can use FSpRstFLock to unlock a directory. Otherwise, you can only use this function to unlock a file. 

You can lock a file or directory with the FSpSetFLock , HSetFLock , PBHSetFLockSync , and PBHSetFLockAsync functions. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr FSpRstFLock (
   const FSSpec * spec
);

/*PBExchangeFilesSync

Exchanges the data stored in two files on the same volume. (Deprecated in Mac OS X v10.4. Use PBExchangeObjectsSync instead.)

OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the basic HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the first file to swap. 
ioVRefNum 

On input, a volume reference number, drive number, or 0 for the default volume. 
ioDestNamePtr 

On input, a pointer to the name of the second file to swap. 
ioDestDirID 

On input, the second file’s parent directory ID. 
ioSrcDirID 

On input, the first file’s parent directory ID. 

Typically, you use PBExchangeFilesSync after creating a new file during a safe save. The PBExchangeFilesSync function changes the fields in the catalog entries that record the location of the data and the modification dates. It swaps both the data forks and the resource forks.

The PBExchangeFilesSync function works on either open or closed files. PBExchangeFilesSync swaps the data in two files by changing some of the information in the volume catalog. If either file is open, PBExchangeFilesSync updates any file control blocks associated with the file. Exchanging the contents of two files requires essentially the same access privileges as opening both files for writing.

The following fields in the catalog entries for the files are exchanged:
ioFlStBlk 
ioFlLgLen 
ioFlPyLen 
ioFlRStBlk 
ioFlRLgLen 
ioFlRPyLen 
ioFlMdDat 

In the file control blocks, the fcbFlNum, fcbDirID, and fcbCName fields are exchanged.

You should use PBExchangeFilesSync to preserve the file ID when updating an existing file, in case the file is being tracked through its file ID. The PBExchangeFilesSync function does not require that file ID references exist for the files being exchanged.

To exchange the contents of files with named forks other than the data and resource forks, or of files larger than 2 GB, use the FSExchangeObjects , PBExchangeObjectsSync , or PBExchangeObjectsAsync function. 
Special Considerations

Your application will have to swap any open reference numbers to the two files because the file's name and parent directory ID are exchanged in the file control blocks. 

Because other programs may have access paths open to one or both of the files exchanged, your application should have exclusive read/write access permission (fsRdWrPerm) to both files before calling PBExchangeFilesSync. Exclusive read/write access to both files will ensure that PBExchangeFilesSync doesn't affect another application because it prevents other applications from obtaining write access to one or both of the files exchanged.

PBExchangeFilesSync does not respect the file-locked attribute; it will perform the exchange even if one or both of the files are locked. Obtaining exclusive read/write access to both files before calling PBExchangeFilesSync ensures that the files are unlocked because locked files cannot be opened with write access.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBExchangeFilesSync (
   HParmBlkPtr paramBlock
);

/*PBUnshareSync

Makes a share point unavailable on the network. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnshareSync (
   HParmBlkPtr paramBlock
);

/*PBLockRangeSync

Locks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXLockRangeSync or FSLockRange instead.)

OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBLockRangeSync on a file system that does not implement it—for example, SMB—PBLockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to lock. 
ioReqCount 

On input, the number of bytes in the range. Set ioReqCount to –1 to lock the maximum number of bytes from the position specified in the ioPosOffset field. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information about the constants you can use to specify the base location. 

You should not use the fsFromLEOF constant when locking a file range. PBLockRangeSync does not return the start of the locked range; thus, there is no way to determine what range was actually locked when you specify fsFromLEOF.
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBLockRangeSync function locks a portion of a file that was opened with shared read/write permission. The beginning of the range to be locked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be locked is determined by the beginning of the range and the ioReqCount field. For example, to lock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0.

The PBLockRangeSync function uses the same parameters as both PBReadSync and PBWriteSync; by calling it immediately before PBReadSync, you can use the information in the parameter block for the PBReadSync call. For more information about the PBReadSync and PBWriteSync functions, see the Device Manager Reference .

When you’re finished with the data (typically after a call to PBWriteSync), you can call PBUnlockRangeSync to free that portion of the file for subsequent read and write calls. Closing a file also releases all locked ranges in that file.
Special Considerations

The PBLockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a sharable local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set. 
Version Notes

In system software versions 6.0.7 and earlier, specifying ioPosMode as fsFromLEOF results in the wrong byte range being locked. System software version 7.0 fixes this bug.
Carbon Porting Notes

In current releases of Mac OS X (Mac OS X, versions 10.0 - 10.1.x) it is possible to have multiple writers for the same file. Locking a portion of a file with PBLockRangeSync does not guarantee exclusive access to that part of the file. If you call PBLockRangeSync to lock a portion of a file to which another process already has write access, the call will succeed without error. Note that this only affects local volumes; file locking access on AppleShare servers is still supported. For more information, see technote TN2037 at:

http://developer.apple.com/technotes/indexes/fl-a.html

Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBLockRangeSync (
   ParmBlkPtr paramBlock
);

/*PBDTSetCommentSync

Adds a user comment for a file or a directory to the desktop database. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block for this function are:
ioNamePtr 

On input, a pointer to the name of the file or directory. 
ioDTRefNum 

On input, the desktop database reference number for the desktop database to which to add the user comment. 
ioDTBuffer 

On input, a pointer to the buffer containing the comment text. Put the comment in the buffer as a plain text string. 
ioDTReqCount 

On input, the length of the buffer containing the comment text, in bytes. The maximum length of a comment is 200 bytes; longer comments are truncated. Since the comment is a plain text string and not a Pascal string, the File Manager relies on the value in the ioDTReqCount field for determining the length of the buffer. 
ioDirID 

On input, the parent directory ID of the file or directory. 

If the specified object already has a comment in the database, the new comment replaces the old. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTSetCommentSync (
   DTPBPtr paramBlock
);

/*PBDTGetIconSync

Retrieves an icon definition. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
);
Parameters
paramBlock

A pointer to a desktop database parameter block. See DTPBRec for a description of the DTPBRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBDTGetIconSync function returns the bitmap for an icon that represents a file of a given type and creator. For example, to get the icon for a file of file type 'SFWR' created by the application with a signature of 'WAVE', specify these two values in the ioFileType and ioFileCreator fields. 

The relevant fields of the parameter block for this function are:
ioDTRefNum 

On input, the desktop database reference number. 
ioTagInfo 

Reserved; on input, this field must be set to 0. 
ioDTBuffer 

On input, a pointer to a buffer to hold the icon’s data. On return, a pointer to the bitmap returned in the buffer. 
ioDTReqCount 

On input, the requested size of the icon’s bitmap. Pass the size in bytes of the buffer that you’ve allocated for the icon’s bitmap, pointed to by the ioDTBuffer field; this value depends on the icon type. Be sure to allocate enough storage for the icon data; 1024 bytes is the largest amount required for any icon in System 7. You can use the constants described in Icon Size Constants to indicate the amount of memory you have provided for the icon’s data. 
ioDTActCount 

On output, the actual size of the icon’s bitmap. If this value is larger than the value specified in the ioDTReqCount field, only the amount of data allowed by ioDTReqCount is valid. 
ioIconType 

On input, the icon type. For a description of the constants which you can use in this field, see Icon Type Constants. 
ioFileCreator 

On input, the icon’s file creator. 
ioFileType 

On input, the icon’s file type. 
Special Considerations

All of the desktop database functions may move or purge memory blocks in the application heap or for some other reason should not be called from within an interrupt. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBDTGetIconSync (
   DTPBPtr paramBlock
);

/*PBResolveFileIDRefSync

Retrieves the filename and parent directory ID of a file given its file ID.

OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to an FIDParam variant of the HFS parameter block. See HParamBlockRec for more information on the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. A return code of fidNotFound means that the specified file ID reference has become invalid, either because the file was deleted or because the file ID reference was destroyed by PBDeleteFileIDRefSync or PBDeleteFileIDRefAsync.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. If the name string is NULL, PBResolveFileIDRefSync doe s not return the filename, but returns only the parent directory ID of the file in the ioSrcDirID field. If the name string is not NULL but is only a volume name, PBResolveFileIDRefSync ignores the value in the ioVRefNum field and uses the volume name instead. On output, a pointer to the filename of the file with the given file ID. 
ioVRefNum 

On input, a volume specification for the volume containing the file. This field can contain a volume reference number, drive number, or 0 for the default volume. 
ioSrcDirID 

On output, the file’s parent directory ID. 
ioFileID 

On input, a file ID for the file to retrieve information about. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBResolveFileIDRefSync (
   HParmBlkPtr paramBlock
);

/*PBShareSync

Establishes a local volume or directory as a share point. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBShareSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBShareSync (
   HParmBlkPtr paramBlock
);

/*PBDeleteFileIDRefSync

Deletes a file ID reference.

OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the FIDParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

Most applications do not need to use this function. In general, you should track files using alias records, as described in the Alias Manager documentation. The Alias Manager uses file IDs internally as part of its search algorithms for finding the target of an alias record. 

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification for the volume containing the file. 
ioFileID 

On input, the file ID reference to delete. After it has invalidated a file ID reference, the File Manager can no longer resolve that ID reference to a filename and parent directory ID. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBDeleteFileIDRefSync (
   HParmBlkPtr paramBlock
);

/*FSpCatMove

Moves a file or directory from one location to another on the same volume. (Deprecated in Mac OS X v10.4. Use FSMoveObject instead.)

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
);
Parameters
source

A pointer to an FSSpec structure specifying the name and location of the file or directory to move. See FSSpec for a description of the FSSpec data type.
dest

A pointer to an FSSpec structure specifying the name and location of the directory into which the source file or directory is to be moved. The directory ID specified in the parID field of this FSSpec is the directory ID of the parent of the directory into which you want to move the source file or directory. The name field of this FSSpec specifies the name of the directory into which you want to move the source file or directory.

If you don’t already know the parent directory ID of the destination directory, it might be easier to use the PBCatMoveSync or PBCatMoveAsync function, which allow you to specify only the directory ID of the destination directory.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSpCatMove function is strictly a file catalog operation; it does not actually change the location of the file or directory on the disk. You cannot use FSpCatMove to move a file or directory to another volume (that is, the vRefNum field in both FSSpec structures in the source and dest parameters must be the same). Also, you cannot use FSpCatMove to rename files or directories; to rename a file or directory, use FSpRename.

If you need to move files or directories with named forks other than the data and resource forks, with long Unicode names, or files larger than 2GB, you should use the FSMoveObject function, or one of the corresponding parameter block calls, PBMoveObjectSync and PBMoveObjectAsync. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr FSpCatMove (
   const FSSpec * source,
   const FSSpec * dest
);

/*PBHGetLogInInfoSync

Determines the login method used to log on to a particular shared volume. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/

OSErr PBHGetLogInInfoSync (
   HParmBlkPtr paramBlock
);

/*PBFlushFileSync

Writes the contents of a file’s access path buffer to the disk. (Deprecated in Mac OS X v10.4. Use PBFlushForkSync instead.)

OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant field of the parameter block is:
ioRefNum 

On input, a file reference number for the file to flush. 

After writing the contents of the file to the volume, the PBFlushFileSync function updates the file’s entry in the volume catalog.

In the event of a system crash, all cached data not yet written to disk is lost. If you have made changes to space that alreday exists within a file (you are overwriting existing data before the file’s end-of-file), you must use PBFlushFileSync to ensure that everything written to the file will be written to disk. If you flush the fork’s cached blocks using PBFlushFileSync, the only possible data loss in a system crash will be the file’s modification date. 

You do not, however, need to use PBFlushFileSync to flush a file fork before it is closed; the file is automatically flushed when it is closed and all cache blocks associated with it are removed from the cache.

PBFlushFileSync flushes an open fork’s dirty cached blocks, but may not flush catalog information associated with the file. To flush catalog information, call FlushVol , or one of the related parameter block calls, PBFlushVolSync and PBFlushVolAsync. 

To update a file larger than 2GB, or a named fork other than the data and resource forks, you must use the FSFlushFork function, or one of the corresponding parameter block calls, PBFlushForkSync and PBFlushForkAsync. 
Special Considerations

Some information stored on the volume won’t be correct until PBFlushVolSync is called.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBFlushFileSync (
   ParmBlkPtr paramBlock
);

/*PBCatSearchSync

Searches a volume’s catalog file using a set of search criteria that you specify. (Deprecated in Mac OS X v10.4. Use PBCatalogSearchSync instead.)

OSErr PBCatSearchSync (
   CSParamPtr paramBlock
);
Parameters
paramBlock

A pointer to a CSParam variant of an HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. When PBCatSearchSync has searched the entire volume, it returns eofErr. If it exits because it either spends the maximum time allowed in the ioSearchTime field or finds the maximum number of matches allowed in the ioReqMatchCount field, it returns noErr.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the name of the volume to search. 
ioVRefNum 

On input, a volume reference number or drive number for the volume to search; or 0 for the default volume. 
ioMatchPtr 

On input, a pointer to an array of FSSpec structure to hold the matches found by this function. On return, the FSSpec structures in this array identify the files and directories that match the criteria. 
ioReqMatchCount 

On input, the maximum number of matches to return. 
ioActMatchCount 

On output, the actual number of matches returned. 
ioSearchBits 

On input, a bitmap specifying the fields in the criteria structures to match against. See Catalog Search Masks for a description of the bits in this field. 
ioSearchInfo1 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in the structure passed in ioSearchInfo2, and set the matching value in this structure. For values that match against a range (such as dates), set the lower bounds for the range in this structure. 
ioSearchInfo2 

On input, a pointer to a CInfoPBRec union containing search information. For values that match by mask and value (Finder information, for example), set the bits in this structure, and set the matching value in the structure passed in the ioSearchInfo1 field. For values that match against a range (such as dates), set the upper bounds for the range in this structure. 
ioSearchTime 

On input, the maximum allowed search time. If you pass 0 in this field, no time limit is set. 
ioCatPosition 

The current catalog position, specified as a CatPositionRec structure. You can use this field, along with the ioSearchTime field, to search a volume in segments. To search a volume in segments, set a time limit for the search in the ioSearchTime field and set the initialize field of the CatPositionRec structure to the location for the start of the search (0 if you wish to start searching at the beginning of the volume). On return, the catalog position will be updated. You can then pass this updated CatPositionRec structure to the next call to PBCatSearchSync to continue searching at the place where you left off. 
ioOptBuffer 

On input, a pointer to an optional read buffer. 
ioOptBufSize 

On input, the length of the optional read buffer. 

If the catalog file changes between two timed calls to PBCatSearchSync (that is, when you are using ioSearchTime and ioCatPosition to search a volume in segments and the catalog file changes between searches), PBCatSearchSync returns a result code of catChangedErr and no matches. Depending on what has changed on the volume, ioCatPosition might be invalid, most likely by a few entries in one direction or another. You can continue the search, but you risk either skipping some entries or reading some twice. 
Special Considerations

Not all volumes support the PBCatSearchSync function. Before you call PBCatSearchSync to search a particular volume, you should call the PBHGetVolParmsSync function to determine whether that volume supports PBCatSearchSync.If the bHasCatSearch bit is set in the vMAttrib field, then the volume supports PBCatSearchSync.

Even though AFP volumes support PBCatSearchSync, they do not support all of its features that are available on local volumes. These restrictions apply to AFP volumes:
AFP volumes do not use the ioSearchTime field. Current versions of the AppleShare server software search for 1 second or until 4 matches are found. The AppleShare workstation software keeps requesting the appropriate number of matches until the server returns either the number specified in the ioReqMatchCount field or an error.
AFP volumes do not support both logical and physical fork lengths. If you request a search using the length of a fork, the actual minimum length used is the smallest of the values in the logical and physical fields of the ioSearchInfo1 structure and the actual maximum length used is the largest of the values in the logical and physical fields of the ioSearchInfo2 structure.
The fsSBNegate bit of the ioSearchBits field is ignored during searches of remote volumes that support AFP version 2.1.
If the AFP server returns afpCatalogChanged, the catalog position structure returned to your application (in the ioCatPosition field) is the same one you passed to PBCatSearchSync. You should clear the initialize field of that structure to restart the search from the beginning.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBCatSearchSync (
   CSParamPtr paramBlock
);

/*PBHMoveRenameSync

Moves a file or directory and optionally renames it. (Deprecated in Mac OS X v10.4. Use FSMoveObjectSync instead.)

OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to a CopyParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The PBHMoveRenameSync function allows you to move (not copy) a file or directory. The source and destination pathnames must point to the same file server volume. This function is especially useful when you want to copy or move files located on a remote volume, because it allows you to forgo transmitting large amounts of data across a network. This function is used internally by the Finder; most applications do not need to use it.

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to the pathname for the source file or directory. 
ioVRefNum 

On input, a volume reference number or drive number for the volume containing the source file or directory. Pass 0 for the default volume. 
ioNewName 

On input, a pointer to the destination pathname. If ioNewName is NULL, the destination directory is the directory having the ID specified in the ioNewDirID field. If ioNewName is not NULL, the destination directory is the directory having the partial pathname pointed to by ioNewName in the directory having ID ioNewDirID on the specified volume. 
ioCopyName 

On input, a pointer to the file’s new name. The string pointed to by this field must be a filename, not a partial pathname. If you do not wish to rename the file, pass NULL in this field. 
ioNewDirID 

On input, if the ioNewName field is NULL, the directory ID of the destination directory. If ioNewName is not NULL, the parent directory ID of the destination directory. 
ioDirID 

On input, the directory ID of the source directory. 
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBHMoveRenameSync (
   HParmBlkPtr paramBlock
);

/*PBUnlockRangeSync

Unlocks a portion of a file. (Deprecated in Mac OS X v10.4. Use PBXUnlockRangeSync or FSUnlockRange instead.)

OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See ParamBlockRec for a description of the ParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”. If you call PBUnlockRangeSync on a file system that does not implement it—for example, SMB—PBUnlockRangeSync returns noErr and does nothing.
Discussion

The relevant fields of the parameter block are:
ioRefNum 

On input, the file reference number of the file owning the range to unlock. 
ioReqCount 

On input, the number of bytes in the range. 
ioPosMode 

On input, a constant specifying the base location for the start of the locked range. See Position Mode Constants for more information on the constants you can use to indicate the base location. 
ioPosOffset 

On input, the offset from the base location specified in the ioPosMode field for the start of the locked range. 

The PBUnlockRangeSync function unlocks a portion of a file that you locked with PBLockRangeSync or PBLockRangeAsync. The beginning of the range to be unlocked is determined by the ioPosMode and ioPosOffset fields. The end of the range to be unlocked is determined by the beginning of the range and the ioReqCount field. For example, to unlock the first 50 bytes in a file, set ioReqCount to 50, ioPosMode to fsFromStart, and ioPosOffset to 0. The range of bytes to be unlocked must be the exact same range locked by a previous call to PBLockRangeSync or PBLockRangeAsync.

If for some reason you need to unlock a range whose beginning or length is unknown, you can simply close the file. When a file is closed, all locked ranges held by the user are unlocked. 
Special Considerations

The PBUnlockRangeSync function does nothing if the file specified in the ioRefNum field is open with shared read/write permission but is not located on a remote server volume or is not located under a share point on a local volume. To check whether file sharing is currently on, check that the bHasPersonalAccessPrivileges bit in the vMAttrib field of the GetVolParmsInfoBuffer returned by the PBHGetVolParmsSync function is set.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBUnlockRangeSync (
   ParmBlkPtr paramBlock
);

/*PBVolumeMount

Mounts a volume.

OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the IOParam variant of the basic File Manager parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioVRefNum 

On output, a volume reference number for the mounted volume. 
ioBuffer 

On input, a pointer to mounting information. You can use the volume mounting information returned by the PBGetVolMountInfo function or you can use a volume mounting information structure filled in by your application. If you’re mounting an AppleShare volume, place the volume’s AFP mounting information structure in the buffer pointed to by the ioBuffer field. 

This function allows your application to record the mounting information for a volume and then to mount the volume later. 

The PBGetVolMountInfo function does not return the user and volume passwords they’re returned blank. Typically, your application asks the user for any necessary passwords and fills in those fields just before calling PBVolumeMount. If you want to mount a volume with guest status, pass an empty string as the user password.

If you have enough information about the volume, you can fill in the mounting structure yourself and call PBVolumeMount, even if you did not save the mounting information while the volume was mounted. To mount an AFP volume, you must fill in the structure with at least the zone name, server name, user name, user password, and volume password. You can lay out the fields in any order within the data field, as long as you specify the correct offsets.

In general, it is easier to mount remote volumes by creating and then resolving alias records that describe those volumes. The Alias Manager displays the standard user interface for user authentication when resolving alias records for remote volumes. As a result, this function is primarily of interest for applications that need to mount remote volumes with no user interface or with some custom user interface. 
Special Considerations

AFP volumes currently ignore the user authentication method passed in the uamType field of the volume mounting information structure whose address is passed in the ioBuffer field of the parameter block. The most secure available method is used by default, except when a user mounts the volume as Guest and uses the kNoUserAuthentication authentication method.

This function executes synchronously. You should not call it at interrupt time.
Version Notes

The File Sharing workstation software introduced in system software version 7.0 does not currently pass the volume password. The AppleShare 3.0 workstation software does, however, pass the volume password.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr PBVolumeMount (
   ParmBlkPtr paramBlock
);

/*PBSetForeignPrivsSync

Changes the native access-control information for a file or directory stored on a volume managed by a foreign file system. (Deprecated in Mac OS X v10.4. There is no replacement function.)

OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
);
Special Considerations

This function is not implemented in Mac OS X. 
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
Files.h*/
OSErr PBSetForeignPrivsSync (
   HParmBlkPtr paramBlock
);

/*PBHMapIDSync

Determines the name of a user or group given the user or group ID.

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 1 if you’re mapping a user ID to a user name or 2 if you’re mapping a group ID to a group name. See Mapping Code Constants for more information about the values you can use in this field. 
ioObjNamePtr 

On output, a pointer to the user or group name; the maximum size of the name is 31 characters (preceded by a length byte). 
ioObjID 

On input, the user or group ID to be mapped. AppleShare uses the value 0 to signify Any User. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might not need to specify a value in the ioObjType field.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapIDSync (
   HParmBlkPtr paramBlock
);

/*IPBHMapNameSync

Determines the user ID or group ID from a user or group name.

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
);
Parameters
paramBlock

A pointer to the ObjParam variant of the HFS parameter block. See HParamBlockRec for a description of the HParamBlockRec data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ioNamePtr 

On input, a pointer to a pathname. 
ioVRefNum 

On input, a volume specification. 
ioObjType 

On input, the mapping function code its value is 3 if you’re mapping a user name to a user ID or 4 if you’re mapping a group name to a group ID. See Mapping Code Constants for more information on the values you can use in this field. 
ioObjNamePtr 

On input, a pointer to the user or group name. The maximum size of the name is 31 characters. If NULL is passed, the ID returned is always 0. 
ioObjID 

On output, the mapped user or group ID. 
Version Notes

Because user and group IDs are interchangeable under AFP 2.1 and later volumes, you might need to set the ioObjType field to determine which database (user or group) to search first. If both a user and a group have the same name, this field determines which kind of ID you receive.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBHMapNameSync (
   HParmBlkPtr paramBlock
);

/*FSSetForkPosition

Sets the current position of an open fork. 

OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);
Parameters
forkRefNum

The reference number of a fork previously opened by the FSOpenFork, PBOpenForkSync, or PBOpenForkAsync function. 
positionMode

A constant specifying the base location within the fork for the new position. If this parameter is equal to fsAtMark, then the positionOffset parameter is ignored. See Position Mode Constants for a description of the constants you can use to specify the base location. 
positionOffset

The offset of the new position from the base location specified in the positionMode parameter. 
Return Value

A result code. See “File Manager Result Codes”. On Mac OS X, FSSetForkPosition will return the result code posErr if you attempt to set the current position of the fork to an offset before the start of the file. On Mac OS 9, this same attempt will return the result code eofErr.
Special Considerations

To determine if the FSSetForkPosition function is present, call the Gestalt function with the gestaltFSAttr selector. If the FSSetForkPosition function is present, but the volume does not directly support it, the File Manager will automatically call the PBSetFPosSync function. However, if the volume does not directly support the FSSetForkPosition function, you can only set the file position for the data and resource forks, and you cannot grow these files beyond 2GB. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSSetForkPosition (
   SInt16 forkRefNum,
   UInt16 positionMode,
   SInt64 positionOffset
);

/*FSGetForkCBInfo

Returns information about a specified open fork, or about all open forks.

OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
);
Parameters
desiredRefNum

If you want information on a specific fork, set this parameter to that fork’s reference number, and pass NULL in the iterator parameter. If you pass a non-zero value in this parameter, the function attempts to get information on the fork specified by that reference number. 

Pass zero in this parameter to iterate over all open forks. You can limit this iteration to a specific volume with the volume parameter.
volume

The volume to search, when iterating over multiple forks. To iterate over all open forks on a single volume, specify the volume reference number in this parameter. To iterate over all open forks on all volumes, set this parameter to the constant kFSInvalidVolumeRefNum.

This parameter is ignored if you specify a fork reference number in the desiredRefNum parameter. Set desiredRefNum to zero if you wish to iterate over multiple forks.

See FSVolumeRefNum for a description of the FSVolumeRefNum data type.
iterator

A pointer to an iterator. If the desiredRefNum parameter is 0, the iterator maintains state between calls to FSGetForkCBInfo. Set the iterator parameter to 0 before you begin iterating, on the first call to FSGetForkCBInfo. On return, the iterator will be updated; pass this updated iterator in the iterator parameter of the next call to FSIterateForks to continue iterating.
actualRefNum

On return, a pointer to the reference number of the open fork. This parameter is optional if you do not wish to retrieve the fork’s reference number, pass NULL.
forkInfo

On return, a pointer to an FSForkInfo structure containing information about the open fork. This parameter is optional; if you do not wish this information returned, set forkInfo to NULL. See FSForkInfo for a description of the FSForkInfo data type.

On OS X, the value returned by FSGetForkCBInfo in the physicalEOF field of the FSForkInfo structure may differ from the physical file length reported by FSGetCatalogInfo, PBGetCatInfo, and related functions. When a write causes a file to grow in size, the physical length reported by FSGetCatalogInfo and similar calls increases by the clump size, which is a multiple of the allocation block size. However, the physical length returned by FSGetForkCBInfo changes according to the allocation block size and the file lengths returned by the respective functions get out of sync.
ref

On return, a pointer to the FSRef for the file or directory that contains the fork. This parameter is optional; if you do not wish to retrieve the FSRef, set ref to NULL. See FSRef for a description of the FSRef data type.
outForkName

On return, a pointer to the name of the fork. This parameter is optional; if you do not wish the name returned, set outForkName to NULL. See HFSUniStr255 for a description of the HFSUniStr255 data type.
Return Value

A result code. See “File Manager Result Codes”. If you are iterating over multiple forks, the function returns errFSNoMoreItems if there are no more open forks to return.
Discussion

Carbon applications are no longer guaranteed access to the FCB table. Instead, applications should use FSGetForkCBInfo, or one of the related parameter block functions, PBGetForkCBInfoSync and PBGetForkCBInfoAsync , to access information about a fork control block. 
Special Considerations

Returning the fork information in the forkInfo parameter generally does not require a disk access; returning the information in the ref or forkName parameters may cause disk access for some volume formats.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSGetForkCBInfo (
   SInt16 desiredRefNum,
   FSVolumeRefNum volume,
   SInt16 * iterator,
   SInt16 * actualRefNum,
   FSForkInfo * forkInfo,
   FSRef * ref,
   HFSUniStr255 * outForkName
);

/*FSExchangeObjects

Swaps the contents of two files.

OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
);
Parameters
ref

A pointer to an FSRef for the first file. See FSRef for a description of the FSRef data type.
destRef

A pointer to an FSRef for the second file.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The FSExchangeObjects function allows programs to implement a “safe save” operation by creating and writing a complete new file and swapping the contents. An alias, FSSpec, or FSRef that refers to the old file will now access the new data. The corresponding information in in-memory data structures are also exchanged.

Either or both files may have open access paths. After the exchange, the access path will refer to the opposite file’s data (that is, to the same data it originally referred, which is now part of the other file). 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSExchangeObjects (
   const FSRef * ref,
   const FSRef * destRef
);

/*PBMakeFSRefUnicodeSync

Constructs an FSRef for a file or directory, given a parent directory and a Unicode name. 

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
);
Parameters
paramBlock

A pointer to a file system reference parameter block. See FSRefParam for a description of the FSRefParam data type.
Return Value

A result code. See “File Manager Result Codes”.
Discussion

The relevant fields of the parameter block are:
ref 

On input, a pointer to the FSRef of the parent directory of the file or directory for which to create a new FSRef. See FSRef for a description of the FSRef data type. 
nameLength 

On input, the length of the file or directory name. 
name 

On input, a pointer to the Unicode name for the file or directory. The name must be a leaf name; partial or full pathnames are not allowed. If you have a partial or full pathname in Unicode, you will have to parse it yourself and make multiple calls to PBMakeFSRefUnicodeSync. 
textEncodingHint 

On input, the suggested text encoding to use when converting the Unicode name of the file or directory to some other encoding. If you pass the constant kTextEncodingUnknown, the File Manager will use a default value. 
newRef 

On output, if the function returns a result of noErr, a pointer to the new FSRef 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/

OSErr PBMakeFSRefUnicodeSync (
   FSRefParam * paramBlock
);

/*FSMoveObject

Moves a file or directory into a different directory.

OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
);
Parameters
ref

A pointer to an FSRef specifying the file or directory to move. See FSRef for a description of the FSRef data type.
destDirectory

A pointer to an FSRef specifying the directory into which the file or directory indicated by the ref parameter will be moved.
newRef

On return, a pointer to the new FSRef for the file or directory in its new location. This parameter is optional; if you do not wish the FSRef returned, pass NULL.
Return Value

A result code. See “File Manager Result Codes”. If the destDirectory parameter specifies a non-existent object, dirNFErr is returned; if it refers to a file, errFSNotAFolder is returned. If the directory specified in the destDirectory parameter is on a different volume than the file or directory indicated in the ref parameter, diffVolErr is returned.
Discussion

Moving an object may change its FSRef. If you want to continue to refer to the object, you should pass a non- NULL pointer in the newRef parameter and use the FSRef returned there to refer to the object after the move. The original FSRef passed in the ref parameter may or may not be usable after the move. The newRef parameter may point to the same storage as the destDirectory or ref parameters. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSErr FSMoveObject (
   const FSRef * ref,
   const FSRef * destDirectory,
   FSRef * newRef
);

/*FNNotify

Broadcasts notification of changes to the specified directory.

OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
);
Parameters
ref

A file system reference describing the directory for which to broadcast the notification. 
message

An indication of what happened to the target directory.
flags

Options regarding the delivery of the notification. Specify kNilOptions for the default behaviour.
Return Value

A result code. See “File Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
Files.h*/
OSStatus FNNotify (
   const FSRef * ref,
   FNMessage message,
   OptionBits flags
);

/*Maintaining Working Directories
pascal OSErr OpenWD	(short vRefNum, long dirID, long procID, 
			short *wdRefNum);
pascal OSErr CloseWD	(short wdRefNum);
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID);*/
pascal OSErr GetWDInfo	(short wdRefNum, short *vRefNum, long *dirID, 
			long *procID);

/*Manipulating the Default Volume
pascal OSErr GetVol 		(StringPtr volName, short *vRefNum);
pascal OSErr SetVol		(StringPtr volName, short vRefNum);
pascal OSErr HGetVol		(StringPtr volName, short *vRefNum, 
				long *dirID);
pascal OSErr HSetVol		(StringPtr volName, short vRefNum, long dirID);*/
pascal OSErr SetVol		(StringPtr volName, short vRefNum);

#ifdef __cplusplus
}
#endif

#endif
