#ifndef CFSOCKETSTREAM_H
#define CFSOCKETSTREAM_H

#ifndef CFSTREAM_H
#include <CoreFoundation/CFStream.h>
#endif

#ifndef CFHOST_H
#include <CFNetwork/CFHost.h>
#endif

#ifndef CFNETSERVICES_H
#include <CFNetwork/CFNetServices.h>
#endif

#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFStream Property Keys

Constants for CFStream property keys

const CFStringRef kCFStreamPropertyShouldCloseNativeSocket;
const CFStringRef kCFStreamPropertySocketSecurityLevel;
const CFStringRef kCFStreamPropertySOCKSProxy;
const CFStringRef kCFStreamPropertySSLPeerCertificates;
const CFStringRef kCFStreamPropertySSLSettings;
const CFStringRef kCFStreamPropertyProxyLocalByPass;
Constants
kCFStreamPropertyShouldCloseNativeSocket

Should Close Native Socket property key.

If set to kCFBooleanTrue, the stream will close and release the underlying native socket when the stream is released. If set to kCFBooleanFalse, the stream will not close and release the underlying native socket when the stream is released. If a stream is created with a native socket, the default value of this property is kCFBooleanFalse. This property is only available for socket streams. It can be set by calling CFReadStreamSetProperty and CFWriteStreamSetProperty, and it can be copied by CFReadStreamCopyProperty and CFWriteStreamCopyProperty.

Available in Mac OS X v10.2 and later.
kCFStreamPropertySocketNativeHandle

Socket Native Handle property key. 

Causes CFReadStreamCopyProperty or CFWriteStreamCopyProperty to return CFData object that contains the native handle for a socket stream. This property is only available for socket streams.

Available in Mac OS X v10.1 and later.
kCFStreamPropertySocketSecurityLevel

Socket Security Level property key. 

See CFStream Socket Security Level Constants for specific security level constants to use.

Available in Mac OS X v10.2 and later.
kCFStreamPropertySSLPeerCertificates

SSL Peer Certificates property key for copy operations, which return a CFArray object containing SecCertificateRefs. 

For more information, see Security/SecureTransport.h.

Available in Mac OS X v10.4 and later.
kCFStreamPropertySOCKSProxy

SOCKS proxy property key. 

To set a CFStream object to use a SOCKS proxy, call CFReadStreamSetProperty or CFWriteStreamSetProperty with the property name set to kCFStreamPropertySOCKSProxy and its value set to a CFDictionary object having at minimum a kCFStreamPropertySOCKSProxyHost key and a kCFStreamPropertySOCKSProxyPort key. For information on these keys, see CFStream SOCKS Proxy Key Constants. SystemConfiguration returns a CFDictionary for SOCKS proxies that is usable without modification.

Available in Mac OS X v10.2 and later.
kCFStreamPropertySSLSettings

SSL Settings property key for set operations. 

The key’s value is a CFDictionary object containing security settings. For information on the dictionary’s keys and values, see CFStream Property SSL Settings Constants. By default, there are no security settings.

Available in Mac OS X v10.4 and later.
kCFStreamPropertyProxyLocalBypass

Proxy Local Bypass property key. 

The key’s value is CFBoolean object whose value indicates whether local hostnames should be subject to proxy handling.

Available in Mac OS X v10.4 and later.
Declared In
CFNetwork/CFSocketStream.h*/

const CFStringRef kCFStreamPropertyShouldCloseNativeSocket;
const CFStringRef kCFStreamPropertySocketSecurityLevel;
const CFStringRef kCFStreamPropertySOCKSProxy;
const CFStringRef kCFStreamPropertySSLPeerCertificates;
const CFStringRef kCFStreamPropertySSLSettings;
const CFStringRef kCFStreamPropertyProxyLocalByPass;


#ifdef __cplusplus
}
#endif
#endif