#ifndef AUDIOFILE_H
#define AUDIOFILE_H

#include <AvailabilityMacros.h>
#if !defined(__COREAUDIO_USE_FLAT_INCLUDES__)
	#include <CoreAudio/CoreAudioTypes.h>
	#include <CoreServices/CoreServices.h>
#else
	#include <CoreAudioTypes.h>
	#include <CoreServices.h>
#endif

#include <HYS/AudioToolbox/AudioFile.h>
#if defined(__cplusplus)
extern "C"
{
#endif
/*AudioFileTypeAndFormatID

Used by the kAudioGlobalInfo_AvailableStreamDescriptionForFormat property to query for AudioStreamBasicDescriptions based on format and file type.

typedef struct AudioFileTypeAndFormatID{
UInt32 mFileType;
UInt32 mFormatID;
} AudioFileTypeAndFormat;
Discussion

The value of mFileType is a “File Types” value, while mFormatID is from the “Format IDs” in CoreAudioTypes.h.
Constants

Constants are provided for the developer’s convenience. They provide a consistent set of values for various aspects of an audio file.
File Types

These constants are used to specify file types when using functions and structures related to audio files.kAudioFileAIFFType = 'AIFF'
kAudioFileAIFCType = 'AIFC'
kAudioFileWAVEType = 'WAVE'
kAudioFileSoundDesigner2Type = 'Sd2f'
kAudioFileNextType = 'NeXT'
kAudioFileMP3Type = 'MPG3'
kAudioFileAC3Type = 'ac-3'
kAudioFileAAC_ADTSType = 'adts'*/
enum {
kAudioFileAIFFType = 'AIFF',
kAudioFileAIFCType = 'AIFC',
kAudioFileWAVEType = 'WAVE',
kAudioFileSoundDesigner2Type = 'Sd2f',
kAudioFileNextType = 'NeXT',
kAudioFileMP3Type = 'MPG3',
kAudioFileAC3Type = 'ac-3',
kAudioFileAAC_ADTSType = 'adts'
};

/*Audio File Properties

These properties are to be used when getting and setting information about an particular audio file.
kAudioFilePropertyFileFormat = 'ffmt'

Passes a UInt32 that identifies the file’s format, based on the “Format IDs” found in CoreAudioTypes.h.
kAudioFilePropertyDataFormat = 'dfmt'

Passes an AudioStreamBasicDescription that describes the file’s format.
kAudioFilePropertyIsOptimized = 'optm'

Returns a UInt32 with either a value of 0, meaning that the file is not optimized, and therefore, not ready to be written to, or a value of 1, meaning that the file is currently optimized.
kAudioFilePropertyMagicCookieData = 'mgic'

Passes a void pointer towards memory set up for use as a magic cookie.
kAudioFilePropertyAudioDataByteCount = 'bcnt'

Passes a UInt64 that contains the size of the audio data in the file, in bytes.
kAudioFilePropertyAudioDataPacketCount = 'pcnt'

Passes a UInt64 that contains the size of the audio data in the file, in packets.
kAudioFilePropertyMaximumPacketSize = 'psze'

Passes a UInt32 that contains the maximum packet size in the file.
kAudioFilePropertyDataOffset = 'doff'

Passes an SInt64 that contains offset of where the audio data begins inside the file.
kAudioFilePropertyChannelLayout = 'cmap'

Passes an AudioChannelLayout, specified in CoreAudioTypes.h, used in the file.
kAudioFilePropertyDeferSizeUpdates = 'dszu'

Passes a UInt32 where a value of 1 means that the file size information in the file header is updated only when the file is read, optimized, or closed; a value of 0 denotes that the header is updated with every write.
kAudioFilePropertyDataFormatName = 'fnme'

Deprecated in favor of the kAudioFormatProperty_formatName property, available from Audio Format “Audio Format Properties”.*/
enum {
kAudioFilePropertyFileFormat = 'ffmt',
kAudioFilePropertyDataFormat = 'dfmt',
kAudioFilePropertyIsOptimized = 'optm',
kAudioFilePropertyMagicCookieData = 'mgic',
kAudioFilePropertyAudioDataByteCount = 'bcnt',
kAudioFilePropertyAudioDataPacketCount = 'pcnt',
kAudioFilePropertyMaximumPacketSize = 'psze',
kAudioFilePropertyDataOffset = 'doff',
kAudioFilePropertyChannelLayout = 'cmap',
kAudioFilePropertyDeferSizeUpdates = 'dszu',
kAudioFilePropertyDataFormatName = 'fnme'
};

/*Audio File Reference

The Audio File API allows for opening and saving audio files in various formats, for later use.
Audio File Types
Defined Data Types

Typedefs are used to simplify the declaration of converters and the use of properties in the context of an audio file.
typedef struct OpaqueAudioFileID *AudioFileID
typedef UInt32 AudioFilePropertyID
Data Structures*/

typedef struct OpaqueAudioFileID *AudioFileID;
typedef UInt32 AudioFilePropertyID;


/*AudioFileReadPackets

Reads in a certain number of packets from the input file.

extern OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer
);
Discussion

This function reads in the contents of the file by packet, starting at inStartingPoint. The packets that have been read are described in outPacketDescriptions, while the number of packets is specified in ioNumPackets (with the actual number of packets read being the return value), and the size, in bytes, of the read in packets returned in outNumBytes. If the read should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileReadPackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 *outNumBytes,
AudioStreamPacketDescription *outPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *outBuffer);

/*AudioFileGetProperty

Returns the data for the specified property.

extern OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData
);
Discussion

The file and property being queried should be specified in inAudioFile and inPropertyID, respectively, with the size retrieved with AudioFileGetPropertyInfo() passed into ioDataSize, and the resulting data being placed in outPropertyData.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileGetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *ioDataSize,
void *outPropertyData
);

/*AudioFileGetPropertyInfo

Returns the size of the data that will be returned for the property.

extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable
);
Discussion

The file being queried should be passed in as inAudioFile, while the property being queried is passed in as inPropertyID. The size of the resulting data is returned in outDataSize, and isWritable will reflect if the data is modifiable.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileGetPropertyInfo(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 *outDataSize,
UInt32 *isWritable
);

/*AudioFileWritePackets

Writes the buffer to the file, by packets.

extern OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer
);
Discussion

When writing to inAudioFile, specify the starting index as inStartingPacket, the format of the packet as defined in inPacketDescrptions, the size of the write as inNumBytes, and the number of packets to be written in ioNumPackets. If the write should be cached, set inUseCache to true.
Availability
Available in Mac OS X v10.2 and later.
Property Access*/
extern OSStatus AudioFileWritePackets(
AudioFileID inAudioFile,
Boolean inUseCache,
UInt32 inNumBytes,
AudioStreamPacketDescription *inPacketDescriptions,
SInt64 inStartingPacket,
UInt32 *ioNumPackets,
void *inBuffer
);

/*AudioFileCreate

Creates a new file using the descriptions provided.

extern OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile
);
Discussion

The directory that the file to be place into is provided with inParentRef, the name of the file is contained within inFileName, a File Type constant must be provided with inFileType, the format must be specified using inFormat, inFlag contains flags for opening and creating the file (currently undefined; should be set to 0), and outNewFileRef is provided for file system use, while outAudioFile is for use with other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

extern OSStatus AudioFileCreate(
const FSRef *inParentRef,
CFStringRef inFileName,
UInt32 inFileType,
const AudioStreamBasicDescription *inFormat,
UInt32 inFlags,
FSRef *outNewFileRef,
AudioFileID *outAudioFile
);

/*AudioFileSetProperty

Sets the data for the respective property.

extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData
);
Discussion

The file and property being set should be specified in inAudioFile and inPropertyID, respectively, with the size of the data being written passed into ioDataSize, and the data being written coming from inPropertyData.
Availability
Available in Mac OS X v10.2 and later.
Global Info Access*/
extern OSStatus AudioFileSetProperty(
AudioFileID inAudioFile,
AudioFilePropertyID inPropertyID,
UInt32 inDataSize,
const void *inPropertyData
);

/*AudioFileClose

Closes the file.

extern OSStatus AudioFileClose(AudioFileID inAudioFile);
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioFileClose(AudioFileID inAudioFile);

/*AudioFileOpen

Opens a file while preserving its contents.

extern OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile
);
Discussion

The inFileRef should be a reference to an existing file, inPermissions being the permissions for the file, as used by FSOpenFork(), and inFlags, currently undefined, should be set to 0; outAudioFile is a file instance that will be returned for use in other audio file functions.
Availability
Available in Mac OS X v10.2 and later.*/

extern OSStatus AudioFileOpen (
const FSRef *inFileRef,
SInt8 inPermissions,
UInt32 inFlags,
AudioFileID *outAudioFile
);

#ifdef __cplusplus
}
#endif
#endif