#import <AppKit/NSText.h>
#import <HYS/AppKit/NSTextTable.h>

@class NSTextTable;
@class NSLayoutManager;
@class NSTextContainer;




@interface NSTextBlock : NSObject <NSCoding, NSCopying>

/*setWidth:type:forLayer:edge:

Sets the width of a specified edge of a specified layer of the text block.

- (void)setWidth:(float)val type:(NSTextBlockValueType)type forLayer:(NSTextBlockLayer)layer edge:(NSRectEdge)edge
Parameters
val

The new value for the specified edge width.
type

The type of value being provided. This controls how val is interpreted.
layer

The layer of the text block to modify.
edge

The edge of the layer to modify.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setWidth:type:forLayer:
– widthForLayer:edge:*/
- (void)setWidth:(float)val type:(NSTextBlockValueType)type forLayer:(NSTextBlockLayer)layer edge:(NSRectEdge)edge;

/*setWidth:type:forLayer:

Sets the width of all edges of a specified layer of the text block.

- (void)setWidth:(float)val type:(NSTextBlockValueType)type forLayer:(NSTextBlockLayer)layer
Parameters
val

The new value for the specified edge width.
type

The type of value being provided. This controls how val is interpreted.
layer

The layer of the text block to modify.
Availability
Available in Mac OS X v10.4 and later.
See Also
– widthForLayer:edge:
– setWidth:type:forLayer:edge:*/
- (void)setWidth:(float)val type:(NSTextBlockValueType)type forLayer:(NSTextBlockLayer)layer;

/*setVerticalAlignment:

Sets the vertical alignment of the text block.

- (void)setVerticalAlignment:(NSTextBlockVerticalAlignment)alignment
Parameters
alignment

The new vertical alignment for the text block.
Availability
Available in Mac OS X v10.4 and later.
See Also
– verticalAlignment*/
- (void)setVerticalAlignment:(NSTextBlockVerticalAlignment)alignment;

/*setBorderColor:

Sets the color of all borders of the text block.

- (void)setBorderColor:(NSColor *)color
Parameters
color

The new color.
Discussion

This setting has no visible effect unless the border width is larger than the default, which is 0.
Availability
Available in Mac OS X v10.4 and later.
See Also
– borderColorForEdge:
– setBorderColor:forEdge:
– setWidth:type:forLayer:*/
- (void)setBorderColor:(NSColor *)color;

@end

@interface NSTextTableBlock : NSTextBlock

/*initWithTable:startingRow:rowSpan:startingColumn:columnSpan:

Returns an initialized text table block.

- (id)initWithTable:(NSTextTable *)table startingRow:(int)row rowSpan:(int)rowSpan startingColumn:(int)col columnSpan:(int)colSpan
Parameters
table

The text table containing this text table block.
row

The table row at which the text table block starts.
rowSpan

How many rows the text table block covers.
col

The table column at which the text table block starts.
colSpan

How many columns the text table block covers.
Discussion

This is the designated initializer.
Availability
Available in Mac OS X v10.4 and later.*/
- (id)initWithTable:(NSTextTable *)table startingRow:(int)row rowSpan:(int)rowSpan startingColumn:(int)col columnSpan:(int)colSpan;

/*table

Returns the table containing this text table block.

- (NSTextTable *)table
Return Value

The table containing this text table block.
Availability
Available in Mac OS X v10.4 and later.*/
- (NSTextTable *)table;

/*startingRow

Returns the table row at which this text table block starts.

- (int)startingRow
Return Value

The table row at which this text table block starts.
Availability
Available in Mac OS X v10.4 and later.*/
- (int)startingRow;

@end

@interface NSTextTable : NSTextBlock

/*setNumberOfColumns:

Sets the number of columns in the text table.

- (void)setNumberOfColumns:(unsigned)numCols
Parameters
numCols

The new number of columns.
Availability
Available in Mac OS X v10.4 and later.
See Also
– numberOfColumns*/
- (void)setNumberOfColumns:(unsigned)numCols;

/*setLayoutAlgorithm:

Sets the text table layout algorithm.

- (void)setLayoutAlgorithm:(NSTextTableLayoutAlgorithm)algorithm
Parameters
algorithm

The new layout algorithm.
Availability
Available in Mac OS X v10.4 and later.
See Also
– layoutAlgorithm*/
- (void)setLayoutAlgorithm:(NSTextTableLayoutAlgorithm)algorithm;

/*setCollapsesBorders:

Sets whether the text table borders are collapsible.

- (void)setCollapsesBorders:(BOOL)flag
Parameters
flag

YES if the text table borders should be collapsible, NO otherwise.
Availability
Available in Mac OS X v10.4 and later.
See Also
– collapsesBorders*/
- (void)setCollapsesBorders:(BOOL)flag;

/*setHidesEmptyCells:

Sets whether the text table hides empty cells.

- (void)setHidesEmptyCells:(BOOL)flag
Parameters
flag

YES if the text table should hide empty cells, NO otherwise.
Discussion

If empty cells are hidden, locations with empty cells allow the background of the enclosing block or text container to show through.
Availability
Available in Mac OS X v10.4 and later.
See Also
– hidesEmptyCells*/
- (void)setHidesEmptyCells:(BOOL)flag;

@end


