
#import <Foundation/NSDate.h>
#import <AppKit/NSActionCell.h>
#import <HYS/AppKit/NSDatePickerCell.h>

//@class NSCalendar, NSLocale, NSTimeZone;

/*An instance's "datePickerElements" attribute determines which components of its value it considers to be specified/specifiable. This setting is composed by bitwise-ORing together one or more of the "DatePickerElementFlag" values declared in NSDatePickerCell.h. It influences both display and editing behavior, as appropriate for the style of date control in use.
typedef unsigned int NSDatePickerElementFlags;
enum {
    // Time Elements 
    NSHourMinuteDatePickerElementFlag       = 0x000c,
    NSHourMinuteSecondDatePickerElementFlag = 0x000e,
    NSTimeZoneDatePickerElementFlag        = 0x0010,
    // Date Elements 
    NSYearMonthDatePickerElementFlag        = 0x00c0,
    NSYearMonthDayDatePickerElementFlag        = 0x00e0,
    NSEraDatePickerElementFlag            = 0x0100,
};
For a case where the "time" portion of the date value is not of interest, for example, this could be set to NSYearMonthDayDatePickerElementFlag. NSTimeZoneDatePickerElementFlag and NSEraDatePick*/
typedef unsigned int NSDatePickerElementFlags;
enum {
    /* Time Elements */
    NSHourMinuteDatePickerElementFlag       = 0x000c,
    NSHourMinuteSecondDatePickerElementFlag = 0x000e,
    NSTimeZoneDatePickerElementFlag        = 0x0010,
    /* Date Elements */
    NSYearMonthDatePickerElementFlag        = 0x00c0,
    NSYearMonthDayDatePickerElementFlag        = 0x00e0,
    NSEraDatePickerElementFlag            = 0x0100,
};


@interface NSDatePickerCell : NSActionCell
/*delegate

Returns the receiver’s delegate.

- (id)delegate
Return Value

The receiver’s delegate.
Availability
Available in Mac OS X v10.4 and later.
See Also
– setDelegate:*/
- (id)delegate;

@end