@class NSData, NSDictionary, NSEnumerator, NSIndexSet, NSString, NSURL;

@interface NSMutableArray (NSExtendedMutableArray)

/*insertObjects:atIndexes:

Inserts the objects in in a given array into the receiver at the specified indexes.

- (void)insertObjects:(NSArray *)objects atIndexes:(NSIndexSet *)indexes
Parameters
objects

An array of objects to insert into the receiver.
indexes

The indexes at which the objects in objects should be inserted. The count of locations in indexes must equal the count of objects. For more details, see the Discussion.
Discussion

Each object in objects is inserted into the receiver in turn at the corresponding location specified in indexes after earlier insertions have been made. The implementation is conceptually similar to that illustrated in the following example.- void insertObjects:(NSArray *additions) atIndexes:(NSIndexSet *indexes)
{
    int currentIndex = [indexes firstIndex];
    int i, count = [indexes count];
 
    for (i = 0; i < count; i++)
    {
        [self insertObject:[additions objectAtIndex:i] atIndex:currentIndex];
        currentIndex = [indexes indexGreaterThanIndex:currentIndex];
    }
}


The resulting behavior is illustrated by the following example. NSMutableArray *array = [NSMutableArray arrayWithObjects: @"one", @"two", @"three", @"four", nil];
NSArray *newAdditions = [NSArray arrayWithObjects: @"a", @"b", nil];
NSMutableIndexSet *indexes = [NSMutableIndexSet indexSetWithIndex:1];
[indexes addIndex:3];
[array insertObjects:newAdditions atIndexes:indexes];
NSLog(@"array: %@", array);
 
// Output: array: (one, a, two, b, three, four)


The locations specified by indexes may therefore only exceed the bounds of the receiver if one location specifies the count of the array or the count of the array after preceding insertions, and other locations exceeding the bounds do so in a contiguous fashion from that location, as illustrated in the following examples.

In this example, both new objects are appended to the end of the array.NSMutableArray *array = [NSMutableArray arrayWithObjects: @"one", @"two", @"three", @"four", nil];
NSArray *newAdditions = [NSArray arrayWithObjects: @"a", @"b", nil];
NSMutableIndexSet *indexes = [NSMutableIndexSet indexSetWithIndex:5];
[indexes addIndex:4];
[array insertObjects:newAdditions atIndexes:indexes];
NSLog(@"array: %@", array);
 
// Output: array: (one, two, three, four, a, b)


If you replace [indexes addIndex:4] with [indexes addIndex:6] (so that the indexes are 5 and 6), then the application will fail with an out of bounds exception.

In this example, two objects are added into the middle of the array, and another at the current end of the array (index 4) which means that it is third from the end of the modified array.NSMutableArray *array = [NSMutableArray arrayWithObjects: @"one", @"two", @"three", @"four", nil];
NSArray *newAdditions = [NSArray arrayWithObjects: @"a", @"b", @"c", nil];
NSMutableIndexSet *indexes = [NSMutableIndexSet indexSetWithIndex:1];
[indexes addIndex:2];
[indexes addIndex:4];
[array insertObjects:newAdditions atIndexes:indexes];
NSLog(@"array: %@", array);
 
// Output: array: (one, a, b, two, c, three, four)


If you replace [indexes addIndex:4] with [indexes addIndex:6] (so that the indexes are 1, 2, and 6), then the output is (one, a, b, two, three, four, c).
Availability
Available in Mac OS X version 10.4 and later.
See Also
– insertObject:atIndex:*/
- (void)insertObjects:(NSArray *)objects atIndexes:(NSIndexSet *)indexes;

/*removeObjectsAtIndexes:

Removes the objects at the specified indexes from the receiver.

- (void)removeObjectsAtIndexes:(NSIndexSet *)indexes
Parameters
indexes

The indexes of the objects to remove from the receiver. The locations specified by indexes must lie within the bounds of the receiver.
Discussion

This method is similar to removeObjectAtIndex:, but allows you to efficiently remove multiple objects with a single operation. indexes specifies the locations of objects to be removed given the state of the receiver when the method is invoked, as illustrated in the following example.NSMutableArray *array = [NSMutableArray arrayWithObjects: @"one", @"a", @"two", @"b", @"three", @"four", nil];
NSMutableIndexSet *indexes = [NSMutableIndexSet indexSetWithIndex:1];
[indexes addIndex:3];
[array removeObjectsAtIndexes:indexes];
NSLog(@"array: %@", array);
 
// Output: array: (one, two, three, four)

Availability
Available in Mac OS X v10.4 and later.
See Also
– initWithCapacity:
– removeObjectAtIndex:
– removeObject:inRange:*/
- (void)removeObjectsAtIndexes:(NSIndexSet *)indexes;

@end
