<?php
	
	function get_out_value($name)
	{
		global $HTTP_POST_VARS;
		global $HTTP_GET_VARS;

		if ( getenv('REQUEST_METHOD') == 'POST' )
		{
			return $HTTP_POST_VARS[$name];
		}
		else
		{
			return $HTTP_GET_VARS[$name];
		}
	}
	
	function form_to_text($text)
	{
		$string ='';
		$arr = explode("<pre>", $text);
		$count = count($arr);

		$string .= nl2br(stripslashes(htmlspecialchars($arr[0])));
		for ( $i=1 ; $i<$count ; $i++ )
		{
			list($head, $tail) = explode("</pre>", $arr[$i]);
			$head = htmlspecialchars($head);
			$string .= '<pre>'.$head.'</pre>'.nl2br(stripslashes(htmlspecialchars($tail)));
		}
		return $string;
	}
	
	function check_hit($name)
	{
		global $HTTP_COOKIE_VARS;
		$name = str_replace('/', '_', substr($name, 1, strlen($name)));
		$CHECK = $HTTP_COOKIE_VARS[$name];
		if ( $CHECK != "read" )
		{
			setcookie($name, "read");
			return true;
		}
		else return false;
	}
	
	function put_box($text, $bg='white', $bline='black')
	{
		$head_len = 1;
		if ( ord($text[$head_len]) > 128 ) $head_len++;
		return "<table border='0' cellpadding='0' cellspacing='1' bgcolor='".$bline."' width='100%'><tr><td bgcolor='".$bg."'><div style='margin-left:5;margin-right:5;'>".$text."</div></td></tr></table>";
	}
	
	function put_tight_box($text, $bg='white', $bline='black', $align='left')
	{
		$head_len = 1;
		if ( ord($text[$head_len]) > 128 ) $head_len++;
		return "<table border='0' cellpadding='0' cellspacing='1' align='".$align."' bgcolor='".$bline."'><tr><td bgcolor='".$bg."'>".$text."</td></tr></table>";
	}
	
	function put_headpoint($text, $hcolor, $hsize)
	{
		$head_len = 1;
		if ( ord($text[$head_len]) > 128 ) $head_len++;
		return "<font color='$hcolor' style='FONT-SIZE: ".$hsize."pt'><b>".substr($text, 0, $head_len)."</b></font>".substr($text, $head_len, strlen($text));
	}
	
	function mkpage($page, $totalpage, $lnkaddr)
	{
		$pagelnk="";

		if ( $totalpage == 0 ) return "not exist page";

		if ( empty($page) )
		{
			$page = $totalpage;
		}

		if($totalpage>10)
		{
			$pgsn = $page+4;
			$pgen = $page-4;

			if($pgsn>$totalpage)
			{
				$pgen = $pgen - ($pgsn - $totalpage);
				$pgsn = $totalpage;
			}
			else if($pgen<1){
				$pgsn = $pgsn - $pgen;
				$pgen = 1;
			}

			if($pgsn>$totalpage) $pgsn=$totalpage;

			if($pgen<1) $pgen=1;
		}
		else {
			$pgsn=$totalpage;
			$pgen=1;
		}

		if($page != $totalpage)
		{
			$back=$page+1;
			$pagelnk.= "<a href=\"$lnkaddr&page=$back\"></a>";
		}
		if($pgsn != $totalpage) $pagelnk.="[...]";
		for($p=$pgsn; $p>$pgen-1; $p--)
		{
			if($p == $page) $pagelnk.="<b>[$p]</b>";
			else $pagelnk.="<a href=\"$lnkaddr&page=$p\">[$p]</a>";
		}

		if($pgen != "1") $pagelnk.="[...]";
		if($page != "1"){
			$next=$page-1;
			$pagelnk.="<a href=\"$lnkaddr&page=$next\"></a>";
		}
		return $pagelnk;
	}
	
	function mizzle_kcut($my_subject, $subject_length)
	{
		$my_subject_length = strlen($my_subject);
		if($my_subject_length > $subject_length)
		{
			$kor_num = 0;
			for($k = 0; $k < $subject_length; $k++)
			{
				if(ord(substr($my_subject_temp, $k, 1)) > 128)
				{
					$kor_num++;
				}
			}

			if(ord(substr($my_subject_temp, $subject_length, 1)) > 128)
			{
				if(($kor_num % 2) != 0)
				{
					$subject_length--;
				}
			}
			$my_subject = substr($my_subject, 0, $subject_length);
			$my_subject = chop($my_subject) . "...";
		}
		return $my_subject;
	}
	
	function html_to_form($text)
	{
		return str_replace('\'', '&#39;', stripslashes(htmlspecialchars($text)));
	}
?>