// PlaySound.cpp: implementation of the CPlaySound class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "magmatv.h"
#include "mmsystem.h"
#include "PlaySound.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

static ULONG __stdcall PlaySoundThread(void *arg)
{
	CString *pFileName = (CString *)arg;
	PlaySound((LPCTSTR)*pFileName, NULL, SND_FILENAME | SND_ASYNC | SND_NODEFAULT); 
	delete pFileName;
	return 0;
}

CPlaySound::CPlaySound()
{
	m_dwPlayThreadId = 0;
	m_hdlPlayThread = NULL;
}

CPlaySound::~CPlaySound()
{

}

void CPlaySound::Play(CString strFileName)
{
	if (m_hdlPlayThread != NULL)
		Stop();

	CString *pFileName = new CString(strFileName);

	m_hdlPlayThread = CreateThread(
		NULL,                       // default security attributes 
		0,                          // use default stack size  
		PlaySoundThread,			// thread function 
		(void *)pFileName,			// argument to thread function 
		0,                          // use default creation flags 
		&m_dwPlayThreadId);			// returns the thread identifier
}

void CPlaySound::Stop()
{
	if (m_hdlPlayThread != NULL)
		TerminateThread(m_hdlPlayThread, 0);
}
