// $Id: MagmaTVDlg.cpp,v 1.12 2004/04/28 15:00:06 perky Exp $
//
// Copyright (C) 2004 Hye-Shik Chang. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//

#include "stdafx.h"
#include "MagmaTV.h"
#include "MagmaTVDlg.h"
#include "..\MagmaDLL\MagmaDLL.h"//Include this for functions in the DLL.
#include "ExitWindows.h"
#include "Configuration.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define SIGMATV_CLASSNAME	_T("SIGMATV")

#define WM_SIGMAWNDMSG		(WM_USER + 755)

#define TM_POSUPDATE		(WM_USER + 755)
#define TM_OFF5MIN			(WM_USER + 756)
#define TM_OFF10SEC			(WM_USER + 757)
#define POSUPDATE_DELAY		2000
#define OFF5MIN_DELAY		285000
#define OFF10SEC_DELAY		15000

static const char* kpcTrayNotificationMsg = "MagmaTV Message";

#define IDWAVE_TURNOFF10SEC		0
#define IDWAVE_TURNOFF5MIN		1
#define IDWAVE_CANCELED			2
#define IDWAVE_MAX				3


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMagmaTVDlg dialog

CMagmaTVDlg::CMagmaTVDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMagmaTVDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMagmaTVDlg)
	m_hooked = FALSE;
	m_sigmatv_aot = FALSE;
	m_use_voice = FALSE;
	m_voice_type = -1;
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_pTrayIcon = NULL;
	m_nTrayNotificationMsg = RegisterWindowMessage(kpcTrayNotificationMsg);
	m_bTrayMinimized = FALSE;
	m_bOffTriggered = FALSE;
}

void CMagmaTVDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMagmaTVDlg)
	DDX_Check(pDX, IDC_USE_HOOK, m_hooked);
	DDX_Check(pDX, IDC_SIGMATV_AOT, m_sigmatv_aot);
	DDX_Check(pDX, IDC_USE_VOICE, m_use_voice);
	DDX_CBIndex(pDX, IDC_VOICE_TYPE, m_voice_type);
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_COMMAND_1, m_command[0]);
	DDX_Text(pDX, IDC_COMMAND_2, m_command[1]);
	DDX_Text(pDX, IDC_COMMAND_3, m_command[2]);
	DDX_Text(pDX, IDC_COMMAND_4, m_command[3]);
	DDX_Text(pDX, IDC_COMMAND_5, m_command[4]);
	DDX_Text(pDX, IDC_COMMAND_6, m_command[5]);
	DDX_Text(pDX, IDC_COMMAND_7, m_command[6]);
	DDX_Text(pDX, IDC_COMMAND_8, m_command[7]);
	DDX_Text(pDX, IDC_COMMAND_9, m_command[8]);
	DDX_CBIndex(pDX, IDC_USAGE_1, m_usage[0]);
	DDX_CBIndex(pDX, IDC_USAGE_2, m_usage[1]);
	DDX_CBIndex(pDX, IDC_USAGE_3, m_usage[2]);
	DDX_CBIndex(pDX, IDC_USAGE_4, m_usage[3]);
	DDX_CBIndex(pDX, IDC_USAGE_5, m_usage[4]);
	DDX_CBIndex(pDX, IDC_USAGE_6, m_usage[5]);
	DDX_CBIndex(pDX, IDC_USAGE_7, m_usage[6]);
	DDX_CBIndex(pDX, IDC_USAGE_8, m_usage[7]);
	DDX_CBIndex(pDX, IDC_USAGE_9, m_usage[8]);
}

BEGIN_MESSAGE_MAP(CMagmaTVDlg, CDialog)
	//{{AFX_MSG_MAP(CMagmaTVDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_USE_HOOK, OnToggleHook)
	ON_EN_CHANGE(IDC_COMMAND_1, OnChangeCommand1)
	ON_EN_CHANGE(IDC_COMMAND_2, OnChangeCommand2)
	ON_EN_CHANGE(IDC_COMMAND_3, OnChangeCommand3)
	ON_EN_CHANGE(IDC_COMMAND_4, OnChangeCommand4)
	ON_EN_CHANGE(IDC_COMMAND_5, OnChangeCommand5)
	ON_EN_CHANGE(IDC_COMMAND_6, OnChangeCommand6)
	ON_EN_CHANGE(IDC_COMMAND_7, OnChangeCommand7)
	ON_EN_CHANGE(IDC_COMMAND_8, OnChangeCommand8)
	ON_EN_CHANGE(IDC_COMMAND_9, OnChangeCommand9)
	ON_CBN_SELCHANGE(IDC_USAGE_1, OnSelchangeUsage1)
	ON_CBN_SELCHANGE(IDC_USAGE_2, OnSelchangeUsage2)
	ON_CBN_SELCHANGE(IDC_USAGE_3, OnSelchangeUsage3)
	ON_CBN_SELCHANGE(IDC_USAGE_4, OnSelchangeUsage4)
	ON_CBN_SELCHANGE(IDC_USAGE_5, OnSelchangeUsage5)
	ON_CBN_SELCHANGE(IDC_USAGE_6, OnSelchangeUsage6)
	ON_CBN_SELCHANGE(IDC_USAGE_7, OnSelchangeUsage7)
	ON_CBN_SELCHANGE(IDC_USAGE_8, OnSelchangeUsage8)
	ON_CBN_SELCHANGE(IDC_USAGE_9, OnSelchangeUsage9)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_SIGMATV_AOT, OnSigmaTVAOT)
	ON_WM_DESTROY()
	ON_COMMAND(IDM_RESTORE, OnRestore)
	ON_COMMAND(IDM_EXIT, OnExit)
	ON_COMMAND(IDM_ABOUT, OnAbout)
	ON_BN_CLICKED(IDC_USE_VOICE, OnUseVoice)
	ON_CBN_SELCHANGE(IDC_VOICE_TYPE, OnSelchangeVoiceType)
	ON_BN_CLICKED(IDC_HIDE, OnHide)
	ON_MESSAGE(WM_SIGMAWNDMSG, ProcessSigmaMsg)
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMagmaTVDlg message handlers

BOOL CMagmaTVDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL) {
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty()) {
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_pTrayIcon = new CSystemTray;
	m_pTrayIcon->Create(0, m_nTrayNotificationMsg, _T("MagmaTV"),
						m_hIcon, IDR_SYSTRAY_MENU);

	const static int nMsgId[] = {
		IDS_USAGEMSG_0, IDS_USAGEMSG_1, IDS_USAGEMSG_2,
		IDS_USAGEMSG_3, IDS_USAGEMSG_4, IDS_USAGEMSG_5,
		0,
	};
	int i, j;
	for (i = 0; nMsgId[i]; i++) {
		CString strMsg;
		strMsg.LoadString(nMsgId[i]);
		for (j = 0; j < N_KEYS; j++) {
			CComboBox *pCombo;
			pCombo = (CComboBox *)GetDlgItem(g_keyinfo[j].dwComboCtlId);
			pCombo->AddString((LPCTSTR)strMsg);
		}
	}

	LoadConfig();

	if (ApplyHook(m_hooked) == -1) {
		m_hooked = FALSE;
		UpdateData(FALSE);
	}
	ApplyAvailabilities();
	OnUseVoice();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMagmaTVDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if (nID == SC_MINIMIZE || nID == SC_CLOSE)
	{
		m_bTrayMinimized = TRUE;
		ShowWindow(SW_HIDE);
	}
	else if (nID == SC_RESTORE)
	{
		m_bTrayMinimized = FALSE;
		ShowWindow(SW_RESTORE);
		ShowWindow(SW_SHOWNORMAL);
	}
	else if ((nID & 0xFFF0) == IDM_ABOUTBOX) {
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else {
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CMagmaTVDlg::OnPaint() 
{
	if (IsIconic()) {
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else {
		CDialog::OnPaint();
	}
}

HCURSOR CMagmaTVDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CMagmaTVDlg::OnToggleHook()
{
	UpdateData(TRUE);

	if (ApplyHook(m_hooked) == -1)
		m_hooked = FALSE;

	UpdateData(FALSE);
}

void CMagmaTVDlg::OnCancel()
{
	if (m_hooked)
		(void)RemoveHook();

	SaveConfig();

	CDialog::OnCancel();
}

LRESULT CMagmaTVDlg::ProcessSigmaMsg(WPARAM wParam, LPARAM lParam)
{
	DWORD dwMsg = (DWORD)wParam & 0x0fff;

	if (dwMsg == WM_PAINT) {
		UpdatePosTimer();
		return 0L;
	}

	if (dwMsg == WM_CHAR && m_bOffTriggered) {
canceled:
		KillTimer(TM_OFF10SEC);
		KillTimer(TM_OFF5MIN);
		m_bOffTriggered = FALSE;
		PlaySound(IDWAVE_CANCELED);
		return 0L;
	}

	for (int i = 0; i < N_KEYS; i++) {
		if (g_keyinfo[i].dwMessageNumber == dwMsg) {
			if (m_bOffTriggered)
				goto canceled;

			switch (m_usage[i]) {
			case KEYBEHAV_NONE:
				break;
			case KEYBEHAV_CHANNEL:
				{
					HWND hWnd;

					hWnd = FindSigmaWindow();
					if (hWnd == NULL)
						break;

					for (int j = 0; j < m_command[i].GetLength(); j++) {
						TCHAR ch = m_command[i].GetAt(j);
						::SendMessage(hWnd, WM_CHAR, (WPARAM)ch, (LPARAM)1);
					}
				}
				break;
			case KEYBEHAV_RUNCMD:
				WinExec((LPCSTR)m_command[i], SW_SHOW);
				break;
			case KEYBEHAV_TURNOFF:
				{
					CExitWindows exitWindows;
					exitWindows.ForceShutDown();
				}
				break;
			case KEYBEHAV_TURNOFF_AFTER15SEC:
				TriggerOff10Sec();
				break;
			case KEYBEHAV_TURNOFF_AFTER5MIN:
				TriggerOff5Min();
				break;
			default:
				abort();
			}
		}
	}

	return 0L;
}

int CMagmaTVDlg::ApplyHook(BOOL bHook)
{
	if (bHook) {
		HWND hWnd;
		DWORD dwThreadId;

		hWnd = FindSigmaWindow();
		if (hWnd == NULL)
			return -1;
		dwThreadId = GetWindowThreadProcessId(hWnd, NULL);

		if (InstallHook(this->GetSafeHwnd(), dwThreadId) != 0) {
			::AfxMessageBox(IDS_CANTFINDSIGMA);
			return -1;
		}
	}
	else
		(void)RemoveHook();

	return 0;
}

void CMagmaTVDlg::LoadConfig()
{
	Config.Load();
	for (int i = 0; i < N_KEYS; i++) {
		m_command[i] = Config.strCommandLine[i];
		m_usage[i] = Config.eButtonBehavior[i];
	}
	m_hooked = Config.bEnabled;
	m_sigmatv_aot = Config.bSigmaAlwaysOnTop;
	m_use_voice = Config.bVoiceEnabled;
	m_voice_type = Config.nVoiceType;

	UpdateData(FALSE);
}

void CMagmaTVDlg::SaveConfig()
{
	UpdateData(TRUE);

	Config.bEnabled = m_hooked;
	for (int i = 0; i < N_KEYS; i++) {
		Config.eButtonBehavior[i] = m_usage[i];
		Config.strCommandLine[i] = m_command[i];
	}
	Config.bSigmaAlwaysOnTop = m_sigmatv_aot;
	Config.bVoiceEnabled = m_use_voice;
	Config.nVoiceType = m_voice_type;
}

void CMagmaTVDlg::ApplyAvailabilities()
{
	UpdateData(TRUE);

	for (int i = 0; i < N_KEYS; i++) {
		BOOL bEnabled = (m_usage[i] == 1 || m_usage[i] == 2);
		GetDlgItem(g_keyinfo[i].dwEditCtlId)->EnableWindow(bEnabled);
	}

	UpdateData(FALSE);
}

#define DEF_CHANGECOMMAND(n) \
	void CMagmaTVDlg::OnChangeCommand##n() { UpdateCommand(n - 1); }
DEF_CHANGECOMMAND(1)	DEF_CHANGECOMMAND(2)	DEF_CHANGECOMMAND(3)
DEF_CHANGECOMMAND(4)	DEF_CHANGECOMMAND(5)	DEF_CHANGECOMMAND(6)
DEF_CHANGECOMMAND(7)	DEF_CHANGECOMMAND(8)	DEF_CHANGECOMMAND(9)
#undef DEF_CHANGECOMMAND

void CMagmaTVDlg::UpdateCommand(int nId)
{
	CString strItemText;
	GetDlgItemText(g_keyinfo[nId].dwEditCtlId, strItemText);
	m_command[nId] = strItemText;
}

#define DEF_CHANGEUSAGE(n) \
	void CMagmaTVDlg::OnSelchangeUsage##n() { UpdateUsage(n - 1); }
DEF_CHANGEUSAGE(1)	DEF_CHANGEUSAGE(2)	DEF_CHANGEUSAGE(3)
DEF_CHANGEUSAGE(4)	DEF_CHANGEUSAGE(5)	DEF_CHANGEUSAGE(6)
DEF_CHANGEUSAGE(7)	DEF_CHANGEUSAGE(8)	DEF_CHANGEUSAGE(9)
#undef DEF_CHANGEUSAGE

void CMagmaTVDlg::UpdateUsage(int nId)
{
	CComboBox *pCtl;
	pCtl = (CComboBox *) GetDlgItem(g_keyinfo[nId].dwComboCtlId);
	m_usage[nId] = pCtl->GetCurSel();
	ApplyAvailabilities();
}

HWND CMagmaTVDlg::FindSigmaWindow()
{
	HWND hWnd;

	hWnd = ::FindWindow(SIGMATV_CLASSNAME, NULL);
	if (hWnd == NULL) {
		::AfxMessageBox(IDS_CANTFINDSIGMA);
		return (HWND)0;
	}
	return hWnd;
}

void CMagmaTVDlg::UpdatePosTimer()
{
	//KillTimer(TM_POSUPDATE);
	SetTimer(TM_POSUPDATE, POSUPDATE_DELAY, NULL);
}

void CMagmaTVDlg::OnTimer(UINT nIDEvent) 
{
	if (m_sigmatv_aot && nIDEvent == TM_POSUPDATE) {
		HWND hWnd;

		KillTimer(TM_POSUPDATE);
		hWnd = ::FindWindow(_T("Sigma Window"), NULL);
		if (hWnd == NULL)
			return;

		RECT rect;
		::GetWindowRect(hWnd, &rect);
		::SetWindowPos(hWnd, HWND_TOPMOST, rect.left, rect.top,
						rect.right - rect.left, rect.bottom - rect.top,
						SWP_SHOWWINDOW);
	}
	else if (nIDEvent == TM_OFF5MIN)
		TriggerOff10Sec();
	else if (nIDEvent == TM_OFF10SEC) {
		KillTimer(TM_OFF10SEC);
		CExitWindows exitWindows;
		exitWindows.ForceShutDown();
	}
	
	CDialog::OnTimer(nIDEvent);
}

void CMagmaTVDlg::OnSigmaTVAOT() 
{
	UpdateData(TRUE);
}

void CMagmaTVDlg::OnDestroy() 
{
	CDialog::OnDestroy();

	m_bTrayMinimized = FALSE;
	delete m_pTrayIcon;	
}

void CMagmaTVDlg::OnRestore() 
{
	if (m_bTrayMinimized)
	{
		ShowWindow(SW_RESTORE);
		ShowWindow(SW_SHOWNORMAL);
		m_bTrayMinimized = FALSE;
	} else {
		//ShowWindow(SW_MINIMIZE);
		ShowWindow(SW_HIDE);
		m_bTrayMinimized = TRUE;
	}
}

void CMagmaTVDlg::OnExit() 
{
	SendMessage(WM_CLOSE, 0, 0);	
}

void CMagmaTVDlg::OnAbout() 
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

void CMagmaTVDlg::OnUseVoice() 
{
	UpdateData(TRUE);
	GetDlgItem(IDC_VOICE_TYPE)->EnableWindow(m_use_voice);
	GetDlgItem(IDC_PLAY)->EnableWindow(m_use_voice);
}

void CMagmaTVDlg::OnSelchangeVoiceType() 
{
	CComboBox *pCtl;
	pCtl = (CComboBox *) GetDlgItem(IDC_VOICE_TYPE);
	m_voice_type = pCtl->GetCurSel();
}

void CMagmaTVDlg::OnHide()
{
	ShowWindow(SW_HIDE);
	m_bTrayMinimized = TRUE;
}

void CMagmaTVDlg::PlaySound(int nVoiceId)
{
	static const char *kpcWaveName[] = {
		"10sec", "5min", "cancel",
	};
	static const char *kpcWaveVoiceName[] = {
		"soonsu", "rina", "puring", "oxygen", "zzingeut", "rath"
	};

	if (m_use_voice) {
		CString strFileName;

		strFileName.Format(_T("%s\\%s-%s.wav"), (LPCTSTR)((CMagmaTVApp *)AfxGetApp())->m_strProgramPath,
							kpcWaveVoiceName[m_voice_type], kpcWaveName[nVoiceId]);
		m_PlaySound.Play(strFileName);
	}
}

void CMagmaTVDlg::OnPlay() 
{
	static int nVoiceIdSel = 0, nVoiceTypeLastPlayed = -1;

	UpdateData(TRUE);
	if (nVoiceTypeLastPlayed == m_voice_type)
		nVoiceIdSel = (nVoiceIdSel + 1) % IDWAVE_MAX;
	else
		nVoiceIdSel = 0;
	nVoiceTypeLastPlayed = m_voice_type;
	PlaySound(nVoiceIdSel);
}

void CMagmaTVDlg::TriggerOff5Min()
{
	KillTimer(TM_OFF5MIN);
	KillTimer(TM_OFF10SEC);
	SetTimer(TM_OFF5MIN, OFF5MIN_DELAY, NULL);
	m_bOffTriggered = TRUE;
	PlaySound(IDWAVE_TURNOFF5MIN);
}

void CMagmaTVDlg::TriggerOff10Sec()
{
	KillTimer(TM_OFF5MIN);
	KillTimer(TM_OFF10SEC);
	SetTimer(TM_OFF10SEC, OFF10SEC_DELAY, NULL);
	m_bOffTriggered = TRUE;
	PlaySound(IDWAVE_TURNOFF10SEC);
}
