package net.kldp.j2ee.kupload;

import java.util.Enumeration;
import java.util.Hashtable;

/**
 * 파일이 아닌 Form내의 일반 필드값을 보관하는 클래스. request.getParamer와 호환된다.
 * 
 */
public class Parameters {
	private Hashtable<String, Hashtable<Integer, String>> parameters = new Hashtable<String, Hashtable<Integer, String>>();
	private int count = 0;

	/**
	 * 파라미터를 입력한다.
	 * @param name
	 * @param value
	 */
	protected void putParameter(String name, String value) {
		if (name == null)
			throw new IllegalArgumentException("The name of an element cannot be null.");
		if (parameters.containsKey(name)) {
			Hashtable<Integer, String> values = parameters.get(name);
			values.put(new Integer(values.size()), value);
		} else {
			Hashtable<Integer, String> values = new Hashtable<Integer, String>();
			values.put(new Integer(0), value);
			parameters.put(name, values);
			count++;
		}
	}

	/**
	 * 파라미터를 리턴한다.
	 * 
	 * @param name
	 * @return parameter
	 */
	public String getParameter(String name) {
		if (name == null)
			throw new IllegalArgumentException("Form's name is invalid or does not exist (1305).");
		Hashtable<Integer, String> values = parameters.get(name);
		if (values == null)
			return null;
		else
			return values.get(new Integer(0));
	}

	/**
	 * 파라미터의 Enumeration을 리턴한다.
	 * 
	 * @return parameterNames
	 */
	public Enumeration<String> getParameterNames() {
		return parameters.keys();
	}

	/**
	 * 파라미터를 배열로 리턴한다.
	 * 
	 * @param name
	 * @return parameters
	 */
	public String[] getParameterValues(String name) {
		if (name == null)
			throw new IllegalArgumentException("Form's name is invalid or does not exist (1305).");
		Hashtable<Integer, String> values = parameters.get(name);
		if (values == null)
			return null;
		String strValues[] = new String[values.size()];
		for (int i = 0; i < values.size(); i++)
			strValues[i] = values.get(new Integer(i));
		return strValues;
	}
}