/**
 *    ó.
 * ¼ мⰡ ߰Ϸ ó ʼ̴.  ϴ online   ٷ鼭 ¼ мⰡ  
 *  óؾ Ǵ 찡 . ̰ ó⿡ Է   óָ ¼ м⿡   ùٸ  
 *  ִ. ó⿡ ַ ϴ  屸̴. , Է    ̴.  屸п ؼ
 * ַ ǿ Ǿ. Ư  ħǥ(.)    Ǵ°   ٸ ǹ̷ Ǵ°  
 * . ⿡ 屸   ִ Ưȣ ¿ ڿ    ϴ  ó⸦ Ѵ.
 * 
 * ũ 屸   ִ Ưȣ ǥ(?), ǥ(!), ħǥ(.)̴.   ó Ʒ .
 * 
 * ǥ ǥ Ÿ 
 * 	- Ưڿ پ   쿡 屸 Ѵ. ⿡ ϴ Ưڴ ƽŰڵ尪  ڸ Ѵ.
 * 
 * ħǥ Ÿ 
 * - ڿ ڿ پ   Ѵ.
 * - ħǥ ٷ  ̸ Ѵ. ⿡  ̿Ͽ  쿡 ϸ  Ȯ     ̴.
 * - ʿ ħǥ  Ѵ. ̰ ǥ  ó̴.
 * - ħǥ  ٷ  ܾ ̰ 2byte̸ ħǥ  ܾ 屸 ϰ,    ٸ   óѴ. ̰ '.', '.'   Ӹǥ  ó̴.
 * -  ̿ܿ 屸 Ѵ.
 * 
 *   쿡 ؼ ȣ ǥ  ó ʿϴ.  Ģ Ͽ 屸   ȣ ǥ   ʵ Ѵ.
 */

package kr.ac.kaist.swrc.jhannanum.module.sentence;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

import kr.ac.kaist.swrc.jhannanum.module.Module;

/**
 * @author Sangwon Park
 *
 */
public class SentenceSplitter implements Module {

	private BufferedReader in = null;
	private PrintWriter out = null;
	
	final static private String MODULE_NAME = "SentenceSplitter";

	public void initialize(Reader in, Writer out, String configFile) {
		if (in != null) {
			this.in = new BufferedReader(in);
		} else {
			this.in = null;
		}

		if (out != null) {
			this.out = new PrintWriter(out);
		} else {
			this.out = null;
		}
	}

	public void setReader(Reader in) {
		if (in != null) {
			this.in = new BufferedReader(in);
		} else {
			this.in = null;
		}
	}

	public void setWriter(Writer out) {
		if (out != null) {
			this.out = new PrintWriter(out);
		} else {
			this.out = null;
		}
	}

	public void run() throws Exception {
		String line = "";
		String[] words = null;
		boolean isBOS = true;

		//   
		while ((line = in.readLine()) != null) {
			isBOS = true;
			
			if (line.equals("EOF")) {
				if (!isBOS) {
					out.write("EOS\n");
				}
				out.write("EOF\n\n");
				continue;
			}
			
			//   ߶ м
			words = line.split("\\s");

			for (int i = 0; i < words.length; i++) {
				if (!words[i].matches(".*(\\.|\\!|\\?).*")) {
					//   . ! ?   
					if (isBOS) {
						out.write("BOS " + words[i] + " ");
					} else {
						out.write(words[i] + " ");
					}
					
					isBOS = false;
					
				} else {
					//   . ! ? \n  ִ   ϳ Ȯϸ ó
					int beginIndex = 0;
					boolean isEOS = false;

					for (int j = 0 ; j < words[i].length(); j++) {
						char c = words[i].charAt(j);
						switch (c) {
						case '.':
							if (j > 0) {
								// ħǥ    
								if (Character.isLowerCase((words[i].charAt(j - 1))) || 
										Character.isUpperCase((words[i].charAt(j - 1))))  {
									continue;
								}

								// ħǥ   ̳ Ưڰ ƴϸ 
								if (words[i].charAt(j - 1) == '.' && j != words[i].length() - 1) {
									continue;
								}
							}
							if (j < words[i].length() - 1) {
								// ħǥ ڿ ڰ   
								if (Character.isDigit(words[i].charAt(j + 1))) {
									continue;
								}

								// ħǥ  ۵Ǹ 
								if (words[i].charAt(j + 1) == '.') {
									continue;
								}
							}

							isEOS = true;
							break;
						case '!':
							isEOS = true;
							break;
						case '?':
							isEOS = true;
							break;
						}

						if (isEOS) {
							// Ư ڸ 忡 ԽŴ
							while (j < words[i].length() - 1) {
								if (isSym(words[i].charAt(j + 1))) {
									j++;
								} else {
									break;
								}
							}

							// Ư ڰ ó Ÿ ġ Ȯ
							int k = j;
							for ( ; k >= 0; k--) {
								if (!isSym(words[i].charAt(k))) {
									break;
								}
							}

							if (isBOS) {
								out.write("BOS " + words[i].substring(beginIndex, k + 1) + " " + words[i].substring(k + 1, j + 1) + " EOS\n");
							}
							else {
								out.write(words[i].substring(beginIndex, k + 1) + " " + words[i].substring(k + 1, j + 1) + " EOS\n");
							}
							isBOS = true;

							beginIndex = j + 1;
							isEOS = false;

							out.flush();
						}
					}

					//  κ  
					if (beginIndex < words[i].length()) {
						if (isBOS) {
							out.write("BOS " + words[i].substring(beginIndex, words[i].length()) + " ");
						}
						else { 
							out.write(words[i].substring(beginIndex, words[i].length()) + " ");
						}
						isBOS = false;
						out.flush();
					}
				}
			}
			if (!isBOS && words != null) {
				out.write(" EOS\n");
				out.flush();
			}
			
		}
	}

	public void shutdown() {

	}
	
	public String getName() {
		return MODULE_NAME;
	}

	/**
	 *  忡  ȣ ˻Ѵ.
	 * @param c Ȯ 
	 * @return 
	 */
	private boolean isSym(char c) {
		switch (c) {
		case ')': return true;
		case ']': return true;
		case '}': return true;
		case '?': return true;
		case '!': return true;
		case '.': return true;
		case '\'': return true;
		case '\"': return true;
		}
		return false;
	}
}