/// @file Indicator.h
#ifndef INDICATOR_H
#define INDICATOR_H

#include "../core/process/RObject.h"
#include <windows.h>
#pragma comment(lib, "winmm.lib")

/// @brief rotation ɰ drawing  ü
class Indicator : public RObject {
	public:
		Indicator() : bRotation(false) {}
		virtual ~Indicator(){}
		static RObject* makeIndicator(TiXmlElement* _pIndicatorElement){
			Indicator* pIndicator = new Indicator;
			int x, y;
			_pIndicatorElement->Attribute("x", &x);
			pIndicator->fX = x;
			_pIndicatorElement->Attribute("y", &y);
			pIndicator->fY = y;
			return (RObject*)pIndicator;
		}
		void process(){
			if(bRotation){
				rotation_();
			}else{
				D3DXMatrixTranslation(&matWorld_, -fX, fY, -80.0f);
			}
		}
		void draw(Model* _pModel){
			if(bShow){
                pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld_ );
				pD3DDevice_->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,_pModel->numVertices,0,_pModel->numPolygons);
			}
		}
		void setRObject(CoreGraphic* _pCoreGraphic, CoreInput* _pCoreInput, OggPlayer* _pCoreSound, ControlTable* _pControlTable){
			pD3DDevice_ = _pCoreGraphic->getD3DDevice();
		}
	public:
		bool bRotation;

	private:
		LPDIRECT3DDEVICE9     pD3DDevice_;
		float fAngle_;
		D3DXMATRIXA16 matRotX_;
		D3DXMATRIXA16 matRotY_;
		D3DXMATRIXA16 matRotZ_;
		D3DXMATRIXA16 matTrans_;
		void rotation_(){
			fAngle_ = ((timeGetTime())*(2.0f * D3DX_PI))/(1000.0f * 10);
			D3DXMatrixTranslation(&matTrans_, -fX, fY, -80.0f);
			D3DXMatrixRotationX(&matRotX_, fAngle_);
			D3DXMatrixRotationY(&matRotY_, fAngle_);
			D3DXMatrixRotationZ(&matRotZ_, fAngle_);
			matWorld_ = matRotX_ * matRotY_ * matRotZ_ * matTrans_;
		}
};
#endif