/// @file Indicator.h
#ifndef OBJECTMANAGER_H
#define OBJECTMANAGER_H

#include "../core/graphic/CoreGraphic.h"
#include "../core/input/CoreInput.h"
#include "../core/sound/OggPlayer.h"
#include "../model/ModelMaker.h"
#include "../xml/tinyxml.h"
#include "Indicator.h"
#include <vector>
#include <map>
#include <string>
using std::vector;
using std::map;
using std::string;

#include <assert.h>

/// @brief ġ  MObject ĻŬ
class ObjectManager {
	public:
		~ObjectManager(){
			vector<RMObject*>::iterator pRMObjectItr;
			for(pRMObjectItr=vectorRMObject_.begin(); pRMObjectItr != vectorRMObject_.end(); pRMObjectItr++){
				delete (*pRMObjectItr);
			}
			vector<MObject*>::iterator pMObjectItr;
			for(pMObjectItr=vectorMObject_.begin(); pMObjectItr != vectorMObject_.end(); pMObjectItr++){
				delete (*pMObjectItr);
			}
		}
		void initObjectManager(CoreGraphic* _pCoreGraphic, CoreInput* _pCoreInput, OggPlayer* _pCoreSound){
			pCoreGraphic_ = _pCoreGraphic;
			pCoreInput_ = _pCoreInput;
			pCoreSound_ = _pCoreSound;
			pCoreGraphic_->getD3DDevice()->SetRenderState( D3DRS_LIGHTING, false);

			makeRMObject_["cube"] = makeCube_;
			makeMObject_["indicator"] = makeIndicator_;

			if ( !xmlDoc_.LoadFile("stage.mode.xml") ){
				const char* errorMsg = xmlDoc_.ErrorDesc();
				MessageBox(NULL, errorMsg, "Error Message", MB_OK | MB_ICONERROR);
				exit( 1 );
			}
			TiXmlHandle docHandle( &xmlDoc_ );
			TiXmlHandle scene_00 = docHandle.FirstChild("stage").Child( "scene", 0 );
			TiXmlElement* pModelElement = scene_00.FirstChild("Model").FirstChild("list").Element();
			assert(pModelElement->Attribute("type"));
			putRMObject_(pModelElement);
			TiXmlElement* pMObjectElement = scene_00.FirstChild("MObject").FirstChild("list").Element();
			assert(pMObjectElement);
			putMObject_(pMObjectElement);

			pCoreSound_->OpenOgg("resource/game_resource/london.ogg");
			pCoreSound_->Play(true);
		}
		void control(){
			//if(aParamTable_.IsMode){
			//	this->controlMode();
			//}else{
			//	this->controlScript();
			//}
		}
		// Ȳ̺ controlȿ ٲ

		void tmpProcess(){
			pCoreSound_->Update();
			//MObjectProcess
			vector<MObject*>::iterator pMObjectItr;
			for(pMObjectItr=vectorMObject_.begin(); pMObjectItr != vectorMObject_.end(); pMObjectItr++){
				if( (*pMObjectItr)->bShow ){
					vectorRMObject_[(*pMObjectItr)->modelType]->dequeMObject.push_back((*pMObjectItr));
				}
			}
		}
		void tmpRender(){
			pCoreGraphic_->getD3DDevice()->Clear(0,NULL,D3DCLEAR_TARGET | D3DCLEAR_ZBUFFER,D3DCOLOR_XRGB(100,100,100),1.0f,0);
			pCoreGraphic_->getD3DDevice()->BeginScene();
			pCoreGraphic_->camera(0, 0, 0);
			pCoreGraphic_->getD3DDevice()->SetFVF(D3DFVF_CustomVertex);

			vector<RMObject*>::iterator pRMObjectItr;
			for(pRMObjectItr=vectorRMObject_.begin(); pRMObjectItr != vectorRMObject_.end(); pRMObjectItr++){
				pCoreGraphic_->show((*pRMObjectItr));
				(*pRMObjectItr)->dequeMObject.clear();
			}
			pCoreGraphic_->getD3DDevice()->EndScene();
			pCoreGraphic_->getD3DDevice()->Present(NULL,NULL,NULL,NULL);
		}
	
	private:		
		void putRMObject_(TiXmlElement* _pModelElement){
			while(_pModelElement){
				string key(_pModelElement->Attribute("type"));
				RMObject *pRMObject = (this->*makeRMObject_[key])(_pModelElement);
				vectorRMObject_.push_back(pRMObject);
				_pModelElement = _pModelElement->NextSiblingElement();
			}
		}
		void putMObject_(TiXmlElement* _pMObjectElement){
			while(_pMObjectElement){
				string key(_pMObjectElement->Attribute("type"));
				MObject *pMObject = (this->*makeMObject_[key])(_pMObjectElement);
				vectorMObject_.push_back(pMObject);
				_pMObjectElement = _pMObjectElement->NextSiblingElement();
			}
		}

		void controlScript_(){
			//readXml(xml, aParamTable_.numScript);
			//߿ ε Ÿ ִٸ ̰ MObject ٲ۴.
		}
		void controlMode_(){
			//switch (aParamTable_.numMode){
			//	case
			//}
			//׳ MOjbect ޾Ƶδ.(׳ ִ̾ 尡 ִ)
		}

		MObject* makeIndicator_(TiXmlElement* _pIndicatorElement){
			Indicator* pIndicator = new Indicator;
			int modelType, x, y;
			_pIndicatorElement->Attribute("model", &modelType);
			pIndicator->modelType = modelType;
			_pIndicatorElement->Attribute("x", &x);
			pIndicator->fX = x;
			_pIndicatorElement->Attribute("y", &y);
			pIndicator->fY = y;
			pIndicator->bShow = TRUE;
			return pIndicator;
		}

		RMObject* makeCube_(TiXmlElement* _pModelElement){
			RMObject* pRMObject = new RMObject;
			const char *pTextureName = _pModelElement->Attribute("texture");
			int scale; _pModelElement->Attribute("scale", &scale);
			Model aModel;
			ModelMaker::createCubeModel(pCoreGraphic_->getD3DDevice(), &aModel, pTextureName, scale);
			//ModelMaker::createCubeModel(pCoreGraphic_->getD3DDevice(), &aModel, "a", scale);
			pRMObject->aModel = aModel;
			return pRMObject;
		}

	private:
		TiXmlDocument xmlDoc_;
		//ParamTable aParamTable_;
		CoreGraphic* pCoreGraphic_;
		CoreInput* pCoreInput_;
		OggPlayer* pCoreSound_;

		// Ʈ ObjectManagerȿ ̷.
		vector<RMObject*> vectorRMObject_;
		vector<MObject*> vectorMObject_;
		//ToDo ũƮȿ ε   container
		//vector<MObject*> scriptMObject;

		map<string, MObject* (ObjectManager::*)(TiXmlElement*)> makeMObject_;
		map<string, RMObject* (ObjectManager::*)(TiXmlElement*)> makeRMObject_;

};

#endif