<?php
/**
 * ArrayUtil Ŭ
 *
 * @package php.util
 */
import('php.lang.PObject');

/**
 * help Լ
 *
 * @param array $arr	迭
 * @return ArrayUtil
 */
function A_($arr = array()) { 
	return new ArrayUtil($arr);
}

/**
 * 迭  ƿƼ Wrapper Ŭ 
 *
 * <code>
 * 
 * // 1. ArrayUtil  
 *  new ArrayUtil(array(1,2,3,4,5));    or    A_(array(1,2,3,4,5));
 *
 * // 2.  Լ 
 * $arr = A_(array(5,4,3,2,1));
 * print_r($arr->sort()->to);
 *
 * // 3.  Լ  
 * $arr = A_(array('a', 'b', 'c', 'd', 'e'));
 * print_r($arr->map('strtoupper')->return);
 * 
 * // 4.  Լ ·  
 * $arr = A_(array('a', 'b', 'c', 'd', 'e'));
 * print_r($arr->r(map, 'strtoupper')->to);
 * or
 * print_r($arr->ref()->map('strtoupper')->to);
 *
 * // 5. ϰ ArrayUtil ü ȯؼ  
 * // object Ӽ return   迭 ArrayUtil  ȯش. 
 * $arr = A_(array('a', 'b', 'c', 'd', 'e'));
 * print($arr->r(map, 'strtoupper')->object->r(map, 'strtolower')->return);
 *
 * // 6. ִ ArrayUtil ü ä 
 * $arr = A_()->r(range, 1, 10)->sum();
 * print_r($arr->return); 
 * 
 * // 7. Ű ѱ 
 *
 * function test_func($first, $second, $third) { 
 *	return $first * $second * $third;
 * } 
 *
 * $arr = A_(range(1, 10))->loop('test_func', 10, 20);
 * print_r($arr->return);
 *
 * </code>
 *
 * <pre>
 * - 迭 Լ  
 * 1.  
 *	pop  
 *	multisort  
 *	push  
 *	shift  
 *	splice  
 *	unshift  
 *	walk_recursive
 *	walk  
 *	arsort  
 *	asort  
 *	each  
 *	krsort  
 *	ksort  
 *	natcasesort  
 *	natsort  
 *	rsort  
 *	shuffle  
 *	sort  
 *	uasort  
 *	uksort  
 *	usort  
 *
 * 2. 
 *	map
 *	change_key_case
 *	filter
 *	count_values
 *	chunk
 *	combine
 *	diff_assoc
 *	diff_uassoc
 *	diff_ukey
 *	diff_key
 *	diff
 *	fill_keys
 *	fill
 *	flip
 *	intersect_assoc
 *	intersect_key
 *	intersect_uassoc
 *	intersect_ukey
 *	intersect
 *	keys
 *	key_exists
 *	merge_recursive
 *	merge
 *	pad
 *	product
 *	rand
 *	reduce
 *	reverse
 *	search
 *	slice
 *	sum
 *	unique
 *	values
 *	compact
 *	extract
 *	in
 *	range
 *	implode
 *	explode
 *	loop
 * </pre>
 * 
 */
class ArrayUtil extends ArrayObject implements Iterator {
	private $source;	
	private $current;
	private $history;

	private $index;
	private $return;
	private $is_ref = false;

	/** 
	 * Ű   
	 */
	const POS_ZERO	= -1;			

	/** 
	 * ù° Ű 
	 */
	const POS_FIRST = 0;			

	/** 
	 * ι° Ű 
	 */
	const POS_SECOND = 1;			

	/** 
	 *  Ű 
	 */
	const POS_MAX	= 1000;			

	// ⺻ Լ ̺ 
	private $function_list = array();

	/**
	 *  
	 *
	 */
	public function __construct($arr = array()) { 
		$this->source	= $arr;
		$this->current	= $arr;
		$this->index	= 0;

		$this->init();
	}

	/**
	 * ʱ Լ Ʈ  
	 *
	 */
	public function init() { 
		
		// ܺ ޼ҵ ȣ 
		$this->setFunctionList('map',				'array_map',			self::POS_SECOND,	false);
		$this->setFunctionList('change_key_case',	'array_change_key_case',self::POS_FIRST,	false);
		$this->setFunctionList('filter',			'array_filter',			self::POS_FIRST,	false);
		$this->setFunctionList('count_values',		'array_count_values',	self::POS_FIRST,	false);
		$this->setFunctionList('chunk',				'array_chunk',			self::POS_FIRST,	false);
		$this->setFunctionList('combine',			'array_combine',		self::POS_FIRST,	false);
		$this->setFunctionList('diff_assoc',		'array_diff_assoc',		self::POS_FIRST,	false);
		$this->setFunctionList('diff_uassoc',		'array_diff_uassoc',	self::POS_FIRST,	false);
		$this->setFunctionList('diff_ukey',			'array_diff_ukey',		self::POS_FIRST,	false);
		$this->setFunctionList('diff_key',			'array_diff_key',		self::POS_FIRST,	false);
		$this->setFunctionList('diff',				'array_diff',			self::POS_FIRST,	false);
		$this->setFunctionList('fill_keys',			'array_fill_keys',		self::POS_FIRST,	false);
		$this->setFunctionList('fill',				'array_fill',			self::POS_ZERO,		false);
		$this->setFunctionList('flip',				'array_flip',			self::POS_FIRST,	false);
		$this->setFunctionList('intersect_assoc',	'array_intersect_assoc',self::POS_FIRST,	false);
		$this->setFunctionList('intersect_key',		'array_intersect_key',	self::POS_FIRST,	false);
		$this->setFunctionList('intersect_uassoc',	'array_intersect_uassoc',self::POS_FIRST,	false);
		$this->setFunctionList('intersect_ukey',	'array_intersect_ukey',	self::POS_FIRST,	false);
		$this->setFunctionList('intersect',			'array_intersect',		self::POS_FIRST,	false);
		$this->setFunctionList('keys',				'array_keys',			self::POS_FIRST,	false);
		$this->setFunctionList('key_exists',		'array_key_exists',		self::POS_SECOND,	false);
		$this->setFunctionList('merge_recursive',	'array_merge_recursive',self::POS_FIRST,	false);
		$this->setFunctionList('merge',				'array_merge',			self::POS_FIRST,	false);
		$this->setFunctionList('multisort',			'array_multisort',		self::POS_MAX,		true);
		$this->setFunctionList('pad',				'array_pad',			self::POS_FIRST,	false);
		$this->setFunctionList('pop',				'array_pop',			self::POS_FIRST,	true);
		$this->setFunctionList('product',			'array_product',		self::POS_FIRST,	false);
		$this->setFunctionList('push',				'array_push',			self::POS_FIRST,	true);
		$this->setFunctionList('rand',				'array_rand',			self::POS_FIRST,	false);
		$this->setFunctionList('reduce',			'array_reduce',			self::POS_FIRST,	false);
		$this->setFunctionList('reverse',			'array_reverse',		self::POS_FIRST,	false);
		$this->setFunctionList('search',			'array_search',			self::POS_SECOND,	false);
		$this->setFunctionList('shift',				'array_shift',			self::POS_FIRST,	true);
		$this->setFunctionList('slice',				'array_slice',			self::POS_FIRST,	false);
		$this->setFunctionList('splice',			'array_splice',			self::POS_FIRST,	true);
		$this->setFunctionList('sum',				'array_sum',			self::POS_FIRST,	false);
		$this->setFunctionList('unique',			'array_unique',			self::POS_FIRST,	false);
		$this->setFunctionList('unshift',			'array_unshift',		self::POS_FIRST,	true);
		$this->setFunctionList('values',			'array_values',			self::POS_FIRST,	false);
		$this->setFunctionList('walk_recursive',	'array_walk_recursive',	self::POS_FIRST,	true);
		$this->setFunctionList('walk',				'array_walk',			self::POS_FIRST,	true);
		$this->setFunctionList('arsort',			'arsort',				self::POS_FIRST,	true);
		$this->setFunctionList('asort',				'asort',				self::POS_FIRST,	true);
		$this->setFunctionList('compact',			'compact',				self::POS_ZERO,		false);
		$this->setFunctionList('each',				'each',					self::POS_FIRST,	true);
		$this->setFunctionList('extract',			'extract',				self::POS_FIRST,	false);
		$this->setFunctionList('in',				'in_array',				self::POS_FIRST,	false);
		$this->setFunctionList('krsort',			'krsort',				self::POS_FIRST,	true);
		$this->setFunctionList('ksort',				'ksort',				self::POS_FIRST,	true);
		$this->setFunctionList('natcasesort',		'natcasesort',			self::POS_FIRST,	true);
		$this->setFunctionList('natsort',			'natsort',				self::POS_FIRST,	true);
		$this->setFunctionList('range',				'range',				self::POS_ZERO,		false);
		$this->setFunctionList('rsort',				'rsort',				self::POS_FIRST,	true);
		$this->setFunctionList('shuffle',			'shuffle',				self::POS_FIRST,	true);
		$this->setFunctionList('sort',				'sort',					self::POS_FIRST,	true);
		$this->setFunctionList('uasort',			'uasort',				self::POS_FIRST,	true);
		$this->setFunctionList('uksort',			'uksort',				self::POS_FIRST,	true);
		$this->setFunctionList('usort',				'usort',				self::POS_FIRST,	true);
		$this->setFunctionList('implode',			'implode',				self::POS_FIRST,	false);
		$this->setFunctionList('explode',			'explode',				self::POS_ZERO,		false);

		//  ޼ҵ ȣ 
		$this->setFunctionList('loop',				array($this, '_loop'),	self::POS_FIRST,	false);
	}

	/**
	 *  Լ  
	 *
	 * @param string $name Լ̸
	 * @param string|array $run callback 
	 * @param int $pos Ű ġ
	 * @param bool $is_reference  true : , false :  
	 */
	public function setFunctionList($name, $run, $pos, $is_reference) { 
		$this->function_list[$name] = array('function' => $run,	'pos' => $pos, 'is_reference' => $is_reference);
	}

	/**
	 * array Լ ڵ 
	 *
	 * @return ArrayUtil 
	 */
	public function __call($method, $args) { 

		$method = strtolower($method);

		if (! array_key_exists($method, $this->function_list)) return  ;

		// ArrayUtil ü  array ȯŴ 
		foreach ($args as $key => $value) { 
			$args[$key] = is_a($value, "ArrayUtil") ? $value->to : $value;
		}

		// ڱڽ  Ǹ Ű ۼ 
		if ($this->getPos($method) > self::POS_ZERO) { 
			$this->createMethodArgs($method, $args);	
		}

		// ޼ҵ  
		$this->return = call_user_func_array($this->getFunction($method), $args);

		//  ̰ is_reference Ӽ false ̸ 
		// ,  return  current  ٲ 
		if ($this->is_ref && $this->hasRef($method) == false) { 
			$this->current = $this->return;
		}

		//  α  
		$this->log($method, $args, $this->current);

		//  ʱȭ 
		$this->ref(false);

		return $this;
	}

	/*
	 * ArrayObject  ǵǾ ִ ĸ޼ҵ  
 	 */

	/**
	 * asort
	 *
	 * @return ArrayUtil
	 */
	public function asort ( ) { 
		$arr = func_get_args();
		return $this->__call('asort', $arr); 
	}

	/**
	 * ksort
	 *
	 * @return ArrayUtil
	 */
	public function ksort ( ) {
		$arr = func_get_args();
		return $this->__call('ksort', $arr); 
	}

	/**
	 * natcasesort
	 *
	 * @return ArrayUtil
	 */
	public function natcasesort ( ) {
		$arr = func_get_args();
		return $this->__call('natcasesort', $arr); 	
	}

	/**
	 * natsort
	 *
	 * @return ArrayUtil
	 */
	public function natsort ( ) {
		$arr = func_get_args();
		return $this->__call('natsort', $arr); 		
	} 

	/**
	 * uasort
	 *
	 * @return ArrayUtil
	 */
	public function uasort ( $cmp_function ) {
		$arr = func_get_args();
		return $this->__call('uasort', $arr);	
	}

	/**
	 * uksort
	 *
	 * @return ArrayUtil
	 */
	public function uksort ( $cmp_function ) {
		$arr = func_get_args();
		return $this->__call('uksort', $arr);	
	}
	
	/**
	 * return  
	 * 
	 * <pre>
	 * return : $this->return 
	 * to     : $this->to()
	 * object : $this->toObject()	
	 * </pre>
	 *
	 * <code>
	 * // object Ӽ return  ArrayUtil ü ȯش. 
	 * $arr = A_()->fill(10,100,1);
	 * echo $arr->object->sum()->return;   // հ賻 
	 * </code>
	 *
	 * @return mixed 
	 */
	public function __get($key) { 

		switch (strtolower($key)) { 
			case 'return':	return $this->return;
			case 'to':		return $this->current;
			case 'source':	return $this->source;
			case 'history': return $this->history;
			case 'object':	return A_($this->return);
		}

		return '';
	}

	/**
	 *   ȯ
	 *
	 * <code>
	 * 
	 * // Ʒ  ڵ ϴ. 
	 * $arr = A_()->ref()->fill(10, 100, 1);
	 * or 
	 * $arr = A_()->r(fill, 10, 100, 1);
	 *
	 * </code>
	 * 
	 * @param bool $is_ref  , true̸   , ⺻ true, 
	 * @return ArrayUtil 
	 * @see ArrayUtil::r()
	 */
	public function ref($is_ref = true) { 
		$this->is_ref = $is_ref;

		return $this;
	}

	/**
	 *  ƴ  Լ   ڵ · ȯ 
	 *
	 * <code>
	 *  
	 *  // Լ Ӽ array ϴ ̸ 
	 *  //  array ٲٰ ʹٸ r ޼ҵ带 ؼ Լ Ѵ. 
	 *
	 *  //  迭  10 100 ε 1 ä 
	 *  $arr = A_()->r(fill, 10, 100, 1);
	 *  print_r($arr->to);
	 * 
	 *  //  ϰ   
	 *  $arr = A_()->fill(10, 100, 1);
	 *  print_r($arr->return);
	 * 
	 * </code>
	 *
	 * @return ArrayUtil 
	 * @see ArrayUtil::ref()
	 */
	public function r() { 
		$this->ref();

		$arr = func_get_args();
		$func = array_shift($arr);

		return call_user_func_array(array($this, $func), $arr);

	}

	/** 
	 *   Ȯ 
	 *
	 * @param string $method   Լ ̸ 
	 * @return int    ,  true : , false :  
	 *
	 */
	public function hasRef($method) { 
		return $this->function_list[$method]['is_reference'];
	}

	/** 
	 * Ű ġ 
	 *
	 * @param string $method   Լ ̸ 
	 * @return int    Ű ġ 
	 *
	 */
	public function getPos($method) { 
		return $this->function_list[$method]['pos'];
	}
	
	/** 
	 *   Լ 
	 * 
	 * @param string $method   Լ ̸ 
	 * @return callback   ݹ̸ 
	 */
	public function getFunction($method) { 
		return $this->function_list[$method]['function'];
	}

	/**
	 *  loop  ޼ҵ 
	 *
	 * @param array $current 
	 * @param callback $callback
	 * @param mixed|... Ÿ Ű Ʈ 
	 *
	 * @return ArrayUtil
	 */
	private function _loop() { 

		$arr = func_get_args();

		$current = array_shift($arr);
		$callback = array_shift($arr);

		$temp = array();

		foreach ($current as $key => $value) { 
			$temp[$key] = call_user_func_array($callback, array_merge(array($value), $arr));
		}

		return $temp;
	}

	private function log($method, $args, $result) { 
		$this->history[] = array('method' => $method, 'args'=> $args, 'result' => $result);
	}

	public function display($var = 'history') { 
		print_r($this->{$var});
	}	

	/**
	 * Ű  
	 *
	 *  Ű current  ļ   Ű Ʈ ȯѴ. 
	 *
	 * @param string $method  Լ ̸ 
	 * @param array $args  Ű 
	 */
	private function createMethodArgs($method, &$args) { 
			
		$pos = $this->getPos($method);

		$left = array_slice($args, 0, $pos);
		$right = array_slice($args, $pos);

		if ($pos == self::POS_MAX) { 
			if ($this->hasRef($method)) { 
				$args[] = &$this->current;
			} else { 
				$args[] = $this->current;
			}
		}  else { 
			if ($this->hasRef($method)) { 
				$args = array_merge($left, array(&$this->current), $right);		
			} else { 
				$args = array_merge($left, array($this->current), $right);
			}
		}
	}

	// ArrayAccess  
	/**
	 * 迭 index ϴ üũ
	 *
	 * @param int|string $index 迭ε
	 * @return bool 
	 * @see isset()
	 */
	public function offsetExists ($index) { 
		return array_key_exists($index, $this->current);
	}

	/**
	 * 迭 index شϴ   ´ 
	 *
	 * @param int|string $index 迭ε
	 * @return mixed 
	 */
	public function offsetGet ($index) { 
		return $this->current[$index];
	}

	/**
	 * 迭 index  Ѵ. 
	 *
	 * @param int|string $index 迭ε
	 * @param mixed $value Ҵ 
	 */
	public function offsetSet ($index, $value) { 
		$this->current[$index] = $value;
	}

	/**
	 * 迭 index شϴ  ޸𸮸 Ѵ. 
	 *
	 * @param int|string $index 迭ε
	 * @see unset()
	 */
	public function offsetUnset ($index) { 
		unset($this->current[$index]);
	}

	/**
	 * 迭  ڿ ߰Ų 
	 *
	 * @param mixed $value ߰ 
	 */
	public function append ($value) { 
		$this->current[] = $value;
	}

	// Iterator  
	/**
	 * 迭 ε ó  (⺻ 0)
	 */
	public function rewind() {
		$this->index = 0;
	}

	/**
	 * ȿ ε üũ 
	 *
	 * @return bool
	 */
	public function valid() {
		return $this->index < sizeof($this->current);
	}

	/**
	 *  index 
	 *
	 * @return int
	 */
	public function key() {
		return $this->index;
	}

	/**
	 *  ε شϴ  
	 *
	 * @return mixed 
	 */
	public function current() {
		return $this->current[$this->index];
	}

	/** 
	 * index ĭ 
	 * 
	 */
	public function next() {
		$this->index++;
	}

	// IteratorAggregate 
	public function getIterator() { 
		return $this;
	}

	/**
	 *  current 迭 ũ⸦  
	 *
	 * @param int $mode 迭ũ  
	 * @return int 
	 */
	public function count($mode = 0) { 
		return count($this->current, $mode);
	}
}

?>