<?php
/**
 * ±   Ŭ 
 *
 * @package php.lang
 */

import("php.lang.PObject");

/**
 * Tag   Function
 *
 * <code>
 * $div = T_('div', true)->add('ȳ');   // <div>ȳ</div>
 * </code>
 *
 * @param	string $tag		Tag ̸ 
 * @param	boolean $hasClose	true : Two ±, false : One ±, ⺻ : false 
 * @return  Tag 
 *
 */
function T_($tag, $hasClose = false) {
	return new Tag($tag, $hasClose);
}


/**
 * Tag   class
 *
 * @version	1.0
 * @since	php5 or later 
 * @package php.lang
 */
class Tag extends PObject {
	/**
	 * Tag ̸
	 *
	 * @var		string
	 *
	 */
	protected $tag;

	/**
	 * Two ± 
	 *
	 * @var		boolean		true : Two ±, false : One ± 
	 *
	 */
	protected $hasClose;

	/**
	 * Ӽ Ʈ 
	 *
	 * @var		array
	 *
	 */
	protected $attribute = array();

	/**
	 * Ÿ Ʈ 
	 *
	 * @var		array
	 *
	 */
	protected $style = array();

	/**
	 * data Ʈ 
	 *
	 * @var		array
	 *
	 */
	protected $data = array();

	/**
	 * 
	 *
	 * @param	string $tag	± ̸ 
	 * @param	boolean $close	Two ± 
	 *
	 */
	public function __construct($tag, $close = false)
	{
		$this->tag = strtolower($tag);
		$this->hasClose = $close;
	}

	/**
	 * Ÿ ߰ϱ 
	 *
	 * @param	string	$key	Ÿ ̸
	 * @param	string	$value	Ÿ 
	 *
	 */
	public function addStyle($key,  $value)
	{
		$this->style[$key] = "$key : $value";

		return $this;
	}

	/**
	 * Ÿ 迭 ߰ϱ 
	 *
	 *  <code>$obj->setStyle(array('width'=>'100px', 'height' =>'100px'));</code>
	 *
	 * @param	array	$arr	Ÿ Ʈ 
	 * @return	object
	 */
	public function setStyle($arr)
	{
		foreach ($arr as $key => $value) {
			$this->addStyle($key, $value);
		}

		return $this;
	}


	/**
	 * Ÿ ڿ  
	 *
	 * @return	string 
	 */
	protected function collectStyle()
	{
		return implode(";", $this->style);

	}

	/**
	 * Ӽ ߰ϱ 
	 *
	 * @param	string	$key	Ӽ ̸
	 * @param	string	$value	Ӽ 
	 * @return	object 
	 */
	public function addAttribute($key, $value)
	{
		$this->attribute[$key] = "$key='$value'";

		return $this;
	}

	/**
	 * Ӽ 迭 ߰ϱ 
	 *
	 *  <code>$obj->setAttribute(array('width'=>'100px', 'height' =>'100px'));</code>
	 *
	 * @param	array	$arr	Ӽ Ʈ
	 * @return	void
	 */
	public function setAttribute($arr) {
		foreach ($arr as $key => $attr) {
			$this->addAttribute($key, $attr);
		}

		return $this;
	}

	/**
	 * Ӽ ڿ  
	 *
	 * @return	string 
	 */
	public function collectAttribute()
	{
		return implode(" ", $this->attribute);
	}

	/**
	 * Ÿ ߰ϱ, Ÿz PObject ϴ Ŭ Ϲ ڷ θ Ѵ.
	 *
	 * @param	mixed $obj	php  ڷ 
	 * @return	object 		Tag ü ڽ (this)
	 */
	public function add($obj) {
		$this->data[] = PObject::getObjValue($obj);

		return $this;
	}

	/**
	 * ڿ ȯ
	 *
	 * @return	string
	 */
	public function toString()
	{

		$str = "<{$this->tag} ";

		if ($temp = $this->collectAttribute()) {
			$str .= " $temp ";
		}

		if ($temp = $this->collectStyle()) {
			 $str .= " style=\"$temp\"";
		}

		// one tag 
		if ($this->hasClose) {

			$str .= ">";
			
			if (count($this->data) > 0 ) {
				$str .= implode("", $this->data);
			}
			
			$str .= "</{$this->tag}>\n";
		}	
		// two tag 
		else {


			$str .= "/>\n";
		}

		return $str;
	}
}

?>