<?php
/**
 * ڿ ƿƼ Ŭ
 *
 * @package php.lang
 */

import("php.lang.PObject");


/** 
 * string Ŭ  utility Ŭ 
 *
 * @param $string string ɹڿ
 * @return String 
 */
function string_($string = '') { 
	return new String($string);
}

/**
 * ڿ ƿƼ Ŭ
 *
 * Ī̺ 
 * <table>
 * <tr><th>String ޼ҵ</th><th>ڿԼ</th></tr>
 * <tr><td>addcslashes</td><td>addcslashes</td></tr>
 * <tr><td>addslashes</td><td>addslashes</td></tr>
 * <tr><td>bin2hex</td><td>bin2hex</td></tr>
 * <tr><td>chop	</td><td>chop</td></tr>
 * <tr><td>chr</td><td>chr</td></tr>
 * <tr><td>count_chars</td><td>count_chars</td></tr>
 * <tr><td>entity_encode</td><td>htmlentities</td></tr>
 * <tr><td>entity_decode</td><td>html_entity_decode</td></tr>
 * <tr><td>explode</td><td>explode</td></tr>
 * <tr><td>implode</td><td>implode</td></tr>
 * <tr><td>join	=> join</td></tr>
 * <tr><td>ltrim</td><td>ltrim</td></tr>
 * <tr><td>md5</td><td>md5</td></tr>
 * <tr><td>nl2br</td><td>nl2br</td></tr>
 * <tr><td>ord</td><td>ord</td></tr>
 * <tr><td>parse</td><td>parse_str</td></tr>
 * <tr><td>print</td><td>print</td></tr>
 * <tr><td>printf</td><td>printf</td></tr>
 * <tr><td>rtrim</td><td>rtrim</td></tr>
 * <tr><td>similar</td><td>similar_text</td></tr>
 * <tr><td>soundex</td><td>soundex</td></tr>
 * <tr><td>sprintf</td><td>sprintf</td></tr>
 * <tr><td>sscanf</td><td>sscanf</td></tr>
 * <tr><td>ireplace</td><td>str_ireplace</td></tr>
 * <tr><td>pad</td><td>str_pad</td></tr>
 * <tr><td>repeat</td><td>str_repeat</td></tr>
 * <tr><td>replace</td><td>str_replace</td></tr>
 * <tr><td>rot13</td><td>str_rot13</td></tr>
 * <tr><td>shuffle</td><td>str_shuffle</td></tr>
 * <tr><td>count_split</td><td>str_split</td></tr>
 * <tr><td>word_count</td><td>str_word_count</td></tr>
 * <tr><td>casecmp</td><td>strcasecmp</td></tr>
 * <tr><td>cmp</td><td>strcmp</td></tr>
 * <tr><td>coll</td><td>strcoll</td></tr>
 * <tr><td>strip</td><td>strip_tags</td></tr>
 * <tr><td>stripcslashes</td><td>stripcslashes</td></tr>
 * <tr><td>ipos</td><td>stripos</td></tr>
 * <tr><td>stripslashes</td><td>stripslashes</td></tr>
 * <tr><td>istr</td><td>stristr</td></tr>
 * <tr><td>len</td><td>strlen</td></tr>
 * <tr><td>natcasecmp</td><td>strnatcasecmp</td></tr>
 * <tr><td>natcmp </td><td>strnatcmp</td></tr>
 * <tr><td>ncasecmp </td><td>strncasecmp</td></tr>
 * <tr><td>ncmp</td><td>strncmp</td></tr>
 * <tr><td>pbrk</td><td>strpbrk</td></tr>
 * <tr><td>pos</td><td>strpos</td></tr>
 * <tr><td>last_string</td><td>strrchr</td></tr>
 * <tr><td>reverse </td><td>strrev</td></tr>
 * <tr><td>reverse_ipos</td><td>strripos</td></tr>
 * <tr><td>reverse_pos</td><td>strrpos</td></tr>
 * <tr><td>first_string</td><td>strstr</td></tr>
 * <tr><td>lower</td><td>strtolower</td></tr>
 * <tr><td>upper</td><td>strtoupper</td></tr>
 * <tr><td>translate </td><td>strtr</td></tr>
 * <tr><td>sub_compare</td><td>substr_compare</td></tr>
 * <tr><td>sub_count </td><td>substr_count</td></tr>
 * <tr><td>sub_replace</td><td>substr_replace</td></tr>
 * <tr><td>substring </td><td>substr</td></tr>
 * <tr><td>trim</td><td>trim</td></tr>
 * <tr><td>ucfirst </td><td>ucfirst</td></tr>
 * <tr><td>ucwords </td><td>ucwords</td></tr>
 * <tr><td>wrap</td><td>wordwrap</td></tr>
 * <tr><td>iconv</td><td>iconv</td></tr>
 * <tr><td>base64_encode</td><td>base64_encode</td></tr>
 * <tr><td>base64_decode</td><td>base64_decode</td></tr>
 * <tr><td>build_query</td><td>http_build_query</td></tr>
 * <tr><td>parse_url</td><td>parse_url</td></tr>
 * <tr><td>rawencode</td><td>rawurlencode</td></tr>
 * <tr><td>rawdecode</td><td>rawurldecode</td></tr>
 * <tr><td>urlencode</td><td>urlencode</td></tr>
 * <tr><td>urldecode</td><td>urldecode</td></tr>
 * <tr><td>highlight</td><td>highlight_string</td></tr>
 * <tr><td>phpstrip</td><td>php_strip_whitespace</td></tr>
 * <tr><td>constant</td><td>constant</td></tr>
 * <tr><td>split</td><td>split</td></tr>
 * <tr><td>spliti</td><td>spliti</td></tr>
 * <tr><td>number_format</td><td>number_format</td></tr>
 * <tr><td>money_format</td><td>money_format</td></tr>
 * <tr><td>match_all</td><td>preg_match_all</td></tr>
 * <tr><td>match</td><td>preg_match</td></tr>
 * <tr><td>preg_qoute</td><td>preg_qoute</td></tr>
 * <tr><td>preplace_callback</td><td>preg_replace_callback</td></tr>
 * <tr><td>preplace</td><td>preg_replace</td></tr>
 * <tr><td>psplit</td><td>preg_split</td></tr>
 * </table>
 * 
 * 
 * 
 *
 * @package php.lang
 * @version 1.0
 *
 */
class String extends PObject
{
	private $source = "";
	private $current = "";

	private $history;
	private $is_ref = false;
	private $return;


	/** 
	 * Ű   
	 */
	const POS_ZERO	= -1;			

	/** 
	 * ù° Ű 
	 */
	const POS_FIRST = 0;			

	/** 
	 * ι° Ű 
	 */
	const POS_SECOND = 1;			

	/** 
	 * ° Ű 
	 */
	const POS_THIRD = 2;		

	/** 
	 *  Ű 
	 */
	const POS_MAX	= 1000;			

	// ⺻ Լ ̺ 
	private $function_list = array();


	public function __construct($string = '') { 
		$this->source	= $string;
		$this->current	= $string;

		$this->init();
	}

	public function init() { 

		//  ޼ҵ ȣ 
		$this->setFunctionList('before',	array($this, '_before'),	self::POS_ZERO);
		$this->setFunctionList('append',	array($this, '_append'),	self::POS_ZERO);
		$this->setFunctionList('left',		array($this, '_left'),		self::POS_ZERO);
		$this->setFunctionList('right',		array($this, '_right'),	self::POS_ZERO);
	}

	/**
	 * string Լ ڵ 
	 *
	 * @return String 
	 */
	public function __call($method, $args) { 

		$method = strtolower($method);

		if (! $this->isFunction($method)) return  ;

		// String ü  array ȯŴ 
		foreach ($args as $key => $value) { 
			$args[$key] = PObject::getObjValue($value);
		}

		// ڱڽ  Ǹ Ű ۼ 

		if ($this->getPos($method) > self::POS_ZERO) { 
			$this->createMethodArgs($method, $args);	
		}

		// ޼ҵ  

		$this->return = call_user_func_array($this->getFunction($method), $args);

		//  ̰ is_reference Ӽ false ̸ 
		// ,  return  current  ٲ 
		if ($this->is_ref) { 
			$this->current = $this->return;
		}

		//  α  
		$this->log($method, $args, $this->current);

		//  ʱȭ 
		$this->ref(false);

		return $this;
	}


	/**
	 *  Լ  
	 *
	 * @param string $name Լ̸
	 * @param string|array $run callback 
	 * @param int $pos Ű ġ
	 */
	public function setFunctionList($name, $run, $pos) { 
		$this->function_list[$name] = array('function' => $run,	'pos' => $pos);
	}

	public function isFunction($name) { 
		return  (array_key_exists($name, $GLOBALS['FUNCTION_TABLE']['STRING']) or array_key_exists($name, $this->function_list));
	}

	public function __get($key) { 

		switch (strtolower($key)) { 
			case 'return':	return $this->return;
			case 'to':		return $this->current;
			case 'source':	return $this->source;
			case 'history': return $this->history;
			case 'object':	return (is_array($this->return) ? A_($this->return) : new String($this->return));
		}

		return '';
	}

	/**
	 *   ȯ
	 *
	 * @param bool $is_ref  , true̸   , ⺻ true, 
	 * @return String 
	 * @see String::r()
	 */
	public function ref($is_ref = true) { 
		$this->is_ref = $is_ref;

		return $this;
	}

	/**
	 *  ƴ  Լ   ڵ · ȯ 
	 *
	 * @return String 
	 * @see String::ref()
	 */
	public function r() { 
		$this->ref();

		$arr = func_get_args();
		$func = array_shift($arr);

		return call_user_func_array(array($this, $func), $arr);

	}


	/** 
	 * Ű ġ 
	 *
	 * @param string $method   Լ ̸ 
	 * @return int    Ű ġ 
	 *
	 */
	public function getPos($method) { 

		if (array_key_exists($method, $GLOBALS['FUNCTION_TABLE']['STRING'])) { 
			return $GLOBALS['FUNCTION_TABLE']['STRING'][$method]['pos'];
		} else { 
			return $this->function_list[$method]['pos'];
		}
	}
	
	/** 
	 *   Լ 
	 * 
	 * @param string $method   Լ ̸ 
	 * @return callback   ݹ̸ 
	 */
	public function getFunction($method) { 
		return D_($GLOBALS['FUNCTION_TABLE']['STRING'][$method]['function'] , $this->function_list[$method]['function']);
	}


	private function log($method, $args, $result) { 
		$this->history[] = array('method' => $method, 'args'=> $args, 'result' => $result);
	}

	/**
	 * Ű  
	 *
	 *  Ű current  ļ   Ű Ʈ ȯѴ. 
	 *
	 * @param string $method  Լ ̸ 
	 * @param array $args  Ű 
	 */
	private function createMethodArgs($method, &$args) { 
		$pos = $this->getPos($method);

		$left = array_slice($args, 0, $pos);
		$right = array_slice($args, $pos);

		if ($pos == self::POS_MAX) { 
			$args[] = $this->current;
		}  else { 
			$args = array_merge($left, array($this->current), $right);
		}
	}

	/**
	 * ڿ ڸ ( ʿ)
	 * php_mbstring.dll ε ʿ 
	 * 
	 * @param	string	$str	ڿ
	 * @param	int		$length ڸ 
	 * @param	string	$subfix	ڿ  ڿ, ⺻ "..."
	 * @return	string
	 *
	 */
	public static function cut($str, $length, $subfix = "...") {
		if (strlen($str) <= $length) { 
			return $str;
		} else { 
			return substr($str, 0, $length).$subfix;
		}	
	}

	/**
	 * UTF-8 · ڿ ȯ  (php5 iconv  ⺻ ž)
	 * 
	 * @param	string $str		ȯ ڿ
	 * @param	string $encoding  ڵ
	 * @return	string
	 *
	 */
	public static function getUTF8($str, $encoding = 'CP949') { 
		return iconv($encoding, 'utf-8', $str);
	}

	/**
	 * EUC-KR · ڿ ȯ  (php5 iconv  ⺻ ž)
	 * 
	 * @param	string	$str	  ȯ ڿ
	 * @param	string 	$encoding  ڵ
	 * @return	string
	 *
	 */

	public static function getEUCKR($str, $encoding = 'UTF-8') { 
		return iconv($encoding, 'euc-kr', $str);
	}

	/**
	 * ± ,  
	 * 
	 * @param	string	$tagName  ± ̸
	 * @param	string	$subject  ˻ ڿ
	 * @param	boolean	$isOne	  true : One ±, false : Two ±
	 *
	 * @return	array	  tag			: ± ̸,
	 *					  body			: Ī ڿ,
	 *					  id			:  ̵,
	 *					  attribute		: Ӽ,
	 *					  description	: ,
	 *					  convert		: ȯ 
	 *
	 */
	public static function matchTag($tagName, $subject, $isOne = true) {
		$tagName = strtolower($tagName);

		if ($isOne) { 
			$pattern = "/(\\[{$tagName}(=([^ ]+))? ([^\\]]+)\\])+/i";
		} else { 
			$pattern = "/(\\[{$tagName}(=([^\\] ]+))?([^\\]]*)\\]([^\\a]*)\\[\\/{$tagName}\\])+/i";
		}

		preg_match_all($pattern, $subject, $out, PREG_SET_ORDER);

		$arr = array();

		foreach ($out as $obj) {
			$arr[] = array(
						'tag'			=> $tagName,		// ± ̸
						'body'			=> $obj[1],			// Ī ڿ
						'id'			=> $obj[3],			// ̵
						'attribute'		=> $obj[4],			// Ӽ
						'description'	=> $obj[5],			// 
						'convert'		=> $obj[5]			// ȯ 
			);
		}

		return $arr;
	}

	/**
	 * ± 
	 *
	 * callback Լ ⺻ attribute, description  ̿ؼ convert ϴ Լ̴. 
	 * ⺻ ´ 
	 *
	 *  <code>
	 *  function callback_func(&$obj) { 
	 *		$obj['convert'] = str_replace("\n", "<br>", $obj['description']);
	 *	} </code>
	 *
	 *  
	 *  callback Լ Ŭ ޼ҵ 
	 * 
	 *  <code>
	 *  class AAA { 
     *     function callback_func(&$obj) { 
     *
	 *		}
	 *	}
	 *  
	 *  $class = new AAA;
	 *  array($class, 'callback_func'); 
	 *  </code>
	 * 
	 * 	 ؼ callback Լ κп ־ ָ ȴ.
	 *
	 * @param	string	$tagName	± ̸
	 * @param	string	$subject	˻ ڿ
	 * @param	boolean	$isOne		true : One ±, false : Two ±
	 * @param	callback	$callback	callback Լ
	 *
	 * @return	array	  tag			: ± ̸,
	 *					  body			: Ī ڿ,
	 *					  id			:  ̵,
	 *					  attribute		: Ӽ,
	 *					  description	: ,
	 *					  convert		: ȯ 
	 *
	 */
	public static function matchTagCallBack($tagName, $subject, $isOne, $callback) { 
		if ($callback == null) return;

		$arr = String::matchTag($tagName, $subject, $isOne);

		if ($callback != null) { 
			foreach ($arr as &$obj) { 
				$obj = call_user_func($callback, $obj);
			}
		} 

		return $arr;
	}

	/**
	 * ڿ ȯ 
	 * 
	 * @param	string	$tagName  ± ̸
	 * @param	string	$subject  ˻ ڿ
	 * @param	boolean	$isOne	  true : One ±, false : Two ±
	 * @param	callback $callback callback Լ
	 * @return	string	ȯ $subject 		
	 */
	public static function matchTagReplace($tagName, $subject, $isOne, $callback)  { 
		
		$arr = String::matchTagCallBack($tagName, $subject, $isOne, $callback);

		foreach ($arr as $obj) { 
			$subject = str_replace($obj['body'].PHP_EOL, $obj['convert'], $subject);
			$subject = str_replace($obj['body'], $obj['convert'], $subject);
		}

		return $subject;
	}

	private function _before($string = '') { 
		return $string.$this->current;
	}

	private function _append($string = '') { 
		return $this->current.$string;
	}

	private function _left($len) { 
		return substr($this->current, 0, $len);
	}

	private function _right($len) { 
		return substr($this->current, strlen($this->current) - $len, $len-1);
	}

	public function toString() { 
		return $this->current;
	}
}


$GLOBALS['FUNCTION_TABLE']['STRING'] = array (
	'addcslashes'	=> array('function' => 'addcslashes',	'pos' => String::POS_FIRST),
	'addslashes'	=> array('function' => 'addslashes',	'pos' => String::POS_FIRST),
	'bin2hex'		=> array('function' => 'bin2hex',		'pos' => String::POS_FIRST),
	'chop'			=> array('function' => 'chop',			'pos' => String::POS_FIRST),
	'chr'			=> array('function' => 'chr',			'pos' => String::POS_FIRST),
	'count_chars'	=> array('function' => 'count_chars',	'pos' => String::POS_FIRST),
	'entity_encode'	=> array('function' => 'htmlentities',	'pos' => String::POS_FIRST),
	'entity_decode'	=> array('function' => 'html_entity_decode',	'pos' => String::POS_FIRST),
	'explode'		=> array('function' => 'explode',		'pos' => String::POS_SECOND),
	'implode'		=> array('function' => 'implode',		'pos' => String::POS_ZERO),
	'join'			=> array('function' => 'join',			'pos' => String::POS_ZERO),
	'ltrim'			=> array('function' => 'ltrim',			'pos' => String::POS_FIRST),
	'md5'			=> array('function' => 'md5',			'pos' => String::POS_FIRST),
	'nl2br'			=> array('function' => 'nl2br',			'pos' => String::POS_FIRST),
	'ord'			=> array('function' => 'ord',			'pos' => String::POS_FIRST),
	'parse'			=> array('function' => 'parse_str',		'pos' => String::POS_FIRST),
	'print'			=> array('function' => 'print',			'pos' => String::POS_FIRST),
	'printf'		=> array('function' => 'printf',		'pos' => String::POS_FIRST),
	'rtrim'			=> array('function' => 'rtrim',			'pos' => String::POS_FIRST),
	'similar'		=> array('function' => 'similar_text',	'pos' => String::POS_FIRST),
	'soundex'		=> array('function' => 'soundex',		'pos' => String::POS_FIRST),
	'sprintf'		=> array('function' => 'sprintf',		'pos' => String::POS_FIRST),
	'sscanf'		=> array('function' => 'sscanf',		'pos' => String::POS_SECOND),
	'ireplace'		=> array('function' => 'str_ireplace',	'pos' => String::POS_FIRST),
	'pad'			=> array('function' => 'str_pad',		'pos' => String::POS_FIRST),
	'repeat'		=> array('function' => 'str_repeat',	'pos' => String::POS_FIRST),
	'replace'		=> array('function' => 'str_replace',	'pos' => String::POS_THIRD),
	'rot13'			=> array('function' => 'str_rot13',		'pos' => String::POS_FIRST),
	'shuffle'		=> array('function' => 'str_shuffle',	'pos' => String::POS_FIRST),
	'count_split'	=> array('function' => 'str_split',		'pos' => String::POS_FIRST),
	'word_count'	=> array('function' => 'str_word_count','pos' => String::POS_FIRST),
	'casecmp'		=> array('function' => 'strcasecmp',	'pos' => String::POS_FIRST),
	'cmp'			=> array('function' => 'strcmp',		'pos' => String::POS_FIRST),
	'coll'			=> array('function' => 'strcoll',		'pos' => String::POS_FIRST),
	'strip'			=> array('function' => 'strip_tags',	'pos' => String::POS_FIRST),
	'stripcslashes'	=> array('function' => 'stripcslashes',	'pos' => String::POS_FIRST),
	'ipos'			=> array('function' => 'stripos',		'pos' => String::POS_FIRST),
	'stripslashes'	=> array('function' => 'stripslashes',	'pos' => String::POS_FIRST),
	'istr'			=> array('function' => 'stristr',		'pos' => String::POS_FIRST),
	'len'			=> array('function' => 'strlen',		'pos' => String::POS_FIRST),
	'natcasecmp'	=> array('function' => 'strnatcasecmp',	'pos' => String::POS_FIRST),
	'natcmp'		=> array('function' => 'strnatcmp',		'pos' => String::POS_FIRST),
	'ncasecmp'		=> array('function' => 'strncasecmp',	'pos' => String::POS_FIRST),
	'ncmp'			=> array('function' => 'strncmp',		'pos' => String::POS_FIRST),
	'pbrk'			=> array('function' => 'strpbrk',		'pos' => String::POS_FIRST),
	'pos'			=> array('function' => 'strpos',		'pos' => String::POS_FIRST),
	'last_string'	=> array('function' => 'strrchr',		'pos' => String::POS_FIRST),
	'reverse'		=> array('function' => 'strrev',		'pos' => String::POS_FIRST),
	'reverse_ipos'	=> array('function' => 'strripos',		'pos' => String::POS_FIRST),
	'reverse_pos'	=> array('function' => 'strrpos',		'pos' => String::POS_FIRST),
	'first_string'	=> array('function' => 'strstr',		'pos' => String::POS_FIRST),
	'lower'			=> array('function' => 'strtolower',	'pos' => String::POS_FIRST),
	'upper'			=> array('function' => 'strtoupper',	'pos' => String::POS_FIRST),
	'translate'		=> array('function' => 'strtr',			'pos' => String::POS_FIRST),
	'sub_compare'	=> array('function' => 'substr_compare','pos' => String::POS_FIRST),
	'sub_count'		=> array('function' => 'substr_count',	'pos' => String::POS_FIRST),
	'sub_replace'	=> array('function' => 'substr_replace','pos' => String::POS_FIRST),
	'substring'		=> array('function' => 'substr',		'pos' => String::POS_FIRST),
	'trim'			=> array('function' => 'trim',			'pos' => String::POS_FIRST),
	'ucfirst'		=> array('function' => 'ucfirst',		'pos' => String::POS_FIRST),
	'ucwords'		=> array('function' => 'ucwords',		'pos' => String::POS_FIRST),
	'wrap'			=> array('function' => 'wordwrap',		'pos' => String::POS_FIRST),
	'iconv'			=> array('function' => 'iconv',			'pos' => String::POS_THIRD),
	'base64_encode'	=> array('function' => 'base64_encode',	'pos' => String::POS_FIRST),
	'base64_decode'	=> array('function' => 'base64_decode',	'pos' => String::POS_FIRST),
	'build_query'	=> array('function' => 'http_build_query',	'pos' => String::POS_ZERO),
	'parse_url'		=> array('function' => 'parse_url',		'pos' => String::POS_FIRST),
	'rawencode'		=> array('function' => 'rawurlencode',	'pos' => String::POS_FIRST),
	'rawdecode'		=> array('function' => 'rawurldecode',	'pos' => String::POS_FIRST),
	'urlencode'		=> array('function' => 'urlencode',		'pos' => String::POS_FIRST),
	'urldecode'		=> array('function' => 'urldecode',		'pos' => String::POS_FIRST),
	'highlight'		=> array('function' => 'highlight_string',	'pos' => String::POS_FIRST),
	'phpstrip'		=> array('function' => 'php_strip_whitespace',	'pos' => String::POS_FIRST),
	'constant'		=> array('function' => 'constant',		'pos' => String::POS_FIRST),
	'split'			=> array('function' => 'split',			'pos' => String::POS_SECOND),
	'spliti'		=> array('function' => 'spliti',		'pos' => String::POS_SECOND),
	'number_format'	=> array('function' => 'number_format',	'pos' => String::POS_FIRST),
	'money_format'	=> array('function' => 'money_format',	'pos' => String::POS_FIRST),
	'match_all'		=> array('function' => 'preg_match_all',	'pos' => String::POS_SECOND),
	'match'			=> array('function' => 'preg_match',	'pos' => String::POS_SECOND),
	'preg_qoute'	=> array('function' => 'preg_qoute',	'pos' => String::POS_SECOND),
	'preplace_callback'	=> array('function' => 'preg_replace_callback',	'pos' => String::POS_THIRD),
	'preplace'		=> array('function' => 'preg_replace',	'pos' => String::POS_THIRD),
	'psplit'		=> array('function' => 'preg_split',	'pos' => String::POS_SECOND),
);

?>