package net.kldp.beat.upload;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.commons.fileupload.FileItem;

public class FormFileImpl extends File implements FormFile {
	private static final long serialVersionUID = 2619755555221510054L;
	private File file;
	private String fieldName;
	private String contentType;

	public FormFileImpl(File file) {
		super(file.getAbsolutePath());
		this.file = file;
	}

	public FormFileImpl(FileItem item) {
		super("sdfdsfdsf");
	}

	@Override
	public String getFieldName() {
		return fieldName;
	}

	public void setFieldName(String fieldName) {
		this.fieldName = fieldName;
	}

	@Override
	public void copyFile(File copyFile) throws IOException {
		if (copyFile.exists()) {
			copyFile.createNewFile();
		}
		FileInputStream fis = new FileInputStream(file);
		FileOutputStream fos = new FileOutputStream(copyFile);
		try {
			byte[] buf = new byte[1024];
			int i = 0;
			while ((i = fis.read(buf)) != -1) {
				fos.write(buf, 0, i);
			}
		} catch (IOException e) {
			throw e;
		} finally {
			if (fis != null)
				fis.close();
			if (fos != null)
				fos.close();
		}
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
	}

	@Override
	public String getContentType() {
		return contentType;
	}

	@Override
	public String getFileName() {
		return file == null ? null : file.getName();
	}

	@Override
	public int getFileSize() {
		return (int) (file == null ? 0 : file.length());
	}

	@Override
	public String getFileSuffix() {
		String fileName = getFileName();
		if (fileName == null)
			return null;
		String value = fileName.substring(fileName.lastIndexOf('.') + 1, fileName.length());
		if (fileName.lastIndexOf('.') > 0)
			return value;
		else
			return "";
	}
}