package net.kldp.beat.map;

import java.util.Enumeration;

import javax.servlet.http.HttpServletRequest;

public class RequestMap extends AbstractMap {

	private HttpServletRequest request;

	public RequestMap(HttpServletRequest request) {
		this.request = request;
	}
	
	@Override
	Object getAttribute(String key) {
		return request.getAttribute(key);
	}

	@SuppressWarnings("unchecked")
	@Override
	Enumeration<String> getAttributeNames() {
		return request.getAttributeNames();
	}

	@Override
	void removeAttribute(String key) {
		request.removeAttribute(key);
	}

	@Override
	void setAttribute(String key, Object value) {
		request.setAttribute(key, value);
	}
}