package net.kldp.beat.map;

import java.util.Enumeration;
import java.util.Map;

import javax.servlet.ServletContext;

public class ApplicationMap extends AbstractMap implements Map<String, Object> {

	private ServletContext servletContext;

	public ApplicationMap(ServletContext servletContext) {
		this.servletContext = servletContext;
	}

	@SuppressWarnings("unchecked")
	Enumeration<String> getAttributeNames() {
		return servletContext.getAttributeNames();
	}

	void removeAttribute(String key) {
		servletContext.removeAttribute(key);
	}

	Object getAttribute(String key) {
		return servletContext.getAttribute(key);
	}

	void setAttribute(String key, Object value) {
		servletContext.setAttribute(key, value);
	}
}