package net.kldp.beat.action;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyCopy {
	private static Log logger = LogFactory.getLog(PropertyCopy.class);

	@SuppressWarnings("unchecked")
	public static void beanToMap(Object bean, Map<String, Object> map) {
		map.putAll(describe(bean));
	}

	public static void mapToBean(Map<String, Object> map, Object bean) {
		populate(bean, map);
	}

	public static void beanToBean(Object from, Object to) {
		populate(to, describe(from));
	}

	private static void populate(Object bean, Map<String, Object> map) {
		try {
			BeanUtils.populate(bean, map);
		} catch (IllegalAccessException e) {
			logger.fatal(e);
		} catch (InvocationTargetException e) {
			logger.fatal(e);
		}
	}

	@SuppressWarnings("unchecked")
	private static Map<String, Object> describe(Object bean) {
		try {
			Map<String, Object> map;
			map = PropertyUtils.describe(bean);
			map.remove("class");
			return map;
		} catch (IllegalAccessException e) {
			logger.fatal(e);
		} catch (InvocationTargetException e) {
			logger.fatal(e);
		} catch (NoSuchMethodException e) {
			logger.fatal(e);
		}
		return new HashMap<String, Object>();
	}
}