/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ServletDispatcher;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;
import org.apache.commons.beanutils.PropertyUtils;

public class ServletDispatcherImpl
implements ServletDispatcher {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletContext context;
    private static final String REDIRECT = "redirect";
    private static final String FORWARD = "forward";
    private static final String STREAM = "stream";

    public ServletDispatcherImpl(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.context = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    @Override
    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    @Override
    public String getQueryString() {
        return this.request.getQueryString();
    }

    @Override
    public void dispatch(String string, String string2) throws ServletException, IOException {
        if (string2.equals(REDIRECT)) {
            this.response.sendRedirect(string);
        } else if (string2.equals(FORWARD)) {
            RequestDispatcher requestDispatcher = this.context.getRequestDispatcher(string);
            requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        } else if (string2.equals(STREAM)) {
            FileInputStream fileInputStream = new FileInputStream(string);
            ServletOutputStream servletOutputStream = this.response.getOutputStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                servletOutputStream.write(byArray, 0, n);
            }
            fileInputStream.close();
            servletOutputStream.close();
        } else {
            throw new ServletException("can not dispath Result. unknown type - " + string2);
        }
    }

    @Override
    public void dispatch(Result result, Object object) throws ServletException, IOException {
        String string = result.type().toLowerCase();
        if (string.equals(FORWARD)) {
            String string2 = Config.view_path() + result.value();
            System.out.println(string2);
            string2 = this.interpretString(string2, this.actionToMap(object));
            if (result.params() != null && result.params().length > 0) {
                String string3 = this.interpretString(this.arrayToParam(result.params()), this.actionToMap(object));
                string2 = string2 + "?" + string3;
            }
            this.dispatch(string2, string);
        } else if (string.equals(REDIRECT)) {
            this.dispatch(result.value(), string);
        } else if (string.equals(STREAM)) {
            String string4 = this.interpretString(result.value(), this.actionToMap(object));
            this.response.setContentType(result.contentType());
            this.dispatch(string4, string);
        } else {
            throw new ServletException("can not dispath Result. unknown type - " + string);
        }
    }

    private String interpretString(String string, Map<String, Object> map) {
        for (String string2 : map.keySet()) {
            System.out.println(string2);
            Object object = map.get(string2);
            System.out.println(object);
            if (object == null) continue;
            string = string.replaceAll("\\$\\{" + string2 + "}", object.toString());
        }
        return string;
    }

    private Map<String, Object> actionToMap(Object object) {
        try {
            Map map = null;
            map = PropertyUtils.describe((Object)object);
            map.remove("class");
            return map;
        }
        catch (Exception exception) {
            return new HashMap<String, Object>();
        }
    }

    private String arrayToParam(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string + "&");
        }
        if (stringBuffer.length() < 1) {
            return "";
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1);
    }
}

