/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ActionContext;
import net.kldp.beat.action.ActionMapper;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.action.PropertyCopy;
import net.kldp.beat.action.ServletDispatcherImpl;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.interceptor.SystemInterceptor;
import net.kldp.beat.interceptor.UserInterceptor;
import net.kldp.beat.web.interceptor.InterceptorFactory;

public class ActionService {
    private ServletDispatcherImpl dispatcher;
    private ActionContext context;

    public ActionService(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.dispatcher = new ServletDispatcherImpl(servletContext, httpServletRequest, httpServletResponse);
        this.context = new ActionContext(httpServletRequest, httpServletResponse, servletContext);
    }

    public void doService(Object object, ActionMapper actionMapper) throws ServletException {
        InterceptorStack interceptorStack = new InterceptorStack(object);
        this.executeSystemInterceptor(object, interceptorStack.getSystemInterceptors());
        PropertyCopy.mapToBean(this.context.getParameterMap(), object);
        if (!this.validate(object, interceptorStack.getResult("input"))) {
            return;
        }
        this.initInterceptors(interceptorStack);
        if (!this.executeInterceptors(object, interceptorStack.getBeforeInterceptors())) {
            this.executeInterceptors(object, interceptorStack.getAfterInterceptors());
            return;
        }
        this.invokeMethod(object, interceptorStack.getBeforeMethod());
        Result result = interceptorStack.getResult(this.executeAction(object));
        if (result == null) {
            if (!interceptorStack.hasResults()) {
                result = actionMapper.getDefaultResult();
            } else {
                throw new ServletException("can not found Result");
            }
        }
        this.invokeMethod(object, interceptorStack.getBeforeResultMethod());
        System.out.println("Bean injection");
        PropertyCopy.beanToMap(object, this.context.getRequestMap());
        this.dispatchView(result, object);
        this.invokeMethod(object, interceptorStack.getAfterMethod());
        this.executeInterceptors(object, interceptorStack.getAfterInterceptors());
    }

    private void initInterceptors(InterceptorStack interceptorStack) throws InterceptorException {
        Object object;
        Object object2;
        Map<UserInterceptor, Annotation> map = interceptorStack.getBeforeInterceptors();
        for (UserInterceptor object3 : map.keySet()) {
            Object object4 = InterceptorStack.getAnnotations(object3);
            object2 = ((ArrayList)object4).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                InterceptorFactory.intecept((UserInterceptor)object3, (ActionContext)this.context, (Annotation)object);
            }
        }
        Map<UserInterceptor, Annotation> map2 = interceptorStack.getAfterInterceptors();
        for (Object object4 : map2.keySet()) {
            if (map.containsKey(object4)) continue;
            object2 = InterceptorStack.getAnnotations(object4);
            object = ((ArrayList)object2).iterator();
            while (object.hasNext()) {
                Annotation annotation = (Annotation)object.next();
                InterceptorFactory.intecept((UserInterceptor)object4, (ActionContext)this.context, (Annotation)annotation);
            }
        }
    }

    private void dispatchView(Result result, Object object) throws ServletException {
        try {
            this.dispatcher.dispatch(result, object);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
    }

    private boolean validate(Object object, Result result) throws ServletException {
        if (this.context.getErrorsMap().size() > 0) {
            if (result == null) {
                throw new ServletException("can not found Result annotation for input.");
            }
            PropertyCopy.beanToMap(object, this.context.getRequestMap());
            System.out.println("name" + this.context.getRequestMap().get("name"));
            try {
                this.dispatcher.dispatch(result, object);
            }
            catch (IOException iOException) {
                throw new ServletException((Throwable)iOException);
            }
            return false;
        }
        return true;
    }

    private void invokeMethod(Object object, Method method) throws ServletException {
        if (method != null) {
            try {
                method.invoke(object, new Object[]{null});
            }
            catch (Exception exception) {
                throw new ServletException("Can not execute Method");
            }
        }
    }

    private void executeSystemInterceptor(Object object, Map<SystemInterceptor, Annotation> map) throws InterceptorException {
        InterceptorFactory.intecept((Object)object, map, (ActionContext)this.context);
    }

    private boolean executeInterceptors(Object object, Map<UserInterceptor, Annotation> map) throws ServletException {
        boolean bl = true;
        for (UserInterceptor userInterceptor : map.keySet()) {
            if (userInterceptor.intercept(object, map.get(userInterceptor))) continue;
            bl = false;
        }
        return bl;
    }

    private String executeAction(Object object) throws ServletException {
        try {
            Method method = object.getClass().getMethod("execute", new Class[0]);
            return (String)method.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
    }
}

