/*
 * Decompiled with CFR 0.152.
 */
package net.kldp.beat.action;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.kldp.beat.action.ActionMapper;
import net.kldp.beat.action.AwareInjector;
import net.kldp.beat.action.InterceptorStack;
import net.kldp.beat.action.ServletDispatcherImpl;
import net.kldp.beat.annotation.Multipart;
import net.kldp.beat.annotation.Result;
import net.kldp.beat.config.Config;
import net.kldp.beat.exception.InterceptorException;
import net.kldp.beat.exception.ValidationException;
import net.kldp.beat.interceptor.Interceptor;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class ActionService {
    private HttpServletResponse response;
    private HttpServletRequest request;
    private ServletContext context;
    private Object action;

    public ActionService(ServletContext servletContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.context = servletContext;
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }

    public void doService(Object object, ActionMapper actionMapper) throws ServletException {
        Result result;
        this.action = object;
        ServletDispatcherImpl servletDispatcherImpl = new ServletDispatcherImpl(this.context, this.request, this.response);
        AwareInjector awareInjector = new AwareInjector(this.context, this.request, this.response);
        InterceptorStack interceptorStack = new InterceptorStack(object, awareInjector);
        try {
            this.injectionProperties(interceptorStack.getMultipart());
        }
        catch (FileUploadException fileUploadException) {
            throw new ServletException("can not upload file" + (Object)((Object)fileUploadException));
        }
        awareInjector.injection(object);
        try {
            if (!awareInjector.validation(object)) {
                Result result2 = interceptorStack.getResult("input");
                if (result2 == null) {
                    throw new ServletException("can not found Result annotation for input.");
                }
                this.injectionProperties(awareInjector.getRequestMap());
                try {
                    servletDispatcherImpl.dispatch(result2, object);
                    return;
                }
                catch (IOException iOException) {
                    throw new ServletException((Throwable)iOException);
                }
            }
        }
        catch (ValidationException validationException) {
            throw new ServletException((Throwable)validationException);
        }
        if (!this.executeInterceptors(interceptorStack.getBeforeInterceptors())) {
            this.executeInterceptors(interceptorStack.getAfterInterceptors());
            return;
        }
        this.executeMethod(interceptorStack.getBeforeMethod());
        try {
            result = interceptorStack.getResult(this.executeAction());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ServletException((Throwable)invocationTargetException);
        }
        if (result == null) {
            if (interceptorStack.getResults().size() == 0) {
                result = actionMapper.getDefaultResult();
            } else {
                throw new ServletException("can not found Result");
            }
        }
        this.executeMethod(interceptorStack.getBeforeResultMethod());
        this.injectionProperties(awareInjector.getRequestMap());
        try {
            servletDispatcherImpl.dispatch(result, object);
        }
        catch (IOException iOException) {
            throw new ServletException((Throwable)iOException);
        }
        this.executeMethod(interceptorStack.getAfterMethod());
        this.executeInterceptors(interceptorStack.getAfterInterceptors());
    }

    private void executeMethod(Method method) throws ServletException {
        if (method != null) {
            try {
                method.invoke(this.action, new Object[]{null});
            }
            catch (Exception exception) {
                throw new ServletException("Can not execute Method");
            }
        }
    }

    private boolean executeInterceptors(Map<Interceptor, Annotation> map) throws ServletException {
        boolean bl = true;
        for (Interceptor interceptor : map.keySet()) {
            try {
                if (interceptor.intercept(this.action, map.get(interceptor))) continue;
                bl = false;
            }
            catch (InterceptorException interceptorException) {
                throw new ServletException((Throwable)interceptorException);
            }
        }
        return bl;
    }

    private void injectionProperties(Multipart multipart) throws FileUploadException {
        try {
            if (multipart != null && ServletFileUpload.isMultipartContent((HttpServletRequest)this.request)) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                HashMap<String, File> hashMap2 = new HashMap<String, File>();
                DiskFileItemFactory diskFileItemFactory = new DiskFileItemFactory();
                diskFileItemFactory.setSizeThreshold(0x100000);
                if (!Config.temp_dir().equals("")) {
                    diskFileItemFactory.setRepository(new File(Config.temp_dir()));
                }
                ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)diskFileItemFactory);
                if (multipart.size() > 0) {
                    servletFileUpload.setSizeMax((long)(multipart.size() * 1024 * 1024));
                } else if (Config.max_upload_size() > 0) {
                    servletFileUpload.setSizeMax((long)(Config.max_upload_size() * 1024 * 1024));
                }
                List list = servletFileUpload.parseRequest(this.request);
                for (FileItem fileItem : list) {
                    if (fileItem.isFormField()) {
                        hashMap.put(fileItem.getFieldName(), fileItem.getString());
                        continue;
                    }
                    hashMap.put(fileItem.getFieldName(), fileItem.getName());
                    hashMap2.put(fileItem.getFieldName(), new File(fileItem.getName()));
                }
                if (hashMap.size() > 0) {
                    BeanUtils.populate((Object)this.action, hashMap);
                }
                if (hashMap2.size() > 0) {
                    BeanUtils.populate((Object)this.action, hashMap2);
                }
            } else {
                BeanUtils.populate((Object)this.action, (Map)this.request.getParameterMap());
            }
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    private void injectionProperties(Map<String, Object> map) {
        try {
            Map map2 = PropertyUtils.describe((Object)this.action);
            map2.remove("class");
            map.putAll(map2);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
    }

    private String executeAction() throws InvocationTargetException {
        try {
            Method method = this.action.getClass().getMethod("execute", new Class[0]);
            String string = (String)method.invoke(this.action, new Object[0]);
            return string;
        }
        catch (Exception exception) {
            throw new InvocationTargetException(exception);
        }
    }
}

