package com.babukuma.util.dbunit;

import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JFrame;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JLabel;
import javax.swing.JComboBox;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JScrollPane;

/**
 * 사용자 인터페이스 부분
 * @author BABUKUMA
 */
public class TestXmlCreator extends JFrame implements ActionListener {

    /**
     * Serial Version UID
     */
    private static final long serialVersionUID = 1L;

    /**
     * DataBase Select ComboBox
     */
    private JComboBox jcmbDBType = null;

    /**
     * JDBC Driver Name
     */
    private JTextField jtxfDriver = null;

    /**
     * JDBC Class Location
     */
    private JTextField jtxfLocation = null;

    /**
     * DB Connect URL
     */
    private JTextField jtxfURL = null;

    /**
     * DB Connect User ID
     */
    private JTextField jtxfUserID = null;

    /**
     * DB Connect User Password
     */
    private JPasswordField jpwfPassword = null;

    /**
     * 사용할 DB Schema
     */
    private JTextField jtxfSchema = null;

    /**
     * 결과 테이블의 이름
     */
    private JTextField jtxfResultName = null;

    /**
     * 생성할 Test Xml File의 Path
     */
    private JTextField jtxfFile = null;

    /**
     * Select문으로 생성할 지, 전체 테이블을 생성할 지 선택하는 RadioButton
     */
    private JRadioButton[] jrdoScope = null;

    /**
     * Class File 찾기 Button
     */
    private JButton jbtnLocation = null;

    /**
     * 생성할 파일의 경로 설정 버튼
     */
    private JButton jbtnFile = null;

    /**
     * 모든 조건을 Reset하는 버튼
     */
    private JButton jbtnReset = null;

    /**
     * Test Xml File 생성 버튼
     */
    private JButton jbtnCreate = null;

    /**
     * Select 문 입력 TextArea
     */
    private JTextArea jtxaQuery = null;

    /**
     * DataBase Type
     */
    private final String[] dbType = {"Oracle", "MySQL", "MS-SQL", "DB2",
        "HSQLDB"};

    /**
     * This method initializes jPanelTop
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlTop() {
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.setRows(7);
        JPanel jpnlTop = new JPanel();
        jpnlTop.setBorder(javax.swing.BorderFactory.createTitledBorder(
            javax.swing.BorderFactory
                .createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED),
            "DB Information",
            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
            javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
        jpnlTop.setLayout(gridLayout1);
        jpnlTop.add(getJpnlDBType(), null);
        jpnlTop.add(getJpnlDriver(), null);
        jpnlTop.add(getJpnlLocation(), null);
        jpnlTop.add(getJpnlURL(), null);
        jpnlTop.add(getJpnlUserID(), null);
        jpnlTop.add(getJpnlPassword(), null);
        jpnlTop.add(getJpnlSchema(), null);

        return jpnlTop;
    }

    /**
     * This method initializes jPanelDown
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlDown() {
        JLabel jlblQuery = new JLabel();
        jlblQuery.setText("Query");
        JPanel jpnlDown = new JPanel();
        jpnlDown.setLayout(new BorderLayout());
        jpnlDown.setBorder(javax.swing.BorderFactory.createTitledBorder(
            javax.swing.BorderFactory
                .createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED),
            "Create Data Infomation",
            javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION,
            javax.swing.border.TitledBorder.DEFAULT_POSITION, null, null));
        jpnlDown.add(getJpnlScope(), java.awt.BorderLayout.NORTH);
        jpnlDown.add(getJpnlSouth(), java.awt.BorderLayout.SOUTH);
        jpnlDown.add(jlblQuery, java.awt.BorderLayout.WEST);
        jpnlDown.add(getJscpQuery(), java.awt.BorderLayout.CENTER);

        return jpnlDown;
    }

    /**
     * This method initializes jPanelDBType
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlDBType() {
        JLabel jlblDBType = new JLabel();
        jlblDBType.setText("DB Type");
        jlblDBType.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        jlblDBType.setToolTipText("DB Type");
        jlblDBType.setPreferredSize(new java.awt.Dimension(100, 18));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlDBType = new JPanel();
        jpnlDBType.setLayout(flowLayout);
        jpnlDBType.add(jlblDBType, null);

        // JComboBox jcmbDBType
        jcmbDBType = new JComboBox();

        for (int i = 0; i < dbType.length; i++) {
            jcmbDBType.addItem(dbType[i]);
        }
        jpnlDBType.add(jcmbDBType, null);

        return jpnlDBType;
    }

    /**
     * This method initializes jpnlDriver
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlDriver() {
        JLabel jlblDriver = new JLabel();
        jlblDriver.setText("JDBC Driver");
        jlblDriver.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblDriver.setToolTipText("JDBC Driver Class");
        jlblDriver.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout1 = new FlowLayout();
        flowLayout1.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlDriver = new JPanel();
        jpnlDriver.setLayout(flowLayout1);
        jpnlDriver.add(jlblDriver, null);

        // TextField jtxfDriver
        jtxfDriver = new JTextField();
        jtxfDriver.setPreferredSize(new java.awt.Dimension(250, 22));
        // jtxfDriver.setText("oracle.jdbc.driver.OracleDriver");
        jpnlDriver.add(jtxfDriver, null);

        return jpnlDriver;
    }

    /**
     * This method initializes jpnlLocation
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlLocation() {
        JLabel jlblLocation = new JLabel();
        jlblLocation.setText("Class location");
        jlblLocation.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblLocation.setToolTipText("Class location");
        jlblLocation.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout2 = new FlowLayout();
        flowLayout2.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlLocation = new JPanel();
        jpnlLocation.setLayout(flowLayout2);
        jpnlLocation.add(jlblLocation, null);

        // JTextField jtxfLocation
        jtxfLocation = new JTextField();
        jtxfLocation.setPreferredSize(new java.awt.Dimension(200, 22));
        jpnlLocation.add(jtxfLocation, null);

        // JButton jbtnLocation
        jbtnLocation = new JButton();
        jbtnLocation.setText("File");
        jbtnLocation.addActionListener(this);
        jpnlLocation.add(jbtnLocation, null);

        return jpnlLocation;
    }

    /**
     * This method initializes jpnlURL
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlURL() {
        JLabel jlblURL = new JLabel();
        jlblURL.setText("Connection URL");
        jlblURL.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblURL.setToolTipText("Connection URL");
        jlblURL.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout3 = new FlowLayout();
        flowLayout3.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlURL = new JPanel();
        jpnlURL.setLayout(flowLayout3);
        jpnlURL.add(jlblURL, null);

        // JTextField jtxfURL
        jtxfURL = new JTextField();
        jtxfURL.setPreferredSize(new java.awt.Dimension(250, 22));
        // jtxfURL.setText("jdbc:oracle:thin:@ct-java:1521:orcl");
        jpnlURL.add(jtxfURL, null);

        return jpnlURL;
    }

    /**
     * This method initializes jpnlUserID
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlUserID() {
        JLabel jlblUserID = new JLabel();
        jlblUserID.setText("User ID");
        jlblUserID.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblUserID.setToolTipText("User ID");
        jlblUserID.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout4 = new FlowLayout();
        flowLayout4.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlUserID = new JPanel();
        jpnlUserID.setLayout(flowLayout4);
        jpnlUserID.add(jlblUserID, null);

        // JTextField jtxfUserID
        jtxfUserID = new JTextField();
        jtxfUserID.setPreferredSize(new java.awt.Dimension(100, 22));
        // jtxfUserID.setText("eco");
        jpnlUserID.add(jtxfUserID, null);

        return jpnlUserID;
    }

    /**
     * This method initializes jpnlPassword
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlPassword() {
        JLabel jlblPassword = new JLabel();
        jlblPassword.setText("Password");
        jlblPassword.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblPassword.setToolTipText("Password");
        jlblPassword.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout5 = new FlowLayout();
        flowLayout5.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlPassword = new JPanel();
        jpnlPassword.setLayout(flowLayout5);
        jpnlPassword.add(jlblPassword, null);

        // JPasswordField jpwfPassword
        jpwfPassword = new JPasswordField();
        jpwfPassword.setPreferredSize(new java.awt.Dimension(100, 22));
        // jpwfPassword.setText("eco");
        jpnlPassword.add(jpwfPassword, null);

        return jpnlPassword;
    }

    /**
     * This method initializes jpnlSchema
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlSchema() {
        JLabel jlblSchema = new JLabel();
        jlblSchema.setText("Schema");
        jlblSchema.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblSchema.setToolTipText("Schema");
        jlblSchema.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout6 = new FlowLayout();
        flowLayout6.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlSchema = new JPanel();
        jpnlSchema.setLayout(flowLayout6);
        jpnlSchema.add(jlblSchema, null);

        // JTextField jtxfSchema
        jtxfSchema = new JTextField();
        jtxfSchema.setPreferredSize(new java.awt.Dimension(150, 22));
        // jtxfSchema.setText("ECO");
        jpnlSchema.add(jtxfSchema, null);

        return jpnlSchema;
    }

    /**
     * This method initializes jpnlScope
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlScope() {
        FlowLayout flowLayout7 = new FlowLayout();
        flowLayout7.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlScope = new JPanel();
        jpnlScope.setLayout(flowLayout7);

        // JRadioButton jrdoScope
        jrdoScope = new JRadioButton[2];
        jrdoScope[0] = new JRadioButton();
        jrdoScope[0].setText("SELECT");
        jrdoScope[0].addActionListener(this);
        jrdoScope[1] = new JRadioButton();
        jrdoScope[1].setText("ALL TABLE");
        jrdoScope[1].addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(jrdoScope[0]);
        group.add(jrdoScope[1]);
        jrdoScope[0].setSelected(true);
        jpnlScope.add(jrdoScope[0], null);
        jpnlScope.add(jrdoScope[1], null);

        return jpnlScope;
    }

    /**
     * This method initializes jpnlSouth
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlSouth() {
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.setRows(3);
        JPanel jpnlSouth = new JPanel();
        jpnlSouth.setLayout(gridLayout2);
        jpnlSouth.add(getJpnlResultName(), null);
        jpnlSouth.add(getJpnlFile(), null);
        jpnlSouth.add(getJpnlBtn(), null);

        return jpnlSouth;
    }

    /**
     * This method initializes jpnlResultName
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlResultName() {
        JLabel jlblResultName = new JLabel();
        jlblResultName.setText("Result Name");
        jlblResultName.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblResultName.setToolTipText("Result Name");
        jlblResultName.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout8 = new FlowLayout();
        flowLayout8.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlResultName = new JPanel();
        jpnlResultName.setLayout(flowLayout8);
        jpnlResultName.add(jlblResultName, null);

        // JTextField jtxfResultName
        jtxfResultName = new JTextField();
        jtxfResultName.setPreferredSize(new java.awt.Dimension(250, 22));
        jtxfResultName.setText("TEST_TABLE");
        jpnlResultName.add(jtxfResultName, null);

        return jpnlResultName;
    }

    /**
     * This method initializes jpnlFile
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlFile() {
        JLabel jlblFile = new JLabel();
        jlblFile.setText("Save File");
        jlblFile.setPreferredSize(new java.awt.Dimension(100, 18));
        jlblFile.setToolTipText("Save XML File Path");
        jlblFile.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        FlowLayout flowLayout9 = new FlowLayout();
        flowLayout9.setAlignment(java.awt.FlowLayout.LEFT);
        JPanel jpnlFile = new JPanel();
        jpnlFile.setLayout(flowLayout9);
        jpnlFile.add(jlblFile, null);

        // JTextField jtxfFile
        jtxfFile = new JTextField();
        jtxfFile.setPreferredSize(new java.awt.Dimension(200, 22));
        jpnlFile.add(jtxfFile, null);

        // JButton jbtnFile
        jbtnFile = new JButton();
        jbtnFile.setText("File");
        jbtnFile.addActionListener(this);
        jpnlFile.add(jbtnFile, null);

        return jpnlFile;
    }

    /**
     * This method initializes jpnlBtn
     * @return javax.swing.JPanel
     */
    private JPanel getJpnlBtn() {
        FlowLayout fwlBtn = new FlowLayout();
        fwlBtn.setAlignment(java.awt.FlowLayout.RIGHT);
        JPanel jpnlBtn = new JPanel();
        jpnlBtn.setLayout(fwlBtn);

        // JButton jbtnReset
        jbtnReset = new JButton();
        jbtnReset.setText("Reset");
        jbtnReset.setToolTipText("Reset");
        jbtnReset.addActionListener(this);
        jpnlBtn.add(jbtnReset, null);

        // JButton jbtnCreate
        jbtnCreate = new JButton();
        jbtnCreate.setText("Create");
        jbtnCreate.setToolTipText("Test XML Create..");
        jbtnCreate.addActionListener(this);
        jpnlBtn.add(jbtnCreate, null);

        return jpnlBtn;
    }

    /**
     * This method initializes jscpQuery
     * @return javax.swing.JScrollPane
     */
    private JScrollPane getJscpQuery() {
        JScrollPane jscpQuery = new JScrollPane();

        // JTextArea jtxaQuery
        jtxaQuery = new JTextArea();
        jscpQuery.setViewportView(jtxaQuery);

        return jscpQuery;
    }

    /**
     * @param args 사용하지 않음
     */
    public static void main(String[] args) {
        new TestXmlCreator();
    }

    /**
     * This is the default constructor
     */
    public TestXmlCreator() {
        super();
        initialize();
        this.setVisible(true);
    }

    /**
     * This method initializes this
     */
    private void initialize() {
        this.setSize(400, 600);
        this.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);
        this.setContentPane(getJcpnMain());
        this.setTitle("TestXmlCreator for DBUnit");
    }

    /**
     * This method initializes jContentPane
     * @return javax.swing.JPanel
     */
    private JPanel getJcpnMain() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.setRows(2);
        JPanel jcpnMain = new JPanel();
        jcpnMain.setLayout(gridLayout);
        jcpnMain.add(getJpnlTop(), null);
        jcpnMain.add(getJpnlDown(), null);
        return jcpnMain;
    }

    /**
     * Event처리
     * @param event Event가 발생한 Object
     */
    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();

        if ((obj == jrdoScope[0]) || (obj == jrdoScope[1])) { // Scope Select
            changeScope();
        } else if (obj == jbtnCreate) { // Create Button Click
            runCreate();
        } else if (obj == jbtnLocation) { // Location Button Click
            setClassLocation();
        } else if (obj == jbtnFile) { // Save File Button Click
            setSaveFilePath();
        } else if (obj == jbtnReset) { // Reset Button Click
            eventReset();
        }
    }

    /**
     * SELECT인지, 모든 테이블인지 상태 변경
     */
    private void changeScope() {
        if (jrdoScope[0].isSelected()) { // SELECT 선택시
            jtxaQuery.setEnabled(true);
            jtxfResultName.setEnabled(true);
            jtxaQuery.setBackground(Color.WHITE);
            jtxfResultName.setBackground(Color.WHITE);
        } else { // 모든 테이블 선택시
            jtxaQuery.setEnabled(false);
            jtxfResultName.setEnabled(false);
            jtxaQuery.setBackground(Color.LIGHT_GRAY);
            jtxfResultName.setBackground(Color.LIGHT_GRAY);
        }
    }

    /**
     * Reset Button Click
     */
    private void eventReset() {
        jrdoScope[0].setSelected(true);
        jtxaQuery.setText("");
        jtxfResultName.setText("");
    }

    /**
     * Test XML Data Create
     */
    private void runCreate() {
        // [SELECT] 선택시 체크
        if (jrdoScope[0].isSelected()) {
            // Query 입력 체크
            if (jtxaQuery.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Query is Empty!!",
                    "Warning", JOptionPane.WARNING_MESSAGE);
                return;
            }

            // 결과 테이블명 입력 체크
            if (jtxfResultName.getText().trim().length() == 0) {
                JOptionPane.showMessageDialog(this, "Result Name is Empty!!",
                    "Warning", JOptionPane.WARNING_MESSAGE);
                return;
            }
        }
        AbstractDataCreator creator = null;

        // Select DB Type
        switch (jcmbDBType.getSelectedIndex()) {
            case 0: // Oracle
                creator = new OracleDataCreator(jtxfLocation.getText(),
                    jtxfDriver.getText(), jtxfURL.getText(), jtxfUserID
                        .getText(), new String(jpwfPassword.getPassword()),
                    jtxfSchema.getText());
                break;
            case 1: // MySQL
                creator = new MySQLDataCreator(jtxfLocation.getText(),
                    jtxfDriver.getText(), jtxfURL.getText(), jtxfUserID
                        .getText(), new String(jpwfPassword.getPassword()),
                    jtxfSchema.getText());
                break;
            case 2: // MS-SQL
                creator = new MSSQLDataCreator(jtxfLocation.getText(),
                    jtxfDriver.getText(), jtxfURL.getText(), jtxfUserID
                        .getText(), new String(jpwfPassword.getPassword()),
                    jtxfSchema.getText());
                break;
            case 3: // DB2
                creator = new DB2DataCreator(jtxfLocation.getText(), jtxfDriver
                    .getText(), jtxfURL.getText(), jtxfUserID.getText(),
                    new String(jpwfPassword.getPassword()), jtxfSchema
                        .getText());
                break;
            case 4: // HSQLDB
                creator = new HSQLDBDataCreator(jtxfLocation.getText(),
                    jtxfDriver.getText(), jtxfURL.getText(), jtxfUserID
                        .getText(), new String(jpwfPassword.getPassword()),
                    jtxfSchema.getText());
                break;
            default:
                JOptionPane.showMessageDialog(this, "Failed!!", "Warning",
                    JOptionPane.WARNING_MESSAGE);
                return;
        }

        try {
            if (creator.makeXmlData(jrdoScope[0].isSelected(), jtxaQuery
                .getText(), jtxfResultName.getText(), jtxfFile.getText())) {
                JOptionPane.showMessageDialog(this, "Complete!!", "Alert",
                    JOptionPane.INFORMATION_MESSAGE);
            } else {
                JOptionPane.showMessageDialog(this, "Failed!!", "Warning",
                    JOptionPane.WARNING_MESSAGE);
            }
        } catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error",
                JOptionPane.ERROR_MESSAGE);

        }
    }

    /**
     * ClassLocation Set
     */
    private void setClassLocation() {
        JFileChooser fc = new JFileChooser();

        if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            jtxfLocation.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }

    /**
     * SaveFielPath Set
     */
    private void setSaveFilePath() {
        JFileChooser fc = new JFileChooser();

        if (fc.showSaveDialog(this) == JFileChooser.APPROVE_OPTION) {
            jtxfFile.setText(fc.getSelectedFile().getAbsolutePath());
        }
    }
}
